/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.exec;

import com.sun.javatest.Status;
import com.sun.javatest.regtest.TimeoutHandler;
import com.sun.javatest.regtest.agent.Alarm;
import com.sun.javatest.regtest.util.ProcessUtils;
import com.sun.javatest.regtest.util.StreamCopier;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class ProcessCommand {
    private HashMap<Integer, Status> statusTable;
    private Status defaultStatus = Status.error("unknown reason");
    private File execDir;
    private List<String> cmd;
    private Map<String, String> env;
    private PrintWriter out;
    private PrintWriter err;
    private long timeout;
    private TimeoutHandler timeoutHandler;

    public ProcessCommand setStatusForExit(int exitCode, Status status) {
        if (this.statusTable == null) {
            this.statusTable = new HashMap();
            if (this.defaultStatus == null) {
                this.defaultStatus = Status.error("unrecognized exit code");
            }
        }
        this.statusTable.put(exitCode, status);
        return this;
    }

    public ProcessCommand setDefaultStatus(Status status) {
        if (this.statusTable == null) {
            this.statusTable = new HashMap();
        }
        this.defaultStatus = status;
        return this;
    }

    public ProcessCommand setExecDir(File dir) {
        this.execDir = dir;
        return this;
    }

    public File getExecDir() {
        return this.execDir;
    }

    public ProcessCommand setCommand(List<String> cmd) {
        this.cmd = cmd;
        return this;
    }

    public List<String> getCommand() {
        return this.cmd;
    }

    public ProcessCommand setEnvironment(Map<String, String> env) {
        this.env = env;
        return this;
    }

    public Map<String, String> getEnvironment() {
        return this.env;
    }

    public ProcessCommand setStreams(PrintWriter out, PrintWriter err) {
        if (out == null) {
            throw new IllegalArgumentException("Output stream is required");
        }
        if (err == null) {
            throw new IllegalArgumentException("Error stream is required");
        }
        this.out = out;
        this.err = err;
        return this;
    }

    public PrintWriter getOutStream() {
        return this.out;
    }

    public PrintWriter getErrorStream() {
        return this.err;
    }

    public ProcessCommand setTimeout(long timeout, TimeUnit unit) {
        this.timeout = TimeUnit.MILLISECONDS.convert(timeout, unit);
        return this;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public ProcessCommand setTimeoutHandler(TimeoutHandler timeoutHandler) {
        this.timeoutHandler = timeoutHandler;
        return this;
    }

    public TimeoutHandler getTimeoutHandler() {
        return this.timeoutHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status exec() {
        Status status;
        OutputStream processOut;
        if (this.out == null) {
            throw new IllegalArgumentException("Output stream is required");
        }
        if (this.err == null) {
            throw new IllegalArgumentException("Error stream is required");
        }
        ProcessBuilder pb = new ProcessBuilder(this.cmd);
        pb.directory(this.execDir);
        if (this.env != null) {
            pb.environment().clear();
            pb.environment().putAll(this.env);
        }
        final Process process = pb.start();
        InputStream processIn = process.getInputStream();
        InputStream processErr = process.getErrorStream();
        long start = System.currentTimeMillis();
        Alarm alarm = Alarm.NONE;
        final CountDownLatch timeoutHandlerDone = new CountDownLatch(1);
        if (this.timeout > 0L) {
            final Thread victim = Thread.currentThread();
            alarm = Alarm.schedule(this.timeout, TimeUnit.MILLISECONDS, this.out, new Runnable(){

                @Override
                public void run() {
                    ProcessCommand.this.invokeTimeoutHandler(ProcessCommand.this.timeoutHandler, timeoutHandlerDone, process, victim);
                }
            });
        }
        if ((processOut = process.getOutputStream()) != null) {
            processOut.close();
        }
        try {
            StatusScanner statusScanner = new StatusScanner();
            StreamCopier outCopier = new StreamCopier(processIn, this.out);
            StreamCopier errCopier = new StreamCopier(processErr, this.err, statusScanner);
            outCopier.start();
            errCopier.start();
            outCopier.join();
            errCopier.join();
            int exitCode = process.waitFor();
            alarm.cancel();
            status = this.getStatus(exitCode, statusScanner.exitStatus());
        }
        catch (InterruptedException e) {
            Status status2;
            try {
                alarm.cancel();
                status2 = Status.error("Program `" + this.cmd.get(0) + "' interrupted");
            }
            catch (Throwable throwable) {
                try {
                    processIn.close();
                    processErr.close();
                    alarm.cancel();
                    if (alarm.didFire()) {
                        boolean done = this.waitForTimeoutHandler(timeoutHandlerDone, this.timeoutHandler);
                        String msg = "Program `" + this.cmd.get(0) + "' timed out";
                        if (!done) {
                            msg = msg + ": timeout handler did not complete within its own timeout.";
                        }
                        long end = System.currentTimeMillis();
                        msg = msg + " (timeout set to " + this.timeout + "ms, elapsed time including timeout handling was " + (end - start) + "ms).";
                        return Status.error(msg);
                    }
                    throw throwable;
                }
                catch (IOException e2) {
                    String msg = "Error invoking program `" + this.cmd.get(0) + "': " + String.valueOf(e2);
                    return Status.error(msg);
                }
            }
            processIn.close();
            processErr.close();
            alarm.cancel();
            if (alarm.didFire()) {
                boolean done = this.waitForTimeoutHandler(timeoutHandlerDone, this.timeoutHandler);
                String msg = "Program `" + this.cmd.get(0) + "' timed out";
                if (!done) {
                    msg = msg + ": timeout handler did not complete within its own timeout.";
                }
                long end = System.currentTimeMillis();
                msg = msg + " (timeout set to " + this.timeout + "ms, elapsed time including timeout handling was " + (end - start) + "ms).";
                return Status.error(msg);
            }
            return status2;
        }
        processIn.close();
        processErr.close();
        alarm.cancel();
        if (alarm.didFire()) {
            boolean done = this.waitForTimeoutHandler(timeoutHandlerDone, this.timeoutHandler);
            String msg = "Program `" + this.cmd.get(0) + "' timed out";
            if (!done) {
                msg = msg + ": timeout handler did not complete within its own timeout.";
            }
            long end = System.currentTimeMillis();
            msg = msg + " (timeout set to " + this.timeout + "ms, elapsed time including timeout handling was " + (end - start) + "ms).";
            return Status.error(msg);
        }
        return status;
    }

    private void invokeTimeoutHandler(final TimeoutHandler timeoutHandler, final CountDownLatch timeoutHandlerDone, final Process process, final Thread victim) {
        Thread timeoutHandlerThread = new Thread(){

            @Override
            public void run() {
                if (timeoutHandler != null) {
                    timeoutHandler.handleTimeout(process);
                }
                ProcessUtils.destroyForcibly(process);
                timeoutHandlerDone.countDown();
                victim.interrupt();
            }
        };
        timeoutHandlerThread.setName("Timeout Handler for " + this.cmd.get(0));
        timeoutHandlerThread.start();
    }

    private boolean waitForTimeoutHandler(CountDownLatch timeoutHandlerDone, TimeoutHandler timeoutHandler) {
        boolean done = true;
        while (timeoutHandlerDone.getCount() != 0L) {
            try {
                if (timeoutHandler.getTimeout() <= 0L) {
                    timeoutHandlerDone.await();
                    continue;
                }
                done = timeoutHandlerDone.await(timeoutHandler.getTimeout() + 10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {}
        }
        return done;
    }

    protected Status getStatus(int exitCode, Status logStatus) {
        if (logStatus != null) {
            return logStatus;
        }
        if (this.statusTable != null) {
            Status s = this.statusTable.get(exitCode);
            return s == null ? this.defaultStatus.augment("exit code: " + exitCode) : s;
        }
        if (exitCode == 0) {
            return Status.passed("exit code 0");
        }
        return Status.failed("exit code " + exitCode);
    }

    private static class StatusScanner
    implements StreamCopier.LineScanner {
        private String lastStatusLine;

        private StatusScanner() {
        }

        @Override
        public void scan(String line) {
            if (line.startsWith("STATUS:")) {
                this.lastStatusLine = line = Status.decode(line);
            }
        }

        public Status exitStatus() {
            if (this.lastStatusLine == null) {
                return null;
            }
            return Status.parse(this.lastStatusLine.substring("STATUS:".length()));
        }
    }
}

