/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.exec;

import com.sun.javatest.Status;
import com.sun.javatest.regtest.RStatus;
import com.sun.javatest.regtest.TimeoutHandler;
import com.sun.javatest.regtest.agent.MainActionHelper;
import com.sun.javatest.regtest.agent.MainWrapper;
import com.sun.javatest.regtest.agent.SearchPath;
import com.sun.javatest.regtest.config.ExecMode;
import com.sun.javatest.regtest.config.JDK;
import com.sun.javatest.regtest.config.JDKOpts;
import com.sun.javatest.regtest.config.Locations;
import com.sun.javatest.regtest.config.Modules;
import com.sun.javatest.regtest.config.ParseException;
import com.sun.javatest.regtest.exec.Action;
import com.sun.javatest.regtest.exec.Agent;
import com.sun.javatest.regtest.exec.BuildAction;
import com.sun.javatest.regtest.exec.JUnitAction;
import com.sun.javatest.regtest.exec.Lock;
import com.sun.javatest.regtest.exec.ModuleConfig;
import com.sun.javatest.regtest.exec.ProcessCommand;
import com.sun.javatest.regtest.exec.RegressionScript;
import com.sun.javatest.regtest.exec.TestNGAction;
import com.sun.javatest.regtest.exec.TestRunException;
import com.sun.javatest.regtest.tool.Version;
import com.sun.javatest.regtest.util.StringUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class MainAction
extends Action {
    public static final String NAME = "main";
    private final List<String> testJavaArgs = new ArrayList<String>();
    private final List<String> testClassArgs = new ArrayList<String>();
    private Class<? extends MainActionHelper.TestRunner> driverClass = null;
    private List<String> driverArgs = null;
    private String testModuleName = null;
    private String testClassName = null;
    private File policyFN = null;
    private String secureCN = null;
    private boolean overrideSysPolicy = false;
    protected boolean reverseStatus = false;
    protected boolean useBootClassPath = false;
    protected Set<String> othervmOverrideReasons = new LinkedHashSet<String>();
    protected boolean nativeCode = false;
    private int timeout = -1;
    private String manual = "unset";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void init(Map<String, String> opts, List<String> args, String reason, RegressionScript script) throws ParseException {
        this.init(opts, args, reason, script, null, null);
    }

    void init(Map<String, String> opts, List<String> args, String reason, RegressionScript script, Class<? extends MainActionHelper.TestRunner> driverClass, String ... driverArgs) throws ParseException {
        Set<Locations.LibLocn.Kind> testKinds;
        boolean multiModule;
        super.init(opts, args, reason, script);
        if (args.isEmpty()) {
            throw new ParseException("No class provided for `main'");
        }
        boolean othervm = false;
        block22: for (Map.Entry<String, String> e : opts.entrySet()) {
            String optName = e.getKey();
            String optValue = e.getValue();
            switch (optName) {
                case "fail": {
                    this.reverseStatus = this.parseFail(optValue);
                    continue block22;
                }
                case "manual": {
                    this.manual = this.parseMainManual(optValue);
                    continue block22;
                }
                case "timeout": {
                    this.timeout = this.parseTimeout(optValue);
                    continue block22;
                }
                case "othervm": {
                    othervm = true;
                    this.othervmOverrideReasons.add("/othervm specified");
                    continue block22;
                }
                case "native": {
                    this.nativeCode = true;
                    continue block22;
                }
                case "bootclasspath": {
                    this.useBootClassPath = true;
                    this.othervmOverrideReasons.add("/bootclasspath specified");
                    continue block22;
                }
                case "policy": {
                    this.overrideSysPolicy = true;
                    this.policyFN = this.parsePolicy(optValue);
                    continue block22;
                }
                case "java.security.policy": {
                    String name = optValue;
                    if (optValue.startsWith("=")) {
                        this.overrideSysPolicy = true;
                        name = optValue.substring(1);
                    }
                    this.policyFN = this.parsePolicy(name);
                    continue block22;
                }
                case "secure": {
                    this.secureCN = this.parseSecure(optValue);
                    continue block22;
                }
            }
            throw new ParseException("Bad option for main: " + optName);
        }
        if (this.manual.equals("unset")) {
            if (this.timeout < 0) {
                this.timeout = script.getActionTimeout(-1);
            }
        } else {
            if (this.timeout >= 0) {
                throw new ParseException("`/manual' disables use of `/timeout'");
            }
            this.timeout = 0;
        }
        if (driverClass != null) {
            this.driverClass = driverClass;
            this.driverArgs = List.of(driverArgs);
        }
        if (script.useBootClassPath()) {
            this.useBootClassPath = true;
            this.othervmOverrideReasons.add("test or library uses bootclasspath");
        }
        boolean seenEnablePreview = false;
        for (int i = 0; i < args.size(); ++i) {
            String arg = args.get(i);
            if (this.testClassName == null) {
                if (arg.startsWith("-")) {
                    if (arg.equals("--enable-preview")) {
                        seenEnablePreview = true;
                    }
                    this.testJavaArgs.add(arg);
                    if (!JDKOpts.hasFollowingArg(arg)) continue;
                    this.testJavaArgs.add(args.get(++i));
                    continue;
                }
                int sep = arg.indexOf("/");
                if (sep == -1) {
                    this.testModuleName = null;
                    this.testClassName = arg;
                    continue;
                }
                this.testModuleName = arg.substring(0, sep);
                this.testClassName = arg.substring(sep + 1);
                continue;
            }
            this.testClassArgs.add(arg);
        }
        if (this.testClassName == null) {
            throw new ParseException("No class provided for `main'");
        }
        if (!othervm) {
            if (this.testJavaArgs.size() > 0) {
                throw new ParseException(String.valueOf(this.testJavaArgs) + ": vm option(s) found, need to specify /othervm");
            }
            if (this.policyFN != null) {
                throw new ParseException("`/policy' and `/java.security.policy` require use of `/othervm'");
            }
            if (this.secureCN != null) {
                throw new ParseException("`/secure' requires use of `/othervm'");
            }
        }
        if (script.enablePreview() && !seenEnablePreview) {
            this.testJavaArgs.add("--enable-preview");
            if (!othervm) {
                this.othervmOverrideReasons.add("test requires --enable-preview");
            }
        }
        if (!othervm) {
            for (Modules.Entry m : script.getModules()) {
                String name = m.moduleName;
                if (!script.systemModules.contains(name) || script.defaultModules.contains(name)) continue;
                this.othervmOverrideReasons.add("test requires non-default system module");
                break;
            }
        }
        if (!othervm && (this instanceof TestNGAction || this instanceof JUnitAction) && (multiModule = (testKinds = script.locations.getDirKinds(script.locations.absTestSrcDir())).equals(EnumSet.of(Locations.LibLocn.Kind.USER_MODULE)))) {
            this.othervmOverrideReasons.add("test requires testng and/or junit as modules");
        }
    }

    public List<String> getJavaArgs() {
        return this.testJavaArgs;
    }

    public String getModuleName() {
        return this.testModuleName;
    }

    public String getClassName() {
        return this.testClassName;
    }

    public List<String> getClassArgs() {
        return this.testClassArgs;
    }

    List<String> filterJavaOpts(List<String> args) {
        return args;
    }

    @Override
    public Set<File> getSourceFiles() {
        LinkedHashSet<File> files = new LinkedHashSet<File>();
        if (this.testClassName != null) {
            Map<String, String> buildOpts = Collections.emptyMap();
            List<String> buildArgs = List.of(this.join(this.testModuleName, this.testClassName));
            try {
                BuildAction ba = new BuildAction();
                ba.init(buildOpts, buildArgs, "Named class compiled on demand", this.script);
                files.addAll(ba.getSourceFiles());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (this.policyFN != null) {
            files.add(this.policyFN);
        }
        return files;
    }

    @Override
    public Set<String> getModules() {
        return this.testModuleName == null ? Collections.emptySet() : Collections.singleton(this.testModuleName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Status run() throws TestRunException {
        Status status;
        if (this.script.usePatchModules()) {
            this.othervmOverrideReasons.add("test or library overrides a system module");
        }
        if (!(status = this.build()).isPassed()) {
            return status;
        }
        if (this.nativeCode && this.script.getNativeDir() == null) {
            return RStatus.error("Use -nativepath to specify the location of native code");
        }
        if (this.script.isCheck()) {
            this.startAction(true);
            status = RStatus.passed("Test description appears acceptable");
            this.endAction(status);
            return status;
        }
        Lock lock = this.script.getLockIfRequired();
        if (lock != null) {
            lock.lock();
        }
        this.startAction(true);
        try {
            switch (!this.othervmOverrideReasons.isEmpty() ? ExecMode.OTHERVM : this.script.getExecMode()) {
                case AGENTVM: {
                    this.showMode(ExecMode.AGENTVM);
                    status = this.runAgentJVM();
                    return status;
                }
                case OTHERVM: {
                    this.showMode(ExecMode.OTHERVM, this.othervmOverrideReasons);
                    status = this.runOtherJVM();
                    return status;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        finally {
            this.endAction(status);
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    protected Status build() throws TestRunException {
        Map<String, String> buildOpts = Collections.emptyMap();
        List<String> buildArgs = List.of(this.join(this.testModuleName, this.testClassName));
        BuildAction ba = new BuildAction();
        return ba.build(buildOpts, buildArgs, "Named class compiled on demand", this.script);
    }

    private Status runOtherJVM() throws TestRunException {
        Status status;
        List<Object> runClassArgs;
        String runModuleClassName;
        String runModuleName;
        if (this.driverClass == null) {
            runModuleName = this.testModuleName;
            runModuleClassName = this.join(this.testModuleName, this.testClassName);
            runClassArgs = this.testClassArgs;
        } else {
            runModuleName = null;
            runModuleClassName = this.driverClass.getName();
            runClassArgs = new ArrayList<String>();
            runClassArgs.addAll(this.driverArgs);
            runClassArgs.add(this.join(this.testModuleName, this.testClassName));
            runClassArgs.addAll(this.testClassArgs);
        }
        File argFile = this.getArgFile();
        try (BufferedWriter w = new BufferedWriter(new FileWriter(argFile));){
            w.write(runModuleClassName + "\u0000");
            w.write(StringUtils.join(runClassArgs, " ") + "\u0000");
        }
        catch (IOException e) {
            return RStatus.error("Can't write `main' argument file");
        }
        LinkedHashMap<String, String> env = new LinkedHashMap<String, String>();
        env.putAll(this.getEnvVars(this.nativeCode));
        boolean useCLASSPATH = true;
        Set<Locations.LibLocn.Kind> testKinds = this.script.locations.getDirKinds(this.script.locations.absTestSrcDir());
        boolean multiModule = testKinds.equals(EnumSet.of(Locations.LibLocn.Kind.USER_MODULE));
        Map<RegressionScript.PathKind, SearchPath> paths = this.script.getExecutionPaths(multiModule, runModuleName, this.useBootClassPath, true);
        SearchPath cp = paths.get((Object)RegressionScript.PathKind.CLASSPATH);
        if (cp != null && !cp.isEmpty()) {
            env.put("CLASSPATH", cp.toString());
        }
        Path javaCmd = this.script.getJavaProg();
        JDKOpts javaOpts = new JDKOpts();
        SearchPath bcpa = paths.get((Object)RegressionScript.PathKind.BOOTCLASSPATH_APPEND);
        SearchPath pp = paths.get((Object)RegressionScript.PathKind.PATCHPATH);
        javaOpts.addPath("-Xbootclasspath/a:", bcpa);
        javaOpts.addAllPatchModules(pp);
        javaOpts.addPath("--module-path", paths.get((Object)RegressionScript.PathKind.MODULEPATH));
        Set<String> addMods = this.addMods(paths);
        if (!addMods.isEmpty()) {
            javaOpts.add("--add-modules");
            javaOpts.add(StringUtils.join(addMods, ","));
        }
        if (pp != null && !pp.isEmpty() && bcpa != null && !bcpa.isEmpty()) {
            for (String s : this.getModules(pp)) {
                javaOpts.add("--add-reads=" + s + "=ALL-UNNAMED");
            }
        }
        if (this.driverClass != null && this.testModuleName != null && this.testClassName.contains(".")) {
            Module driverModule = this.driverClass.getModule();
            String exportTarget = driverModule.isNamed() ? driverModule.getName() : "ALL-UNNAMED";
            String testPackage = this.testClassName.substring(0, this.testClassName.lastIndexOf("."));
            javaOpts.add("--add-exports=" + this.testModuleName + "/" + testPackage + "=" + exportTarget);
        }
        javaOpts.addAll(this.getExtraModuleConfigOptions(Modules.Phase.DYNAMIC));
        javaOpts.addAll(this.script.getTestVMJavaOptions());
        javaOpts.addAll(this.script.getTestDebugOptions());
        LinkedHashMap<String, String> javaProps = new LinkedHashMap<String, String>();
        javaProps.putAll(this.script.getTestProperties());
        if (this.policyFN != null) {
            File newPolicyFN = this.addGrantEntries(this.policyFN, argFile);
            javaProps.put("java.security.policy", (this.overrideSysPolicy ? "=" : "") + String.valueOf(newPolicyFN));
        }
        if (this.secureCN != null) {
            javaProps.put("java.security.manager", this.secureCN);
        } else if (this.policyFN != null) {
            javaProps.put("java.security.manager", "default");
        }
        if (this.script.getTestThreadFactory() != null) {
            javaProps.put(MainWrapper.TEST_THREAD_FACTORY, this.script.getTestThreadFactory());
        }
        if (this.script.getTestThreadFactoryPath() != null) {
            javaProps.put(MainWrapper.TEST_THREAD_FACTORY_PATH, this.script.getTestThreadFactoryPath());
        }
        javaOpts.addAll(this.testJavaArgs);
        String className = MainWrapper.class.getName();
        ArrayList<String> classArgs = new ArrayList<String>();
        classArgs.add(argFile.getPath());
        classArgs.addAll(runClassArgs);
        ArrayList<String> command = new ArrayList<String>();
        command.add(javaCmd.toString());
        for (Map.Entry e : javaProps.entrySet()) {
            command.add("-D" + (String)e.getKey() + "=" + (String)e.getValue());
        }
        command.addAll(this.filterJavaOpts(javaOpts.toList()));
        command.add(className);
        command.addAll(classArgs);
        try (PrintWriter sysOut = this.section.createOutput("System.out");
             PrintWriter sysErr = this.section.createOutput("System.err");){
            if (showMode) {
                this.showMode(this.getName(), ExecMode.OTHERVM, this.section);
            }
            if (showCmd) {
                this.showCmd(this.getName(), command, this.section);
            }
            new ModuleConfig("Boot Layer").setFromOpts(javaOpts).write(this.configWriter);
            this.recorder.java(env, javaCmd, javaProps, javaOpts.toList(), className, classArgs);
            ProcessCommand cmd = new ProcessCommand();
            cmd.setExecDir(this.script.absTestScratchDir().toFile());
            cmd.setStatusForExit(Status.exitCodes[0], RStatus.passed("Execution successful"));
            cmd.setStatusForExit(Status.exitCodes[1], RStatus.failed("Execution failed"));
            cmd.setDefaultStatus(RStatus.failed("Unexpected exit from test"));
            TimeoutHandler timeoutHandler = this.script.getTimeoutHandlerProvider().createHandler(this.getClass(), this.script, this.section);
            cmd.setCommand(command).setEnvironment(env).setStreams(sysOut, sysErr).setTimeout(this.timeout, TimeUnit.SECONDS).setTimeoutHandler(timeoutHandler);
            status = RStatus.normalize(cmd.exec());
        }
        status = this.checkReverse(status, this.reverseStatus);
        return status;
    }

    private Set<String> addMods(Map<RegressionScript.PathKind, SearchPath> paths) {
        LinkedHashSet<String> addMods = new LinkedHashSet<String>();
        if (this.testModuleName != null) {
            addMods.add(this.testModuleName);
        }
        addMods.addAll(this.getModules(paths.get((Object)RegressionScript.PathKind.MODULEPATH)));
        return addMods;
    }

    private Status runAgentJVM() throws TestRunException {
        Status status;
        Agent agent;
        Set<String> runAddMods;
        List<String> runMainArgs;
        String runMainClass;
        String runModuleName;
        if (this.driverClass == null) {
            runModuleName = this.testModuleName;
            runMainClass = this.testClassName;
            runMainArgs = this.testClassArgs;
        } else {
            runModuleName = null;
            runMainClass = this.driverClass.getName();
            runMainArgs = new ArrayList<String>();
            runMainArgs.addAll(this.driverArgs);
            runMainArgs.add(this.testClassName);
            runMainArgs.addAll(this.testClassArgs);
        }
        Set<Locations.LibLocn.Kind> testKinds = this.script.locations.getDirKinds(this.script.locations.absTestSrcDir());
        boolean multiModule = testKinds.equals(EnumSet.of(Locations.LibLocn.Kind.USER_MODULE));
        Map<RegressionScript.PathKind, SearchPath> paths = this.script.getExecutionPaths(multiModule, runModuleName, this.useBootClassPath, true);
        JDK jdk = this.script.getTestJDK();
        List<Path> stdLibs = new SearchPath().append(this.script.getJavaTestClassPath()).append(jdk.getJDKClassPath()).append(this.script.getJUnitPath()).append(this.script.getTestNGPath()).asList();
        Version v = this.script.getRequiredVersion();
        SearchPath classpath = paths.get((Object)RegressionScript.PathKind.CLASSPATH);
        SearchPath agentClasspath = v.version == null || v.compareTo(new Version("5.1 b01")) >= 0 ? new SearchPath().append(stdLibs) : new SearchPath(classpath).retainAll(stdLibs);
        SearchPath runClasspath = new SearchPath(classpath).removeAll(stdLibs);
        SearchPath runModulePath = paths.get((Object)RegressionScript.PathKind.MODULEPATH);
        if (showMode) {
            this.showMode(this.getName(), ExecMode.AGENTVM, this.section);
        }
        Map<String, String> javaProps = this.script.getTestProperties();
        Path javaProg = this.script.getJavaProg();
        ArrayList<String> javaArgs = new ArrayList<String>();
        javaArgs.add("-classpath");
        javaArgs.add(classpath.toString());
        if (runModulePath != null) {
            javaArgs.add("--module-path");
            javaArgs.add(runModulePath.toString());
        }
        if (!(runAddMods = this.addMods(paths)).isEmpty()) {
            javaArgs.add("--add-modules");
            javaArgs.add(StringUtils.join(runAddMods, ","));
        }
        this.recorder.java(this.script.getEnvVars(), javaProg, javaProps, javaArgs, runMainClass, runMainArgs);
        try {
            String factory = this.script.getTestThreadFactory() == null ? null : this.script.getTestThreadFactory();
            agent = this.script.getAgent(jdk, agentClasspath, this.filterJavaOpts(MainAction.join(this.script.getTestVMJavaOptions(), this.script.getTestDebugOptions())), factory, this.script.getTestThreadFactoryPath());
            this.section.getMessageWriter().println("Agent id: " + agent.getId());
            new ModuleConfig("Boot Layer").setFromOpts(agent.vmOpts).write(this.configWriter);
        }
        catch (Agent.Fault e) {
            return RStatus.error("Cannot get VM for test: " + String.valueOf(e.getCause()));
        }
        TimeoutHandler timeoutHandler = this.script.getTimeoutHandlerProvider().createHandler(this.getClass(), this.script, this.section);
        try {
            StringBuilder sb;
            LinkedHashSet<String> runAddExports = new LinkedHashSet<String>();
            LinkedHashSet<String> runAddOpens = new LinkedHashSet<String>();
            if (jdk.hasModules()) {
                for (Modules.Entry e : this.script.getModules()) {
                    if (e.packageName == null) continue;
                    if (e.addExports) {
                        runAddExports.add(e.moduleName + "/" + e.packageName);
                    }
                    if (!e.addOpens) continue;
                    runAddOpens.add(e.moduleName + "/" + e.packageName);
                }
            }
            if (!runAddExports.isEmpty()) {
                sb = null;
                for (String s : runAddExports) {
                    if (!s.contains("/")) continue;
                    if (sb == null) {
                        sb = new StringBuilder();
                        sb.append("Additional exports to unnamed modules from @modules: ");
                    } else {
                        sb.append(" ");
                    }
                    sb.append(s);
                }
                if (sb != null) {
                    this.section.getMessageWriter().println(sb);
                }
            }
            if (!runAddOpens.isEmpty()) {
                sb = null;
                for (String s : runAddOpens) {
                    if (!s.contains("/")) continue;
                    if (sb == null) {
                        sb = new StringBuilder();
                        sb.append("Additional opens to unnamed modules from @modules: ");
                    } else {
                        sb.append(" ");
                    }
                    sb.append(s);
                }
                if (sb != null) {
                    this.section.getMessageWriter().println(sb);
                }
            }
            new ModuleConfig("Test Layer").setAddExportsToUnnamed(runAddExports).setAddOpensToUnnamed(runAddOpens).setClassPath(runClasspath).setModulePath(runModulePath).write(this.configWriter);
            status = agent.doMainAction(this.script.getTestResult().getTestName(), javaProps, runAddExports, runAddOpens, runAddMods, runClasspath, runModulePath != null ? runModulePath : new SearchPath(), runMainClass, runMainArgs, this.timeout, timeoutHandler, this.section);
        }
        catch (Agent.Fault e) {
            status = e.getCause() instanceof IOException ? RStatus.error(String.format("Agent communication error: %s; check console log for any additional details", e.getCause())) : RStatus.error(String.format("Agent error: %s; check console log for any additional details", e.getCause()));
        }
        if (status.isError()) {
            this.script.closeAgent(agent);
        }
        status = this.checkReverse(status, this.reverseStatus);
        return status;
    }

    private String parseMainManual(String value) throws ParseException {
        if (value != null) {
            throw new ParseException("Arguments to `manual' option not supported: " + value);
        }
        value = "novalue";
        return value;
    }

    private Status checkReverse(Status status, boolean reverseStatus) {
        if (!status.isError() && !status.getReason().startsWith("Unexpected exit from test")) {
            Object sr;
            boolean ok = status.isPassed();
            int st = status.getType();
            if (ok && reverseStatus) {
                sr = "Execution passed unexpectedly";
                st = 1;
            } else if (ok && !reverseStatus) {
                sr = status.getReason().isEmpty() ? "Execution successful" : status.getReason();
            } else if (!ok && reverseStatus) {
                sr = "Execution failed as expected";
                st = 0;
            } else {
                sr = "Execution failed";
            }
            if (st == 1 && status.getReason() != null && !status.getReason().equals("Execution successful")) {
                sr = (String)sr + ": " + status.getReason();
            }
            status = RStatus.createStatus(st, (String)sr);
        }
        return status;
    }

    private String join(String moduleName, String className) {
        return moduleName == null ? className : moduleName + "/" + className;
    }
}

