/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.exec;

import com.sun.javatest.Status;
import com.sun.javatest.regtest.RStatus;
import com.sun.javatest.regtest.TimeoutHandler;
import com.sun.javatest.regtest.agent.AStatus;
import com.sun.javatest.regtest.agent.ActionHelper;
import com.sun.javatest.regtest.agent.CompileActionHelper;
import com.sun.javatest.regtest.agent.JDK_Version;
import com.sun.javatest.regtest.agent.SearchPath;
import com.sun.javatest.regtest.config.ExecMode;
import com.sun.javatest.regtest.config.JDK;
import com.sun.javatest.regtest.config.JDKOpts;
import com.sun.javatest.regtest.config.Locations;
import com.sun.javatest.regtest.config.Modules;
import com.sun.javatest.regtest.config.ParseException;
import com.sun.javatest.regtest.exec.Action;
import com.sun.javatest.regtest.exec.Agent;
import com.sun.javatest.regtest.exec.ModuleConfig;
import com.sun.javatest.regtest.exec.ProcessCommand;
import com.sun.javatest.regtest.exec.RegressionScript;
import com.sun.javatest.regtest.exec.TestRunException;
import com.sun.javatest.regtest.util.StringUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

public class CompileAction
extends Action {
    public static final String NAME = "compile";
    private Locations.LibLocn libLocn;
    private File destDir;
    private boolean reverseStatus = false;
    private String ref = null;
    private int timeout = -1;
    private boolean classpathp = false;
    private boolean sourcepathp = false;
    private boolean process = false;
    private String module = null;
    private boolean multiModule = false;
    private Set<String> modules;
    private boolean addDebugOpts = false;
    protected Set<String> othervmOverrideReasons = new LinkedHashSet<String>();

    @Override
    public String getName() {
        return NAME;
    }

    Status compile(Locations.LibLocn libLocn, Map<String, String> opts, List<String> args, String reason, RegressionScript script) throws TestRunException {
        this.libLocn = libLocn;
        this.init(opts, args, reason, script);
        return this.run();
    }

    @Override
    public void init(Map<String, String> opts, List<String> args, String reason, RegressionScript script) throws ParseException {
        super.init(opts, args, reason, script);
        if (reason.startsWith("User specified action: run ")) {
            this.addDebugOpts = true;
        }
        if (args.isEmpty()) {
            throw new ParseException("No classname provided for `compile'");
        }
        block16: for (Map.Entry<String, String> e : opts.entrySet()) {
            String optName = e.getKey();
            String optValue = e.getValue();
            switch (optName) {
                case "fail": {
                    this.reverseStatus = this.parseFail(optValue);
                    continue block16;
                }
                case "timeout": {
                    this.timeout = this.parseTimeout(optValue);
                    continue block16;
                }
                case "ref": {
                    this.ref = this.parseRef(optValue);
                    continue block16;
                }
                case "process": {
                    this.process = true;
                    continue block16;
                }
                case "module": {
                    this.module = this.parseModule(optValue);
                    this.modules = Collections.singleton(this.module);
                    continue block16;
                }
                case "modules": {
                    if (optValue != null) {
                        throw new ParseException("Unexpected value for `modules': " + optValue);
                    }
                    this.multiModule = true;
                    this.modules = new LinkedHashSet<String>();
                    continue block16;
                }
            }
            throw new ParseException("Bad option for compile: " + optName);
        }
        if (this.module != null && this.multiModule) {
            throw new ParseException("Bad combination of options: /module=" + this.module + ", /modules");
        }
        if (this.module == null && !this.multiModule) {
            this.modules = Collections.emptySet();
        }
        if (this.timeout < 0) {
            this.timeout = script.getActionTimeout(-1);
        }
        Locations locations = script.locations;
        this.destDir = this.libLocn == null ? (this.multiModule ? locations.absTestModulesDir().toFile() : locations.absTestClsDir(this.module).toFile()) : (this.module == null ? this.libLocn.absClsDir : this.libLocn.absClsDir.resolve(this.module)).toFile();
        if (!script.isCheck()) {
            CompileAction.mkdirs(this.destDir);
        }
        boolean foundJavaFile = false;
        boolean foundAsmFile = false;
        for (int i = 0; i < args.size(); ++i) {
            Path absSourceFile;
            File sourceFile;
            String currArg = args.get(i);
            if (currArg.endsWith(".java")) {
                foundJavaFile = true;
                sourceFile = new File(currArg.replace('/', File.separatorChar));
                if (!sourceFile.isAbsolute()) {
                    if (this.multiModule) {
                        this.addModule(currArg);
                    }
                    if (!Files.exists(absSourceFile = locations.absTestSrcFile(this.module, sourceFile), new LinkOption[0])) {
                        throw new ParseException("Can't find source file: " + currArg);
                    }
                    args.set(i, absSourceFile.toString());
                }
            } else if (currArg.endsWith(".jasm") || currArg.endsWith("jcod")) {
                if (this.module != null) {
                    throw new ParseException("Compile option not allowed: ");
                }
                foundAsmFile = true;
                sourceFile = new File(currArg.replace('/', File.separatorChar));
                if (!sourceFile.isAbsolute()) {
                    if (this.multiModule) {
                        this.addModule(currArg);
                    }
                    if (!Files.exists(absSourceFile = locations.absTestSrcFile(null, sourceFile), new LinkOption[0])) {
                        throw new ParseException("Can't find source file: " + currArg);
                    }
                    args.set(i, absSourceFile.toString());
                }
            }
            if (currArg.equals("-classpath") || currArg.equals("-cp") || currArg.equals("--class-path") || currArg.startsWith("--class-path=")) {
                if (this.module != null || this.multiModule) {
                    throw new ParseException("Compile option not allowed: ");
                }
                this.classpathp = true;
                if (currArg.startsWith("--class-path=")) continue;
                ++i;
                continue;
            }
            if (currArg.equals("-sourcepath") || currArg.equals("--source-path") || currArg.startsWith("--source-path=")) {
                if (this.module != null || this.multiModule) {
                    throw new ParseException("Compile option not allowed: ");
                }
                this.sourcepathp = true;
                if (currArg.startsWith("--source-path=")) continue;
                ++i;
                continue;
            }
            if (!currArg.equals("-d")) continue;
            throw new ParseException("Compile option not allowed: ");
        }
        if (!(foundJavaFile || this.process || foundAsmFile)) {
            throw new ParseException("No classname ending with `.java' found");
        }
        if (foundAsmFile) {
            if (this.sourcepathp || this.classpathp || this.process) {
                throw new ParseException("Compile option not allowed: ");
            }
            if (this.reverseStatus || this.ref != null) {
                throw new ParseException("Compile option not allowed: ");
            }
        }
    }

    @Override
    public Set<File> getSourceFiles() {
        LinkedHashSet<File> files = new LinkedHashSet<File>();
        for (String currArg : this.args) {
            if (!currArg.endsWith(".java") && !currArg.endsWith(".jasm") && !currArg.endsWith(".jcod")) continue;
            files.add(new File(currArg));
        }
        return files;
    }

    @Override
    public Set<String> getModules() {
        return this.modules;
    }

    @Override
    public Status run() throws TestRunException {
        Status status;
        this.startAction(true);
        List<String> javacArgs = new ArrayList<String>();
        ArrayList<String> jasmArgs = new ArrayList<String>();
        ArrayList<String> jcodArgs = new ArrayList<String>();
        boolean runJavac = this.process;
        int insertPos = -1;
        boolean seenSourceOrRelease = false;
        boolean seenEnablePreview = false;
        for (String currArg : this.args) {
            if (currArg.endsWith(".java")) {
                if (!new File(currArg).exists()) {
                    throw new TestRunException("Can't find source file: " + currArg);
                }
                if (insertPos == -1) {
                    insertPos = javacArgs.size();
                }
                javacArgs.add(currArg);
                runJavac = true;
                continue;
            }
            if (currArg.endsWith(".jasm")) {
                jasmArgs.add(currArg);
                continue;
            }
            if (currArg.endsWith(".jcod")) {
                jcodArgs.add(currArg);
                continue;
            }
            int eq = currArg.indexOf("=");
            switch (eq == -1 ? currArg : currArg.substring(0, eq)) {
                case "--enable-preview": {
                    seenEnablePreview = true;
                    break;
                }
                case "-source": 
                case "--source": 
                case "--release": {
                    if (insertPos == -1) {
                        insertPos = javacArgs.size();
                    }
                    seenSourceOrRelease = true;
                }
            }
            javacArgs.add(currArg);
        }
        if (runJavac && this.script.enablePreview() && !seenEnablePreview) {
            javacArgs.add(insertPos, "--enable-preview");
            if (!seenSourceOrRelease) {
                int v = this.script.getTestJDKVersion().major;
                javacArgs.add(insertPos + 1, "--source=" + v);
            }
        }
        if (this.script.isCheck()) {
            status = RStatus.passed("Test description appears acceptable");
        } else {
            status = RStatus.passed("Not yet run");
            if (status.isPassed() && !jasmArgs.isEmpty()) {
                status = this.jasm(jasmArgs);
            }
            if (status.isPassed() && !jcodArgs.isEmpty()) {
                status = this.jcod(jcodArgs);
            }
            if (status.isPassed() && runJavac) {
                javacArgs = this.getJavacCommandArgs(javacArgs);
                for (String arg : javacArgs) {
                    if (!arg.startsWith("-J")) continue;
                    this.othervmOverrideReasons.add("JVM options specified for compiler");
                    break;
                }
                if (this.explicitAnnotationProcessingRequested(javacArgs) && !this.getExtraModuleConfigOptions(Modules.Phase.DYNAMIC).isEmpty()) {
                    this.othervmOverrideReasons.add("additional runtime exports needed for annotation processing");
                }
                switch (!this.othervmOverrideReasons.isEmpty() ? ExecMode.OTHERVM : this.script.getExecMode()) {
                    case AGENTVM: {
                        this.showMode(ExecMode.AGENTVM);
                        status = this.runAgentJVM(javacArgs);
                        break;
                    }
                    case OTHERVM: {
                        this.showMode(ExecMode.OTHERVM, this.othervmOverrideReasons);
                        status = this.runOtherJVM(javacArgs);
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
        }
        this.endAction(status);
        return status;
    }

    private Status jasm(List<String> files) {
        return this.asmtools("jasm", files);
    }

    private Status jcod(List<String> files) {
        return this.asmtools("jcoder", files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Status asmtools(String toolName, List<String> files) {
        if (files.isEmpty()) {
            return Status.passed(toolName + ": no files");
        }
        ArrayList<String> toolArgs = new ArrayList<String>();
        toolArgs.add("-d");
        toolArgs.add(this.destDir.getPath());
        toolArgs.addAll(files);
        try {
            String toolClassName = "org.openjdk.asmtools." + toolName + ".Main";
            this.recorder.asmtools(toolClassName, toolArgs);
            Class<?> toolClass = Class.forName(toolClassName);
            Constructor<?> constr = toolClass.getConstructor(PrintStream.class, String.class);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(baos);
            try {
                Object tool = constr.newInstance(ps, toolName);
                Method m = toolClass.getMethod(NAME, String[].class);
                Object r = m.invoke(tool, new Object[]{toolArgs.toArray(new String[0])});
                if (r instanceof Boolean) {
                    boolean ok = (Boolean)r;
                    Status status = ok ? Status.passed(toolName + " OK") : Status.failed(toolName + " failed");
                    return status;
                }
                Status status = Status.error("unexpected result from " + toolName + ": " + r.toString());
                return status;
            }
            finally {
                try (PrintWriter out = this.section.createOutput(toolName);){
                    out.write(baos.toString());
                }
            }
        }
        catch (ClassNotFoundException e) {
            return Status.error("can't find " + toolName);
        }
        catch (ReflectiveOperationException t) {
            return Status.error("error invoking " + toolName + ": " + String.valueOf(t));
        }
    }

    private List<String> getJavacCommandArgs(List<String> args) throws TestRunException {
        Set<String> userMods;
        Map<RegressionScript.PathKind, SearchPath> compilePaths = this.script.getCompilePaths(this.libLocn, this.multiModule, this.module);
        JDKOpts javacArgs = new JDKOpts();
        javacArgs.addAll(this.script.getTestCompilerOptions());
        if (this.isModuleOptionsAllowed(args)) {
            javacArgs.addAll(this.getExtraModuleConfigOptions(Modules.Phase.STATIC));
        }
        if (this.destDir != null) {
            javacArgs.add("-d");
            javacArgs.add(this.destDir.toString());
        }
        if (this.multiModule) {
            javacArgs.addPath("--module-source-path", compilePaths.get((Object)RegressionScript.PathKind.MODULESOURCEPATH));
        } else if (this.module != null) {
            javacArgs.addAll("--patch-module", this.module + "=" + String.valueOf(compilePaths.get((Object)RegressionScript.PathKind.SOURCEPATH)));
        } else {
            javacArgs.addPath("--source-path", compilePaths.get((Object)RegressionScript.PathKind.SOURCEPATH));
        }
        SearchPath cp = compilePaths.get((Object)RegressionScript.PathKind.CLASSPATH);
        javacArgs.addPath("--class-path", cp);
        javacArgs.addPath("--module-path", compilePaths.get((Object)RegressionScript.PathKind.MODULEPATH));
        SearchPath pp = compilePaths.get((Object)RegressionScript.PathKind.PATCHPATH);
        javacArgs.addAllPatchModules(pp);
        if (pp != null && !pp.isEmpty() && cp != null && !cp.isEmpty()) {
            for (String s : this.getModules(pp)) {
                javacArgs.add("--add-reads=" + s + "=ALL-UNNAMED");
            }
        }
        if (!(userMods = this.getModules(compilePaths.get((Object)RegressionScript.PathKind.MODULEPATH))).isEmpty()) {
            javacArgs.add("--add-modules");
            javacArgs.add(StringUtils.join(userMods, ","));
        }
        javacArgs.addAll(args);
        return javacArgs.toList();
    }

    private boolean isModuleOptionsAllowed(List<String> args) {
        Iterator<String> iter = args.iterator();
        block8: while (iter.hasNext()) {
            String option;
            switch (option = iter.next()) {
                case "-source": 
                case "-target": 
                case "--release": {
                    if (!iter.hasNext()) continue block8;
                    JDK_Version v = JDK_Version.forName(iter.next());
                    return v != null && v.compareTo(JDK_Version.V9) >= 0;
                }
            }
            if (!option.startsWith("--release=")) continue;
            JDK_Version v = JDK_Version.forName(option.substring(option.indexOf("=") + 1));
            return v != null && v.compareTo(JDK_Version.V9) >= 0;
        }
        return true;
    }

    private Status runOtherJVM(List<String> javacArgs) throws TestRunException {
        Map<String, String> javacProps = this.script.getTestProperties();
        Map<String, String> env = this.script.getEnvVars();
        Path javacCmd = this.script.getJavacProg();
        JDKOpts javacVMOpts = new JDKOpts();
        javacVMOpts.addAll(this.script.getTestVMOptions());
        if (this.addDebugOpts && this.script.getCompileJDK().equals(this.script.getTestJDK())) {
            javacVMOpts.addAll(this.script.getTestDebugOptions());
        }
        if (this.explicitAnnotationProcessingRequested(javacArgs)) {
            javacVMOpts.addAll(this.getExtraModuleConfigOptions(Modules.Phase.DYNAMIC));
        }
        List<Object> fullJavacArgs = javacArgs;
        if (javacArgs.size() >= 10) {
            File argFile = this.getArgFile();
            try (BufferedWriter w = new BufferedWriter(new FileWriter(argFile));){
                for (String arg : javacArgs) {
                    if (arg.startsWith("-J")) {
                        javacVMOpts.add(arg.substring(2));
                        continue;
                    }
                    w.write(arg);
                    w.newLine();
                }
            }
            catch (IOException e) {
                return RStatus.error("Can't write `compile' argument file");
            }
            catch (SecurityException e) {
                return RStatus.error("Unable to create `compile' argument file");
            }
            javacArgs = List.of("@" + String.valueOf(argFile));
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(javacCmd.toString());
        for (String string : javacVMOpts.toList()) {
            command.add("-J" + string);
        }
        for (Map.Entry entry : javacProps.entrySet()) {
            command.add("-J-D" + (String)entry.getKey() + "=" + (String)entry.getValue());
        }
        command.addAll(javacArgs);
        if (showMode) {
            this.showMode(NAME, ExecMode.OTHERVM, this.section);
        }
        if (showCmd) {
            this.showCmd(NAME, command, this.section);
        }
        new ModuleConfig("Boot Layer (javac runtime environment)").setFromOpts(javacVMOpts).write(this.configWriter);
        new ModuleConfig("javac compilation environment").setFromOpts(fullJavacArgs).write(this.configWriter);
        this.recorder.javac(env, javacCmd, javacVMOpts.toList(), javacProps, javacArgs);
        ActionHelper.PrintStringWriter stdOut = new ActionHelper.PrintStringWriter();
        ActionHelper.PrintStringWriter printStringWriter = new ActionHelper.PrintStringWriter();
        ProcessCommand cmd = new ProcessCommand(){

            @Override
            protected Status getStatus(int exitCode, Status logStatus) {
                JDK_Version v = CompileAction.this.script.getCompileJDKVersion();
                AStatus aStatus = CompileActionHelper.getStatusForJavacExitCode(v, exitCode);
                return new Status(aStatus.getType(), aStatus.getReason());
            }
        };
        TimeoutHandler timeoutHandler = this.script.getTimeoutHandlerProvider().createHandler(this.getClass(), this.script, this.section);
        cmd.setExecDir(this.script.absTestScratchDir().toFile()).setCommand(command).setEnvironment(env).setStreams(stdOut, printStringWriter).setTimeout(this.timeout, TimeUnit.SECONDS).setTimeoutHandler(timeoutHandler);
        Status status = RStatus.normalize(cmd.exec());
        try (PrintWriter sysOut = this.section.createOutput("System.out");){
            sysOut.write(stdOut.getOutput());
        }
        try (PrintWriter sysErr = this.section.createOutput("System.err");){
            sysErr.write(printStringWriter.getOutput());
        }
        status = this.checkReverse(status, this.reverseStatus);
        if (this.ref != null && status.isPassed()) {
            String combined = stdOut.getOutput() + printStringWriter.getOutput();
            status = this.checkGoldenFile(combined, status);
        }
        return status;
    }

    private Status runAgentJVM(List<String> javacArgs) throws TestRunException {
        Status status;
        Agent agent;
        Map<String, String> javacProps = this.script.getTestProperties();
        if (showMode) {
            this.showMode(NAME, ExecMode.AGENTVM, this.section);
        }
        if (showCmd) {
            this.showCmd(NAME, javacArgs, this.section);
        }
        Path javacProg = this.script.getJavacProg();
        List<String> javacVMOpts = this.script.getTestVMOptions();
        this.recorder.javac(this.script.getEnvVars(), javacProg, javacVMOpts, javacProps, javacArgs);
        try {
            JDK jdk = this.script.getCompileJDK();
            SearchPath agentClasspath = new SearchPath(jdk.getJDKClassPath(), this.script.getJavaTestClassPath());
            List<String> vmOpts = this.addDebugOpts && jdk.equals(this.script.getTestJDK()) ? CompileAction.join(this.script.getTestVMOptions(), this.script.getTestDebugOptions()) : this.script.getTestVMOptions();
            agent = this.script.getAgent(jdk, agentClasspath, vmOpts, null, null);
            this.section.getMessageWriter().println("Agent id: " + agent.getId());
            new ModuleConfig("Boot Layer (javac runtime environment)").setFromOpts(agent.vmOpts).write(this.configWriter);
        }
        catch (Agent.Fault e) {
            return RStatus.error("Cannot get VM for test: " + String.valueOf(e.getCause()));
        }
        TimeoutHandler timeoutHandler = this.script.getTimeoutHandlerProvider().createHandler(this.getClass(), this.script, this.section);
        try {
            new ModuleConfig("javac compilation environment").setFromOpts(javacArgs).write(this.configWriter);
            status = agent.doCompileAction(this.script.getTestResult().getTestName(), javacProps, javacArgs, this.timeout, timeoutHandler, this.section);
        }
        catch (Agent.Fault e) {
            status = e.getCause() instanceof IOException ? RStatus.error(String.format("Agent communication error: %s; check console log for any additional details", e.getCause())) : RStatus.error(String.format("Agent error: %s; check console log for any additional details", e.getCause()));
        }
        if (status.isError()) {
            this.script.closeAgent(agent);
        }
        status = this.checkReverse(status, this.reverseStatus);
        if (this.ref != null && status.isPassed()) {
            String outString = this.getOutput(ActionHelper.OutputHandler.OutputKind.DIRECT);
            String errString = this.getOutput(ActionHelper.OutputHandler.OutputKind.DIRECT_LOG);
            String stdOutString = this.getOutput(ActionHelper.OutputHandler.OutputKind.STDOUT);
            String stdErrString = this.getOutput(ActionHelper.OutputHandler.OutputKind.STDERR);
            String combined = outString + errString + stdOutString + stdErrString;
            status = this.checkGoldenFile(combined, status);
        }
        return status;
    }

    private String getOutput(ActionHelper.OutputHandler.OutputKind kind) {
        String s = this.section.getOutput(kind.name);
        return s == null ? "" : s;
    }

    private boolean explicitAnnotationProcessingRequested(List<String> javacArgs) {
        for (String arg : javacArgs) {
            if (!arg.equals("-processor") && !arg.equals("-processorpath") && !arg.equals("-processormodulepath") && !arg.equals("-proc:only") && !arg.equals("-Xprint")) continue;
            return true;
        }
        return false;
    }

    private String parseRef(String value) throws ParseException {
        if (value == null || value.equals("")) {
            throw new ParseException("No reference file name");
        }
        File refFile = this.script.absTestSrcDir().resolve(value).toFile();
        if (!refFile.exists()) {
            throw new ParseException("Can't find reference file: " + String.valueOf(refFile));
        }
        return value;
    }

    private Status checkReverse(Status status, boolean reverseStatus) {
        if (!status.isError()) {
            Object sr;
            boolean ok = status.isPassed();
            int st = status.getType();
            if (ok && reverseStatus) {
                sr = "Compilation passed unexpectedly";
                st = 1;
            } else if (ok && !reverseStatus) {
                sr = "Compilation successful";
            } else if (!ok && reverseStatus) {
                sr = "Compilation failed as expected";
                st = 0;
            } else {
                sr = "Compilation failed";
            }
            if (st == 1 && status.getReason() != null && !status.getReason().equals("Execution successful")) {
                sr = (String)sr + ": " + status.getReason();
            }
            status = RStatus.createStatus(st, (String)sr);
        }
        return status;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Status checkGoldenFile(String actual, Status status) throws TestRunException {
        File refFile = this.script.absTestSrcDir().resolve(this.ref).toFile();
        try (BufferedReader actualReader = new BufferedReader(new StringReader(actual));){
            BufferedReader refReader;
            block15: {
                Status status2;
                refReader = new BufferedReader(new FileReader(refFile));
                try {
                    int lineNum = this.compareGoldenFile(actualReader, refReader);
                    if (lineNum == 0) break block15;
                    status2 = RStatus.failed("Output does not match reference file: " + this.ref + ", line " + lineNum);
                }
                catch (Throwable throwable) {
                    try {
                        refReader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                refReader.close();
                return status2;
            }
            Status status3 = status;
            refReader.close();
            return status3;
        }
        catch (FileNotFoundException e) {
            throw new TestRunException("Can't find reference file: " + String.valueOf(refFile));
        }
        catch (IOException e) {
            throw new TestRunException("Can't read reference file: " + String.valueOf(refFile));
        }
    }

    private int compareGoldenFile(BufferedReader actualReader, BufferedReader refReader) throws TestRunException {
        Pattern ignoreLinesPattern = this.script.getIgnoreRefLinesPattern();
        try {
            String s2;
            String s1;
            int lineNum = 0;
            do {
                s1 = actualReader.readLine();
                if (ignoreLinesPattern != null) {
                    while (s1 != null && ignoreLinesPattern.matcher(s1).matches()) {
                        this.section.getMessageWriter().println("Ignoring line: " + s1);
                        s1 = actualReader.readLine();
                    }
                }
                s2 = refReader.readLine();
                ++lineNum;
                if (s1 != null || s2 != null) continue;
                return 0;
            } while (s1 != null && s2 != null && s1.equals(s2));
            return lineNum;
        }
        catch (IOException e) {
            Path refFile = this.script.absTestSrcDir().resolve(this.ref);
            throw new TestRunException("Problem reading reference file: " + String.valueOf(refFile));
        }
    }

    private void addModule(String file) {
        int sep = file.indexOf(47);
        if (sep > 0) {
            this.modules.add(file.substring(0, sep));
        }
    }
}

