/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.exec;

import com.sun.javatest.Status;
import com.sun.javatest.regtest.RStatus;
import com.sun.javatest.regtest.config.Locations;
import com.sun.javatest.regtest.config.ParseException;
import com.sun.javatest.regtest.exec.Action;
import com.sun.javatest.regtest.exec.CompileAction;
import com.sun.javatest.regtest.exec.RegressionScript;
import com.sun.javatest.regtest.exec.TestRunException;
import com.sun.javatest.regtest.util.FileUtils;
import java.io.File;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class BuildAction
extends Action {
    public static final String NAME = "build";
    private static final String IGNORE_CASE = "(?i)";
    private static final String OPT_MODULE = "([a-z_][.a-z0-9_$]*/)?";
    private static final String PKG_CLASS = "(([a-z_][.a-z0-9_$]*)(\\.\\*|\\.package-info)?)";
    private static final String PKG_CLASS_OR_OTHER = "((([a-z_][.a-z0-9_$]*)(\\.\\*|\\.package-info)?)|\\*|module-info)";
    static final Pattern BUILD_PTN = Pattern.compile("(?i)([a-z_][.a-z0-9_$]*/)?((([a-z_][.a-z0-9_$]*)(\\.\\*|\\.package-info)?)|\\*|module-info)");
    private String implicitOpt;

    @Override
    public String getName() {
        return NAME;
    }

    public Status build(Map<String, String> opts, List<String> args, String reason, RegressionScript script) throws TestRunException {
        this.init(opts, args, reason, script);
        return this.run();
    }

    @Override
    public void init(Map<String, String> opts, List<String> args, String reason, RegressionScript script) throws ParseException {
        super.init(opts, args, reason, script);
        for (Map.Entry<String, String> e : opts.entrySet()) {
            String optName = e.getKey();
            String optValue = e.getValue();
            if (optName.equals("implicit") && optValue.equals("none")) {
                this.implicitOpt = "-implicit:none";
                continue;
            }
            throw new ParseException("Unexpected options for `build'");
        }
        if (args.isEmpty()) {
            throw new ParseException("No classname(s) provided for `build'");
        }
        for (String currArg : args) {
            if (BUILD_PTN.matcher(currArg).matches()) continue;
            throw new ParseException("Bad classname provided for `build': " + currArg);
        }
    }

    @Override
    public Set<File> getSourceFiles() {
        LinkedHashSet<File> files = new LinkedHashSet<File>();
        for (String arg : this.args) {
            try {
                for (Locations.ClassLocn cl : this.script.locations.locateClasses(arg)) {
                    files.add(cl.absSrcFile.toFile());
                }
            }
            catch (Locations.Fault fault) {
            }
        }
        return files;
    }

    @Override
    public Set<String> getModules() {
        LinkedHashSet<String> modules = new LinkedHashSet<String>();
        for (String arg : this.args) {
            int sep = arg.indexOf("/");
            if (sep <= 0) continue;
            modules.add(arg.substring(0, sep));
        }
        return modules;
    }

    @Override
    public Status run() throws TestRunException {
        Status status;
        this.startAction(false);
        PrintWriter pw = this.section.getMessageWriter();
        long now = System.currentTimeMillis();
        LinkedHashMap<Locations.LibLocn, ArrayList<Locations.ClassLocn>> classLocnsToCompile = new LinkedHashMap<Locations.LibLocn, ArrayList<Locations.ClassLocn>>();
        for (String arg : this.args) {
            try {
                for (Locations.ClassLocn cl : this.script.locations.locateClasses(arg)) {
                    long sfMillis = FileUtils.getLastModifiedTime(cl.absSrcFile).toMillis();
                    if (sfMillis > now) {
                        pw.println(String.format("WARNING: file %s has a modification time in the future: %s", cl.absSrcFile, DateFormat.getDateTimeInstance().format(new Date(sfMillis))));
                        pw.println("Unexpected results may occur");
                    }
                    if (cl.isUpToDate()) continue;
                    ArrayList<Locations.ClassLocn> classLocnsForLib = (ArrayList<Locations.ClassLocn>)classLocnsToCompile.get(cl.lib);
                    if (classLocnsForLib == null) {
                        classLocnsForLib = new ArrayList<Locations.ClassLocn>();
                        classLocnsToCompile.put(cl.lib, classLocnsForLib);
                    }
                    classLocnsForLib.add(cl);
                }
            }
            catch (Locations.Fault fault) {
                throw new TestRunException(fault.getMessage());
            }
        }
        if (classLocnsToCompile.isEmpty()) {
            status = RStatus.passed("All files up to date");
        } else {
            Status s;
            status = null;
            for (Path path : this.script.locations.absLibClsList(Locations.LibLocn.Kind.PACKAGE)) {
                FileUtils.createDirectories(path);
            }
            for (Map.Entry entry : classLocnsToCompile.entrySet()) {
                if (((Locations.LibLocn)entry.getKey()).name == null || (s = this.compileLibrary((Locations.LibLocn)entry.getKey(), (List)entry.getValue())).isPassed()) continue;
                status = s;
                break;
            }
            if (status == null) {
                for (Map.Entry entry : classLocnsToCompile.entrySet()) {
                    if (((Locations.LibLocn)entry.getKey()).name != null || (s = this.compileLibrary((Locations.LibLocn)entry.getKey(), (List)entry.getValue())).isPassed()) continue;
                    status = s;
                    break;
                }
            }
            if (status == null) {
                status = RStatus.passed("Build successful");
            }
        }
        this.endAction(status);
        return status;
    }

    private Status compileLibrary(Locations.LibLocn libLocn, List<Locations.ClassLocn> classLocns) throws TestRunException {
        this.showClasses(libLocn, classLocns);
        switch (libLocn.kind) {
            case PACKAGE: {
                return this.compileFiles(libLocn, false, null, this.getSrcFiles(classLocns));
            }
            case USER_MODULE: {
                return this.compileFiles(libLocn, true, null, this.getSrcFiles(classLocns));
            }
            case SYS_MODULE: {
                LinkedHashMap<String, ArrayList<File>> filesForModule = new LinkedHashMap<String, ArrayList<File>>();
                for (Locations.ClassLocn classLocn : classLocns) {
                    ArrayList<File> files = (ArrayList<File>)filesForModule.get(classLocn.optModule);
                    if (files == null) {
                        files = new ArrayList<File>();
                        filesForModule.put(classLocn.optModule, files);
                    }
                    files.add(classLocn.absSrcFile.toFile());
                }
                for (Map.Entry entry : filesForModule.entrySet()) {
                    Status s = this.compileFiles(libLocn, false, (String)entry.getKey(), (List)entry.getValue());
                    if (s.isPassed()) continue;
                    return s;
                }
                return RStatus.passed("Build successful");
            }
        }
        throw new AssertionError();
    }

    private Status compileFiles(Locations.LibLocn libLocn, boolean isMulti, String moduleName, List<File> files) throws TestRunException {
        LinkedHashMap<String, String> compOpts = new LinkedHashMap<String, String>();
        if (isMulti) {
            compOpts.put("modules", null);
        }
        if (moduleName != null) {
            compOpts.put("module", moduleName);
        }
        ArrayList<String> compArgs = new ArrayList<String>();
        if (this.script.getCompileJDK().hasOldSymbolFile()) {
            compArgs.add("-XDignore.symbol.file=true");
        }
        if (this.implicitOpt != null) {
            compArgs.add(this.implicitOpt);
        }
        for (File file : files) {
            compArgs.add(file.getPath());
        }
        CompileAction ca = new CompileAction();
        return ca.compile(libLocn, compOpts, compArgs, ".class file out of date or does not exist", this.script);
    }

    private List<File> getSrcFiles(List<Locations.ClassLocn> classLocns) {
        ArrayList<File> files = new ArrayList<File>();
        for (Locations.ClassLocn cl : classLocns) {
            files.add(cl.absSrcFile.toFile());
        }
        return files;
    }

    private void showClasses(Locations.LibLocn lib, List<Locations.ClassLocn> toCompile) {
        PrintWriter pw = this.section.getMessageWriter();
        if (lib.name == null) {
            pw.println("Test directory:");
        } else {
            pw.println("Library " + lib.name + ":");
        }
        String sep = "  compile: ";
        for (Locations.ClassLocn cl : toCompile) {
            pw.print(sep);
            if (cl.optModule != null) {
                pw.print(cl.optModule);
                pw.print("/");
            }
            pw.print(cl.className);
            sep = ", ";
        }
        pw.println();
    }
}

