/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.exec;

import com.sun.javatest.Status;
import com.sun.javatest.TestResult;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.regtest.RStatus;
import com.sun.javatest.regtest.TimeoutHandler;
import com.sun.javatest.regtest.agent.ActionHelper;
import com.sun.javatest.regtest.agent.AgentServer;
import com.sun.javatest.regtest.agent.Alarm;
import com.sun.javatest.regtest.agent.Flags;
import com.sun.javatest.regtest.agent.SearchPath;
import com.sun.javatest.regtest.config.JDK;
import com.sun.javatest.regtest.config.RegressionParameters;
import com.sun.javatest.regtest.util.ProcessUtils;
import com.sun.javatest.regtest.util.StringUtils;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class Agent {
    static final boolean showAgent = Flags.get("showAgent");
    static final boolean traceAgent = Flags.get("traceAgent");
    private TestResult.Section currentTestResultSection;
    private Map<String, PrintWriter> processStreamWriters = new HashMap<String, PrintWriter>();
    final JDK jdk;
    final List<String> vmOpts;
    final File execDir;
    final Process process;
    final DataInputStream in;
    final DataOutputStream out;
    final AgentServer.KeepAlive keepAlive;
    final int id;
    final Logger logger;
    Instant idleStartTime;
    static int count;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Agent(File dir, JDK jdk, List<String> vmOpts, Map<String, String> envVars, File policyFile, float timeoutFactor, Logger logger, String testThreadFactory, String testThreadFactoryPath) throws Fault {
        try {
            String headless;
            this.id = ++count;
            this.jdk = jdk;
            this.execDir = dir;
            this.vmOpts = vmOpts;
            this.logger = logger;
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add(jdk.getJavaProg().toString());
            cmd.addAll(vmOpts);
            if (policyFile != null) {
                cmd.add("-Djava.security.policy=" + String.valueOf(policyFile.toURI()));
            }
            if ((headless = System.getProperty("java.awt.headless")) != null) {
                cmd.add("-Djava.awt.headless=" + headless);
            }
            cmd.add(AgentServer.class.getName());
            cmd.add("-id");
            cmd.add(String.valueOf(this.id));
            cmd.add("-logfile");
            cmd.add(logger.getAgentServerLogFile(this.id).getPath());
            if (policyFile != null) {
                cmd.add("-allowSetSecurityManager");
            }
            ServerSocket ss = new ServerSocket();
            ss.setReuseAddress(false);
            ss.bind(new InetSocketAddress(0), 1);
            cmd.add("-port");
            cmd.add(String.valueOf(ss.getLocalPort()));
            if (timeoutFactor != 1.0f) {
                cmd.add("-timeoutFactor");
                cmd.add(String.valueOf(timeoutFactor));
            }
            if (testThreadFactory != null) {
                cmd.add("-testThreadFactory");
                cmd.add(testThreadFactory);
            }
            if (testThreadFactoryPath != null) {
                cmd.add("-testThreadFactoryPath");
                cmd.add(testThreadFactoryPath);
            }
            this.log("Started " + String.valueOf(cmd));
            ProcessBuilder pb = new ProcessBuilder(cmd);
            pb.directory(dir);
            Map<String, String> env = pb.environment();
            env.clear();
            env.putAll(envVars);
            this.process = pb.start();
            this.copyAgentProcessStream("stdout", this.process.getInputStream());
            this.copyAgentProcessStream("stderr", this.process.getErrorStream());
            try {
                int ACCEPT_TIMEOUT = (int)(60000.0f * timeoutFactor);
                ss.setSoTimeout(ACCEPT_TIMEOUT);
                Socket s = ss.accept();
                s.setSoTimeout((int)(120000.0f * timeoutFactor));
                this.in = new DataInputStream(s.getInputStream());
                this.out = new DataOutputStream(s.getOutputStream());
            }
            finally {
                ss.close();
            }
            this.keepAlive = new AgentServer.KeepAlive(this.out, traceAgent);
            this.keepAlive.setEnabled(true);
        }
        catch (IOException e) {
            throw new Fault(e);
        }
    }

    void copyAgentProcessStream(final String name, final InputStream in) {
        Thread t = new Thread(){

            @Override
            public void run() {
                try (BufferedReader inReader = new BufferedReader(new InputStreamReader(in));){
                    String line;
                    while ((line = inReader.readLine()) != null) {
                        Agent.this.handleProcessStreamLine(name, line);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }

    private synchronized void captureProcessStreams(TestResult.Section section) {
        this.currentTestResultSection = section;
        if (this.currentTestResultSection == null) {
            for (PrintWriter pw : this.processStreamWriters.values()) {
                pw.close();
            }
            this.processStreamWriters.clear();
        }
    }

    private synchronized void handleProcessStreamLine(String name, String line) {
        if (this.currentTestResultSection == null) {
            this.log(name + ": " + line);
        } else {
            this.processStreamWriters.computeIfAbsent(name, this.currentTestResultSection::createOutput).println(line);
        }
    }

    public boolean matches(File execDir, JDK jdk, List<String> vmOpts) {
        return this.execDir.getName().equals(execDir.getName()) && this.jdk.equals(jdk) && this.vmOpts.equals(vmOpts);
    }

    public Status doCompileAction(final String testName, final Map<String, String> testProps, final List<String> cmdArgs, int timeout, TimeoutHandler timeoutHandler, TestResult.Section trs) throws Fault {
        this.trace("doCompileAction " + testName + " " + String.valueOf(cmdArgs));
        return this.doAction("doCompileAction", new AgentAction(){

            @Override
            public void send() throws IOException {
                Agent.this.out.writeByte(1);
                Agent.this.out.writeUTF(testName);
                Agent.this.writeMap(testProps);
                Agent.this.writeCollection(cmdArgs);
                Agent.this.out.flush();
            }
        }, timeout, timeoutHandler, trs);
    }

    public Status doMainAction(final String testName, final Map<String, String> testProps, final Set<String> addExports, final Set<String> addOpens, final Set<String> addMods, final SearchPath testClassPath, final SearchPath modulePath, final String testClass, final List<String> testArgs, int timeout, TimeoutHandler timeoutHandler, TestResult.Section trs) throws Fault {
        this.trace("doMainAction: " + testName + " " + String.valueOf(testClassPath) + " " + String.valueOf(modulePath) + " " + testClass + " " + String.valueOf(testArgs));
        return this.doAction("doMainAction", new AgentAction(){

            @Override
            public void send() throws IOException {
                Agent.this.out.writeByte(2);
                Agent.this.out.writeUTF(testName);
                Agent.this.writeMap(testProps);
                Agent.this.writeCollection(addExports);
                Agent.this.writeCollection(addOpens);
                Agent.this.writeCollection(addMods);
                Agent.this.out.writeUTF(testClassPath.toString());
                Agent.this.out.writeUTF(modulePath.toString());
                Agent.this.out.writeUTF(testClass);
                Agent.this.writeCollection(testArgs);
                Agent.this.out.flush();
            }
        }, timeout, timeoutHandler, trs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Status doAction(String actionName, AgentAction agentAction, int timeout, final TimeoutHandler timeoutHandler, TestResult.Section trs) throws Fault {
        final PrintWriter messageWriter = trs.getMessageWriter();
        Alarm alarm = Alarm.NONE;
        final CountDownLatch timeoutHandlerDone = new CountDownLatch(1);
        if (timeout > 0) {
            if (timeoutHandler == null) {
                throw new NullPointerException("TimeoutHandler is required");
            }
            this.trace(actionName + ": scheduling timeout handler in " + timeout + " seconds");
            alarm = Alarm.schedule(timeout, TimeUnit.SECONDS, messageWriter, new Runnable(){

                @Override
                public void run() {
                    Agent.this.invokeTimeoutHandler(timeoutHandler, timeoutHandlerDone, messageWriter);
                }
            });
        }
        this.keepAlive.setEnabled(false);
        try {
            this.captureProcessStreams(trs);
            Object object = this.out;
            synchronized (object) {
                agentAction.send();
            }
            this.trace(actionName + ": request sent");
            object = this.readResults(trs);
            return object;
        }
        catch (IOException e) {
            this.trace(actionName + ":  error " + String.valueOf(e));
            throw new Fault(e);
        }
        finally {
            this.captureProcessStreams(null);
            alarm.cancel();
            this.keepAlive.setEnabled(true);
            if (alarm.didFire()) {
                this.waitForTimeoutHandler(actionName, timeoutHandler, timeoutHandlerDone);
                throw new Fault(new Exception("Agent " + this.id + " timed out with a timeout of " + timeout + " seconds"));
            }
        }
    }

    private void invokeTimeoutHandler(final TimeoutHandler timeoutHandler, final CountDownLatch timeoutHandlerDone, final PrintWriter messageWriter) {
        Thread timeoutHandlerThread = new Thread(){

            @Override
            public void run() {
                Agent.this.trace("timeout handler triggered");
                timeoutHandler.handleTimeout(Agent.this.process);
                try {
                    Agent.this.out.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace(messageWriter);
                }
                try {
                    Agent.this.in.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace(messageWriter);
                }
                Agent.this.trace("timeout handler finished");
                timeoutHandlerDone.countDown();
            }
        };
        timeoutHandlerThread.setName("Timeout Handler for Agent " + this.getId());
        timeoutHandlerThread.start();
    }

    private void waitForTimeoutHandler(String actionName, TimeoutHandler timeoutHandler, CountDownLatch timeoutHandlerDone) {
        this.trace(actionName + ":  waiting for timeout handler to complete.");
        try {
            if (timeoutHandler.getTimeout() <= 0L) {
                timeoutHandlerDone.await();
            } else {
                boolean done = timeoutHandlerDone.await(timeoutHandler.getTimeout() + 10L, TimeUnit.SECONDS);
                if (!done) {
                    this.trace(actionName + ": timeout handler did not complete within its own timeout.");
                }
            }
        }
        catch (InterruptedException e1) {
            this.trace(actionName + ":  interrupted while waiting for timeout handler to complete: " + String.valueOf(e1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.log("Closing...");
        this.keepAlive.finished();
        try {
            this.out.write(6);
            this.out.close();
        }
        catch (IOException e) {
            this.trace("Killing process (" + String.valueOf(e) + ")");
            ProcessUtils.destroyForcibly(this.process);
        }
        PrintWriter pw = new PrintWriter(System.err, true);
        Alarm alarm = Alarm.schedulePeriodicInterrupt(60L, TimeUnit.SECONDS, pw, Thread.currentThread());
        try {
            int rc = this.process.waitFor();
            if (rc != 0) {
                this.trace("Exited, process exit code: " + rc);
            }
        }
        catch (InterruptedException e) {
            this.log("Interrupted while closing");
            this.log("Killing process");
            ProcessUtils.destroyForcibly(this.process);
        }
        finally {
            alarm.cancel();
            Thread.interrupted();
        }
        this.log("Closed");
    }

    void writeCollection(Collection<String> c) throws IOException {
        this.out.writeShort(c.size());
        for (String s : c) {
            this.out.writeUTF(s);
        }
    }

    void writeOptionalString(String s) throws IOException {
        if (s == null) {
            this.out.writeByte(0);
        } else {
            this.out.writeByte(1);
            this.out.writeUTF(s);
        }
    }

    static String readOptionalString(DataInputStream in) throws IOException {
        byte b = in.readByte();
        return b == 0 ? null : in.readUTF();
    }

    void writeMap(Map<String, String> map) throws IOException {
        this.out.writeShort(map.size());
        for (Map.Entry<String, String> e : map.entrySet()) {
            this.out.writeUTF(e.getKey());
            this.out.writeUTF(e.getValue());
        }
    }

    Status readResults(TestResult.Section trs) throws IOException {
        byte op;
        HashMap<String, Object> streams = new HashMap<String, Object>();
        block5: while ((op = this.in.readByte()) != -1) {
            switch (op) {
                case 3: {
                    String name = this.in.readUTF();
                    String data = this.in.readUTF();
                    this.trace("readResults: OUTPUT '" + name + "' '" + data + "\"");
                    Object pw = (PrintWriter)streams.get(name);
                    if (pw == null) {
                        pw = name.equals(ActionHelper.OutputHandler.OutputKind.LOG.name) ? trs.getMessageWriter() : trs.createOutput(name);
                        streams.put(name, pw);
                    }
                    ((PrintWriter)pw).write(data);
                    continue block5;
                }
                case 4: {
                    byte type = this.in.readByte();
                    String reason = this.in.readUTF();
                    this.trace("readResults: STATUS '" + type + "' '" + reason + "\"");
                    for (PrintWriter pw : streams.values()) {
                        if (pw == trs.getMessageWriter()) continue;
                        pw.close();
                    }
                    Status status = RStatus.createStatus(type, reason);
                    return status;
                }
                case 5: {
                    continue block5;
                }
            }
            throw new IOException("Agent: unexpected op: " + op);
        }
        throw new EOFException("unexpected EOF");
    }

    public int getId() {
        return this.id;
    }

    private void log(String message) {
        this.logger.log(this, message);
        this.show(message);
    }

    private void show(String s) {
        if (showAgent || traceAgent) {
            this.log(s, System.err);
        }
    }

    private void trace(String s) {
        if (traceAgent) {
            this.log(s, System.err);
        }
    }

    private void log(String message, PrintStream out) {
        out.println("[" + AgentServer.logDateFormat.format(new Date()) + "] Agent[" + this.getId() + "]: " + message);
    }

    public static class Logger {
        private static WeakHashMap<RegressionParameters, Logger> instances = new WeakHashMap();
        private File agentLogFileDirectory;
        private final PrintWriter agentLogWriter;

        public static synchronized Logger instance(RegressionParameters params) {
            return instances.computeIfAbsent(params, Logger::new);
        }

        public static void close(RegressionParameters params) throws IOException {
            Logger l = instances.get(params);
            if (l != null) {
                l.close();
            }
        }

        Logger(RegressionParameters params) {
            PrintWriter out;
            WorkDirectory wd = params.getWorkDirectory();
            this.agentLogFileDirectory = wd.getJTData();
            File logFile = new File(this.agentLogFileDirectory, "agent.trace");
            try {
                out = new PrintWriter(new FileWriter(logFile));
            }
            catch (IOException e) {
                System.err.println("Cannot open agent log file: " + String.valueOf(e));
                out = new PrintWriter(System.err, true){

                    @Override
                    public void close() {
                        this.flush();
                    }
                };
            }
            this.agentLogWriter = out;
        }

        void log(Agent agent, String message) {
            String agentInfo;
            String dateInfo = AgentServer.logDateFormat.format(new Date());
            String string = agentInfo = agent == null ? "" : " Agent[" + agent.getId() + "]";
            if (message.contains("\n")) {
                String[] lines = message.split("\\R");
                int i = 0;
                for (String line : lines) {
                    this.agentLogWriter.printf("[%s]%s: #%d/%d %s%n", dateInfo, agentInfo, ++i, lines.length, line);
                }
            } else {
                this.agentLogWriter.printf("[%s]%s: %s%n", dateInfo, agentInfo, message);
            }
        }

        File getAgentServerLogFile(int id) {
            return new File(this.agentLogFileDirectory, "agentServer." + id + ".trace");
        }

        public void close() throws IOException {
            this.agentLogWriter.close();
        }
    }

    public static class Fault
    extends Exception {
        private static final long serialVersionUID = 0L;

        Fault(Throwable e) {
            super(e);
        }
    }

    static interface AgentAction {
        public void send() throws IOException;
    }

    static class Stats {
        Set<File> allDirs = new TreeSet<File>();
        Set<JDK> allJDKs = new TreeSet<JDK>(Comparator.comparing(j -> j.getPath()));
        Set<List<String>> allVMOpts = new TreeSet<List>(Comparator.comparing(Objects::toString));
        Map<Integer, Integer> useCounts = new TreeMap<Integer, Integer>();
        Map<Integer, Integer> sizeCounts = new TreeMap<Integer, Integer>();

        Stats() {
        }

        void add(Agent a) {
            this.allDirs.add(a.execDir);
            this.allJDKs.add(a.jdk);
            this.allVMOpts.add(a.vmOpts);
            this.useCounts.put(a.id, 1);
        }

        void reuse(Agent a) {
            this.useCounts.put(a.id, this.useCounts.get(a.id) + 1);
        }

        void trackPoolSize(int size) {
            this.sizeCounts.put(size, this.sizeCounts.computeIfAbsent(size, s -> 0) + 1);
        }

        void clear() {
            this.allDirs.clear();
            this.allJDKs.clear();
            this.allVMOpts.clear();
            this.useCounts.clear();
            this.sizeCounts.clear();
        }

        void report(File file, Logger logger) {
            try (PrintWriter out = new PrintWriter(new FileWriter(file));){
                this.report(out, "Execution Directories", this.allDirs);
                out.println();
                this.report(out, "JDKs", this.allJDKs);
                out.println();
                this.report(out, "VM Options", this.allVMOpts);
                out.println();
                out.format("Agent Usage:%n", new Object[0]);
                this.useCounts.forEach((id, c) -> out.format("    %3d: %3d%n", id, c));
                double[] use_m_sd = this.getSimpleMeanStandardDeviation(this.useCounts.values());
                out.format("Mean:          %5.1f%n", use_m_sd[0]);
                out.format("Std Deviation: %5.1f%n", use_m_sd[1]);
                out.println();
                out.format("Pool Size:%n", new Object[0]);
                this.sizeCounts.forEach((size, c) -> out.format("    %3d: %3d%n", size, c));
                double[] size_m_sd = this.getWeightedMeanStandardDeviation(this.sizeCounts);
                out.format("Mean          %5.1f%n", size_m_sd[0]);
                out.format("Std Deviation %5.1f%n", size_m_sd[1]);
            }
            catch (IOException e) {
                logger.log(null, "STATS: can't write stats file " + String.valueOf(file) + ": " + String.valueOf(e));
            }
        }

        private <T> void report(PrintWriter out, String title, Set<T> set) {
            out.format("%s: %d%n", title, set.size());
            set.forEach(item -> out.format("    %s%n", item));
        }

        double[] getSimpleMeanStandardDeviation(Collection<Integer> values) {
            double sum = 0.0;
            for (Integer v : values) {
                sum += (double)v.intValue();
            }
            double mean = sum / (double)values.size();
            double sum2 = 0.0;
            for (Integer v : values) {
                double x = (double)v.intValue() - mean;
                sum2 += x * x;
            }
            double sd = Math.sqrt(sum2 / (double)values.size());
            return new double[]{mean, sd};
        }

        double[] getWeightedMeanStandardDeviation(Map<Integer, Integer> map) {
            long count = 0L;
            double sum = 0.0;
            for (Map.Entry<Integer, Integer> e : map.entrySet()) {
                int value = e.getKey();
                int freq = e.getValue();
                sum += (double)(value * freq);
                count += (long)freq;
            }
            double mean = sum / (double)count;
            double sum2 = 0.0;
            for (Map.Entry<Integer, Integer> e : map.entrySet()) {
                int value = e.getKey();
                int freq = e.getValue();
                double x = (double)value - mean;
                sum2 += x * x * (double)freq;
            }
            double sd = Math.sqrt(sum2 / (double)count);
            return new double[]{mean, sd};
        }
    }

    public static class Pool {
        private static WeakHashMap<RegressionParameters, Pool> instances = new WeakHashMap();
        private Stats stats = new Stats();
        private final Logger logger;
        private final Map<String, Deque<Agent>> agentsByKey = new HashMap<String, Deque<Agent>>();
        private final Deque<Agent> allAgents = new LinkedList<Agent>();
        private File policyFile;
        private float timeoutFactor = 1.0f;
        private int maxPoolSize;
        private Duration idleTimeout;

        public static synchronized Pool instance(RegressionParameters params) {
            return instances.computeIfAbsent(params, Pool::new);
        }

        private Pool(RegressionParameters params) {
            this.logger = Logger.instance(params);
        }

        public void setSecurityPolicy(File policyFile) {
            this.policyFile = policyFile;
        }

        public void setTimeoutFactor(float factor) {
            this.timeoutFactor = factor;
        }

        public void setIdleTimeout(Duration timeout) {
            this.idleTimeout = timeout;
            this.logger.log(null, "POOL: idle timeout: " + String.valueOf(timeout));
        }

        public void setMaxPoolSize(int size) {
            this.maxPoolSize = size;
            this.logger.log(null, "POOL: max pool size: " + this.maxPoolSize);
        }

        synchronized Agent getAgent(File dir, JDK jdk, List<String> vmOpts, Map<String, String> envVars, String testThreadFactory, String testThreadFactoryPath) throws Fault {
            Agent a;
            this.logger.log(null, "POOL: get agent for:\n   directory: " + String.valueOf(dir) + "\n         JDK: " + String.valueOf(jdk) + "\n  VM options: " + String.valueOf(vmOpts) + "\n");
            Deque<Agent> agents = this.agentsByKey.get(Pool.getKey(dir, jdk, vmOpts));
            Agent agent = a = agents == null ? null : agents.pollLast();
            if (a != null) {
                this.logger.log(null, "POOL: Reusing Agent[" + a.getId() + "]");
                this.allAgents.remove(a);
                this.stats.reuse(a);
            } else {
                this.logger.log(null, "POOL: Creating new agent");
                a = new Agent(dir, jdk, vmOpts, envVars, this.policyFile, this.timeoutFactor, this.logger, testThreadFactory, testThreadFactoryPath);
                this.stats.add(a);
            }
            return a;
        }

        synchronized void save(Agent agent) {
            Instant now;
            this.logger.log(agent, "Saving agent to pool");
            String key = Pool.getKey(agent.execDir, agent.jdk, agent.vmOpts);
            this.agentsByKey.computeIfAbsent(key, k -> new LinkedList()).add(agent);
            this.allAgents.addLast(agent);
            agent.idleStartTime = now = Instant.now();
            this.cleanOldEntries(now);
            this.stats.trackPoolSize(this.allAgents.size());
        }

        private synchronized void cleanOldEntries(Instant now) {
            Agent a;
            while (this.allAgents.size() > this.maxPoolSize) {
                a = this.allAgents.getFirst();
                this.logger.log(a, "Removing excess agent from pool");
                this.removeAgent(a);
            }
            while (!this.allAgents.isEmpty() && this.isIdleTooLong(this.allAgents.peekFirst(), now)) {
                a = this.allAgents.getFirst();
                this.logger.log(a, "Removing idle agent from pool");
                this.removeAgent(a);
            }
        }

        private void removeAgent(Agent a) {
            this.agentsByKey.get(Pool.getKey(a)).remove(a);
            this.allAgents.remove(a);
            a.close();
        }

        private boolean isIdleTooLong(Agent a, Instant now) {
            return Duration.between(a.idleStartTime, now).compareTo(this.idleTimeout) > 0;
        }

        public static synchronized void flush(RegressionParameters params) {
            Pool instance = instances.get(params);
            if (instance != null) {
                instance.flush();
            }
        }

        public synchronized void flush() {
            this.logger.log(null, "POOL: closing all agents");
            for (Agent a : this.allAgents) {
                a.close();
            }
            this.allAgents.clear();
            this.agentsByKey.clear();
            this.stats.report(new File(this.logger.agentLogFileDirectory, "agent.summary"), this.logger);
        }

        static synchronized void close(RegressionParameters params, File dir) {
            Pool instance = instances.get(params);
            if (instance != null) {
                instance.close(dir);
            }
        }

        synchronized void close(File dir) {
            this.logger.log(null, "POOL: closing agents using directory " + String.valueOf(dir));
            Iterator<Agent> iter = this.allAgents.iterator();
            while (iter.hasNext()) {
                Agent agent = iter.next();
                if (!agent.execDir.equals(dir)) continue;
                iter.remove();
                String agentKey = Pool.getKey(agent);
                Deque<Agent> deque = this.agentsByKey.get(agentKey);
                deque.remove(agent);
                if (deque.isEmpty()) {
                    this.agentsByKey.remove(agentKey);
                }
                agent.close();
            }
        }

        private static String getKey(Agent agent) {
            return Pool.getKey(agent.execDir, agent.jdk, agent.vmOpts);
        }

        private static String getKey(File dir, JDK jdk, List<String> vmOpts) {
            return dir.getAbsolutePath() + " " + String.valueOf(jdk.getAbsoluteHomeDirectory()) + " " + StringUtils.join(vmOpts, " ");
        }
    }
}

