/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.exec;

import com.sun.javatest.regtest.exec.Action;
import java.io.File;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;

public class ActionRecorder {
    private static final String CONT = " \\";
    private final Action action;
    private PrintWriter pw;

    ActionRecorder(Action action) {
        this.action = action;
    }

    public void exec(List<String> cmd, Map<String, String> envArgs) {
        Object indent;
        this.initPW();
        this.printWorkDir();
        for (Map.Entry<String, String> var : envArgs.entrySet()) {
            this.pw.println(var.getKey() + "=" + this.escape(var.getValue()) + CONT);
        }
        boolean CMD = true;
        int ARG = 2;
        int state = 1;
        int size = cmd.size();
        Object sep = indent = "    ";
        block5: for (int i = 0; i < size; ++i) {
            String word = cmd.get(i);
            switch (state) {
                case 1: {
                    this.pw.print((String)indent);
                    this.pw.print(this.escape(word));
                    if (i + 1 < size) {
                        this.pw.println(CONT);
                    }
                    state = 2;
                    sep = indent = (String)indent + "    ";
                    continue block5;
                }
                case 2: {
                    if (word.startsWith("-") && ((String)sep).equals(" ")) {
                        this.pw.println(CONT);
                        sep = indent;
                    }
                    this.pw.print((String)sep);
                    this.pw.print(this.escape(word));
                    sep = " ";
                }
            }
        }
        this.pw.println();
    }

    public void exec(String cmd) {
        this.initPW();
        this.printWorkDir();
        for (String line : cmd.split("[\r\n]+")) {
            this.pw.println(line);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void java(Map<String, String> envArgs, Path javaCmd, Map<String, String> javaProps, List<String> javaOpts, String className, List<String> classArgs) {
        this.initPW();
        this.printWorkDir();
        for (Map.Entry<String, String> entry : envArgs.entrySet()) {
            this.pw.println(entry.getKey() + "=" + this.escape(entry.getValue()) + CONT);
        }
        Object indent = "    ";
        this.pw.println((String)indent + this.escape(javaCmd.toString()) + CONT);
        indent = (String)indent + "    ";
        for (Map.Entry<String, String> entry : javaProps.entrySet()) {
            this.pw.println((String)indent + "-D" + this.escape(entry.getKey()) + "=" + this.escape(entry.getValue()) + CONT);
        }
        if (javaOpts.size() > 0) {
            Object object = indent;
            for (String o : javaOpts) {
                void var8_13;
                void var8_11;
                if (o.startsWith("-") && var8_11.equals(" ")) {
                    this.pw.println(CONT);
                    Object object2 = indent;
                }
                this.pw.print((String)var8_13);
                this.pw.print(this.escape(o));
                String string = " ";
            }
            this.pw.println(CONT);
        }
        this.pw.print((String)indent + this.escape(className));
        for (String string : classArgs) {
            this.pw.print(" ");
            this.pw.print(this.escape(string));
        }
        this.pw.println();
    }

    /*
     * WARNING - void declaration
     */
    void javac(Map<String, String> envArgs, Path javacCmd, List<String> javacVMOpts, Map<String, String> javacProps, List<String> javacArgs) {
        this.initPW();
        this.printWorkDir();
        for (Map.Entry<String, String> entry : envArgs.entrySet()) {
            this.pw.println(entry.getKey() + "=" + this.escape(entry.getValue()) + CONT);
        }
        Object indent = "    ";
        this.pw.println((String)indent + this.escape(javacCmd.toString()) + CONT);
        indent = (String)indent + "    ";
        for (String o : javacVMOpts) {
            this.pw.println((String)indent + "-J" + this.escape(o) + CONT);
        }
        for (Map.Entry<String, String> e : javacProps.entrySet()) {
            this.pw.println((String)indent + "-J-D" + this.escape(e.getKey()) + "=" + this.escape(e.getValue()) + CONT);
        }
        Object object = indent;
        for (String a : javacArgs) {
            void var7_13;
            void var7_11;
            if (a.startsWith("-") && var7_11.equals(" ")) {
                this.pw.println(CONT);
                Object object2 = indent;
            }
            this.pw.print((String)var7_13);
            this.pw.print(this.escape(a));
            String string = " ";
        }
        this.pw.println();
    }

    public void asmtools(String toolClassName, List<String> toolArgs) {
        this.initPW();
        this.printWorkDir();
        String javaHome = System.getProperty("java.home");
        String javaCmd = new File(javaHome, "bin/java").toString();
        String indent = "    ";
        this.pw.println(indent + this.escape(javaCmd) + CONT);
        this.pw.println(indent + "-classpath " + String.valueOf(this.action.script.getAsmToolsPath()) + CONT);
        this.pw.print(indent + this.escape(toolClassName));
        for (String a : toolArgs) {
            this.pw.print(" ");
            this.pw.print(this.escape(a));
        }
        this.pw.println();
    }

    public void close() {
        if (this.pw != null) {
            this.pw.close();
        }
    }

    private void initPW() {
        if (this.pw == null) {
            this.pw = new PrintWriter(this.action.section.createOutput("rerun"));
        }
    }

    private String escape(String word) {
        for (int i = 0; i < word.length(); ++i) {
            switch (word.charAt(i)) {
                case ' ': 
                case '$': 
                case '\\': {
                    return "'" + word + "'";
                }
            }
        }
        return word;
    }

    private void printWorkDir() {
        this.pw.println("cd " + this.escape(this.action.script.absTestScratchDir().toString()) + " && \\");
    }
}

