/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.exec;

import com.sun.javatest.Status;
import com.sun.javatest.TestResult;
import com.sun.javatest.regtest.agent.ActionHelper;
import com.sun.javatest.regtest.agent.Flags;
import com.sun.javatest.regtest.agent.SearchPath;
import com.sun.javatest.regtest.config.ExecMode;
import com.sun.javatest.regtest.config.Modules;
import com.sun.javatest.regtest.config.OS;
import com.sun.javatest.regtest.config.ParseException;
import com.sun.javatest.regtest.exec.ActionRecorder;
import com.sun.javatest.regtest.exec.RegressionScript;
import com.sun.javatest.regtest.exec.TestRunException;
import com.sun.javatest.regtest.util.FileUtils;
import com.sun.javatest.regtest.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class Action
extends ActionHelper {
    private static final Map<Path, String> automaticNames = new ConcurrentHashMap<Path, String>();
    protected static final String FILESEP = System.getProperty("file.separator");
    protected static final String LINESEP = System.getProperty("line.separator");
    protected static final String EXECQUOTE = System.getProperty("os.name").startsWith("Windows") ? "\"" : "";
    public static final String REASON_ASSUMED_ACTION = "ASSUMED_ACTION";
    public static final String REASON_USER_SPECIFIED = "USER_SPECIFIED";
    public static final String REASON_ASSUMED_BUILD = "ASSUMED_BUILD";
    public static final String REASON_FILE_TOO_OLD = "FILE_OUT_OF_DATE";
    protected static final String SREASON_ASSUMED_ACTION = "Assumed action based on file name: run ";
    protected static final String SREASON_USER_SPECIFIED = "User specified action: run ";
    protected static final String SREASON_ASSUMED_BUILD = "Named class compiled on demand";
    protected static final String SREASON_FILE_TOO_OLD = ".class file out of date or does not exist";
    protected static final String PARSE_TIMEOUT_NONE = "No timeout value";
    protected static final String PARSE_TIMEOUT_BAD_INT = "Bad integer specification: ";
    protected static final String PARSE_FAIL_UEXPECT = "Unexpected value for `fail': ";
    protected static final String PARSE_MODULE_NONE = "No module name";
    protected static final String PARSE_MODULE_INVALID = "Invalid module name";
    protected static final String PARSE_BAD_OPT_JDK = "Option not allowed using provided test JDK: ";
    protected static final String PARSE_NO_POLICY_NAME = "No policy file name";
    protected static final String PARSE_CANT_FIND_POLICY = "Can't find policy file: ";
    protected static final String PARSE_NO_SECURE_NAME = "No security manager file name";
    protected static final String PARSE_POLICY_OTHERVM = "`/policy' and `/java.security.policy` require use of `/othervm'";
    protected static final String PARSE_SECURE_OTHERVM = "`/secure' requires use of `/othervm'";
    protected static final String PARSE_TIMEOUT_MANUAL = "`/manual' disables use of `/timeout'";
    protected static final String POLICY_WRITE_PROB = "Problems writing new policy file: ";
    protected static final String POLICY_SM_PROB = "Unable to create new policy file: ";
    protected static final String LOG_COMMAND = "command: ";
    protected static final String LOG_RESULT = " result: ";
    protected static final String LOG_JT_COMMAND = "JavaTest command: ";
    protected static final String LOG_REASON = "reason: ";
    protected static final String LOG_ELAPSED_TIME = "elapsed time (seconds): ";
    protected static final String LOG_STARTED = "started: ";
    protected static final String LOG_FINISHED = "finished: ";
    protected static final String EXEC_FAIL = "Execution failed";
    protected static final String EXEC_FAIL_EXPECT = "Execution failed as expected";
    protected static final String EXEC_PASS_UNEXPECT = "Execution passed unexpectedly";
    protected static final String CHECK_PASS = "Test description appears acceptable";
    protected static final String AGENTVM_CANT_GET_VM = "Cannot get VM for test";
    protected static final String AGENTVM_IO_EXCEPTION = "Agent communication error: %s; check console log for any additional details";
    protected static final String AGENTVM_EXCEPTION = "Agent error: %s; check console log for any additional details";
    protected static final String CANT_FIND_SRC = "Can't find source file: ";
    protected static final String APPLET_ONE_ARG_REQ = "`applet' requires exactly one file argument";
    protected static final String APPLET_BAD_VAL_MANUAL = "Bad value for `manual' option: ";
    protected static final String APPLET_BAD_OPT = "Bad option for applet: ";
    protected static final String APPLET_CANT_FIND_HTML = "Can't find HTML file: ";
    protected static final String APPLET_HTML_READ_PROB = "Problem reading HTML file: ";
    protected static final String APPLET_MISS_ENDBODY = "No </body> tag in ";
    protected static final String APPLET_MISS_APPLET = "No <applet> tag in ";
    protected static final String APPLET_MISS_ENDAPPLET = "No </applet> tag in ";
    protected static final String APPLET_MISS_REQ_ATTRIB = " missing required attribute ";
    protected static final String APPLET_ARCHIVE_USUPP = "`archive' not supported in file: ";
    protected static final String APPLET_MISS_REQ_PARAM = "Missing required name or value for param in <param> tag";
    protected static final String APPLET_CANT_WRITE_ARGS = "Can't write `applet' argument file";
    protected static final String APPLET_SECMGR_FILEOPS = "Unable to create applet argument file";
    protected static final String APPLET_USER_EVAL = ", user evaluated";
    protected static final String APPLET_MANUAL_TEST = "Manual test";
    protected static final String BUILD_UNEXPECT_OPT = "Unexpected options for `build'";
    protected static final String BUILD_NO_CLASSNAME = "No classname(s) provided for `build'";
    protected static final String BUILD_BAD_CLASSNAME = "Bad classname provided for `build': ";
    protected static final String BUILD_NO_COMP_NEED = "No need to compile: ";
    protected static final String BUILD_UP_TO_DATE = "All files up to date";
    protected static final String BUILD_SUCC = "Build successful";
    protected static final String BUILD_LIB_LIST = " in directory-list: ";
    protected static final String BUILD_FUTURE_SOURCE = "WARNING: file %s has a modification time in the future: %s";
    protected static final String BUILD_FUTURE_SOURCE_2 = "Unexpected results may occur";
    protected static final String CLEAN_SUCC = "Clean successful";
    protected static final String CLEAN_UNEXPECT_OPT = "Unexpected option(s) for `clean'";
    protected static final String CLEAN_NO_CLASSNAME = "No classname(s) provided for `clean'";
    protected static final String CLEAN_BAD_CLASSNAME = "Bad classname provided for `clean': ";
    protected static final String CLEAN_RM_FAILED = "`clean' unable to delete file: ";
    protected static final String CLEAN_SECMGR_PROB = "Problem deleting directory contents: ";
    protected static final String COMPILE_NO_CLASSNAME = "No classname provided for `compile'";
    protected static final String COMPILE_NO_DOT_JAVA = "No classname ending with `.java' found";
    protected static final String COMPILE_BAD_OPT = "Bad option for compile: ";
    protected static final String COMPILE_OPT_DISALLOW = "Compile option not allowed: ";
    protected static final String COMPILE_NO_REF_NAME = "No reference file name";
    protected static final String COMPILE_CANT_FIND_REF = "Can't find reference file: ";
    protected static final String COMPILE_CANT_READ_REF = "Can't read reference file: ";
    protected static final String COMPILE_GOLD_FAIL = "Output does not match reference file: ";
    protected static final String COMPILE_GOLD_LINE = ", line ";
    protected static final String COMPILE_GOLD_READ_PROB = "Problem reading reference file: ";
    protected static final String COMPILE_MODULES_UEXPECT = "Unexpected value for `modules': ";
    protected static final String COMPILE_CANT_CREATE_ARG_FILE = "Can't create `compile' argument file";
    protected static final String COMPILE_CANT_WRITE_ARGS = "Can't write `compile' argument file";
    protected static final String COMPILE_SECMGR_FILEOPS = "Unable to create `compile' argument file";
    protected static final String COMPILE_PASS_UNEXPECT = "Compilation passed unexpectedly";
    protected static final String COMPILE_PASS = "Compilation successful";
    protected static final String COMPILE_FAIL_EXPECT = "Compilation failed as expected";
    protected static final String COMPILE_FAIL = "Compilation failed";
    protected static final String COMPILE_CANT_RESET_SECMGR = "Cannot reset security manager";
    protected static final String COMPILE_CANT_RESET_PROPS = "Cannot reset system properties";
    protected static final String IGNORE_UNEXPECT_OPTS = "Unexpected option(s) for `ignore'";
    protected static final String IGNORE_TEST_IGNORED = "Test ignored";
    protected static final String IGNORE_TEST_IGNORED_C = "Test ignored: ";
    protected static final String IGNORE_TEST_SUPPRESSED = "@ignore suppressed by command line option";
    protected static final String IGNORE_TEST_SUPPRESSED_C = "@ignore suppressed by command line option: ";
    protected static final String JUNIT_NO_CLASSNAME = "No class provided for `junit'";
    protected static final String JUNIT_BAD_MAIN_ARG = "Bad argument provided for class in `junit'";
    protected static final String DRIVER_NO_CLASSNAME = "No class provided for `driver'";
    protected static final String DRIVER_UNEXPECT_VMOPT = "VM options not allowed";
    protected static final String DRIVER_BAD_OPT = "Bad option for driver: ";
    protected static final String MAIN_NO_CLASSNAME = "No class provided for `main'";
    protected static final String MAIN_MANUAL_NO_VAL = "Arguments to `manual' option not supported: ";
    protected static final String MAIN_BAD_OPT = "Bad option for main: ";
    protected static final String MAIN_CANT_FIND_SECURE = "Can't find security manager file name: ";
    protected static final String MAIN_BAD_OPT_JDK = "Option not allowed using provided test JDK: ";
    protected static final String MAIN_NO_POLICY_NAME = "No policy file name";
    protected static final String MAIN_CANT_FIND_POLICY = "Can't find policy file: ";
    protected static final String MAIN_POLICY_OTHERVM = "`/policy' requires use of `/othervm'";
    protected static final String MAIN_NO_SECURE_NAME = "No security manager file name";
    protected static final String MAIN_SECURE_OTHERVM = "`/secure' requires use of `/othervm'";
    protected static final String MAIN_UNEXPECT_VMOPT = ": vm option(s) found, need to specify /othervm";
    protected static final String MAIN_POLICY_WRITE_PROB = "Problems writing new policy file: ";
    protected static final String MAIN_POLICY_SM_PROB = "Unable to create new policy file: ";
    protected static final String MAIN_CANT_RESET_SECMGR = "Cannot reset security manager";
    protected static final String MAIN_CANT_RESET_PROPS = "Cannot reset system properties";
    protected static final String MAIN_NO_NATIVES = "Use -nativepath to specify the location of native code";
    protected static final String MAIN_CANT_WRITE_ARGS = "Can't write `main' argument file";
    protected static final String MAIN_SECMGR_FILEOPS = "Unable to create `main' argument file";
    protected static final String SHELL_NO_SCRIPT_NAME = "No script name provided for `shell'";
    protected static final String SHELL_MANUAL_NO_VAL = "Arguments to `manual' option not supported: ";
    protected static final String SHELL_BAD_OPTION = "Bad option for shell: ";
    protected Map<String, String> opts;
    protected List<String> args;
    protected String reason;
    protected RegressionScript script;
    protected TestResult.Section section;
    protected ActionRecorder recorder;
    protected PrintWriter configWriter;
    private long startTime;
    protected static final boolean showCmd = Flags.get("showCmd");
    protected static final boolean showMode = Flags.get("showMode");
    protected static final boolean showJDK = Flags.get("showJDK");

    public abstract String getName();

    public void init(Map<String, String> opts, List<String> args, String reason, RegressionScript script) throws ParseException {
        this.opts = opts;
        this.args = args;
        this.reason = reason;
        this.script = script;
    }

    public abstract Status run() throws TestRunException;

    public Set<File> getSourceFiles() {
        return null;
    }

    public Set<String> getModules() {
        return Collections.emptySet();
    }

    protected Map<String, String> getEnvVars(boolean nativeCode) {
        Path nativeDir;
        Map<String, String> envVars = this.script.getEnvVars();
        if (nativeCode && (nativeDir = this.script.getNativeDir()) != null) {
            String libPathName;
            envVars = new LinkedHashMap<String, String>(envVars);
            OS os = OS.current();
            switch (os.family) {
                case "aix": 
                case "os400": {
                    libPathName = "LIBPATH";
                    break;
                }
                case "mac": {
                    libPathName = "DYLD_LIBRARY_PATH";
                    break;
                }
                case "windows": {
                    libPathName = "PATH";
                    break;
                }
                default: {
                    libPathName = "LD_LIBRARY_PATH";
                }
            }
            String libPath = envVars.get(libPathName);
            if (libPath == null) {
                envVars.put(libPathName, nativeDir.toString());
            } else {
                envVars.put(libPathName, libPath + File.pathSeparator + String.valueOf(nativeDir));
            }
            envVars = Collections.unmodifiableMap(envVars);
        }
        return envVars;
    }

    static synchronized void mkdirs(File dir) {
        dir.mkdirs();
    }

    public File getArgFile() {
        Path f = this.script.absTestWorkFile(this.getName() + "." + this.script.getNextSerial() + ".jta");
        FileUtils.createDirectories(f.getParent());
        return f.toFile();
    }

    protected int parseTimeout(String value) throws ParseException {
        if (value == null) {
            throw new ParseException(PARSE_TIMEOUT_NONE);
        }
        try {
            return this.script.getActionTimeout(Integer.parseInt(value));
        }
        catch (NumberFormatException e) {
            throw new ParseException(PARSE_TIMEOUT_BAD_INT + value);
        }
    }

    protected boolean parseFail(String value) throws ParseException {
        if (value != null) {
            throw new ParseException(PARSE_FAIL_UEXPECT + value);
        }
        return true;
    }

    protected String parseModule(String value) throws ParseException {
        if (value == null) {
            throw new ParseException(PARSE_MODULE_NONE);
        }
        if (!this.isQualifiedName(value)) {
            throw new ParseException(PARSE_MODULE_INVALID + value);
        }
        return value;
    }

    private boolean isQualifiedName(String name) {
        boolean beginIdent = true;
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (beginIdent) {
                if (!Character.isJavaIdentifierStart(ch)) {
                    return false;
                }
                beginIdent = false;
                continue;
            }
            if (ch == '.') {
                beginIdent = true;
                continue;
            }
            if (Character.isJavaIdentifierPart(ch)) continue;
            return false;
        }
        return !beginIdent;
    }

    protected File addGrantEntries(File fileName) throws TestRunException {
        return this.addGrantEntries(fileName, null);
    }

    protected File addGrantEntries(File fileName, File argFile) throws TestRunException {
        File newPolicy = this.script.absTestScratchDir().resolve(fileName.getName() + "_new").toFile();
        try (FileWriter fw = new FileWriter(newPolicy);){
            fw.write("// The following grant entries were added by jtreg.  Do not edit." + LINESEP);
            fw.write("grant {" + LINESEP);
            fw.write("    permission java.io.FilePermission \"" + this.script.absTestClsTopDir().toString().replace(FILESEP, "{/}") + "${/}-\", \"read\";" + LINESEP);
            if (argFile != null) {
                fw.write("    permission java.io.FilePermission \"" + argFile.getPath().replace(FILESEP, "{/}") + "\", \"read\";" + LINESEP);
            }
            fw.write("};" + LINESEP);
            ArrayList<Path> libs = new ArrayList<Path>();
            libs.addAll(this.script.getJavaTestClassPath().asList());
            if (this.script.isJUnitRequired()) {
                libs.addAll(this.script.getJUnitPath().asList());
            }
            if (this.script.isTestNGRequired()) {
                libs.addAll(this.script.getTestNGPath().asList());
            }
            for (Path lib : libs) {
                fw.write("grant codebase \"" + String.valueOf(lib.toUri()) + "\" {" + LINESEP);
                fw.write("    permission java.security.AllPermission;" + LINESEP);
                fw.write("};" + LINESEP);
            }
            fw.write(LINESEP);
            fw.write("// original policy file:" + LINESEP);
            fw.write("// " + String.valueOf(fileName) + LINESEP);
            try (BufferedReader in = new BufferedReader(new FileReader(fileName));){
                String line;
                while ((line = in.readLine()) != null) {
                    fw.write(line + LINESEP);
                }
            }
        }
        catch (IOException e) {
            throw new TestRunException("Problems writing new policy file: " + String.valueOf(newPolicy));
        }
        catch (SecurityException e) {
            throw new TestRunException("Unable to create new policy file: " + String.valueOf(newPolicy));
        }
        return newPolicy;
    }

    protected File parsePolicy(String value) throws ParseException {
        if (value == null || value.equals("")) {
            throw new ParseException("No policy file name");
        }
        File policyFile = this.script.absTestSrcDir().resolve(value).toFile();
        if (!policyFile.exists()) {
            throw new ParseException("Can't find policy file: " + String.valueOf(policyFile));
        }
        return policyFile;
    }

    protected String parseSecure(String value) throws ParseException {
        if (value == null || value.equals("")) {
            throw new ParseException("No security manager file name");
        }
        return value;
    }

    protected void startAction(boolean initConfig) {
        String name = this.getName();
        this.section = this.script.getTestResult().createSection(name);
        PrintWriter pw = this.section.getMessageWriter();
        pw.println(LOG_COMMAND + name + " " + StringUtils.join(this.args, " "));
        pw.println(LOG_REASON + this.reason);
        this.recorder = new ActionRecorder(this);
        if (initConfig) {
            this.configWriter = this.section.createOutput("configuration");
        }
        Date startDate = new Date();
        this.startTime = startDate.getTime();
        pw.println(LOG_STARTED + String.valueOf(startDate));
    }

    protected void endAction(Status status) {
        Date endDate = new Date();
        long elapsedTime = endDate.getTime() - this.startTime;
        PrintWriter pw = this.section.getMessageWriter();
        pw.println(LOG_FINISHED + String.valueOf(endDate));
        pw.println(LOG_ELAPSED_TIME + (double)elapsedTime / 1000.0);
        this.recorder.close();
        this.section.setStatus(status);
    }

    protected void showCmd(String action, String[] cmdArgs, TestResult.Section section) {
        this.showCmd(action, List.of(cmdArgs), section);
    }

    protected void showCmd(String action, List<String> cmdArgs, TestResult.Section section) {
        PrintWriter pw = section.getMessageWriter();
        pw.println(LOG_JT_COMMAND + action);
        for (String s : cmdArgs) {
            pw.print("'" + s + "' ");
        }
        pw.println();
    }

    protected void showMode(String action, ExecMode mode, TestResult.Section section) {
        PrintWriter pw = section.getMessageWriter();
        pw.println("MODE: " + String.valueOf((Object)mode));
    }

    protected void showMode(ExecMode mode) {
        this.showMode(mode, null);
    }

    protected void showMode(ExecMode mode, Set<String> reasons) {
        PrintWriter pw = this.section.getMessageWriter();
        pw.print("Mode: " + mode.name().toLowerCase());
        if (reasons != null && !reasons.isEmpty()) {
            pw.print(" ");
            pw.print(reasons);
        }
        pw.println();
    }

    String[] quoteBackslash(String[] s) {
        String bs = "\\";
        String[] retVal = new String[s.length];
        if (System.getProperty("file.separator").equals(bs)) {
            for (int i = 0; i < s.length; ++i) {
                String victim = s[i];
                StringBuilder sb = new StringBuilder();
                for (int j = 0; j < victim.length(); ++j) {
                    String c = String.valueOf(victim.charAt(j));
                    sb.append(c);
                    if (!c.equals(bs)) continue;
                    sb.append(c);
                }
                retVal[i] = sb.toString();
            }
        } else {
            retVal = s;
        }
        return retVal;
    }

    String singleQuoteString(String s) {
        StringBuilder b = new StringBuilder();
        b.append("'").append(s).append("'");
        return b.toString();
    }

    protected static <T> List<T> join(List<T> l1, List<T> l2) {
        ArrayList<T> result = new ArrayList<T>();
        result.addAll(l1);
        result.addAll(l2);
        return result;
    }

    Set<String> getModules(SearchPath pp) {
        if (pp == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> results = new LinkedHashSet<String>();
        for (Path element : pp.asList()) {
            if (Files.isRegularFile(element, new LinkOption[0])) {
                this.getModule(element, results);
                continue;
            }
            if (!Files.isDirectory(element, new LinkOption[0])) continue;
            for (Path file : FileUtils.listFiles(element)) {
                this.getModule(file, results);
            }
        }
        return results;
    }

    private void getModule(Path file, Set<String> results) {
        if (this.isModule(file)) {
            results.add(file.getFileName().toString());
        } else if (file.getFileName().toString().endsWith(".jar")) {
            results.add(this.getAutomaticModuleName(file));
        }
    }

    private boolean isModule(Path f) {
        if (Files.isDirectory(f, new LinkOption[0])) {
            if (this.script.systemModules.contains(f.getFileName().toString())) {
                return true;
            }
            if (Files.exists(f.resolve("module-info.class"), new LinkOption[0])) {
                return true;
            }
            if (Files.exists(f.resolve("module-info.java"), new LinkOption[0])) {
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getAutomaticModuleName(Path f) {
        String cached = automaticNames.get(f);
        if (cached != null) {
            return cached;
        }
        try (JarFile jar = new JarFile(f.toFile());){
            Manifest mf = jar.getManifest();
            Attributes attrs = mf.getMainAttributes();
            String amn = attrs.getValue("Automatic-Module-Name");
            if (amn != null) {
                automaticNames.put(f, amn);
                String string = amn;
                return string;
            }
        }
        catch (IOException e) {
            this.script.getMessageWriter().println("Problem reading jar manifest to get Automatic-Module-Name: " + String.valueOf(f) + " " + String.valueOf(e));
        }
        String fn = f.getFileName().toString();
        String mn = fn.substring(0, fn.length() - 4);
        Object vs = null;
        Matcher matcher = Pattern.compile("-(\\d+(\\.|$))").matcher(mn);
        if (!matcher.find()) return mn.replaceAll("[^A-Za-z0-9]", ".").replaceAll("(\\.)(\\1)+", ".").replaceAll("^\\.", "").replaceAll("\\.$", "");
        int start = matcher.start();
        mn = mn.substring(0, start);
        return mn.replaceAll("[^A-Za-z0-9]", ".").replaceAll("(\\.)(\\1)+", ".").replaceAll("^\\.", "").replaceAll("\\.$", "");
    }

    protected List<String> getExtraModuleConfigOptions(Modules.Phase phase) {
        if (!this.script.getTestJDK().hasModules()) {
            return Collections.emptyList();
        }
        Modules modules = this.script.getModules();
        boolean needAddExports = false;
        LinkedHashSet<String> addModules = null;
        for (Object e : modules) {
            String m = ((Modules.Entry)e).moduleName;
            if (((Modules.Entry)e).needAddExports()) {
                needAddExports = true;
            }
            if (addModules == null) {
                addModules = new LinkedHashSet<String>();
            }
            addModules.add(m);
        }
        if (!needAddExports && addModules == null) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>();
        if (addModules != null) {
            list.add("--add-modules");
            list.add(StringUtils.join(addModules, ","));
        }
        for (Modules.Entry e : modules) {
            if (e.packageName == null) continue;
            if (e.addExports) {
                list.add("--add-exports");
                list.add(e.moduleName + "/" + e.packageName + "=ALL-UNNAMED");
            }
            if (!e.addOpens || phase != Modules.Phase.DYNAMIC) continue;
            list.add("--add-opens");
            list.add(e.moduleName + "/" + e.packageName + "=ALL-UNNAMED");
        }
        PrintWriter pw = this.section.getMessageWriter();
        pw.println("Additional options from @modules: " + StringUtils.join(list, " "));
        return list;
    }

    protected boolean includesOption(String option, String arg, List<String> options) {
        boolean seenOption = false;
        for (String opt : options) {
            if (opt.equals(option + "=" + arg)) {
                return true;
            }
            if (opt.equals(option)) {
                seenOption = true;
                continue;
            }
            if (seenOption && opt.equals(arg)) {
                return true;
            }
            seenOption = false;
        }
        return false;
    }
}

