/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.config;

import com.sun.javatest.TestDescription;
import com.sun.javatest.regtest.config.RegressionParameters;
import com.sun.javatest.regtest.util.StringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class Modules
implements Iterable<Entry> {
    public static final Modules noModules = new Modules();
    Set<Entry> entries;
    private static final WeakHashMap<RegressionParameters, Map<String, Entry>> caches = new WeakHashMap();

    public static Entry parse(String s) throws Fault {
        String moduleName;
        String packageName = null;
        boolean addExports = false;
        boolean addOpens = false;
        int slash = s.indexOf("/");
        if (slash == -1) {
            moduleName = s;
        } else {
            moduleName = s.substring(0, slash);
            int colon = s.indexOf(":", slash + 1);
            if (colon == -1) {
                packageName = s.substring(slash + 1);
                addExports = true;
            } else {
                String[] modifiers;
                packageName = s.substring(slash + 1, colon);
                String[] stringArray = modifiers = s.substring(colon + 1).split(",");
                int n = stringArray.length;
                block9: for (int i = 0; i < n; ++i) {
                    String m;
                    switch (m = stringArray[i]) {
                        case "open": 
                        case "private": {
                            addOpens = true;
                            continue block9;
                        }
                        case "+open": {
                            addExports = true;
                            addOpens = true;
                            continue block9;
                        }
                        default: {
                            throw new Fault("bad modifier: " + m);
                        }
                    }
                }
            }
        }
        if (!Modules.isDottedName(moduleName)) {
            throw new Fault("invalid module name: " + moduleName);
        }
        if (packageName != null && !Modules.isDottedName(packageName)) {
            throw new Fault("invalid package name: " + packageName);
        }
        return new Entry(moduleName, packageName, addExports, addOpens);
    }

    private static boolean isDottedName(String qualId) {
        for (String id : qualId.split("\\.")) {
            if (Modules.isValidIdentifier(id)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidIdentifier(String id) {
        if (id.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(id.charAt(0))) {
            return false;
        }
        for (int i = 1; i < id.length(); ++i) {
            if (Character.isJavaIdentifierPart(id.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private Modules() {
        this.entries = Collections.emptySet();
    }

    public Modules(RegressionParameters params, TestDescription td) throws Fault {
        String tagEntries = td.getParameter("modules");
        if (tagEntries == null) {
            this.entries = Collections.emptySet();
        } else {
            this.entries = new LinkedHashSet<Entry>();
            for (String s : tagEntries.trim().split("\\s+")) {
                this.entries.add(this.getEntry(params, s));
            }
        }
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public Iterator<Entry> iterator() {
        return this.entries.iterator();
    }

    public String toString() {
        return StringUtils.join(this.entries, " ");
    }

    private Entry getEntry(RegressionParameters params, String s) throws Fault {
        Map cache = caches.computeIfAbsent(params, k -> new HashMap());
        Entry e = (Entry)cache.get(s);
        if (e == null) {
            e = Modules.parse(s);
            cache.put(s, e);
        }
        return e;
    }

    public static class Fault
    extends Exception {
        private static final long serialVersionUID = 1L;

        Fault(String message) {
            super(message);
        }
    }

    public static class Entry {
        public final String moduleName;
        public final String packageName;
        public final boolean addExports;
        public final boolean addOpens;

        Entry(String moduleName, String packageName, boolean addExports, boolean addOpens) {
            this.moduleName = moduleName;
            this.packageName = packageName;
            this.addExports = addExports;
            this.addOpens = addOpens;
        }

        public boolean needAddExports() {
            return this.packageName != null;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.moduleName);
            if (this.packageName != null) {
                sb.append("/").append(this.packageName);
                String sep = ":";
                if (this.addOpens) {
                    if (this.addExports) {
                        sb.append(sep).append("+open");
                    } else {
                        sb.append(sep).append("open");
                    }
                }
            }
            return sb.toString();
        }
    }

    public static enum Phase {
        STATIC,
        DYNAMIC;

    }
}

