/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.config;

import com.sun.javatest.regtest.agent.Flags;
import com.sun.javatest.regtest.agent.GetJDKProperties;
import com.sun.javatest.regtest.agent.GetSystemProperty;
import com.sun.javatest.regtest.agent.JDK_Version;
import com.sun.javatest.regtest.agent.SearchPath;
import com.sun.javatest.regtest.config.ExtraPropDefns;
import com.sun.javatest.regtest.config.JDKOpts;
import com.sun.javatest.regtest.config.RegressionParameters;
import com.sun.javatest.regtest.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JDK {
    private static final Map<Path, JDK> cache = new HashMap<Path, JDK>();
    private final Path jdk;
    private final Path absJDK;
    private String javaSpecificationVersion;
    private JDK_Version jdkVersion;
    private Map<Set<String>, String> fullVersions;
    private Boolean hasOldSymbolFile = null;
    private final Map<RegressionParameters, Info> infoMap = new HashMap<RegressionParameters, Info>();
    private static final boolean showModules = Flags.get("showModules");

    public static JDK of(String javaHome) throws InvalidPathException {
        return JDK.of(Path.of(javaHome, new String[0]));
    }

    public static synchronized JDK of(Path javaHome) {
        JDK jdk = cache.get(javaHome);
        if (jdk == null) {
            jdk = new JDK(javaHome);
            cache.put(javaHome, jdk);
        }
        return jdk;
    }

    private JDK(Path jdk) {
        this.jdk = jdk;
        this.absJDK = jdk.toAbsolutePath();
    }

    public boolean equals(Object o) {
        if (!(o instanceof JDK)) {
            return false;
        }
        JDK other = (JDK)o;
        return this.absJDK.equals(other.absJDK);
    }

    public int hashCode() {
        return this.absJDK.hashCode();
    }

    public String toString() {
        return this.getPath();
    }

    public File getFile() {
        return this.jdk.toFile();
    }

    public Path getHomeDirectory() {
        return this.jdk;
    }

    public File getAbsoluteFile() {
        return this.absJDK.toFile();
    }

    public Path getAbsoluteHomeDirectory() {
        return this.absJDK;
    }

    public Path getJavaProg() {
        return this.getProg("java", false);
    }

    public Path getJavacProg() {
        return this.getProg("javac", false);
    }

    public Path getProg(String command, boolean checkExe) {
        Path prog_exe;
        Path bin = this.absJDK.resolve("bin");
        Path prog = bin.resolve(command);
        if (!Files.exists(prog, new LinkOption[0]) && checkExe && Files.exists(prog_exe = bin.resolve(command + ".exe"), new LinkOption[0])) {
            return prog_exe;
        }
        return prog;
    }

    public boolean exists() {
        return Files.exists(this.jdk, new LinkOption[0]);
    }

    public String getPath() {
        return this.jdk.toString();
    }

    public String getAbsolutePath() {
        return this.absJDK.toString();
    }

    public SearchPath getJDKClassPath() {
        return new SearchPath(this.absJDK.resolve("lib").resolve("tools.jar"));
    }

    public JDK_Version getVersion(RegressionParameters params, Consumer<String> logger) {
        return this.getJDKVersion(params.getJavaTestClassPath(), logger);
    }

    public synchronized JDK_Version getJDKVersion(SearchPath classpath, Consumer<String> logger) {
        if (this.jdkVersion == null) {
            this.jdkVersion = JDK_Version.forName(this.getJavaSpecificationVersion(classpath, logger));
        }
        return this.jdkVersion;
    }

    private synchronized String getJavaSpecificationVersion(SearchPath getSysPropClassPath, Consumer<String> logger) {
        if (this.javaSpecificationVersion != null) {
            return this.javaSpecificationVersion;
        }
        String VERSION_PROPERTY = "java.specification.version";
        for (Info info : this.infoMap.values()) {
            if (info.jdkProperties == null) continue;
            this.javaSpecificationVersion = info.jdkProperties.getProperty("java.specification.version");
            if (this.javaSpecificationVersion == null) continue;
            return this.javaSpecificationVersion;
        }
        this.javaSpecificationVersion = "unknown";
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.environment().put("CLASSPATH", getSysPropClassPath.toString());
        pb.command(this.getJavaProg().toString(), GetSystemProperty.class.getName(), "java.specification.version");
        pb.redirectErrorStream(true);
        try {
            Process p = pb.start();
            List<String> lines = this.getOutput(p, logger);
            int rc = p.waitFor();
            if (rc == 0) {
                for (String line : lines) {
                    String[] v = line.trim().split("=", 2);
                    if (v.length != 2 || !v[0].equals("java.specification.version")) continue;
                    this.javaSpecificationVersion = v[1];
                    break;
                }
                if (this.javaSpecificationVersion.equals("unknown")) {
                    logger.accept("Error getting java.specification.version for " + String.valueOf(this.jdk) + ": property not found in output");
                    lines.forEach(logger::accept);
                }
            } else {
                logger.accept("Error getting java.specification.version for " + String.valueOf(this.jdk) + ": exit code " + rc);
                lines.forEach(logger::accept);
            }
        }
        catch (IOException | InterruptedException e) {
            logger.accept("Error getting java.specification.version for " + String.valueOf(this.jdk) + ": " + String.valueOf(e));
        }
        if (this.javaSpecificationVersion == null || this.javaSpecificationVersion.length() == 0) {
            this.javaSpecificationVersion = "1.1";
        }
        return this.javaSpecificationVersion;
    }

    public synchronized String getVersionText(Collection<String> vmOpts, Consumer<String> logger) {
        if (this.fullVersions == null) {
            this.fullVersions = new HashMap<Set<String>, String>();
        }
        String VERSION_OPTION = "-version";
        LinkedHashSet<String> vmOptsSet = new LinkedHashSet<String>(vmOpts);
        String fullVersion = this.fullVersions.get(vmOptsSet);
        if (fullVersion == null) {
            fullVersion = "";
            ArrayList<String> cmdArgs = new ArrayList<String>();
            cmdArgs.add(this.getJavaProg().toString());
            cmdArgs.addAll(vmOpts);
            cmdArgs.add("-version");
            try {
                Process p = new ProcessBuilder(cmdArgs).redirectErrorStream(true).start();
                List<String> lines = this.getOutput(p, logger);
                int rc = p.waitFor();
                if (rc == 0) {
                    fullVersion = StringUtils.join(lines, "\n");
                } else {
                    logger.accept("Error running 'java -version' for " + String.valueOf(this.jdk) + ": exit code " + rc);
                    lines.forEach(logger::accept);
                }
            }
            catch (IOException | InterruptedException e) {
                logger.accept("Error running 'java -version' for " + String.valueOf(this.jdk) + ": " + String.valueOf(e));
            }
            this.fullVersions.put(vmOptsSet, fullVersion);
        }
        return fullVersion;
    }

    public synchronized Properties getProperties(RegressionParameters params, Consumer<String> logger) throws Fault {
        Info info = this.getInfo(params);
        if (info.jdkProperties == null) {
            info.jdkProperties = this.execGetProperties(params, Collections.emptyList(), List.of("--system-properties", "--modules=boot-layer"), true, logger);
        }
        return info.jdkProperties;
    }

    public boolean hasModules() {
        Consumer<String> logger = System.err::println;
        Iterator<RegressionParameters> iterator = this.infoMap.keySet().iterator();
        if (iterator.hasNext()) {
            RegressionParameters p = iterator.next();
            return !this.getDefaultModules(p, logger).isEmpty();
        }
        throw new IllegalStateException();
    }

    public synchronized Set<String> getDefaultModules(RegressionParameters params, Consumer<String> logger) {
        Info info = this.getInfo(params);
        if (info.defaultModules == null) {
            try {
                Properties props = this.getProperties(params, logger);
                String m = props.getProperty("jtreg.modules");
                info.defaultModules = m == null ? Collections.emptySet() : Collections.unmodifiableSet(new LinkedHashSet<String>(List.of(m.split(" +"))));
            }
            catch (Fault f) {
                throw new IllegalStateException(f);
            }
            if (showModules) {
                System.err.println("default modules: " + String.valueOf(new TreeSet<String>(info.defaultModules)));
            }
        }
        return info.defaultModules;
    }

    public synchronized Set<String> getSystemModules(RegressionParameters params, Consumer<String> logger) {
        Info info = this.getInfo(params);
        if (info.systemModules == null) {
            if (this.getVersion(params, logger).compareTo(JDK_Version.V9) >= 0) {
                try {
                    Properties props;
                    String m;
                    String modulesOpt = "--modules=all-system";
                    for (String vmOpt : params.getTestVMJavaOptions()) {
                        if (!vmOpt.matches("--(add|limit)-modules(=.*)?")) continue;
                        modulesOpt = "--modules=boot-layer";
                        break;
                    }
                    if ((m = (props = this.execGetProperties(params, Collections.emptyList(), List.of(modulesOpt), false, logger)).getProperty("jtreg.modules")) == null) {
                        info.systemModules = Collections.emptySet();
                    }
                    info.systemModules = Collections.unmodifiableSet(new LinkedHashSet<String>(List.of(m.split(" +"))));
                }
                catch (Fault f) {
                    throw new IllegalStateException(f);
                }
            } else {
                info.systemModules = Collections.emptySet();
            }
            if (showModules) {
                System.err.println("system modules: " + String.valueOf(new TreeSet<String>(info.systemModules)));
            }
        }
        return info.systemModules;
    }

    public boolean hasOldSymbolFile() {
        if (this.hasOldSymbolFile == null) {
            JDK_Version v;
            if (this.javaSpecificationVersion != null && ((v = JDK_Version.forName(this.javaSpecificationVersion)).compareTo(JDK_Version.V1_5) <= 0 || v.compareTo(JDK_Version.V10) >= 0)) {
                this.hasOldSymbolFile = false;
                return this.hasOldSymbolFile;
            }
            Path ctSym = this.absJDK.resolve("lib").resolve("ct.sym");
            if (Files.exists(ctSym, new LinkOption[0])) {
                try (JarFile jar = new JarFile(ctSym.toFile());){
                    JarEntry e = jar.getJarEntry("META-INF/sym/rt.jar/java/lang/Object.class");
                    this.hasOldSymbolFile = e != null;
                }
                catch (IOException e) {
                    this.hasOldSymbolFile = false;
                }
            } else {
                this.hasOldSymbolFile = false;
            }
        }
        return this.hasOldSymbolFile;
    }

    private Properties execGetProperties(RegressionParameters params, List<String> extraVMOpts, List<String> opts, boolean includeExtraPropDefns, Consumer<String> logger) throws Fault {
        ExtraPropDefns epd = includeExtraPropDefns ? params.getTestSuite().getExtraPropDefns() : new ExtraPropDefns();
        try {
            epd.compile(params, params.getCompileJDK(), params.getWorkDirectory().getFile("extraPropDefns"));
        }
        catch (ExtraPropDefns.Fault e) {
            throw new Fault(e.getMessage(), e);
        }
        JDKOpts jdkOpts = new JDKOpts();
        jdkOpts.add("--class-path");
        SearchPath cp = new SearchPath(params.getJavaTestClassPath());
        cp.append(epd.getClassDir());
        jdkOpts.add(cp.toString());
        SearchPath bcp = new SearchPath(epd.getBootClassDir());
        if (!bcp.isEmpty()) {
            jdkOpts.add("-Xbootclasspath/a:" + String.valueOf(bcp));
        }
        params.getBasicTestProperties().forEach((name, value) -> jdkOpts.add("-D" + name + "=" + value));
        List<String> vmOpts = params.getTestVMJavaOptions();
        jdkOpts.addAll(vmOpts);
        jdkOpts.addAll(extraVMOpts);
        jdkOpts.addAll(epd.getVMOpts());
        ArrayList<String> cmdArgs = new ArrayList<String>();
        cmdArgs.add(this.getJavaProg().toString());
        cmdArgs.addAll(jdkOpts.toList());
        cmdArgs.add(GetJDKProperties.class.getName());
        cmdArgs.addAll(opts);
        cmdArgs.addAll(epd.getClasses());
        try {
            File scratchDir = params.getWorkDirectory().getFile("scratch");
            scratchDir.mkdirs();
            Process p = new ProcessBuilder(cmdArgs).directory(scratchDir).start();
            this.asyncCopy(p.getErrorStream(), logger);
            List<String> lines = this.readLines(p.getInputStream());
            int rc = p.waitFor();
            if (rc != 0) {
                for (String line : lines) {
                    logger.accept(line);
                }
                String msg = String.format("failed to get JDK properties:%ncmd: \"%s\"%ncwd: \"%s\"%nexit code: %d", StringUtils.join(cmdArgs, "\" \""), scratchDir, rc);
                logger.accept(msg);
                throw new Fault(msg);
            }
            return this.loadProperties(lines, logger);
        }
        catch (IOException | InterruptedException e) {
            logger.accept("Error accessing extra property definitions: " + String.valueOf(e));
            throw new Fault("Error accessing extra property definitions: " + String.valueOf(e), e);
        }
    }

    private List<String> readLines(InputStream is) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(is));){
            String line;
            while ((line = in.readLine()) != null) {
                lines.add(line);
            }
        }
        return lines;
    }

    private Properties loadProperties(List<String> lines, Consumer<String> logger) throws Fault {
        Properties props = new Properties();
        try {
            props.load(new StringReader(String.join((CharSequence)"\n", lines)));
        }
        catch (IOException e) {
            logger.accept("Error loading extra property definitions: " + String.valueOf(e));
            lines.forEach(logger::accept);
            throw new Fault("Error loading extra property definitions: " + String.valueOf(e));
        }
        return props;
    }

    private void asyncCopy(InputStream in, Consumer<String> logger) {
        new Thread(() -> {
            try {
                String line;
                BufferedReader err = new BufferedReader(new InputStreamReader(in));
                while ((line = err.readLine()) != null) {
                    logger.accept(line);
                }
            }
            catch (IOException e) {
                logger.accept("Error reading stderr while accessing properties: " + String.valueOf(e));
            }
        }).start();
    }

    private List<String> getOutput(Process p, Consumer<String> logger) {
        ArrayList<String> arrayList;
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader r = new BufferedReader(new InputStreamReader(p.getInputStream()));
        try {
            String line;
            while ((line = r.readLine()) != null) {
                lines.add(line);
            }
            arrayList = lines;
        }
        catch (Throwable throwable) {
            try {
                try {
                    r.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                logger.accept("Error getting output from process: " + String.valueOf(e));
                logger.accept("Output so far:");
                lines.forEach(logger::accept);
                return Collections.singletonList(e.getMessage());
            }
        }
        r.close();
        return arrayList;
    }

    private Info getInfo(RegressionParameters params) {
        Info info = this.infoMap.get(params);
        if (info == null) {
            info = new Info();
            this.infoMap.put(params, info);
        }
        return info;
    }

    static class Info {
        Properties jdkProperties;
        Set<String> defaultModules;
        Set<String> systemModules;

        Info() {
        }
    }

    public static class Fault
    extends Exception {
        private static final long serialVersionUID = 1L;

        Fault(String msg) {
            super(msg);
        }

        Fault(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

