/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.config;

import com.sun.javatest.regtest.util.FileUtils;
import com.sun.javatest.regtest.util.GraphUtils;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;

public class GroupManager {
    public static final String GROUP_PREFIX = ":";
    public static final String EXCLUDE_PREFIX = "-";
    final PrintWriter out;
    final Path root;
    final Map<String, Group> groups = new HashMap<String, Group>();
    private Collection<String> ignoreDirs = Collections.emptySet();
    private Collection<String> allowExtns = Collections.emptySet();
    private static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(GroupManager.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String ... args) throws Exception {
        Path root = Path.of(args[0], new String[0]);
        ArrayList<String> files = new ArrayList<String>();
        files.addAll(List.of(args).subList(1, args.length));
        PrintWriter out = new PrintWriter(System.err);
        try {
            GroupManager gm = new GroupManager(out, root, files);
            gm.setAllowedExtensions(List.of(".java", ".sh", ".html"));
            for (Group g : gm.groups.values()) {
                System.err.println(g.name + ": " + String.valueOf(g.getFiles()));
            }
        }
        finally {
            out.flush();
        }
    }

    GroupManager(PrintWriter out, Path root, List<String> files) throws IOException {
        this.out = out;
        this.root = root;
        for (String f : files) {
            boolean optional;
            if (f.startsWith("[") && f.endsWith("]")) {
                f = f.substring(1, f.length() - 1);
                optional = true;
            } else {
                optional = false;
            }
            Path file = root.resolve(f);
            if (optional && !Files.exists(file, new LinkOption[0])) continue;
            BufferedReader in = Files.newBufferedReader(file);
            try {
                Properties p = new Properties();
                p.load(in);
                for (Map.Entry<Object, Object> e : p.entrySet()) {
                    String groupName = (String)e.getKey();
                    String entryDef = (String)e.getValue();
                    Group g = this.getGroup(groupName);
                    g.addEntry(new Entry(file, root, entryDef));
                }
            }
            finally {
                if (in == null) continue;
                in.close();
            }
        }
        this.validate();
    }

    void setAllowedExtensions(Collection<String> extns) {
        this.allowExtns = new HashSet<String>(extns);
    }

    void setIgnoredDirectories(Collection<String> names) {
        this.ignoreDirs = new HashSet<String>(names);
    }

    public Set<Path> getFiles(String group) throws InvalidGroup {
        Group g = this.getGroup(group);
        if (g.invalid) {
            throw new InvalidGroup();
        }
        return g.getFiles();
    }

    private Group getGroup(String name) {
        Group g = this.groups.get(name);
        if (g == null) {
            g = new Group(name);
            this.groups.put(name, g);
        }
        return g;
    }

    public Set<String> getGroups() {
        return this.groups.keySet();
    }

    public boolean invalid() {
        return this.groups.values().stream().anyMatch(g -> g.invalid);
    }

    private void validate() {
        for (Group group : this.groups.values()) {
            if (!group.name.matches("(?i)[a-z][a-z0-9_]*")) {
                this.error(group, i18n.getString("gm.invalid.name.for.group"));
            }
            for (Entry entry : group.entries) {
                List<Set<Path>> allFiles = List.of(entry.includeFiles, entry.excludeFiles);
                for (Set<Path> files : allFiles) {
                    for (Path f : files) {
                        if (Files.exists(f, new LinkOption[0])) continue;
                        URI u = this.root.toUri().relativize(f.toUri());
                        this.error(entry.origin, group, i18n.getString("gm.file.not.found", (Object)u.getPath()));
                    }
                }
                for (Group eg : entry.includeGroups) {
                    if (eg.isEmpty()) {
                        this.error(entry.origin, group, i18n.getString("gm.group.not.found", (Object)eg.name));
                    }
                    if (eg != group) continue;
                    this.error(entry.origin, group, i18n.getString("gm.group.includes.itself"));
                }
            }
        }
        final HashMap<Group, 1> nodes = new HashMap<Group, 1>();
        for (Group g3 : this.groups.values()) {
            nodes.put(g3, new GraphUtils.TarjanNode<Group>(g3){

                @Override
                public Iterable<? extends GraphUtils.TarjanNode<Group>> getDependencies() {
                    ArrayList<GraphUtils.TarjanNode> deps = new ArrayList<GraphUtils.TarjanNode>();
                    for (Entry e : ((Group)this.data).entries) {
                        for (Group g : e.includeGroups) {
                            deps.add((GraphUtils.TarjanNode)nodes.get(g));
                        }
                    }
                    return deps;
                }

                @Override
                public String printDependency(GraphUtils.Node<Group> to) {
                    return ((Group)to.data).name;
                }
            });
        }
        Set set = GraphUtils.tarjan(nodes.values());
        for (Set set2 : set) {
            if (set2.size() <= 1) continue;
            String s = set2.stream().map(tn -> ((Group)tn.data).name).collect(Collectors.joining(", "));
            set2.stream().map(tn -> (Group)tn.data).forEach(g -> this.error((Group)g, i18n.getString("gm.cycle.detected", (Object)s)));
        }
    }

    private void error(Group g, String message) {
        if (g.entries.isEmpty()) {
            this.out.println(i18n.getString("gm.group.prefix", g.name, message));
            g.invalid = true;
        } else {
            this.error(g.entries.get((int)0).origin, g, message);
        }
    }

    private void error(Path f, Group g, String message) {
        this.out.println(i18n.getString("gm.file.group.prefix", f, g.name, message));
        g.invalid = true;
    }

    private class Group {
        final String name;
        final List<Entry> entries;
        private Set<Path> files;
        boolean invalid;

        Group(String name) {
            this.name = name;
            this.entries = new ArrayList<Entry>();
        }

        boolean isEmpty() {
            return this.entries.isEmpty();
        }

        void addEntry(Entry e) {
            this.entries.add(e);
        }

        Set<Path> getFiles() {
            if (this.files == null) {
                this.files = new LinkedHashSet<Path>();
                HashSet<Path> inclFiles = new HashSet<Path>();
                HashSet<Path> exclFiles = new HashSet<Path>();
                for (Entry e : this.entries) {
                    inclFiles.addAll(e.includeFiles);
                    for (Group g : e.includeGroups) {
                        inclFiles.addAll(g.getFiles());
                    }
                    exclFiles.addAll(e.excludeFiles);
                    for (Group g : e.excludeGroups) {
                        exclFiles.addAll(g.getFiles());
                    }
                }
                this.addFiles(this.files, inclFiles, exclFiles);
            }
            return this.files;
        }

        private void addFiles(Collection<Path> files, Collection<Path> includes, Collection<Path> excludes) {
            for (Path incl : includes) {
                if (this.contains(files, incl) || this.contains(excludes, incl)) continue;
                if (Files.isRegularFile(incl, new LinkOption[0])) {
                    this.addFile(files, incl);
                    continue;
                }
                if (!Files.isDirectory(incl, new LinkOption[0])) continue;
                Set<Path> excludesForIncl = this.filter(incl, excludes);
                if (excludesForIncl.isEmpty()) {
                    this.addFile(files, incl);
                    continue;
                }
                this.addFiles(files, this.list(incl), excludesForIncl);
            }
        }

        private void addFile(Collection<Path> files, Path file) {
            files.removeIf(f -> this.contains(file, (Path)f));
            files.add(file);
        }

        private boolean contains(Collection<Path> files, Path file) {
            for (Path f : files) {
                if (!f.equals(file) && !this.contains(f, file)) continue;
                return true;
            }
            return false;
        }

        private boolean contains(Path dir, Path file) {
            return file.startsWith(dir);
        }

        private Set<Path> filter(Path dir, Collection<Path> files) {
            LinkedHashSet<Path> results = null;
            for (Path f : files) {
                if (!f.startsWith(dir)) continue;
                if (results == null) {
                    results = new LinkedHashSet<Path>();
                }
                results.add(f);
            }
            return results == null ? Set.of() : results;
        }

        private List<Path> list(Path file) {
            ArrayList<Path> children = new ArrayList<Path>();
            for (Path f : FileUtils.listFiles(file)) {
                String fn = f.getFileName().toString();
                if ((!Files.isDirectory(f, new LinkOption[0]) || GroupManager.this.ignoreDirs.contains(fn)) && (!Files.isRegularFile(f, new LinkOption[0]) || !GroupManager.this.allowExtns.contains(this.getExtension(fn)))) continue;
                children.add(f);
            }
            return children;
        }

        private String getExtension(String name) {
            int sep = name.lastIndexOf(".");
            return sep == -1 ? null : name.substring(sep);
        }

        public String toString() {
            return this.name;
        }
    }

    class Entry {
        final Path origin;
        final Set<Path> includeFiles = new LinkedHashSet<Path>();
        final Set<Path> excludeFiles = new LinkedHashSet<Path>();
        final Set<Group> includeGroups = new LinkedHashSet<Group>();
        final Set<Group> excludeGroups = new LinkedHashSet<Group>();

        Entry(Path origin, Path root, String def) {
            this.origin = origin;
            def = def.trim();
            if (def.length() == 0) {
                return;
            }
            for (String item : def.split("\\s+")) {
                String name;
                boolean exclude = item.startsWith(GroupManager.EXCLUDE_PREFIX);
                if (exclude) {
                    item = item.substring(1);
                }
                if (item.startsWith(GroupManager.GROUP_PREFIX)) {
                    name = item.substring(1);
                    (exclude ? this.excludeGroups : this.includeGroups).add(GroupManager.this.getGroup(name));
                    continue;
                }
                name = item;
                if (name.startsWith("/")) {
                    name = name.substring(1);
                }
                if (name.endsWith("/")) {
                    name = name.substring(0, name.length() - 1);
                }
                Path f = name.equals("") ? root : root.resolve(name);
                (exclude ? this.excludeFiles : this.includeFiles).add(f);
            }
        }

        public String toString() {
            return "Entry[origin:" + String.valueOf(this.origin) + "inclFiles:" + String.valueOf(this.includeFiles) + ",exclFiles:" + String.valueOf(this.excludeFiles) + ",inclGroups:" + String.valueOf(this.includeGroups) + ",exclGroups:" + String.valueOf(this.excludeGroups) + "]";
        }
    }

    public static class InvalidGroup
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

