/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.config;

public abstract class Expr {
    protected static final int PREC_LIT = 6;
    protected static final int PREC_NOT = 6;
    protected static final int PREC_NUM = 6;
    protected static final int PREC_PRN = 6;
    protected static final int PREC_TRM = 6;
    protected static final int PREC_DIV = 5;
    protected static final int PREC_MUL = 5;
    protected static final int PREC_REM = 5;
    protected static final int PREC_ADD = 4;
    protected static final int PREC_SUB = 4;
    protected static final int PREC_GE = 3;
    protected static final int PREC_GT = 3;
    protected static final int PREC_LE = 3;
    protected static final int PREC_LT = 3;
    protected static final int PREC_EQ = 2;
    protected static final int PREC_NE = 2;
    protected static final int PREC_AND = 1;
    protected static final int PREC_OR = 0;

    public static Expr parse(String s, Context c) throws Fault {
        Parser p = new Parser(s, c);
        return p.parse();
    }

    public abstract String eval(Context var1) throws Fault;

    public boolean evalBoolean(Context c) throws Fault {
        String s = this.eval(c);
        if (s.equals("true")) {
            return true;
        }
        if (s.equals("false")) {
            return false;
        }
        throw new Fault("invalid boolean value: `" + s + "' for expression `" + String.valueOf(this) + "'");
    }

    public long evalNumber(Context c) throws Fault {
        String s = this.eval(c);
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException ex) {
            throw new Fault("invalid numeric value: " + s);
        }
    }

    abstract int precedence();

    Expr order() {
        return this;
    }

    static class Parser {
        private final Context context;
        private final String text;
        private int index;
        private Token token;
        private String idValue;

        Parser(String text, Context context) throws Fault {
            this.context = context;
            this.text = text;
            this.nextToken();
        }

        Expr parse() throws Fault {
            Expr e = this.parseExpr();
            this.expect(Token.END);
            return e;
        }

        Expr parseExpr() throws Fault {
            block16: for (Expr e = this.parseTerm(); e != null; e = e.order()) {
                switch (this.token.ordinal()) {
                    case 0: {
                        this.nextToken();
                        e = new AddExpr(e, this.parseTerm());
                        continue block16;
                    }
                    case 1: {
                        this.nextToken();
                        e = new AndExpr(e, this.parseTerm());
                        continue block16;
                    }
                    case 2: {
                        this.nextToken();
                        e = new DivideExpr(e, this.parseTerm());
                        continue block16;
                    }
                    case 5: {
                        this.nextToken();
                        e = new EqualExpr(e, this.parseTerm());
                        continue block16;
                    }
                    case 7: {
                        this.nextToken();
                        e = new GreaterEqualExpr(e, this.parseTerm());
                        continue block16;
                    }
                    case 8: {
                        this.nextToken();
                        e = new GreaterExpr(e, this.parseTerm());
                        continue block16;
                    }
                    case 9: {
                        this.nextToken();
                        e = new LessEqualExpr(e, this.parseTerm());
                        continue block16;
                    }
                    case 11: {
                        this.nextToken();
                        e = new LessExpr(e, this.parseTerm());
                        continue block16;
                    }
                    case 12: {
                        this.nextToken();
                        e = new MatchExpr(e, this.parseTerm());
                        continue block16;
                    }
                    case 13: {
                        this.nextToken();
                        e = new MultiplyExpr(e, this.parseTerm());
                        continue block16;
                    }
                    case 15: {
                        this.nextToken();
                        e = new NotEqualExpr(e, this.parseTerm());
                        continue block16;
                    }
                    case 18: {
                        this.nextToken();
                        e = new OrExpr(e, this.parseTerm());
                        continue block16;
                    }
                    case 19: {
                        this.nextToken();
                        e = new RemainderExpr(e, this.parseTerm());
                        continue block16;
                    }
                    case 22: {
                        this.nextToken();
                        e = new SubtractExpr(e, this.parseTerm());
                        continue block16;
                    }
                    default: {
                        return e;
                    }
                }
            }
            return null;
        }

        Expr parseTerm() throws Fault {
            switch (this.token.ordinal()) {
                case 14: {
                    String id = this.idValue;
                    this.nextToken();
                    if (this.context.isValidName(id)) {
                        return new NameExpr(id);
                    }
                    throw new Fault("invalid name: " + id);
                }
                case 16: {
                    this.nextToken();
                    return new NotExpr(this.parseTerm());
                }
                case 6: 
                case 17: 
                case 23: {
                    String num = this.idValue;
                    this.nextToken();
                    return new NumberExpr(num);
                }
                case 10: {
                    this.nextToken();
                    Expr e = this.parseExpr();
                    this.expect(Token.RPAREN);
                    return new ParenExpr(e);
                }
                case 21: {
                    String s = this.idValue;
                    this.nextToken();
                    return new StringExpr(s);
                }
            }
            throw new Fault(this.token.getText() + " not expected");
        }

        private void expect(Token t) throws Fault {
            if (t != this.token) {
                throw new Fault(t.getText() + "expected, but " + this.token.getText() + " found");
            }
            this.nextToken();
        }

        private void nextToken() throws Fault {
            block31: while (this.index < this.text.length()) {
                int c = this.text.charAt(this.index++);
                switch (c) {
                    case 9: 
                    case 32: {
                        continue block31;
                    }
                    case 38: {
                        this.token = Token.AND;
                        return;
                    }
                    case 124: {
                        this.token = Token.OR;
                        return;
                    }
                    case 43: {
                        this.token = Token.ADD;
                        return;
                    }
                    case 45: {
                        this.token = Token.SUB;
                        return;
                    }
                    case 42: {
                        this.token = Token.MUL;
                        return;
                    }
                    case 47: {
                        this.token = Token.DIV;
                        return;
                    }
                    case 37: {
                        this.token = Token.REM;
                        return;
                    }
                    case 40: {
                        this.token = Token.LPAREN;
                        return;
                    }
                    case 41: {
                        this.token = Token.RPAREN;
                        return;
                    }
                    case 60: {
                        if (this.index < this.text.length() && this.text.charAt(this.index) == '=') {
                            this.token = Token.LE;
                            ++this.index;
                        } else {
                            this.token = Token.LT;
                        }
                        return;
                    }
                    case 62: {
                        if (this.index < this.text.length() && this.text.charAt(this.index) == '=') {
                            this.token = Token.GE;
                            ++this.index;
                        } else {
                            this.token = Token.GT;
                        }
                        return;
                    }
                    case 126: {
                        if (this.index < this.text.length() && this.text.charAt(this.index) == '=') {
                            this.token = Token.MATCH;
                            ++this.index;
                        } else {
                            throw new Fault("unexpected character after `~'");
                        }
                        return;
                    }
                    case 61: {
                        if (this.index < this.text.length() && this.text.charAt(this.index) == '=') {
                            this.token = Token.EQ;
                            ++this.index;
                        } else {
                            throw new Fault("unexpected character after `='");
                        }
                        return;
                    }
                    case 33: {
                        if (this.index < this.text.length() && this.text.charAt(this.index) == '=') {
                            this.token = Token.NE;
                            ++this.index;
                        } else {
                            this.token = Token.NOT;
                        }
                        return;
                    }
                    case 34: {
                        StringBuilder sb = new StringBuilder();
                        if (this.index < this.text.length()) {
                            c = this.text.charAt(this.index);
                            ++this.index;
                        } else {
                            throw new Fault("invalid string constant");
                        }
                        while (c != 34) {
                            if (c == 92) {
                                if (this.index < this.text.length()) {
                                    c = this.text.charAt(this.index);
                                    ++this.index;
                                } else {
                                    throw new Fault("invalid string constant");
                                }
                                switch (c) {
                                    case 98: {
                                        c = 8;
                                        break;
                                    }
                                    case 102: {
                                        c = 12;
                                        break;
                                    }
                                    case 110: {
                                        c = 10;
                                        break;
                                    }
                                    case 114: {
                                        c = 13;
                                        break;
                                    }
                                    case 116: {
                                        c = 9;
                                        break;
                                    }
                                    case 92: {
                                        c = 92;
                                        break;
                                    }
                                    case 39: {
                                        c = 39;
                                        break;
                                    }
                                    case 34: {
                                        c = 34;
                                        break;
                                    }
                                    default: {
                                        throw new Fault("invalid string constant");
                                    }
                                }
                            }
                            sb.append((char)c);
                            if (this.index >= this.text.length()) break;
                            c = this.text.charAt(this.index);
                            ++this.index;
                        }
                        if (c != 34) {
                            throw new Fault("invalid string constant");
                        }
                        this.token = Token.STRING;
                        this.idValue = String.valueOf(sb);
                        return;
                    }
                }
                if (Character.isUnicodeIdentifierStart((char)c)) {
                    this.idValue = String.valueOf((char)c);
                    while (this.index < this.text.length() && (Character.isUnicodeIdentifierPart((char)(c = this.text.charAt(this.index))) || c == 46)) {
                        if (!Character.isIdentifierIgnorable((char)c)) {
                            this.idValue = this.idValue + (char)c;
                        }
                        ++this.index;
                    }
                    this.token = this.idValue.equalsIgnoreCase("true") ? Token.TRUE : (this.idValue.equalsIgnoreCase("false") ? Token.FALSE : Token.NAME);
                    return;
                }
                if (Character.isDigit((char)c)) {
                    int start = this.index - 1;
                    while (this.index < this.text.length()) {
                        c = this.text.charAt(this.index);
                        if (Character.isDigit((char)c)) {
                            ++this.index;
                            continue;
                        }
                        switch (c) {
                            case 71: 
                            case 75: 
                            case 77: 
                            case 103: 
                            case 107: 
                            case 109: {
                                ++this.index;
                            }
                        }
                    }
                    this.token = Token.NUMBER;
                    this.idValue = this.text.substring(start, this.index);
                    return;
                }
                throw new Fault("unrecognized character: `" + (char)c + "'");
            }
            this.token = Token.END;
        }
    }

    public static interface Context {
        public boolean isValidName(String var1);

        public String get(String var1) throws Fault;
    }

    public static class Fault
    extends Exception {
        private static final long serialVersionUID = 1L;

        Fault(String msg) {
            super(msg);
        }
    }

    static class SubtractExpr
    extends BinaryExpr {
        SubtractExpr(Expr left, Expr right) {
            super(left, right);
        }

        @Override
        public String eval(Context c) throws Fault {
            return String.valueOf(this.left.evalNumber(c) - this.right.evalNumber(c));
        }

        @Override
        int precedence() {
            return 4;
        }

        public String toString() {
            return "`" + String.valueOf(this.left) + "-" + String.valueOf(this.right) + "'";
        }
    }

    static class StringExpr
    extends Expr {
        private final String value;

        StringExpr(String value) {
            this.value = value;
        }

        @Override
        public String eval(Context c) throws Fault {
            return this.value;
        }

        @Override
        int precedence() {
            return 6;
        }

        public String toString() {
            return "\"" + this.value + "\"";
        }
    }

    static class RemainderExpr
    extends BinaryExpr {
        RemainderExpr(Expr left, Expr right) {
            super(left, right);
        }

        @Override
        public String eval(Context c) throws Fault {
            return String.valueOf(this.left.evalNumber(c) % this.right.evalNumber(c));
        }

        @Override
        int precedence() {
            return 5;
        }

        public String toString() {
            return "`" + String.valueOf(this.left) + "%" + String.valueOf(this.right) + "'";
        }
    }

    static class ParenExpr
    extends Expr {
        private final Expr expr;

        ParenExpr(Expr expr) {
            this.expr = expr;
        }

        @Override
        public String eval(Context c) throws Fault {
            return this.expr.eval(c);
        }

        @Override
        int precedence() {
            return 6;
        }

        public String toString() {
            return "(" + String.valueOf(this.expr) + ")";
        }
    }

    static class OrExpr
    extends BinaryExpr {
        OrExpr(Expr left, Expr right) {
            super(left, right);
        }

        @Override
        public String eval(Context c) throws Fault {
            return String.valueOf(this.left.evalBoolean(c) || this.right.evalBoolean(c));
        }

        @Override
        int precedence() {
            return 0;
        }

        public String toString() {
            return "`" + String.valueOf(this.left) + "|" + String.valueOf(this.right) + "'";
        }
    }

    static class NumberExpr
    extends Expr {
        private final String value;

        NumberExpr(String value) {
            this.value = value;
        }

        @Override
        public String eval(Context c) throws Fault {
            long scale;
            char lastCh = this.value.charAt(this.value.length() - 1);
            switch (lastCh) {
                case 'K': 
                case 'k': {
                    scale = 1024L;
                    break;
                }
                case 'M': 
                case 'm': {
                    scale = 0x100000L;
                    break;
                }
                case 'G': 
                case 'g': {
                    scale = 0x40000000L;
                    break;
                }
                default: {
                    return this.value;
                }
            }
            try {
                String s = this.value.substring(0, this.value.length() - 1);
                return String.valueOf(Long.parseLong(s) * scale);
            }
            catch (NumberFormatException ex) {
                throw new Fault("invalid numeric value: " + this.value);
            }
        }

        @Override
        int precedence() {
            return 6;
        }

        public String toString() {
            return this.value;
        }
    }

    static class NotExpr
    extends Expr {
        private final Expr expr;

        NotExpr(Expr expr) {
            this.expr = expr;
        }

        @Override
        public String eval(Context c) throws Fault {
            return String.valueOf(!this.expr.evalBoolean(c));
        }

        @Override
        int precedence() {
            return 6;
        }

        public String toString() {
            return "!" + String.valueOf(this.expr);
        }
    }

    static class NotEqualExpr
    extends BinaryExpr {
        NotEqualExpr(Expr left, Expr right) {
            super(left, right);
        }

        @Override
        public String eval(Context c) throws Fault {
            return String.valueOf(!this.left.eval(c).equalsIgnoreCase(this.right.eval(c)));
        }

        @Override
        int precedence() {
            return 2;
        }

        public String toString() {
            return "`" + String.valueOf(this.left) + "!=" + String.valueOf(this.right) + "'";
        }
    }

    static class NameExpr
    extends Expr {
        private final String name;

        NameExpr(String name) {
            this.name = name;
        }

        @Override
        public String eval(Context c) throws Fault {
            String v = c.get(this.name);
            if (v == null) {
                throw new Fault("name not defined: " + this.name);
            }
            return v;
        }

        @Override
        int precedence() {
            return 6;
        }

        public String toString() {
            return this.name;
        }
    }

    static class MultiplyExpr
    extends BinaryExpr {
        MultiplyExpr(Expr left, Expr right) {
            super(left, right);
        }

        @Override
        public String eval(Context c) throws Fault {
            return String.valueOf(this.left.evalNumber(c) * this.right.evalNumber(c));
        }

        @Override
        int precedence() {
            return 5;
        }

        public String toString() {
            return "`" + String.valueOf(this.left) + "*" + String.valueOf(this.right) + "'";
        }
    }

    static class MatchExpr
    extends BinaryExpr {
        MatchExpr(Expr left, Expr right) {
            super(left, right);
        }

        @Override
        public String eval(Context c) throws Fault {
            return String.valueOf(this.left.eval(c).matches(this.right.eval(c)));
        }

        @Override
        int precedence() {
            return 2;
        }

        public String toString() {
            return "`" + String.valueOf(this.left) + "~=" + String.valueOf(this.right) + "'";
        }
    }

    static class LessEqualExpr
    extends BinaryExpr {
        LessEqualExpr(Expr left, Expr right) {
            super(left, right);
        }

        @Override
        public String eval(Context c) throws Fault {
            return String.valueOf(this.left.evalNumber(c) <= this.right.evalNumber(c));
        }

        @Override
        int precedence() {
            return 3;
        }

        public String toString() {
            return "`" + String.valueOf(this.left) + "<=" + String.valueOf(this.right) + "'";
        }
    }

    static class LessExpr
    extends BinaryExpr {
        LessExpr(Expr left, Expr right) {
            super(left, right);
        }

        @Override
        public String eval(Context c) throws Fault {
            return String.valueOf(this.left.evalNumber(c) < this.right.evalNumber(c));
        }

        @Override
        int precedence() {
            return 3;
        }

        public String toString() {
            return "`" + String.valueOf(this.left) + "<" + String.valueOf(this.right) + "'";
        }
    }

    static class GreaterEqualExpr
    extends BinaryExpr {
        GreaterEqualExpr(Expr left, Expr right) {
            super(left, right);
        }

        @Override
        public String eval(Context c) throws Fault {
            return String.valueOf(this.left.evalNumber(c) >= this.right.evalNumber(c));
        }

        @Override
        int precedence() {
            return 3;
        }

        public String toString() {
            return "`" + String.valueOf(this.left) + ">=" + String.valueOf(this.right) + "'";
        }
    }

    static class GreaterExpr
    extends BinaryExpr {
        GreaterExpr(Expr left, Expr right) {
            super(left, right);
        }

        @Override
        public String eval(Context c) throws Fault {
            return String.valueOf(this.left.evalNumber(c) > this.right.evalNumber(c));
        }

        @Override
        int precedence() {
            return 3;
        }

        public String toString() {
            return "`" + String.valueOf(this.left) + ">" + String.valueOf(this.right) + "'";
        }
    }

    static class EqualExpr
    extends BinaryExpr {
        EqualExpr(Expr left, Expr right) {
            super(left, right);
        }

        @Override
        public String eval(Context c) throws Fault {
            return String.valueOf(this.left.eval(c).equalsIgnoreCase(this.right.eval(c)));
        }

        @Override
        int precedence() {
            return 2;
        }

        public String toString() {
            return "`" + String.valueOf(this.left) + "==" + String.valueOf(this.right) + "'";
        }
    }

    static class DivideExpr
    extends BinaryExpr {
        DivideExpr(Expr left, Expr right) {
            super(left, right);
        }

        @Override
        public String eval(Context c) throws Fault {
            return String.valueOf(this.left.evalNumber(c) / this.right.evalNumber(c));
        }

        @Override
        int precedence() {
            return 5;
        }

        public String toString() {
            return "`" + String.valueOf(this.left) + "/" + String.valueOf(this.right) + "'";
        }
    }

    static class AndExpr
    extends BinaryExpr {
        AndExpr(Expr left, Expr right) {
            super(left, right);
        }

        @Override
        public String eval(Context c) throws Fault {
            return String.valueOf(this.left.evalBoolean(c) && this.right.evalBoolean(c));
        }

        @Override
        int precedence() {
            return 1;
        }

        public String toString() {
            return "`" + String.valueOf(this.left) + "&" + String.valueOf(this.right) + "'";
        }
    }

    static class AddExpr
    extends BinaryExpr {
        AddExpr(Expr left, Expr right) {
            super(left, right);
        }

        @Override
        public String eval(Context c) throws Fault {
            return String.valueOf(this.left.evalNumber(c) + this.right.evalNumber(c));
        }

        @Override
        int precedence() {
            return 4;
        }

        public String toString() {
            return "`" + String.valueOf(this.left) + "+" + String.valueOf(this.right) + "'";
        }
    }

    static abstract class BinaryExpr
    extends Expr {
        protected Expr left;
        protected Expr right;

        BinaryExpr(Expr left, Expr right) {
            this.left = left;
            this.right = right;
        }

        @Override
        Expr order() {
            if (this.precedence() > this.left.precedence() && this.left instanceof BinaryExpr) {
                BinaryExpr e = (BinaryExpr)this.left;
                this.left = e.right;
                e.right = this.order();
                return e;
            }
            return this;
        }
    }

    static enum Token {
        ADD("+"),
        AND("&"),
        DIV("/"),
        END("<end-of-expression>"),
        ERROR("<error>"),
        EQ("="),
        FALSE("false"),
        GE(">="),
        GT(">"),
        LE("<="),
        LPAREN("("),
        LT("<"),
        MATCH("~="),
        MUL("*"),
        NAME("<name>"),
        NE("!="),
        NOT("!"),
        NUMBER("<number>"),
        OR("|"),
        REM("%"),
        RPAREN(")"),
        STRING("<string>"),
        SUB("-"),
        TRUE("true");

        final String text;

        private Token(String text) {
            this.text = text;
        }

        String getText() {
            return this.text.startsWith("<") ? this.text : "'" + this.text + "'";
        }
    }
}

