/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.agent;

import com.sun.javatest.regtest.agent.SearchPath;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.concurrent.ThreadFactory;

public final class TestThreadFactoryHelper {
    static ThreadFactory loadThreadFactory(String className, String path) {
        ThreadFactory threadFactory;
        ArrayList<URL> urls = new ArrayList<URL>();
        if (path != null) {
            SearchPath classpath = new SearchPath(path);
            for (Path f : classpath.asList()) {
                try {
                    urls.add(f.toUri().toURL());
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        URLClassLoader loader = new URLClassLoader(urls.toArray(new URL[0]), ClassLoader.getSystemClassLoader());
        try {
            ThreadFactory factory;
            Class<ThreadFactory> clz = loader.loadClass(className).asSubclass(ThreadFactory.class);
            Constructor<ThreadFactory> ctor = clz.getDeclaredConstructor(new Class[0]);
            threadFactory = factory = ctor.newInstance(new Object[0]);
        }
        catch (Throwable throwable) {
            try {
                try {
                    loader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        loader.close();
        return threadFactory;
    }
}

