/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.agent;

import com.sun.javatest.regtest.agent.AStatus;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class RegressionCompileCommand {
    public static boolean defaultVerbose = Boolean.getBoolean("javatest.JavaCompileCommand.verbose");
    private boolean verbose = defaultVerbose;
    private PrintWriter log;
    private static final AStatus passed = AStatus.passed("Compilation successful");
    private static final AStatus failed = AStatus.failed("Compilation failed");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        AStatus s;
        PrintWriter out = new PrintWriter(System.out);
        PrintWriter err = new PrintWriter(System.err);
        try {
            RegressionCompileCommand c = new RegressionCompileCommand();
            s = c.run(args, out, err);
        }
        finally {
            out.flush();
            err.flush();
        }
        s.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AStatus run(String[] args, PrintWriter log, PrintWriter ref) {
        int i;
        if (args.length == 0) {
            return AStatus.error("No args supplied");
        }
        String compilerClassName = null;
        String compilerName = null;
        String[] options = null;
        for (i = 0; i < args.length; ++i) {
            if (!args[i].equals("-")) continue;
            options = new String[i];
            System.arraycopy(args, 0, options, 0, options.length);
            args = RegressionCompileCommand.shift(args, i + 1);
            break;
        }
        if (options != null) {
            for (i = 0; i < options.length; ++i) {
                if (options[i].equals("-compiler")) {
                    String s;
                    int colon;
                    if (i + 1 == options.length) {
                        return AStatus.error("No compiler specified after -compiler option");
                    }
                    if ((colon = (s = options[++i]).indexOf(":")) == -1) {
                        compilerClassName = s;
                        compilerName = "java " + s;
                        continue;
                    }
                    compilerClassName = s.substring(colon + 1);
                    compilerName = s.substring(0, colon);
                    continue;
                }
                if (options[i].equals("-verbose")) {
                    this.verbose = true;
                    continue;
                }
                return AStatus.error("Unrecognized option: " + options[i]);
            }
        }
        this.log = log;
        try {
            Object result;
            Class<?> compilerClass;
            Object loader = null;
            if (compilerClassName != null) {
                compilerClass = this.getClass(loader, compilerClassName);
                if (compilerClass == null) {
                    AStatus colon = AStatus.error("Cannot find compiler: " + compilerClassName);
                    return colon;
                }
            } else {
                compilerName = "javac";
                compilerClass = this.getClass(loader, "com.sun.tools.javac.Main");
                if (compilerClass == null) {
                    AStatus colon = AStatus.error("Cannot find compiler");
                    return colon;
                }
            }
            loader = null;
            Method compileMethod = this.getMethod(compilerClass, "compile", String[].class, PrintWriter.class);
            if (compileMethod == null) {
                AStatus aStatus = AStatus.error("Cannot find compile method for " + compilerClass.getName());
                return aStatus;
            }
            Object[] compileMethodArgs = new Object[]{args, ref};
            if (!Modifier.isStatic(compileMethod.getModifiers())) {
                AStatus aStatus = AStatus.error("compile method is not static");
                return aStatus;
            }
            try {
                result = compileMethod.invoke(null, compileMethodArgs);
            }
            catch (Throwable t) {
                t.printStackTrace(log);
                AStatus aStatus = AStatus.error("Error invoking compiler");
                log.flush();
                ref.flush();
                return aStatus;
            }
            if (result instanceof Boolean) {
                AStatus aStatus = this.getStatus((Boolean)result);
                return aStatus;
            }
            if (result instanceof Integer) {
                AStatus aStatus = this.getStatus((Integer)result);
                return aStatus;
            }
            AStatus aStatus = AStatus.error("Unexpected return value from compiler: " + result);
            return aStatus;
        }
        finally {
            log.flush();
            ref.flush();
        }
    }

    protected AStatus getStatus(boolean ok) {
        return ok ? passed : failed;
    }

    protected AStatus getStatus(int exitCode) {
        return exitCode == 0 ? passed : failed;
    }

    private Class<?> getClass(ClassLoader loader, String name) {
        try {
            return loader == null ? Class.forName(name) : loader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private Method getMethod(Class<?> c, String name, Class<?> ... argTypes) {
        try {
            return c.getMethod(name, argTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (Throwable t) {
            if (this.verbose) {
                t.printStackTrace(this.log);
            }
            return null;
        }
    }

    private static String[] shift(String[] args, int n) {
        String[] newArgs = new String[args.length - n];
        System.arraycopy(args, n, newArgs, 0, newArgs.length);
        return newArgs;
    }
}

