/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.agent;

import com.sun.javatest.regtest.agent.AStatus;
import com.sun.javatest.regtest.agent.StringArray;
import com.sun.javatest.regtest.agent.TestThreadFactoryHelper;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class MainWrapper {
    public static String TEST_THREAD_FACTORY = "jtreg.test.thread.factory";
    public static String TEST_THREAD_FACTORY_PATH = "jtreg.test.thread.factory.path";
    private static final String MAIN_CANT_READ_ARGS = "JavaTest Error: Can't read main args file.";
    private static final String MAIN_THREAD_INTR = "Thread interrupted: ";
    private static final String MAIN_THREW_EXCEPT = "`main' threw exception: ";
    private static final String MAIN_CANT_LOAD_TEST = "Can't load test: ";
    private static final String MAIN_CANT_FIND_MAIN = "Can't find `main' method";
    private static final String MAIN_SKIPPED = "Skipped: ";
    private static final String SKIP_EXCEPTION = "jtreg.SkippedException";

    public static void main(String[] args) {
        String[] classArgs;
        String className;
        String moduleName;
        try {
            int howMany;
            FileReader in = new FileReader(args[0]);
            StringBuilder sb = new StringBuilder();
            char[] buf = new char[1024];
            while ((howMany = in.read(buf)) > 0) {
                sb.append(buf, 0, howMany);
            }
            in.close();
            String[] fileArgs = StringArray.splitTerminator("\u0000", sb.toString());
            int i = 0;
            String moduleClassName = fileArgs[i++];
            int sep = moduleClassName.indexOf(47);
            moduleName = sep == -1 ? null : moduleClassName.substring(0, sep);
            className = sep == -1 ? moduleClassName : moduleClassName.substring(sep + 1);
            classArgs = StringArray.splitWS(fileArgs[i++]);
        }
        catch (IOException e) {
            AStatus.failed(MAIN_CANT_READ_ARGS + e).exit();
            throw new IllegalStateException();
        }
        MainThreadGroup tg = new MainThreadGroup();
        MainTask task = new MainTask(moduleName, className, classArgs);
        String testThreadFactory = System.getProperty(TEST_THREAD_FACTORY);
        String testThreadFactoryPath = System.getProperty(TEST_THREAD_FACTORY_PATH);
        Thread t = testThreadFactory == null ? new Thread((ThreadGroup)tg, task) : TestThreadFactoryHelper.loadThreadFactory(testThreadFactory, testThreadFactoryPath).newThread(task);
        t.setName("MainThread");
        t.start();
        try {
            t.join();
        }
        catch (InterruptedException e) {
            AStatus.failed(MAIN_THREAD_INTR + Thread.currentThread().getName()).exit();
        }
        if (tg.uncaughtThrowable != null) {
            MainWrapper.handleTestException(tg.uncaughtThrowable);
        } else {
            AStatus.passed("").exit();
        }
    }

    private static void handleTestException(Throwable e) {
        if (SKIP_EXCEPTION.equals(e.getClass().getName())) {
            AStatus.passed(MAIN_SKIPPED + e).exit();
        } else {
            AStatus.failed(MAIN_THREW_EXCEPT + e).exit();
        }
    }

    static class MainThreadGroup
    extends ThreadGroup {
        private final boolean cleanMode = false;
        Throwable uncaughtThrowable = null;
        Thread uncaughtThread = null;

        MainThreadGroup() {
            super("MainThreadGroup");
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            if (e instanceof ThreadDeath) {
                return;
            }
            e.printStackTrace(System.err);
            if (this.uncaughtThrowable == null) {
                this.uncaughtThrowable = e;
                this.uncaughtThread = t;
            }
            AStatus.failed(MainWrapper.MAIN_THREW_EXCEPT + e).exit();
        }
    }

    static class MainTask
    implements Runnable {
        private final String moduleName;
        private final String className;
        private final String[] args;

        MainTask(String moduleName, String className, String[] args) {
            this.moduleName = moduleName;
            this.className = className;
            this.args = args;
        }

        @Override
        public void run() {
            try {
                ClassLoader cl;
                if (this.moduleName != null) {
                    Class<?> layerClass;
                    try {
                        layerClass = Class.forName("java.lang.ModuleLayer");
                    }
                    catch (ClassNotFoundException e) {
                        layerClass = Class.forName("java.lang.reflect.Layer");
                    }
                    Method bootMethod = layerClass.getMethod("boot", new Class[0]);
                    Object bootLayer = bootMethod.invoke(null, new Object[0]);
                    Method findLoaderMth = layerClass.getMethod("findLoader", String.class);
                    cl = (ClassLoader)findLoaderMth.invoke(bootLayer, this.moduleName);
                } else {
                    cl = this.getClass().getClassLoader();
                }
                Class<?> c = Class.forName(this.className, false, cl);
                Method mainMethod = c.getMethod("main", String[].class);
                mainMethod.invoke(null, new Object[]{this.args});
            }
            catch (InvocationTargetException e) {
                Throwable throwable = e.getTargetException();
                throwable.printStackTrace(System.err);
                System.err.println();
                System.err.println("JavaTest Message: Test threw exception: " + throwable);
                System.err.println("JavaTest Message: shutting down test");
                System.err.println();
                MainWrapper.handleTestException(throwable);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace(System.err);
                System.err.println();
                System.err.println("JavaTest Message: main() method must be in a public class named");
                System.err.println("JavaTest Message: " + this.className + " in file " + this.className + ".java");
                System.err.println();
                AStatus.error(MainWrapper.MAIN_CANT_LOAD_TEST + e).exit();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace(System.err);
                System.err.println();
                System.err.println("JavaTest Message: main() method must be in a public class named");
                System.err.println("JavaTest Message: " + this.className + " in file " + this.className + ".java");
                System.err.println();
                AStatus.error(MainWrapper.MAIN_CANT_FIND_MAIN).exit();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace(System.err);
                System.err.println();
                System.err.println("JavaTest Message: Verify that the class defining the test is");
                System.err.println("JavaTest Message: declared public (test invoked via reflection)");
                System.err.println();
                AStatus.error(e.toString()).exit();
            }
        }
    }
}

