/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.agent;

import java.util.HashMap;
import java.util.Map;

public class JDK_Version
implements Comparable<JDK_Version> {
    private static final Map<String, JDK_Version> values = new HashMap<String, JDK_Version>();
    public static JDK_Version V1_1 = JDK_Version.forName("1.1");
    public static JDK_Version V1_5 = JDK_Version.forName("1.5");
    public static JDK_Version V1_6 = JDK_Version.forName("1.6");
    public static JDK_Version V9 = JDK_Version.forName("9");
    public static JDK_Version V10 = JDK_Version.forName("10");
    public final int major;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JDK_Version forName(String name) {
        if (name == null) {
            return null;
        }
        Map<String, JDK_Version> map = values;
        synchronized (map) {
            JDK_Version v = values.get(name);
            if (v == null) {
                try {
                    int major;
                    if (name.startsWith("1.")) {
                        major = Integer.parseInt(name.substring(2));
                        if (major > 10) {
                            return null;
                        }
                    } else {
                        major = Integer.parseInt(name);
                        if (major < 5) {
                            return null;
                        }
                    }
                    v = new JDK_Version(major);
                    values.put(name, v);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            return v;
        }
    }

    public static JDK_Version forThisJVM() {
        return JDK_Version.forName(System.getProperty("java.specification.version"));
    }

    private JDK_Version(int major) {
        this.major = major;
    }

    public String name() {
        return (this.major < 9 ? "1." : "") + this.major;
    }

    public boolean equals(Object other) {
        return other instanceof JDK_Version && this.major == ((JDK_Version)other).major;
    }

    public int hashCode() {
        return this.major;
    }

    @Override
    public int compareTo(JDK_Version other) {
        return this.major < other.major ? -1 : (this.major == other.major ? 0 : 1);
    }

    public String toString() {
        return "JDK " + (this.major < 9 ? "1." : "") + this.major;
    }
}

