/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.agent;

import com.sun.javatest.regtest.agent.AStatus;
import com.sun.javatest.regtest.agent.ActionHelper;
import com.sun.javatest.regtest.agent.Alarm;
import com.sun.javatest.regtest.agent.JDK_Version;
import com.sun.javatest.regtest.agent.RegressionCompileCommand;
import com.sun.javatest.regtest.agent.SearchPath;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;

public class CompileActionHelper
extends ActionHelper {
    private static final AStatus passed = AStatus.passed("Compilation successful");
    private static final AStatus failed = AStatus.failed("Compilation failed");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AStatus runCompile(String testName, Map<String, String> props, List<String> cmdArgs, int timeout, ActionHelper.OutputHandler outputHandler) {
        ActionHelper.SaveState saved = new ActionHelper.SaveState();
        Properties p = System.getProperties();
        for (Map.Entry<String, String> e : props.entrySet()) {
            String name = e.getKey();
            String value = e.getValue();
            if (name.equals("test.class.path.prefix")) {
                SearchPath cp = new SearchPath(value, System.getProperty("java.class.path"));
                p.put("java.class.path", cp.toString());
                continue;
            }
            p.put(e.getKey(), e.getValue());
        }
        System.setProperties(p);
        PrintStream sysOut = outputHandler.getPrintStream(ActionHelper.OutputHandler.OutputKind.STDOUT, true);
        PrintStream sysErr = outputHandler.getPrintStream(ActionHelper.OutputHandler.OutputKind.STDERR, true);
        PrintWriter out = outputHandler.getPrintWriter(ActionHelper.OutputHandler.OutputKind.DIRECT, false);
        PrintWriter err = outputHandler.getPrintWriter(ActionHelper.OutputHandler.OutputKind.DIRECT_LOG, false);
        AStatus status = AStatus.error("");
        try {
            AStatus stat = CompileActionHelper.redirectOutput(sysOut, sysErr);
            if (!stat.isPassed()) {
                AStatus aStatus = stat;
                return aStatus;
            }
            Alarm alarm = Alarm.NONE;
            if (timeout > 0) {
                PrintWriter alarmOut = outputHandler.getPrintWriter(ActionHelper.OutputHandler.OutputKind.LOG, true);
                alarm = Alarm.schedulePeriodicInterrupt(timeout, TimeUnit.SECONDS, alarmOut, Thread.currentThread());
            }
            try {
                RegressionCompileCommand jcc = new RegressionCompileCommand(){

                    @Override
                    protected AStatus getStatus(int exitCode) {
                        JDK_Version v = JDK_Version.forThisJVM();
                        return CompileActionHelper.getStatusForJavacExitCode(v, exitCode);
                    }
                };
                String[] c = cmdArgs.toArray(new String[cmdArgs.size()]);
                status = jcc.run(c, err, out);
            }
            finally {
                alarm.cancel();
            }
        }
        finally {
            out.close();
            err.close();
            sysOut.close();
            sysErr.close();
            status = saved.restore(testName, status);
        }
        return status;
    }

    public static AStatus getStatusForJavacExitCode(JDK_Version v, int exitCode) {
        if (v == null || v.compareTo(JDK_Version.V1_6) < 0) {
            return exitCode == 0 ? passed : failed;
        }
        switch (exitCode) {
            case 0: {
                return passed;
            }
            case 1: {
                return failed;
            }
            case 2: {
                return AStatus.error("command line error (exit code 2)");
            }
            case 3: {
                return AStatus.error("system error (exit code 3)");
            }
            case 4: {
                return AStatus.error("compiler crashed (exit code 4)");
            }
        }
        return AStatus.error("unexpected exit code from javac: " + exitCode);
    }
}

