/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.agent;

import java.io.PrintWriter;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class Alarm {
    protected volatile boolean fired;
    protected ScheduledFuture<?> future;
    protected int count;
    protected final long delay;
    protected final TimeUnit delayUnit;
    protected final PrintWriter msgOut;
    public static final Alarm NONE = new NoAlarm(0L, TimeUnit.MILLISECONDS, null);
    private static final ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, new DaemonThreadFactory());

    public static Alarm schedulePeriodicInterrupt(long delay, TimeUnit unit, PrintWriter msgOut, Thread threadToInterrupt) {
        Interruptor runner = new Interruptor(delay, unit, msgOut, threadToInterrupt);
        runner.future = executor.scheduleWithFixedDelay(runner, TimeUnit.MILLISECONDS.convert(delay, unit), 100L, TimeUnit.MILLISECONDS);
        return runner;
    }

    public static Alarm scheduleInterrupt(long delay, TimeUnit unit, PrintWriter msgOut, Thread threadToInterrupt) {
        Interruptor runner = new Interruptor(delay, unit, msgOut, threadToInterrupt);
        runner.future = executor.schedule(runner, delay, unit);
        return runner;
    }

    public static Alarm schedule(long delay, TimeUnit unit, PrintWriter msgOut, Runnable r) {
        RunnableAlarm runner = new RunnableAlarm(delay, unit, msgOut, r);
        runner.future = executor.schedule(runner, delay, unit);
        return runner;
    }

    protected Alarm(long delay, TimeUnit delayUnit, PrintWriter msgOut) {
        this.delay = delay;
        this.delayUnit = delayUnit;
        this.msgOut = msgOut;
    }

    public void cancel() {
        this.future.cancel(true);
    }

    public boolean didFire() {
        return this.fired;
    }

    protected void run() {
        if (this.msgOut != null) {
            if (this.count == 0) {
                this.msgOut.println(String.format("Timeout signalled after %d seconds", TimeUnit.SECONDS.convert(this.delay, this.delayUnit)));
            } else if (this.count % 100 == 0) {
                this.msgOut.println(String.format("Timeout refired %d times", this.count));
            }
        }
        ++this.count;
        this.fired = true;
    }

    private static class Interruptor
    extends Alarm
    implements Runnable {
        Thread threadToInterrupt;

        public Interruptor(long delay, TimeUnit unit, PrintWriter msgOut, Thread t) {
            super(delay, unit, msgOut);
            this.threadToInterrupt = t;
        }

        @Override
        public void run() {
            super.run();
            this.threadToInterrupt.interrupt();
        }
    }

    private static class RunnableAlarm
    extends Alarm
    implements Runnable {
        Runnable r;

        public RunnableAlarm(long delay, TimeUnit unit, PrintWriter msgOut, Runnable r) {
            super(delay, unit, msgOut);
            this.r = r;
        }

        @Override
        public void run() {
            super.run();
            this.r.run();
        }
    }

    private static class NoAlarm
    extends Alarm {
        protected NoAlarm(long delay, TimeUnit delayUnit, PrintWriter msgOut) {
            super(delay, delayUnit, msgOut);
        }

        @Override
        public void cancel() {
        }

        @Override
        public boolean didFire() {
            return false;
        }
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        ThreadFactory defaultFactory = Executors.defaultThreadFactory();

        private DaemonThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = this.defaultFactory.newThread(r);
            thread.setDaemon(true);
            return thread;
        }
    }
}

