/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.agent;

import com.sun.javatest.regtest.agent.AStatus;
import com.sun.javatest.regtest.agent.ActionHelper;
import com.sun.javatest.regtest.agent.Alarm;
import com.sun.javatest.regtest.agent.CompileActionHelper;
import com.sun.javatest.regtest.agent.Flags;
import com.sun.javatest.regtest.agent.MainActionHelper;
import com.sun.javatest.regtest.agent.RegressionSecurityManager;
import com.sun.javatest.regtest.agent.SearchPath;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public final class AgentServer
implements ActionHelper.OutputHandler {
    public static final boolean traceServer = Flags.get("traceServer");
    public static final String ALLOW_SET_SECURITY_MANAGER = "-allowSetSecurityManager";
    public static final String ID = "-id";
    public static final String LOGFILE = "-logfile";
    public static final String HOST = "-host";
    public static final String PORT = "-port";
    public static final String TIMEOUTFACTOR = "-timeoutFactor";
    public static final String CUSTOM_TEST_THREAD_FACTORY = "-testThreadFactory";
    public static final String CUSTOM_TEST_THREAD_FACTORY_PATH = "-testThreadFactoryPath";
    public static final byte DO_COMPILE = 1;
    public static final byte DO_MAIN = 2;
    public static final byte OUTPUT = 3;
    public static final byte STATUS = 4;
    public static final byte KEEPALIVE = 5;
    public static final byte CLOSE = 6;
    private float timeoutFactor = 1.0f;
    private String testThreadFactory;
    private String testThreadFactoryPath;
    public static final SimpleDateFormat logDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
    private final KeepAlive keepAlive;
    private final DataInputStream in;
    private final DataOutputStream out;
    private final PrintStream traceOut = System.err;
    private final PrintWriter logWriter;
    private final int id;
    private final Map<ActionHelper.OutputHandler.OutputKind, Writer> writers = new EnumMap<ActionHelper.OutputHandler.OutputKind, Writer>(ActionHelper.OutputHandler.OutputKind.class);

    public static void main(String ... args) {
        if (traceServer) {
            System.err.println("AgentServer.main");
        }
        try {
            new AgentServer(args).run();
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }

    public AgentServer(String ... args) throws IOException {
        if (traceServer) {
            this.traceOut.println("Agent.Server started");
        }
        boolean allowSetSecurityManagerFlag = false;
        InetAddress host = InetAddress.getByName("localhost");
        int id = 0;
        int port = -1;
        File logFile = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals(ID)) {
                try {
                    id = Integer.parseInt(args[++i]);
                }
                catch (NumberFormatException e) {
                    id = 0;
                }
                continue;
            }
            if (arg.equals(LOGFILE)) {
                logFile = new File(args[++i]);
                continue;
            }
            if (arg.equals(ALLOW_SET_SECURITY_MANAGER)) {
                allowSetSecurityManagerFlag = true;
                continue;
            }
            if (arg.equals(PORT) && i + 1 < args.length) {
                port = Integer.valueOf(args[++i]);
                continue;
            }
            if (arg.equals(HOST) && i + 1 < args.length) {
                host = InetAddress.getByName(args[++i]);
                continue;
            }
            if (arg.equals(TIMEOUTFACTOR) && i + 1 < args.length) {
                this.timeoutFactor = Float.valueOf(args[++i]).floatValue();
                continue;
            }
            if (arg.equals(CUSTOM_TEST_THREAD_FACTORY) && i + 1 < args.length) {
                this.testThreadFactory = args[++i];
                continue;
            }
            if (arg.equals(CUSTOM_TEST_THREAD_FACTORY_PATH) && i + 1 < args.length) {
                this.testThreadFactoryPath = args[++i];
                continue;
            }
            throw new IllegalArgumentException(arg);
        }
        this.id = id;
        PrintWriter pw = null;
        if (logFile != null) {
            try {
                pw = new PrintWriter(new FileWriter(logFile));
            }
            catch (IOException e) {
                this.traceOut.println("Cannot open log writer: " + e);
                pw = new PrintWriter(System.err){

                    @Override
                    public void close() {
                        this.flush();
                    }
                };
            }
        }
        this.logWriter = pw;
        this.log("Started");
        if (port > 0) {
            Socket s = new Socket(host, port);
            s.setSoTimeout((int)(120000.0f * this.timeoutFactor));
            this.in = new DataInputStream(new BufferedInputStream(s.getInputStream()));
            this.out = new DataOutputStream(new BufferedOutputStream(s.getOutputStream()));
            this.log("Listening on port " + port);
        } else {
            this.in = new DataInputStream(new BufferedInputStream(System.in));
            this.out = new DataOutputStream(new BufferedOutputStream(System.out));
        }
        this.keepAlive = new KeepAlive(this.out, traceServer);
        RegressionSecurityManager.install();
        SecurityManager sm = System.getSecurityManager();
        if (sm instanceof RegressionSecurityManager) {
            RegressionSecurityManager rsm = (RegressionSecurityManager)sm;
            rsm.setAllowPropertiesAccess(true);
            if (allowSetSecurityManagerFlag) {
                rsm.setAllowSetSecurityManager(true);
            }
            rsm.setAllowSetIO(true);
        }
    }

    public void run() throws IOException {
        this.log("Running");
        try {
            int op;
            while ((op = this.in.read()) != -1) {
                switch (op) {
                    case 1: {
                        this.doCompile();
                        break;
                    }
                    case 2: {
                        this.doMain();
                        break;
                    }
                    case 5: {
                        break;
                    }
                    case 6: {
                        return;
                    }
                    default: {
                        throw new Error("Agent.Server: unexpected op: " + op);
                    }
                }
                this.out.flush();
            }
        }
        finally {
            this.keepAlive.finished();
            this.log("Exiting");
            this.logWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCompile() throws IOException {
        if (traceServer) {
            this.traceOut.println("Agent.Server.doCompile");
        }
        String testName = this.in.readUTF();
        Map<String, String> testProps = AgentServer.readMap(this.in);
        List<String> cmdArgs = AgentServer.readList(this.in);
        this.log(testName + ": starting compilation");
        this.keepAlive.setEnabled(true);
        try {
            AStatus status = CompileActionHelper.runCompile(testName, testProps, cmdArgs, 0, this);
            this.writeStatus(status);
        }
        finally {
            this.keepAlive.setEnabled(false);
            this.log(testName + ": finished compilation");
        }
        if (traceServer) {
            this.traceOut.println("Agent.Server.doCompile DONE");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doMain() throws IOException {
        if (traceServer) {
            this.traceOut.println("Agent.Server.doMain");
        }
        String testName = this.in.readUTF();
        Map<String, String> testProps = AgentServer.readMap(this.in);
        Set<String> addExports = AgentServer.readSet(this.in);
        Set<String> addOpens = AgentServer.readSet(this.in);
        Set<String> addMods = AgentServer.readSet(this.in);
        SearchPath classPath = new SearchPath(this.in.readUTF());
        SearchPath modulePath = new SearchPath(this.in.readUTF());
        String className = this.in.readUTF();
        List<String> classArgs = AgentServer.readList(this.in);
        if (traceServer) {
            this.traceOut.println("Agent.Server.doMain: " + testName);
        }
        this.log(testName + ": starting execution of " + className);
        this.keepAlive.setEnabled(true);
        try {
            AStatus status = new MainActionHelper(testName).properties(testProps).addExports(addExports).addOpens(addOpens).addMods(addMods).classpath(classPath).modulepath(modulePath).className(className).classArgs(classArgs).timeout(0).timeoutFactor(this.timeoutFactor).testThreadFactory(this.testThreadFactory).testThreadFactoryPath(this.testThreadFactoryPath).outputHandler(this).runClass();
            this.writeStatus(status);
        }
        finally {
            this.keepAlive.setEnabled(false);
            this.log(testName + ": finished execution of " + className);
        }
        if (traceServer) {
            this.traceOut.println("Agent.Server.doMain DONE");
        }
    }

    static List<String> readList(DataInputStream in) throws IOException {
        int n = in.readShort();
        ArrayList<String> l = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            l.add(in.readUTF());
        }
        return l;
    }

    static Set<String> readSet(DataInputStream in) throws IOException {
        int n = in.readShort();
        LinkedHashSet<String> s = new LinkedHashSet<String>(n);
        for (int i = 0; i < n; ++i) {
            s.add(in.readUTF());
        }
        return s;
    }

    static Map<String, String> readMap(DataInputStream in) throws IOException {
        int n = in.readShort();
        HashMap<String, String> p = new HashMap<String, String>(n, 1.0f);
        for (int i = 0; i < n; ++i) {
            String key = in.readUTF();
            String value = in.readUTF();
            p.put(key, value);
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStatus(AStatus s) throws IOException {
        if (traceServer) {
            this.traceOut.println("Agent.Server.writeStatus: " + s);
        }
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.writeByte(4);
            this.out.writeByte(s.getType());
            this.out.writeUTF(s.getReason());
        }
        this.writers.clear();
    }

    void log(String message) {
        this.logWriter.printf("[%s] AgentServer[%d]: %s%n", logDateFormat.format(new Date()), this.id, message);
        this.logWriter.flush();
    }

    @Override
    public PrintWriter getPrintWriter(ActionHelper.OutputHandler.OutputKind kind, boolean autoFlush) {
        return new PrintWriter(this.getWriter(kind), autoFlush);
    }

    private Writer getWriter(final ActionHelper.OutputHandler.OutputKind kind) {
        Writer w = this.writers.get((Object)kind);
        if (w == null) {
            w = new Writer(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void write(char[] cbuf, int off, int len) throws IOException {
                    if (traceServer) {
                        AgentServer.this.traceOut.println("Agent.Server.write[" + (Object)((Object)kind) + ",writer] " + new String(cbuf, off, len));
                    }
                    int BLOCKSIZE = 4096;
                    while (len > 0) {
                        int n = len > 4096 ? 4096 : len;
                        DataOutputStream dataOutputStream = AgentServer.this.out;
                        synchronized (dataOutputStream) {
                            AgentServer.this.out.writeByte(3);
                            AgentServer.this.out.writeUTF(kind.name);
                            AgentServer.this.out.writeUTF(new String(cbuf, off, n));
                        }
                        off += n;
                        len -= n;
                    }
                    if (traceServer) {
                        AgentServer.this.traceOut.println("Agent.Server.write[" + (Object)((Object)kind) + ",writer]--done");
                    }
                }

                @Override
                public void flush() throws IOException {
                    AgentServer.this.out.flush();
                }

                @Override
                public void close() throws IOException {
                    AgentServer.this.out.flush();
                }
            };
            this.writers.put(kind, w);
        }
        return w;
    }

    @Override
    public PrintStream getPrintStream(ActionHelper.OutputHandler.OutputKind kind, boolean autoFlush) {
        return new PrintStream(this.getOutputStream(kind), autoFlush);
    }

    private OutputStream getOutputStream(final ActionHelper.OutputHandler.OutputKind kind) {
        final Writer w = this.getWriter(kind);
        return new OutputStream(){
            private static final int BUFSIZE = 1024;
            private ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
            private CharBuffer charBuffer = CharBuffer.allocate(1024);
            private CharsetDecoder decoder = Charset.forName(System.getProperty("sun.stdout.encoding", System.getProperty("sun.jnu.encoding", Charset.defaultCharset().name()))).newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);

            @Override
            public void write(byte[] bytes, int off, int len) throws IOException {
                int n;
                if (traceServer) {
                    AgentServer.this.traceOut.println("Agent.Server.write[" + (Object)((Object)kind) + ",stream] " + new String(bytes, off, len));
                }
                while (len > 0 && len >= (n = this.byteBuffer.remaining())) {
                    this.byteBuffer.put(bytes, off, n);
                    this.decode();
                    off += n;
                    len -= n;
                }
                this.byteBuffer.put(bytes, off, len);
                if (traceServer) {
                    AgentServer.this.traceOut.println("Agent.Server.write[" + (Object)((Object)kind) + ",stream]--done");
                }
            }

            @Override
            public void write(int b) throws IOException {
                this.byteBuffer.put((byte)b);
                if (!this.byteBuffer.hasRemaining()) {
                    this.decode();
                }
            }

            @Override
            public void flush() throws IOException {
                this.decode();
                this.writeCharBuffer();
                w.flush();
            }

            @Override
            public void close() throws IOException {
                this.decode();
                this.byteBuffer.flip();
                this.decoder.decode(this.byteBuffer, this.charBuffer, true);
                this.writeCharBuffer();
                w.flush();
            }

            private void decode() throws IOException {
                CoderResult cr;
                this.byteBuffer.flip();
                while ((cr = this.decoder.decode(this.byteBuffer, this.charBuffer, false)) != CoderResult.UNDERFLOW) {
                    this.writeCharBuffer();
                }
                this.byteBuffer.compact();
            }

            private void writeCharBuffer() throws IOException {
                this.charBuffer.flip();
                w.write(this.charBuffer.toString());
                this.charBuffer.clear();
            }
        };
    }

    public static class KeepAlive {
        public static final int WRITE_TIMEOUT = 60000;
        public static final int READ_TIMEOUT = 120000;
        final DataOutputStream out;
        final Runnable ping = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    DataOutputStream dataOutputStream = out;
                    synchronized (dataOutputStream) {
                        if (trace) {
                            traceOut.println("KeepAlive.ping");
                        }
                        out.writeByte(5);
                        out.flush();
                    }
                    this.setEnabled(true);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        Alarm alarm = Alarm.NONE;
        final PrintStream traceOut = System.err;
        final boolean trace;

        public KeepAlive(DataOutputStream out, boolean trace) {
            this.out = out;
            this.trace = trace;
        }

        public synchronized void setEnabled(boolean on) {
            this.alarm.cancel();
            this.alarm = on ? Alarm.schedule(60000L, TimeUnit.MILLISECONDS, null, this.ping) : Alarm.NONE;
        }

        public synchronized void finished() {
            this.setEnabled(false);
        }
    }
}

