/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest;

import com.sun.javatest.regtest.agent.Alarm;
import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;

public abstract class TimeoutHandler {
    protected final PrintWriter log;
    protected final File outputDir;
    protected final File testJdk;
    private long timeout;

    public TimeoutHandler(PrintWriter log, File outputDir, File testJdk) {
        this(log, outputDir, testJdk.toPath());
    }

    public TimeoutHandler(PrintWriter log, File outputDir, Path testJdk) {
        this.log = log;
        this.outputDir = outputDir;
        this.testJdk = testJdk.toFile();
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void handleTimeout(Process proc) {
        this.log.println("Timeout information:");
        long pid = 0L;
        try {
            pid = this.getProcessId(proc);
        }
        catch (Exception ex) {
            ex.printStackTrace(this.log);
        }
        if (pid == 0L) {
            this.log.println("Could not find process id for the process that timed out.");
            this.log.println("Skipping timeout handling.");
            return;
        }
        Alarm a = this.timeout <= 0L ? Alarm.NONE : Alarm.scheduleInterrupt(this.timeout, TimeUnit.SECONDS, this.log, Thread.currentThread());
        try {
            this.runActions(proc, pid);
        }
        catch (InterruptedException ex) {
            a.cancel();
            this.log.println("Timeout handler interrupted: ");
            ex.printStackTrace(this.log);
        }
        finally {
            a.cancel();
        }
        this.log.println("--- Timeout information end.");
    }

    protected abstract void runActions(Process var1, long var2) throws InterruptedException;

    protected long getProcessId(Process proc) {
        try {
            try {
                Method pid = Process.class.getMethod("pid", new Class[0]);
                return (Long)pid.invoke((Object)proc, new Object[0]);
            }
            catch (NoSuchMethodException ignore) {
                return TimeoutHandler.getProcessIdPreJdk9(proc);
            }
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getProcessIdPreJdk9(Process proc) throws IllegalAccessException, NoSuchFieldException {
        if (proc.getClass().getName().equals("java.lang.UNIXProcess")) {
            int pid;
            Field f = proc.getClass().getDeclaredField("pid");
            boolean oldValue = f.isAccessible();
            try {
                f.setAccessible(true);
                pid = f.getInt(proc);
            }
            finally {
                f.setAccessible(oldValue);
            }
            return pid;
        }
        return 0L;
    }
}

