/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.diff;

import com.sun.javatest.TestResult;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.diff.DiffReader;
import com.sun.javatest.diff.Fault;
import com.sun.javatest.diff.HTMLReporter;
import com.sun.javatest.diff.MultiMap;
import com.sun.javatest.diff.ReportReader;
import com.sun.javatest.diff.Reporter;
import com.sun.javatest.diff.SimpleReporter;
import com.sun.javatest.diff.StatusComparator;
import com.sun.javatest.diff.WorkDirectoryReader;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public abstract class Diff {
    protected File outFile;
    protected PrintWriter out;
    protected Comparator<TestResult> comparator;
    protected Reporter reporter;
    protected boolean includeReason;
    protected String format;
    protected String title;
    private static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(Diff.class);

    public abstract boolean report(File var1) throws Fault, InterruptedException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean diff(List<File> list, File file) throws Fault, InterruptedException {
        this.outFile = file;
        ArrayList<DiffReader> arrayList = new ArrayList<DiffReader>();
        for (File serializable : list) {
            arrayList.add(this.open(serializable));
        }
        PrintWriter printWriter = this.out;
        if (file != null) {
            try {
                this.out = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            }
            catch (IOException iOException) {
                throw new Fault(i18n, "diff.cantOpenFile", file, iOException);
            }
        }
        try {
            this.initComparator();
            this.initReporter();
            this.reporter.setTitle(this.title);
            this.reporter.setComparator(this.comparator);
            this.reporter.setReaders(arrayList);
            ArrayList<int[]> arrayList2 = new ArrayList<int[]>();
            MultiMap<String, TestResult> multiMap = new MultiMap<String, TestResult>();
            for (DiffReader diffReader : arrayList) {
                int n = multiMap.addColumn(diffReader.getFile().getPath());
                int[] nArray = new int[4];
                for (TestResult testResult : diffReader) {
                    multiMap.addRow(n, testResult.getTestName(), testResult);
                    int n2 = testResult.getStatus().getType();
                    nArray[n2] = nArray[n2] + 1;
                }
                arrayList2.add(nArray);
            }
            this.reporter.setTestCounts(arrayList2);
            try {
                this.reporter.write(multiMap);
            }
            catch (IOException bl) {
                throw new Fault(i18n, "diff.ioError", bl);
            }
            boolean bl = this.reporter.diffs == 0;
            return bl;
        }
        finally {
            if (this.out != printWriter) {
                this.out.close();
                this.out = printWriter;
            }
        }
    }

    protected void initFormat() {
        String string;
        int n;
        if (this.format == null && this.outFile != null && (n = (string = this.outFile.getName()).lastIndexOf(".")) != -1) {
            this.format = string.substring(n + 1).toLowerCase();
        }
    }

    protected void initReporter() throws Fault {
        if (this.reporter == null) {
            try {
                this.initFormat();
                this.reporter = this.format != null && this.format.equals("html") ? new HTMLReporter(this.out) : new SimpleReporter(this.out);
            }
            catch (IOException iOException) {
                throw new Fault(i18n, "diff.cantOpenReport", iOException);
            }
        }
    }

    protected void initComparator() {
        if (this.comparator == null) {
            this.comparator = new StatusComparator(this.includeReason);
        }
    }

    protected DiffReader open(File file) throws Fault {
        if (!file.exists()) {
            throw new Fault(i18n, "main.cantFindFile", file);
        }
        try {
            if (WorkDirectoryReader.accepts(file)) {
                return new WorkDirectoryReader(file);
            }
            if (ReportReader.accepts(file)) {
                return new ReportReader(file);
            }
            throw new Fault(i18n, "main.unrecognizedFile", file);
        }
        catch (TestSuite.Fault | WorkDirectory.Fault | IOException exception) {
            throw new Fault(i18n, "main.cantOpenFile", file, exception);
        }
    }
}

