      SUBROUTINE NDF1_QMA( EL, QUAL, BADBIT, TYPE, NPNTR, PNTR, BAD,
     :                     STATUS )
*+
*  Name:
*     NDF1_QMA

*  Purpose:
*     Perform quality masking on vectorised arrays.

*  Language:
*     Starlink Fortran 77

*  Invocation:
*     CALL NDF1_QMA( EL, QUAL, BADBIT, TYPE, NPNTR, PNTR, BAD, STATUS )

*  Description:
*     The routine converts a vectorised quality array QUAL into a set
*     of "bad pixel" flags which are inserted into up to 4 matching
*     vectorised arrays of any numeric data type.  This is done by
*     performing a bit-wise AND operation between elements of the QUAL
*     array and the bitmask BADBIT. Where the result of this operation
*     is non-zero, the corresponding elements of the vectorised arrays
*     are set to the appropriate "bad" value.  Other array elements are
*     unchanged. A logical value BAD is also returned indicating
*     whether any "bad" pixels were actually generated by this quality
*     masking process. The arrays to be processed are passed to this
*     routine by pointer.

*  Arguments:
*     EL = INTEGER (Given)
*        The number of elements to process in each vectorised array.
*     QUAL( EL ) = BYTE (Given)
*        The quality array.
*     BADBIT = BYTE (Given)
*        The bad-bits mask to be applied to the quality array.
*     TYPE = CHARACTER * ( * ) (Given)
*        The data type of the arrays to be processed; an HDS primitive
*        numeric type string (case insensitive).
*     NPNTR = INTEGER (Given)
*        Number of arrays to be processed in the range 1 to 4. The
*        routine will return without action if this value is out of
*        range.
*     PNTR( 4 ) = INTEGER (Given)
*        The first NPNTR elements of this array should contain pointers
*        to the vectorised arrays to be processed.
*     BAD = LOGICAL (Returned)
*        Whether any bad pixels were generated as a result of the
*        quality masking process.
*     STATUS = INTEGER (Given and Returned)
*        The global status.

*  Algorithm:
*     -  Make a copy of the TYPE argument and check it is not truncated.
*     -  Convert to upper case.
*     -  Compare the data type with each permitted value in turn,
*     calling the appropriate routine to perform quality masking.
*     -  Note if the data type was not recognised.
*     -  If the TYPE argument is not valid, then report an error.

*  Authors:
*     RFWS: R.F. Warren-Smith (STARLINK)
*     {enter_new_authors_here}

*  History:
*     21-NOV-1989 (RFWS):
*        Original version.
*     6-FEB-1990 (RFWS):
*        Extended to process up to four arrays at once.
*     14-NOV-1990 (RFWS):
*        Added an extra status check.
*     {enter_further_changes_here}

*  Bugs:
*     {note_any_bugs_here}

*-
      
*  Type Definitions:
      IMPLICIT NONE              ! No implicit typing

*  Global Constants:
      INCLUDE 'SAE_PAR'          ! Standard SAE constants
      INCLUDE 'CNF_PAR'          ! For CNF_PVAL function
      INCLUDE 'DAT_PAR'          ! DAT_ public constants
      INCLUDE 'NDF_PAR'          ! NDF_ public constants
      INCLUDE 'NDF_ERR'          ! NDF_ error codes

*  Arguments Given:
      INTEGER EL
      BYTE QUAL( EL )
      BYTE BADBIT
      CHARACTER * ( * ) TYPE
      INTEGER NPNTR
      INTEGER PNTR( 4 )

*  Arguments Returned:
      LOGICAL BAD

*  Status:
      INTEGER STATUS             ! Global status

*  Local Variables:
      CHARACTER * ( NDF__SZTYP ) UTYPE ! Upper case version of TYPE
      LOGICAL TYPOK              ! Whether the TYPE argument is valid

*.

*  Check inherited global status.
      IF ( STATUS .NE. SAI__OK ) RETURN

*  Make a copy of the TYPE argument and check it is not truncated.
      UTYPE = TYPE
      TYPOK = UTYPE .EQ. TYPE

*  If OK, then convert to upper case.
      IF ( TYPOK ) THEN
         CALL CHR_UCASE( UTYPE )

*  Compare the data type with each permitted value in turn, calling the
*  appropriate routine to perform quality masking.

*  ...byte.
         IF ( UTYPE .EQ. '_BYTE' ) THEN
            CALL NDF1_QMAB( EL, QUAL, BADBIT, NPNTR,
     :                      %VAL( CNF_PVAL( PNTR( 1 ) ) ),
     :                      %VAL( CNF_PVAL( PNTR( 2 ) ) ),
     :                      %VAL( CNF_PVAL( PNTR( 3 ) ) ),
     :                      %VAL( CNF_PVAL( PNTR( 4 ) ) ),
     :                      BAD, STATUS )
 
*  ...unsigned byte.
         ELSE IF ( UTYPE .EQ. '_UBYTE' ) THEN
            CALL NDF1_QMAUB( EL, QUAL, BADBIT, NPNTR,
     :                       %VAL( CNF_PVAL( PNTR( 1 ) ) ),
     :                       %VAL( CNF_PVAL( PNTR( 2 ) ) ),
     :                       %VAL( CNF_PVAL( PNTR( 3 ) ) ),
     :                       %VAL( CNF_PVAL( PNTR( 4 ) ) ),
     :                       BAD, STATUS )
 
*  ...double precision.
         ELSE IF ( UTYPE .EQ. '_DOUBLE' ) THEN
            CALL NDF1_QMAD( EL, QUAL, BADBIT, NPNTR,
     :                      %VAL( CNF_PVAL( PNTR( 1 ) ) ),
     :                      %VAL( CNF_PVAL( PNTR( 2 ) ) ),
     :                      %VAL( CNF_PVAL( PNTR( 3 ) ) ),
     :                      %VAL( CNF_PVAL( PNTR( 4 ) ) ),
     :                      BAD, STATUS )
 
*  ...integer.
         ELSE IF ( UTYPE .EQ. '_INTEGER' ) THEN
            CALL NDF1_QMAI( EL, QUAL, BADBIT, NPNTR,
     :                      %VAL( CNF_PVAL( PNTR( 1 ) ) ),
     :                      %VAL( CNF_PVAL( PNTR( 2 ) ) ),
     :                      %VAL( CNF_PVAL( PNTR( 3 ) ) ),
     :                      %VAL( CNF_PVAL( PNTR( 4 ) ) ),
     :                      BAD, STATUS )
 
*  ...real.
         ELSE IF ( UTYPE .EQ. '_REAL' ) THEN
            CALL NDF1_QMAR( EL, QUAL, BADBIT, NPNTR,
     :                      %VAL( CNF_PVAL( PNTR( 1 ) ) ),
     :                      %VAL( CNF_PVAL( PNTR( 2 ) ) ),
     :                      %VAL( CNF_PVAL( PNTR( 3 ) ) ),
     :                      %VAL( CNF_PVAL( PNTR( 4 ) ) ),
     :                      BAD, STATUS )
 
*  ...word.
         ELSE IF ( UTYPE .EQ. '_WORD' ) THEN
            CALL NDF1_QMAW( EL, QUAL, BADBIT, NPNTR,
     :                      %VAL( CNF_PVAL( PNTR( 1 ) ) ),
     :                      %VAL( CNF_PVAL( PNTR( 2 ) ) ),
     :                      %VAL( CNF_PVAL( PNTR( 3 ) ) ),
     :                      %VAL( CNF_PVAL( PNTR( 4 ) ) ),
     :                      BAD, STATUS )
 
*  ...unsigned word.
         ELSE IF ( UTYPE .EQ. '_UWORD' ) THEN
            CALL NDF1_QMAUW( EL, QUAL, BADBIT, NPNTR,
     :                       %VAL( CNF_PVAL( PNTR( 1 ) ) ),
     :                       %VAL( CNF_PVAL( PNTR( 2 ) ) ),
     :                       %VAL( CNF_PVAL( PNTR( 3 ) ) ),
     :                       %VAL( CNF_PVAL( PNTR( 4 ) ) ),
     :                       BAD, STATUS )

*  Note if the data type was not recognised.
         ELSE
            TYPOK = .FALSE.
         END IF
      END IF

*  If the TYPE argument is not valid, then report an error.
      IF ( STATUS .EQ. SAI__OK ) THEN
         IF ( .NOT. TYPOK ) THEN
            STATUS = NDF__FATIN
            CALL MSG_SETC( 'ROUTINE', 'NDF1_QMA' )
            CALL MSG_SETC( 'BADTYPE', TYPE )
            CALL ERR_REP( 'NDF1_QMA_TYPE',
     :      'Routine ^ROUTINE called with an invalid TYPE argument ' //
     :      'of ''^BADTYPE'' (internal programming error).', STATUS )
         END IF
      END IF

*  Call error tracing routine and exit.
      IF ( STATUS .NE. SAI__OK ) CALL NDF1_TRACE( 'NDF1_QMA', STATUS )

      END
