; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -force-streaming-compatible-sve < %s | FileCheck %s

target datalayout = "e-m:o-i64:64-i128:128-n32:64-S128"

target triple = "aarch64-unknown-linux-gnu"

;============ f16

define void @test_copysign_v4f16_v4f16(ptr %ap, ptr %bp) #0 {
; CHECK-LABEL: test_copysign_v4f16_v4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr d0, [x0]
; CHECK-NEXT:    ldr d1, [x1]
; CHECK-NEXT:    and z0.h, z0.h, #0x7fff
; CHECK-NEXT:    and z1.h, z1.h, #0x8000
; CHECK-NEXT:    orr z0.d, z0.d, z1.d
; CHECK-NEXT:    str d0, [x0]
; CHECK-NEXT:    ret
  %a = load <4 x half>, ptr %ap
  %b = load <4 x half>, ptr %bp
  %r = call <4 x half> @llvm.copysign.v4f16(<4 x half> %a, <4 x half> %b)
  store <4 x half> %r, ptr %ap
  ret void
}

define void @test_copysign_v8f16_v8f16(ptr %ap, ptr %bp) #0 {
; CHECK-LABEL: test_copysign_v8f16_v8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    ldr q1, [x1]
; CHECK-NEXT:    and z0.h, z0.h, #0x7fff
; CHECK-NEXT:    and z1.h, z1.h, #0x8000
; CHECK-NEXT:    orr z0.d, z0.d, z1.d
; CHECK-NEXT:    str q0, [x0]
; CHECK-NEXT:    ret
  %a = load <8 x half>, ptr %ap
  %b = load <8 x half>, ptr %bp
  %r = call <8 x half> @llvm.copysign.v8f16(<8 x half> %a, <8 x half> %b)
  store <8 x half> %r, ptr %ap
  ret void
}

define void @test_copysign_v16f16_v16f16(ptr %ap, ptr %bp) #0 {
; CHECK-LABEL: test_copysign_v16f16_v16f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x1]
; CHECK-NEXT:    and z0.h, z0.h, #0x8000
; CHECK-NEXT:    ldp q2, q3, [x0]
; CHECK-NEXT:    and z1.h, z1.h, #0x8000
; CHECK-NEXT:    and z2.h, z2.h, #0x7fff
; CHECK-NEXT:    orr z0.d, z2.d, z0.d
; CHECK-NEXT:    and z3.h, z3.h, #0x7fff
; CHECK-NEXT:    orr z1.d, z3.d, z1.d
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %a = load <16 x half>, ptr %ap
  %b = load <16 x half>, ptr %bp
  %r = call <16 x half> @llvm.copysign.v16f16(<16 x half> %a, <16 x half> %b)
  store <16 x half> %r, ptr %ap
  ret void
}

;============ f32

define void @test_copysign_v2f32_v2f32(ptr %ap, ptr %bp) #0 {
; CHECK-LABEL: test_copysign_v2f32_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr d0, [x0]
; CHECK-NEXT:    ldr d1, [x1]
; CHECK-NEXT:    and z0.s, z0.s, #0x7fffffff
; CHECK-NEXT:    and z1.s, z1.s, #0x80000000
; CHECK-NEXT:    orr z0.d, z0.d, z1.d
; CHECK-NEXT:    str d0, [x0]
; CHECK-NEXT:    ret
  %a = load <2 x float>, ptr %ap
  %b = load <2 x float>, ptr %bp
  %r = call <2 x float> @llvm.copysign.v2f32(<2 x float> %a, <2 x float> %b)
  store <2 x float> %r, ptr %ap
  ret void
}

define void @test_copysign_v4f32_v4f32(ptr %ap, ptr %bp) #0 {
; CHECK-LABEL: test_copysign_v4f32_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    ldr q1, [x1]
; CHECK-NEXT:    and z0.s, z0.s, #0x7fffffff
; CHECK-NEXT:    and z1.s, z1.s, #0x80000000
; CHECK-NEXT:    orr z0.d, z0.d, z1.d
; CHECK-NEXT:    str q0, [x0]
; CHECK-NEXT:    ret
  %a = load <4 x float>, ptr %ap
  %b = load <4 x float>, ptr %bp
  %r = call <4 x float> @llvm.copysign.v4f32(<4 x float> %a, <4 x float> %b)
  store <4 x float> %r, ptr %ap
  ret void
}

define void @test_copysign_v8f32_v8f32(ptr %ap, ptr %bp) #0 {
; CHECK-LABEL: test_copysign_v8f32_v8f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x1]
; CHECK-NEXT:    and z0.s, z0.s, #0x80000000
; CHECK-NEXT:    ldp q2, q3, [x0]
; CHECK-NEXT:    and z1.s, z1.s, #0x80000000
; CHECK-NEXT:    and z2.s, z2.s, #0x7fffffff
; CHECK-NEXT:    orr z0.d, z2.d, z0.d
; CHECK-NEXT:    and z3.s, z3.s, #0x7fffffff
; CHECK-NEXT:    orr z1.d, z3.d, z1.d
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %a = load <8 x float>, ptr %ap
  %b = load <8 x float>, ptr %bp
  %r = call <8 x float> @llvm.copysign.v8f32(<8 x float> %a, <8 x float> %b)
  store <8 x float> %r, ptr %ap
  ret void
}

;============ f64

define void @test_copysign_v2f64_v2f64(ptr %ap, ptr %bp) #0 {
; CHECK-LABEL: test_copysign_v2f64_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    ldr q1, [x1]
; CHECK-NEXT:    and z0.d, z0.d, #0x7fffffffffffffff
; CHECK-NEXT:    and z1.d, z1.d, #0x8000000000000000
; CHECK-NEXT:    orr z0.d, z0.d, z1.d
; CHECK-NEXT:    str q0, [x0]
; CHECK-NEXT:    ret
  %a = load <2 x double>, ptr %ap
  %b = load <2 x double>, ptr %bp
  %r = call <2 x double> @llvm.copysign.v2f64(<2 x double> %a, <2 x double> %b)
  store <2 x double> %r, ptr %ap
  ret void
}

define void @test_copysign_v4f64_v4f64(ptr %ap, ptr %bp) #0 {
; CHECK-LABEL: test_copysign_v4f64_v4f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x1]
; CHECK-NEXT:    and z0.d, z0.d, #0x8000000000000000
; CHECK-NEXT:    ldp q2, q3, [x0]
; CHECK-NEXT:    and z1.d, z1.d, #0x8000000000000000
; CHECK-NEXT:    and z2.d, z2.d, #0x7fffffffffffffff
; CHECK-NEXT:    orr z0.d, z2.d, z0.d
; CHECK-NEXT:    and z3.d, z3.d, #0x7fffffffffffffff
; CHECK-NEXT:    orr z1.d, z3.d, z1.d
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %a = load <4 x double>, ptr %ap
  %b = load <4 x double>, ptr %bp
  %r = call <4 x double> @llvm.copysign.v4f64(<4 x double> %a, <4 x double> %b)
  store <4 x double> %r, ptr %ap
  ret void
}

;============ v2f32

define void @test_copysign_v2f32_v2f64(ptr %ap, ptr %bp) #0 {
; CHECK-LABEL: test_copysign_v2f32_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr q0, [x1]
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    ldr d1, [x0]
; CHECK-NEXT:    fcvt z0.s, p0/m, z0.d
; CHECK-NEXT:    uzp1 z0.s, z0.s, z0.s
; CHECK-NEXT:    and z1.s, z1.s, #0x7fffffff
; CHECK-NEXT:    and z0.s, z0.s, #0x80000000
; CHECK-NEXT:    orr z0.d, z1.d, z0.d
; CHECK-NEXT:    str d0, [x0]
; CHECK-NEXT:    ret
  %a = load <2 x float>, ptr %ap
  %b = load <2 x double>, ptr %bp
  %tmp0 = fptrunc <2 x double> %b to <2 x float>
  %r = call <2 x float> @llvm.copysign.v2f32(<2 x float> %a, <2 x float> %tmp0)
  store <2 x float> %r, ptr %ap
  ret void
}

;============ v4f32

; SplitVecOp #1
define void @test_copysign_v4f32_v4f64(ptr %ap, ptr %bp) #0 {
; CHECK-LABEL: test_copysign_v4f32_v4f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x1]
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    fcvt z1.s, p0/m, z1.d
; CHECK-NEXT:    uzp1 z1.s, z1.s, z1.s
; CHECK-NEXT:    ldr q2, [x0]
; CHECK-NEXT:    fcvt z0.s, p0/m, z0.d
; CHECK-NEXT:    uzp1 z0.s, z0.s, z0.s
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    splice z1.s, p0, z1.s, z0.s
; CHECK-NEXT:    and z1.s, z1.s, #0x80000000
; CHECK-NEXT:    and z2.s, z2.s, #0x7fffffff
; CHECK-NEXT:    orr z0.d, z2.d, z1.d
; CHECK-NEXT:    str q0, [x0]
; CHECK-NEXT:    ret
  %a = load <4 x float>, ptr %ap
  %b = load <4 x double>, ptr %bp
  %tmp0 = fptrunc <4 x double> %b to <4 x float>
  %r = call <4 x float> @llvm.copysign.v4f32(<4 x float> %a, <4 x float> %tmp0)
  store <4 x float> %r, ptr %ap
  ret void
}

;============ v2f64

define void @test_copysign_v2f64_v2f32(ptr %ap, ptr %bp) #0 {
; CHECK-LABEL: test_copysign_v2f64_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    ld1w { z1.d }, p0/z, [x1]
; CHECK-NEXT:    and z0.d, z0.d, #0x7fffffffffffffff
; CHECK-NEXT:    fcvt z1.d, p0/m, z1.s
; CHECK-NEXT:    and z1.d, z1.d, #0x8000000000000000
; CHECK-NEXT:    orr z0.d, z0.d, z1.d
; CHECK-NEXT:    str q0, [x0]
; CHECK-NEXT:    ret
  %a = load <2 x double>, ptr %ap
  %b = load < 2 x float>, ptr %bp
  %tmp0 = fpext <2 x float> %b to <2 x double>
  %r = call <2 x double> @llvm.copysign.v2f64(<2 x double> %a, <2 x double> %tmp0)
  store <2 x double> %r, ptr %ap
  ret void
}

;============ v4f64

; SplitVecRes mismatched
define void @test_copysign_v4f64_v4f32(ptr %ap, ptr %bp) #0 {
; CHECK-LABEL: test_copysign_v4f64_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov x8, #2
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ld1w { z2.d }, p0/z, [x1, x8, lsl #2]
; CHECK-NEXT:    ld1w { z3.d }, p0/z, [x1]
; CHECK-NEXT:    and z0.d, z0.d, #0x7fffffffffffffff
; CHECK-NEXT:    fcvt z3.d, p0/m, z3.s
; CHECK-NEXT:    fcvt z2.d, p0/m, z2.s
; CHECK-NEXT:    and z1.d, z1.d, #0x7fffffffffffffff
; CHECK-NEXT:    and z3.d, z3.d, #0x8000000000000000
; CHECK-NEXT:    and z2.d, z2.d, #0x8000000000000000
; CHECK-NEXT:    orr z0.d, z0.d, z3.d
; CHECK-NEXT:    orr z1.d, z1.d, z2.d
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %a = load <4 x double>, ptr %ap
  %b = load <4 x float>, ptr %bp
  %tmp0 = fpext <4 x float> %b to <4 x double>
  %r = call <4 x double> @llvm.copysign.v4f64(<4 x double> %a, <4 x double> %tmp0)
  store <4 x double> %r, ptr %ap
  ret void
}

;============ v4f16

define void @test_copysign_v4f16_v4f32(ptr %ap, ptr %bp) #0 {
; CHECK-LABEL: test_copysign_v4f16_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr q0, [x1]
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    ldr d1, [x0]
; CHECK-NEXT:    fcvt z0.h, p0/m, z0.s
; CHECK-NEXT:    uzp1 z0.h, z0.h, z0.h
; CHECK-NEXT:    and z1.h, z1.h, #0x7fff
; CHECK-NEXT:    and z0.h, z0.h, #0x8000
; CHECK-NEXT:    orr z0.d, z1.d, z0.d
; CHECK-NEXT:    str d0, [x0]
; CHECK-NEXT:    ret
  %a = load <4 x half>, ptr %ap
  %b = load <4 x float>, ptr %bp
  %tmp0 = fptrunc <4 x float> %b to <4 x half>
  %r = call <4 x half> @llvm.copysign.v4f16(<4 x half> %a, <4 x half> %tmp0)
  store <4 x half> %r, ptr %ap
  ret void
}

define void @test_copysign_v4f16_v4f64(ptr %ap, ptr %bp) #0 {
; CHECK-LABEL: test_copysign_v4f16_v4f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub sp, sp, #16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    ldp q1, q0, [x1]
; CHECK-NEXT:    fcvt h3, d1
; CHECK-NEXT:    mov z1.d, z1.d[1]
; CHECK-NEXT:    fcvt h1, d1
; CHECK-NEXT:    fcvt h2, d0
; CHECK-NEXT:    mov z0.d, z0.d[1]
; CHECK-NEXT:    fcvt h0, d0
; CHECK-NEXT:    ldr d4, [x0]
; CHECK-NEXT:    str h3, [sp, #8]
; CHECK-NEXT:    str h1, [sp, #10]
; CHECK-NEXT:    str h2, [sp, #12]
; CHECK-NEXT:    and z4.h, z4.h, #0x7fff
; CHECK-NEXT:    str h0, [sp, #14]
; CHECK-NEXT:    ldr d0, [sp, #8]
; CHECK-NEXT:    and z0.h, z0.h, #0x8000
; CHECK-NEXT:    orr z0.d, z4.d, z0.d
; CHECK-NEXT:    str d0, [x0]
; CHECK-NEXT:    add sp, sp, #16
; CHECK-NEXT:    ret
  %a = load <4 x half>, ptr %ap
  %b = load <4 x double>, ptr %bp
  %tmp0 = fptrunc <4 x double> %b to <4 x half>
  %r = call <4 x half> @llvm.copysign.v4f16(<4 x half> %a, <4 x half> %tmp0)
  store <4 x half> %r, ptr %ap
  ret void
}

;============ v8f16

define void @test_copysign_v8f16_v8f32(ptr %ap, ptr %bp) #0 {
; CHECK-LABEL: test_copysign_v8f16_v8f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x1]
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fcvt z1.h, p0/m, z1.s
; CHECK-NEXT:    uzp1 z1.h, z1.h, z1.h
; CHECK-NEXT:    ldr q2, [x0]
; CHECK-NEXT:    fcvt z0.h, p0/m, z0.s
; CHECK-NEXT:    uzp1 z0.h, z0.h, z0.h
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    splice z1.h, p0, z1.h, z0.h
; CHECK-NEXT:    and z1.h, z1.h, #0x8000
; CHECK-NEXT:    and z2.h, z2.h, #0x7fff
; CHECK-NEXT:    orr z0.d, z2.d, z1.d
; CHECK-NEXT:    str q0, [x0]
; CHECK-NEXT:    ret
  %a = load <8 x half>, ptr %ap
  %b = load <8 x float>, ptr %bp
  %tmp0 = fptrunc <8 x float> %b to <8 x half>
  %r = call <8 x half> @llvm.copysign.v8f16(<8 x half> %a, <8 x half> %tmp0)
  store <8 x half> %r, ptr %ap
  ret void
}

declare <4 x half> @llvm.copysign.v4f16(<4 x half> %a, <4 x half> %b) #0
declare <8 x half> @llvm.copysign.v8f16(<8 x half> %a, <8 x half> %b) #0
declare <16 x half> @llvm.copysign.v16f16(<16 x half> %a, <16 x half> %b) #0

declare <2 x float> @llvm.copysign.v2f32(<2 x float> %a, <2 x float> %b) #0
declare <4 x float> @llvm.copysign.v4f32(<4 x float> %a, <4 x float> %b) #0
declare <8 x float> @llvm.copysign.v8f32(<8 x float> %a, <8 x float> %b) #0

declare <2 x double> @llvm.copysign.v2f64(<2 x double> %a, <2 x double> %b) #0
declare <4 x double> @llvm.copysign.v4f64(<4 x double> %a, <4 x double> %b) #0

attributes #0 = { "target-features"="+sve" }
