#!/bin/sh
#
# This performs testing conversion "circular" conversions:
#	UNIX->MAC->DOS->UNIX and
#	UNIX->DOS->MAC->UNIX
# on hd2u thus testing all conversions - whether they do not corrupt data.
#
# Copyright (C) 2006 Peter Hanecak <hany@hany.sk>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# See the COPYING file for license information.

HD2U=./dos2unix
MD5=`which md5sum`
SILENT=false
TEMP_FILE=$$.test.tmp


if [ ! -e $MD5 ]; then
	echo "${0}: unable to locate md5 utility - unable to perform tests"
	exit -1
fi
if [ "$TEMP_FILE" == "" ]; then
	echo "${0}: TEMP_FILE is empty!"
	exit -2
fi
if [ -e "$TEMP_FILE" ]; then
	echo "${0}: temporary file $TEMP_FILE alredy exists!"
	exit -3
fi


if [ "$1" == "--silent" ]; then
	SILENT=true
	shift
fi


while [ "$1" != "" ]; do
	TEST_FILE=$1
	if [ ! -e "$TEST_FILE" ]; then
		echo "${0}: test file $TEST_FILE does not exists!"
		exit -4
	fi
	if [ "$SILENT" != "true" ]; then echo -n "testing conversions on ${TEST_FILE}: "; fi

	MD5_CS_ORIG=`cat $TEST_FILE | $MD5`

	cat $TEST_FILE \
		| $HD2U --u2m \
		| $HD2U --m2d \
		| $HD2U --d2u \
		> $TEMP_FILE
	MD5_CS_TEST=`cat $TEMP_FILE | $MD5`
	if [ "$MD5_CS_ORIG" != "$MD5_CS_TEST" ]; then
		echo "test 1 of circular conversion failed"
		exit -5
	fi

	cat $TEST_FILE \
		| $HD2U --u2d \
		| $HD2U --d2m \
		| $HD2U --m2u \
		> $TEMP_FILE
	MD5_CS_TEST=`cat $TEMP_FILE | $MD5`
	if [ "$MD5_CS_ORIG" != "$MD5_CS_TEST" ]; then
		echo "test 2 of circular conversion failed"
		exit -6
	fi

	if [ "$SILENT" != "true" ]; then echo "OK"; fi

	shift
done

rm -f $TEMP_FILE

exit 0
	