; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -S -passes=instsimplify | FileCheck %s

declare i32 @llvm.bitreverse.i32(i32)
declare <2 x i32> @llvm.bitreverse.v2i32(<2 x i32>)

define i1 @test1(i32 %arg) {
; CHECK-LABEL: @test1(
; CHECK-NEXT:    ret i1 false
;
  %a = or i32 %arg, 1
  %b = call i32 @llvm.bitreverse.i32(i32 %a)
  %res = icmp eq i32 %b, 0
  ret i1 %res
}

define i1 @test1v(<2 x i32> %arg) {
; CHECK-LABEL: @test1v(
; CHECK-NEXT:    ret i1 false
;
  %a = or <2 x i32> %arg, <i32 1, i32 0>
  %b = call <2 x i32> @llvm.bitreverse.v2i32(<2 x i32> %a)
  %c = extractelement <2 x i32> %b, i32 0
  %res = icmp eq i32 %c, 0
  ret i1 %res
}

define i1 @test2(i32 %arg) {
; CHECK-LABEL: @test2(
; CHECK-NEXT:    ret i1 false
;
  %a = or i32 %arg, 1024
  %b = call i32 @llvm.bitreverse.i32(i32 %a)
  %res = icmp eq i32 %b, 0
  ret i1 %res
}

define i1 @test2v(<2 x i32> %arg) {
; CHECK-LABEL: @test2v(
; CHECK-NEXT:    ret i1 false
;
  %a = or <2 x i32> %arg, <i32 0, i32 1024>
  %b = call <2 x i32> @llvm.bitreverse.v2i32(<2 x i32> %a)
  %c = extractelement <2 x i32> %b, i32 1
  %res = icmp eq i32 %c, 0
  ret i1 %res
}

define i1 @test3(i32 %arg) {
; CHECK-LABEL: @test3(
; CHECK-NEXT:    ret i1 false
;
  %a = and i32 %arg, 1
  %b = call i32 @llvm.bitreverse.i32(i32 %a)
  %and = and i32 %b, 1
  %res = icmp eq i32 %and, 1
  ret i1 %res
}

define i1 @test3v(<2 x i32> %arg) {
; CHECK-LABEL: @test3v(
; CHECK-NEXT:    ret i1 false
;
  %a = and <2 x i32> %arg, <i32 1, i32 -1>
  %b = call <2 x i32> @llvm.bitreverse.v2i32(<2 x i32> %a)
  %and = and <2 x i32> %b, <i32 1, i32 -1>
  %ext = extractelement <2 x i32> %and, i32 0
  %res = icmp eq i32 %ext, 1
  ret i1 %res
}
