// Copyright 2020 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_X_KEYSYMS_KEYSYMS_H_
#define UI_GFX_X_KEYSYMS_KEYSYMS_H_

#include <cstdint>

static constexpr uint32_t XK_space = 0x20;
static constexpr uint32_t XK_exclam = 0x21;
static constexpr uint32_t XK_quotedbl = 0x22;
static constexpr uint32_t XK_numbersign = 0x23;
static constexpr uint32_t XK_dollar = 0x24;
static constexpr uint32_t XK_percent = 0x25;
static constexpr uint32_t XK_ampersand = 0x26;
static constexpr uint32_t XK_quoteright = 0x27;
static constexpr uint32_t XK_parenleft = 0x28;
static constexpr uint32_t XK_parenright = 0x29;
static constexpr uint32_t XK_asterisk = 0x2A;
static constexpr uint32_t XK_plus = 0x2B;
static constexpr uint32_t XK_comma = 0x2C;
static constexpr uint32_t XK_minus = 0x2D;
static constexpr uint32_t XK_period = 0x2E;
static constexpr uint32_t XK_slash = 0x2F;
static constexpr uint32_t XK_0 = 0x30;
static constexpr uint32_t XK_1 = 0x31;
static constexpr uint32_t XK_2 = 0x32;
static constexpr uint32_t XK_3 = 0x33;
static constexpr uint32_t XK_4 = 0x34;
static constexpr uint32_t XK_5 = 0x35;
static constexpr uint32_t XK_6 = 0x36;
static constexpr uint32_t XK_7 = 0x37;
static constexpr uint32_t XK_8 = 0x38;
static constexpr uint32_t XK_9 = 0x39;
static constexpr uint32_t XK_colon = 0x3A;
static constexpr uint32_t XK_semicolon = 0x3B;
static constexpr uint32_t XK_less = 0x3C;
static constexpr uint32_t XK_equal = 0x3D;
static constexpr uint32_t XK_greater = 0x3E;
static constexpr uint32_t XK_question = 0x3F;
static constexpr uint32_t XK_at = 0x40;
static constexpr uint32_t XK_A = 0x41;
static constexpr uint32_t XK_Z = 0x5A;
static constexpr uint32_t XK_bracketleft = 0x5B;
static constexpr uint32_t XK_backslash = 0x5C;
static constexpr uint32_t XK_bracketright = 0x5D;
static constexpr uint32_t XK_asciicircum = 0x5E;
static constexpr uint32_t XK_underscore = 0x5F;
static constexpr uint32_t XK_quoteleft = 0x60;
static constexpr uint32_t XK_a = 0x61;
static constexpr uint32_t XK_z = 0x7A;
static constexpr uint32_t XK_braceleft = 0x7B;
static constexpr uint32_t XK_bar = 0x7C;
static constexpr uint32_t XK_braceright = 0x7D;
static constexpr uint32_t XK_asciitilde = 0x7E;
static constexpr uint32_t XK_exclamdown = 0xA1;
static constexpr uint32_t XK_brokenbar = 0xA6;
static constexpr uint32_t XK_guillemotleft = 0xAB;
static constexpr uint32_t XK_degree = 0xB0;
static constexpr uint32_t XK_periodcentered = 0xB7;
static constexpr uint32_t XK_guillemotright = 0xBB;
static constexpr uint32_t XK_questiondown = 0xBF;
static constexpr uint32_t XK_Agrave = 0xC0;
static constexpr uint32_t XK_Odiaeresis = 0xD6;
static constexpr uint32_t XK_multiply = 0xD7;
static constexpr uint32_t XK_Ooblique = 0xD8;
static constexpr uint32_t XK_Ugrave = 0xD9;
static constexpr uint32_t XK_Thorn = 0xDE;
static constexpr uint32_t XK_agrave = 0xE0;
static constexpr uint32_t XK_odiaeresis = 0xF6;
static constexpr uint32_t XK_oslash = 0xF8;
static constexpr uint32_t XK_ugrave = 0xF9;
static constexpr uint32_t XK_thorn = 0xFE;
static constexpr uint32_t XK_ydiaeresis = 0xFF;
static constexpr uint32_t XK_Aogonek = 0x1A1;
static constexpr uint32_t XK_breve = 0x1A2;
static constexpr uint32_t XK_Lstroke = 0x1A3;
static constexpr uint32_t XK_Lcaron = 0x1A5;
static constexpr uint32_t XK_Sacute = 0x1A6;
static constexpr uint32_t XK_Scaron = 0x1A9;
static constexpr uint32_t XK_Scedilla = 0x1AA;
static constexpr uint32_t XK_Tcaron = 0x1AB;
static constexpr uint32_t XK_Zacute = 0x1AC;
static constexpr uint32_t XK_Zcaron = 0x1AE;
static constexpr uint32_t XK_Zabovedot = 0x1AF;
static constexpr uint32_t XK_aogonek = 0x1B1;
static constexpr uint32_t XK_ogonek = 0x1B2;
static constexpr uint32_t XK_lstroke = 0x1B3;
static constexpr uint32_t XK_lcaron = 0x1B5;
static constexpr uint32_t XK_sacute = 0x1B6;
static constexpr uint32_t XK_caron = 0x1B7;
static constexpr uint32_t XK_scaron = 0x1B9;
static constexpr uint32_t XK_scedilla = 0x1BA;
static constexpr uint32_t XK_tcaron = 0x1BB;
static constexpr uint32_t XK_zacute = 0x1BC;
static constexpr uint32_t XK_doubleacute = 0x1BD;
static constexpr uint32_t XK_zcaron = 0x1BE;
static constexpr uint32_t XK_zabovedot = 0x1BF;
static constexpr uint32_t XK_Racute = 0x1C0;
static constexpr uint32_t XK_Abreve = 0x1C3;
static constexpr uint32_t XK_Lacute = 0x1C5;
static constexpr uint32_t XK_Cacute = 0x1C6;
static constexpr uint32_t XK_Ccaron = 0x1C8;
static constexpr uint32_t XK_Eogonek = 0x1CA;
static constexpr uint32_t XK_Ecaron = 0x1CC;
static constexpr uint32_t XK_Dcaron = 0x1CF;
static constexpr uint32_t XK_Dstroke = 0x1D0;
static constexpr uint32_t XK_Nacute = 0x1D1;
static constexpr uint32_t XK_Ncaron = 0x1D2;
static constexpr uint32_t XK_Odoubleacute = 0x1D5;
static constexpr uint32_t XK_Rcaron = 0x1D8;
static constexpr uint32_t XK_Uring = 0x1D9;
static constexpr uint32_t XK_Udoubleacute = 0x1DB;
static constexpr uint32_t XK_Tcedilla = 0x1DE;
static constexpr uint32_t XK_racute = 0x1E0;
static constexpr uint32_t XK_abreve = 0x1E3;
static constexpr uint32_t XK_lacute = 0x1E5;
static constexpr uint32_t XK_cacute = 0x1E6;
static constexpr uint32_t XK_ccaron = 0x1E8;
static constexpr uint32_t XK_eogonek = 0x1EA;
static constexpr uint32_t XK_ecaron = 0x1EC;
static constexpr uint32_t XK_dcaron = 0x1EF;
static constexpr uint32_t XK_dstroke = 0x1F0;
static constexpr uint32_t XK_nacute = 0x1F1;
static constexpr uint32_t XK_ncaron = 0x1F2;
static constexpr uint32_t XK_odoubleacute = 0x1F5;
static constexpr uint32_t XK_rcaron = 0x1F8;
static constexpr uint32_t XK_uring = 0x1F9;
static constexpr uint32_t XK_udoubleacute = 0x1FB;
static constexpr uint32_t XK_tcedilla = 0x1FE;
static constexpr uint32_t XK_abovedot = 0x1FF;
static constexpr uint32_t XK_Hstroke = 0x2A1;
static constexpr uint32_t XK_Hcircumflex = 0x2A6;
static constexpr uint32_t XK_Iabovedot = 0x2A9;
static constexpr uint32_t XK_Gbreve = 0x2AB;
static constexpr uint32_t XK_Jcircumflex = 0x2AC;
static constexpr uint32_t XK_hstroke = 0x2B1;
static constexpr uint32_t XK_hcircumflex = 0x2B6;
static constexpr uint32_t XK_idotless = 0x2B9;
static constexpr uint32_t XK_gbreve = 0x2BB;
static constexpr uint32_t XK_jcircumflex = 0x2BC;
static constexpr uint32_t XK_Cabovedot = 0x2C5;
static constexpr uint32_t XK_Ccircumflex = 0x2C6;
static constexpr uint32_t XK_Gabovedot = 0x2D5;
static constexpr uint32_t XK_Gcircumflex = 0x2D8;
static constexpr uint32_t XK_Ubreve = 0x2DD;
static constexpr uint32_t XK_Scircumflex = 0x2DE;
static constexpr uint32_t XK_cabovedot = 0x2E5;
static constexpr uint32_t XK_ccircumflex = 0x2E6;
static constexpr uint32_t XK_gabovedot = 0x2F5;
static constexpr uint32_t XK_gcircumflex = 0x2F8;
static constexpr uint32_t XK_ubreve = 0x2FD;
static constexpr uint32_t XK_scircumflex = 0x2FE;
static constexpr uint32_t XK_kra = 0x3A2;
static constexpr uint32_t XK_Rcedilla = 0x3A3;
static constexpr uint32_t XK_Itilde = 0x3A5;
static constexpr uint32_t XK_Lcedilla = 0x3A6;
static constexpr uint32_t XK_Emacron = 0x3AA;
static constexpr uint32_t XK_Gcedilla = 0x3AB;
static constexpr uint32_t XK_Tslash = 0x3AC;
static constexpr uint32_t XK_rcedilla = 0x3B3;
static constexpr uint32_t XK_itilde = 0x3B5;
static constexpr uint32_t XK_lcedilla = 0x3B6;
static constexpr uint32_t XK_emacron = 0x3BA;
static constexpr uint32_t XK_gcedilla = 0x3BB;
static constexpr uint32_t XK_tslash = 0x3BC;
static constexpr uint32_t XK_ENG = 0x3BD;
static constexpr uint32_t XK_eng = 0x3BF;
static constexpr uint32_t XK_Amacron = 0x3C0;
static constexpr uint32_t XK_Iogonek = 0x3C7;
static constexpr uint32_t XK_Eabovedot = 0x3CC;
static constexpr uint32_t XK_Imacron = 0x3CF;
static constexpr uint32_t XK_Ncedilla = 0x3D1;
static constexpr uint32_t XK_Omacron = 0x3D2;
static constexpr uint32_t XK_Kcedilla = 0x3D3;
static constexpr uint32_t XK_Uogonek = 0x3D9;
static constexpr uint32_t XK_Utilde = 0x3DD;
static constexpr uint32_t XK_Umacron = 0x3DE;
static constexpr uint32_t XK_amacron = 0x3E0;
static constexpr uint32_t XK_iogonek = 0x3E7;
static constexpr uint32_t XK_eabovedot = 0x3EC;
static constexpr uint32_t XK_imacron = 0x3EF;
static constexpr uint32_t XK_ncedilla = 0x3F1;
static constexpr uint32_t XK_omacron = 0x3F2;
static constexpr uint32_t XK_kcedilla = 0x3F3;
static constexpr uint32_t XK_uogonek = 0x3F9;
static constexpr uint32_t XK_utilde = 0x3FD;
static constexpr uint32_t XK_umacron = 0x3FE;
static constexpr uint32_t XK_overline = 0x47E;
static constexpr uint32_t XK_kana_fullstop = 0x4A1;
static constexpr uint32_t XK_kana_openingbracket = 0x4A2;
static constexpr uint32_t XK_kana_closingbracket = 0x4A3;
static constexpr uint32_t XK_kana_comma = 0x4A4;
static constexpr uint32_t XK_kana_conjunctive = 0x4A5;
static constexpr uint32_t XK_kana_WO = 0x4A6;
static constexpr uint32_t XK_kana_a = 0x4A7;
static constexpr uint32_t XK_kana_i = 0x4A8;
static constexpr uint32_t XK_kana_u = 0x4A9;
static constexpr uint32_t XK_kana_e = 0x4AA;
static constexpr uint32_t XK_kana_o = 0x4AB;
static constexpr uint32_t XK_kana_ya = 0x4AC;
static constexpr uint32_t XK_kana_yu = 0x4AD;
static constexpr uint32_t XK_kana_yo = 0x4AE;
static constexpr uint32_t XK_kana_tsu = 0x4AF;
static constexpr uint32_t XK_prolongedsound = 0x4B0;
static constexpr uint32_t XK_kana_A = 0x4B1;
static constexpr uint32_t XK_kana_I = 0x4B2;
static constexpr uint32_t XK_kana_U = 0x4B3;
static constexpr uint32_t XK_kana_E = 0x4B4;
static constexpr uint32_t XK_kana_O = 0x4B5;
static constexpr uint32_t XK_kana_KA = 0x4B6;
static constexpr uint32_t XK_kana_KI = 0x4B7;
static constexpr uint32_t XK_kana_KU = 0x4B8;
static constexpr uint32_t XK_kana_KE = 0x4B9;
static constexpr uint32_t XK_kana_KO = 0x4BA;
static constexpr uint32_t XK_kana_SA = 0x4BB;
static constexpr uint32_t XK_kana_SHI = 0x4BC;
static constexpr uint32_t XK_kana_SU = 0x4BD;
static constexpr uint32_t XK_kana_SE = 0x4BE;
static constexpr uint32_t XK_kana_SO = 0x4BF;
static constexpr uint32_t XK_kana_TA = 0x4C0;
static constexpr uint32_t XK_kana_CHI = 0x4C1;
static constexpr uint32_t XK_kana_TSU = 0x4C2;
static constexpr uint32_t XK_kana_TE = 0x4C3;
static constexpr uint32_t XK_kana_TO = 0x4C4;
static constexpr uint32_t XK_kana_NA = 0x4C5;
static constexpr uint32_t XK_kana_NI = 0x4C6;
static constexpr uint32_t XK_kana_NU = 0x4C7;
static constexpr uint32_t XK_kana_NE = 0x4C8;
static constexpr uint32_t XK_kana_NO = 0x4C9;
static constexpr uint32_t XK_kana_HA = 0x4CA;
static constexpr uint32_t XK_kana_HI = 0x4CB;
static constexpr uint32_t XK_kana_FU = 0x4CC;
static constexpr uint32_t XK_kana_HE = 0x4CD;
static constexpr uint32_t XK_kana_HO = 0x4CE;
static constexpr uint32_t XK_kana_MA = 0x4CF;
static constexpr uint32_t XK_kana_MI = 0x4D0;
static constexpr uint32_t XK_kana_MU = 0x4D1;
static constexpr uint32_t XK_kana_ME = 0x4D2;
static constexpr uint32_t XK_kana_MO = 0x4D3;
static constexpr uint32_t XK_kana_YA = 0x4D4;
static constexpr uint32_t XK_kana_YU = 0x4D5;
static constexpr uint32_t XK_kana_YO = 0x4D6;
static constexpr uint32_t XK_kana_RA = 0x4D7;
static constexpr uint32_t XK_kana_RI = 0x4D8;
static constexpr uint32_t XK_kana_RU = 0x4D9;
static constexpr uint32_t XK_kana_RE = 0x4DA;
static constexpr uint32_t XK_kana_RO = 0x4DB;
static constexpr uint32_t XK_kana_WA = 0x4DC;
static constexpr uint32_t XK_kana_N = 0x4DD;
static constexpr uint32_t XK_voicedsound = 0x4DE;
static constexpr uint32_t XK_semivoicedsound = 0x4DF;
static constexpr uint32_t XK_Arabic_comma = 0x5AC;
static constexpr uint32_t XK_Arabic_semicolon = 0x5BB;
static constexpr uint32_t XK_Arabic_question_mark = 0x5BF;
static constexpr uint32_t XK_Arabic_hamza = 0x5C1;
static constexpr uint32_t XK_Arabic_maddaonalef = 0x5C2;
static constexpr uint32_t XK_Arabic_hamzaonalef = 0x5C3;
static constexpr uint32_t XK_Arabic_hamzaonwaw = 0x5C4;
static constexpr uint32_t XK_Arabic_hamzaunderalef = 0x5C5;
static constexpr uint32_t XK_Arabic_hamzaonyeh = 0x5C6;
static constexpr uint32_t XK_Arabic_alef = 0x5C7;
static constexpr uint32_t XK_Arabic_beh = 0x5C8;
static constexpr uint32_t XK_Arabic_tehmarbuta = 0x5C9;
static constexpr uint32_t XK_Arabic_teh = 0x5CA;
static constexpr uint32_t XK_Arabic_theh = 0x5CB;
static constexpr uint32_t XK_Arabic_jeem = 0x5CC;
static constexpr uint32_t XK_Arabic_hah = 0x5CD;
static constexpr uint32_t XK_Arabic_khah = 0x5CE;
static constexpr uint32_t XK_Arabic_dal = 0x5CF;
static constexpr uint32_t XK_Arabic_thal = 0x5D0;
static constexpr uint32_t XK_Arabic_ra = 0x5D1;
static constexpr uint32_t XK_Arabic_zain = 0x5D2;
static constexpr uint32_t XK_Arabic_seen = 0x5D3;
static constexpr uint32_t XK_Arabic_sheen = 0x5D4;
static constexpr uint32_t XK_Arabic_sad = 0x5D5;
static constexpr uint32_t XK_Arabic_dad = 0x5D6;
static constexpr uint32_t XK_Arabic_tah = 0x5D7;
static constexpr uint32_t XK_Arabic_zah = 0x5D8;
static constexpr uint32_t XK_Arabic_ain = 0x5D9;
static constexpr uint32_t XK_Arabic_ghain = 0x5DA;
static constexpr uint32_t XK_Arabic_tatweel = 0x5E0;
static constexpr uint32_t XK_Arabic_feh = 0x5E1;
static constexpr uint32_t XK_Arabic_qaf = 0x5E2;
static constexpr uint32_t XK_Arabic_kaf = 0x5E3;
static constexpr uint32_t XK_Arabic_lam = 0x5E4;
static constexpr uint32_t XK_Arabic_meem = 0x5E5;
static constexpr uint32_t XK_Arabic_noon = 0x5E6;
static constexpr uint32_t XK_Arabic_ha = 0x5E7;
static constexpr uint32_t XK_Arabic_waw = 0x5E8;
static constexpr uint32_t XK_Arabic_alefmaksura = 0x5E9;
static constexpr uint32_t XK_Arabic_yeh = 0x5EA;
static constexpr uint32_t XK_Arabic_fathatan = 0x5EB;
static constexpr uint32_t XK_Arabic_dammatan = 0x5EC;
static constexpr uint32_t XK_Arabic_kasratan = 0x5ED;
static constexpr uint32_t XK_Arabic_fatha = 0x5EE;
static constexpr uint32_t XK_Arabic_damma = 0x5EF;
static constexpr uint32_t XK_Arabic_kasra = 0x5F0;
static constexpr uint32_t XK_Arabic_shadda = 0x5F1;
static constexpr uint32_t XK_Arabic_sukun = 0x5F2;
static constexpr uint32_t XK_Serbian_dje = 0x6A1;
static constexpr uint32_t XK_Macedonia_gje = 0x6A2;
static constexpr uint32_t XK_Cyrillic_io = 0x6A3;
static constexpr uint32_t XK_Ukrainian_ie = 0x6A4;
static constexpr uint32_t XK_Macedonia_dse = 0x6A5;
static constexpr uint32_t XK_Ukrainian_i = 0x6A6;
static constexpr uint32_t XK_Ukrainian_yi = 0x6A7;
static constexpr uint32_t XK_Cyrillic_je = 0x6A8;
static constexpr uint32_t XK_Cyrillic_lje = 0x6A9;
static constexpr uint32_t XK_Cyrillic_nje = 0x6AA;
static constexpr uint32_t XK_Serbian_tshe = 0x6AB;
static constexpr uint32_t XK_Macedonia_kje = 0x6AC;
static constexpr uint32_t XK_Ukrainian_ghe_with_upturn = 0x6AD;
static constexpr uint32_t XK_Byelorussian_shortu = 0x6AE;
static constexpr uint32_t XK_Cyrillic_dzhe = 0x6AF;
static constexpr uint32_t XK_Serbian_dze = 0x6AF;
static constexpr uint32_t XK_numerosign = 0x6B0;
static constexpr uint32_t XK_Serbian_DJE = 0x6B1;
static constexpr uint32_t XK_Macedonia_GJE = 0x6B2;
static constexpr uint32_t XK_Cyrillic_IO = 0x6B3;
static constexpr uint32_t XK_Ukrainian_IE = 0x6B4;
static constexpr uint32_t XK_Macedonia_DSE = 0x6B5;
static constexpr uint32_t XK_Ukrainian_I = 0x6B6;
static constexpr uint32_t XK_Ukrainian_YI = 0x6B7;
static constexpr uint32_t XK_Cyrillic_JE = 0x6B8;
static constexpr uint32_t XK_Cyrillic_LJE = 0x6B9;
static constexpr uint32_t XK_Cyrillic_NJE = 0x6BA;
static constexpr uint32_t XK_Serbian_TSHE = 0x6BB;
static constexpr uint32_t XK_Macedonia_KJE = 0x6BC;
static constexpr uint32_t XK_Ukrainian_GHE_WITH_UPTURN = 0x6BD;
static constexpr uint32_t XK_Byelorussian_SHORTU = 0x6BE;
static constexpr uint32_t XK_Cyrillic_DZHE = 0x6BF;
static constexpr uint32_t XK_Serbian_DZE = 0x6BF;
static constexpr uint32_t XK_Cyrillic_yu = 0x6C0;
static constexpr uint32_t XK_Cyrillic_a = 0x6C1;
static constexpr uint32_t XK_Cyrillic_be = 0x6C2;
static constexpr uint32_t XK_Cyrillic_tse = 0x6C3;
static constexpr uint32_t XK_Cyrillic_de = 0x6C4;
static constexpr uint32_t XK_Cyrillic_ie = 0x6C5;
static constexpr uint32_t XK_Cyrillic_ef = 0x6C6;
static constexpr uint32_t XK_Cyrillic_ghe = 0x6C7;
static constexpr uint32_t XK_Cyrillic_ha = 0x6C8;
static constexpr uint32_t XK_Cyrillic_i = 0x6C9;
static constexpr uint32_t XK_Cyrillic_shorti = 0x6CA;
static constexpr uint32_t XK_Cyrillic_ka = 0x6CB;
static constexpr uint32_t XK_Cyrillic_el = 0x6CC;
static constexpr uint32_t XK_Cyrillic_em = 0x6CD;
static constexpr uint32_t XK_Cyrillic_en = 0x6CE;
static constexpr uint32_t XK_Cyrillic_o = 0x6CF;
static constexpr uint32_t XK_Cyrillic_pe = 0x6D0;
static constexpr uint32_t XK_Cyrillic_ya = 0x6D1;
static constexpr uint32_t XK_Cyrillic_er = 0x6D2;
static constexpr uint32_t XK_Cyrillic_es = 0x6D3;
static constexpr uint32_t XK_Cyrillic_te = 0x6D4;
static constexpr uint32_t XK_Cyrillic_u = 0x6D5;
static constexpr uint32_t XK_Cyrillic_zhe = 0x6D6;
static constexpr uint32_t XK_Cyrillic_ve = 0x6D7;
static constexpr uint32_t XK_Cyrillic_softsign = 0x6D8;
static constexpr uint32_t XK_Cyrillic_yeru = 0x6D9;
static constexpr uint32_t XK_Cyrillic_ze = 0x6DA;
static constexpr uint32_t XK_Cyrillic_sha = 0x6DB;
static constexpr uint32_t XK_Cyrillic_e = 0x6DC;
static constexpr uint32_t XK_Cyrillic_shcha = 0x6DD;
static constexpr uint32_t XK_Cyrillic_che = 0x6DE;
static constexpr uint32_t XK_Cyrillic_hardsign = 0x6DF;
static constexpr uint32_t XK_Cyrillic_YU = 0x6E0;
static constexpr uint32_t XK_Cyrillic_A = 0x6E1;
static constexpr uint32_t XK_Cyrillic_BE = 0x6E2;
static constexpr uint32_t XK_Cyrillic_TSE = 0x6E3;
static constexpr uint32_t XK_Cyrillic_DE = 0x6E4;
static constexpr uint32_t XK_Cyrillic_IE = 0x6E5;
static constexpr uint32_t XK_Cyrillic_EF = 0x6E6;
static constexpr uint32_t XK_Cyrillic_GHE = 0x6E7;
static constexpr uint32_t XK_Cyrillic_HA = 0x6E8;
static constexpr uint32_t XK_Cyrillic_I = 0x6E9;
static constexpr uint32_t XK_Cyrillic_SHORTI = 0x6EA;
static constexpr uint32_t XK_Cyrillic_KA = 0x6EB;
static constexpr uint32_t XK_Cyrillic_EL = 0x6EC;
static constexpr uint32_t XK_Cyrillic_EM = 0x6ED;
static constexpr uint32_t XK_Cyrillic_EN = 0x6EE;
static constexpr uint32_t XK_Cyrillic_O = 0x6EF;
static constexpr uint32_t XK_Cyrillic_PE = 0x6F0;
static constexpr uint32_t XK_Cyrillic_YA = 0x6F1;
static constexpr uint32_t XK_Cyrillic_ER = 0x6F2;
static constexpr uint32_t XK_Cyrillic_ES = 0x6F3;
static constexpr uint32_t XK_Cyrillic_TE = 0x6F4;
static constexpr uint32_t XK_Cyrillic_U = 0x6F5;
static constexpr uint32_t XK_Cyrillic_ZHE = 0x6F6;
static constexpr uint32_t XK_Cyrillic_VE = 0x6F7;
static constexpr uint32_t XK_Cyrillic_SOFTSIGN = 0x6F8;
static constexpr uint32_t XK_Cyrillic_YERU = 0x6F9;
static constexpr uint32_t XK_Cyrillic_ZE = 0x6FA;
static constexpr uint32_t XK_Cyrillic_SHA = 0x6FB;
static constexpr uint32_t XK_Cyrillic_E = 0x6FC;
static constexpr uint32_t XK_Cyrillic_SHCHA = 0x6FD;
static constexpr uint32_t XK_Cyrillic_CHE = 0x6FE;
static constexpr uint32_t XK_Cyrillic_HARDSIGN = 0x6FF;
static constexpr uint32_t XK_Greek_ALPHAaccent = 0x7A1;
static constexpr uint32_t XK_Greek_EPSILONaccent = 0x7A2;
static constexpr uint32_t XK_Greek_ETAaccent = 0x7A3;
static constexpr uint32_t XK_Greek_IOTAaccent = 0x7A4;
static constexpr uint32_t XK_Greek_IOTAdiaeresis = 0x7A5;
static constexpr uint32_t XK_Greek_IOTAdieresis = 0x7A5;
static constexpr uint32_t XK_Greek_OMICRONaccent = 0x7A7;
static constexpr uint32_t XK_Greek_UPSILONaccent = 0x7A8;
static constexpr uint32_t XK_Greek_UPSILONdieresis = 0x7A9;
static constexpr uint32_t XK_Greek_OMEGAaccent = 0x7AB;
static constexpr uint32_t XK_Greek_accentdieresis = 0x7AE;
static constexpr uint32_t XK_Greek_horizbar = 0x7AF;
static constexpr uint32_t XK_Greek_alphaaccent = 0x7B1;
static constexpr uint32_t XK_Greek_epsilonaccent = 0x7B2;
static constexpr uint32_t XK_Greek_etaaccent = 0x7B3;
static constexpr uint32_t XK_Greek_iotaaccent = 0x7B4;
static constexpr uint32_t XK_Greek_iotadieresis = 0x7B5;
static constexpr uint32_t XK_Greek_iotaaccentdieresis = 0x7B6;
static constexpr uint32_t XK_Greek_omicronaccent = 0x7B7;
static constexpr uint32_t XK_Greek_upsilonaccent = 0x7B8;
static constexpr uint32_t XK_Greek_upsilondieresis = 0x7B9;
static constexpr uint32_t XK_Greek_upsilonaccentdieresis = 0x7BA;
static constexpr uint32_t XK_Greek_omegaaccent = 0x7BB;
static constexpr uint32_t XK_Greek_ALPHA = 0x7C1;
static constexpr uint32_t XK_Greek_BETA = 0x7C2;
static constexpr uint32_t XK_Greek_GAMMA = 0x7C3;
static constexpr uint32_t XK_Greek_DELTA = 0x7C4;
static constexpr uint32_t XK_Greek_EPSILON = 0x7C5;
static constexpr uint32_t XK_Greek_ZETA = 0x7C6;
static constexpr uint32_t XK_Greek_ETA = 0x7C7;
static constexpr uint32_t XK_Greek_THETA = 0x7C8;
static constexpr uint32_t XK_Greek_IOTA = 0x7C9;
static constexpr uint32_t XK_Greek_KAPPA = 0x7CA;
static constexpr uint32_t XK_Greek_LAMBDA = 0x7CB;
static constexpr uint32_t XK_Greek_LAMDA = 0x7CB;
static constexpr uint32_t XK_Greek_MU = 0x7CC;
static constexpr uint32_t XK_Greek_NU = 0x7CD;
static constexpr uint32_t XK_Greek_XI = 0x7CE;
static constexpr uint32_t XK_Greek_OMICRON = 0x7CF;
static constexpr uint32_t XK_Greek_PI = 0x7D0;
static constexpr uint32_t XK_Greek_RHO = 0x7D1;
static constexpr uint32_t XK_Greek_SIGMA = 0x7D2;
static constexpr uint32_t XK_Greek_TAU = 0x7D4;
static constexpr uint32_t XK_Greek_UPSILON = 0x7D5;
static constexpr uint32_t XK_Greek_PHI = 0x7D6;
static constexpr uint32_t XK_Greek_CHI = 0x7D7;
static constexpr uint32_t XK_Greek_PSI = 0x7D8;
static constexpr uint32_t XK_Greek_OMEGA = 0x7D9;
static constexpr uint32_t XK_Greek_alpha = 0x7E1;
static constexpr uint32_t XK_Greek_beta = 0x7E2;
static constexpr uint32_t XK_Greek_gamma = 0x7E3;
static constexpr uint32_t XK_Greek_delta = 0x7E4;
static constexpr uint32_t XK_Greek_epsilon = 0x7E5;
static constexpr uint32_t XK_Greek_zeta = 0x7E6;
static constexpr uint32_t XK_Greek_eta = 0x7E7;
static constexpr uint32_t XK_Greek_theta = 0x7E8;
static constexpr uint32_t XK_Greek_iota = 0x7E9;
static constexpr uint32_t XK_Greek_kappa = 0x7EA;
static constexpr uint32_t XK_Greek_lambda = 0x7EB;
static constexpr uint32_t XK_Greek_lamda = 0x7EB;
static constexpr uint32_t XK_Greek_mu = 0x7EC;
static constexpr uint32_t XK_Greek_nu = 0x7ED;
static constexpr uint32_t XK_Greek_xi = 0x7EE;
static constexpr uint32_t XK_Greek_omicron = 0x7EF;
static constexpr uint32_t XK_Greek_pi = 0x7F0;
static constexpr uint32_t XK_Greek_rho = 0x7F1;
static constexpr uint32_t XK_Greek_sigma = 0x7F2;
static constexpr uint32_t XK_Greek_finalsmallsigma = 0x7F3;
static constexpr uint32_t XK_Greek_tau = 0x7F4;
static constexpr uint32_t XK_Greek_upsilon = 0x7F5;
static constexpr uint32_t XK_Greek_phi = 0x7F6;
static constexpr uint32_t XK_Greek_chi = 0x7F7;
static constexpr uint32_t XK_Greek_psi = 0x7F8;
static constexpr uint32_t XK_Greek_omega = 0x7F9;
static constexpr uint32_t XK_leftradical = 0x8A1;
static constexpr uint32_t XK_topleftradical = 0x8A2;
static constexpr uint32_t XK_horizconnector = 0x8A3;
static constexpr uint32_t XK_topintegral = 0x8A4;
static constexpr uint32_t XK_botintegral = 0x8A5;
static constexpr uint32_t XK_vertconnector = 0x8A6;
static constexpr uint32_t XK_topleftsqbracket = 0x8A7;
static constexpr uint32_t XK_botleftsqbracket = 0x8A8;
static constexpr uint32_t XK_toprightsqbracket = 0x8A9;
static constexpr uint32_t XK_botrightsqbracket = 0x8AA;
static constexpr uint32_t XK_topleftparens = 0x8AB;
static constexpr uint32_t XK_botleftparens = 0x8AC;
static constexpr uint32_t XK_toprightparens = 0x8AD;
static constexpr uint32_t XK_botrightparens = 0x8AE;
static constexpr uint32_t XK_leftmiddlecurlybrace = 0x8AF;
static constexpr uint32_t XK_rightmiddlecurlybrace = 0x8B0;
static constexpr uint32_t XK_lessthanequal = 0x8BC;
static constexpr uint32_t XK_notequal = 0x8BD;
static constexpr uint32_t XK_greaterthanequal = 0x8BE;
static constexpr uint32_t XK_integral = 0x8BF;
static constexpr uint32_t XK_therefore = 0x8C0;
static constexpr uint32_t XK_variation = 0x8C1;
static constexpr uint32_t XK_infinity = 0x8C2;
static constexpr uint32_t XK_nabla = 0x8C5;
static constexpr uint32_t XK_approximate = 0x8C8;
static constexpr uint32_t XK_similarequal = 0x8C9;
static constexpr uint32_t XK_ifonlyif = 0x8CD;
static constexpr uint32_t XK_implies = 0x8CE;
static constexpr uint32_t XK_identical = 0x8CF;
static constexpr uint32_t XK_radical = 0x8D6;
static constexpr uint32_t XK_includedin = 0x8DA;
static constexpr uint32_t XK_includes = 0x8DB;
static constexpr uint32_t XK_intersection = 0x8DC;
static constexpr uint32_t XK_union = 0x8DD;
static constexpr uint32_t XK_logicaland = 0x8DE;
static constexpr uint32_t XK_logicalor = 0x8DF;
static constexpr uint32_t XK_partialderivative = 0x8EF;
static constexpr uint32_t XK_function = 0x8F6;
static constexpr uint32_t XK_leftarrow = 0x8FB;
static constexpr uint32_t XK_uparrow = 0x8FC;
static constexpr uint32_t XK_rightarrow = 0x8FD;
static constexpr uint32_t XK_downarrow = 0x8FE;
static constexpr uint32_t XK_soliddiamond = 0x9E0;
static constexpr uint32_t XK_checkerboard = 0x9E1;
static constexpr uint32_t XK_ht = 0x9E2;
static constexpr uint32_t XK_ff = 0x9E3;
static constexpr uint32_t XK_cr = 0x9E4;
static constexpr uint32_t XK_lf = 0x9E5;
static constexpr uint32_t XK_nl = 0x9E8;
static constexpr uint32_t XK_vt = 0x9E9;
static constexpr uint32_t XK_lowrightcorner = 0x9EA;
static constexpr uint32_t XK_uprightcorner = 0x9EB;
static constexpr uint32_t XK_upleftcorner = 0x9EC;
static constexpr uint32_t XK_lowleftcorner = 0x9ED;
static constexpr uint32_t XK_crossinglines = 0x9EE;
static constexpr uint32_t XK_horizlinescan1 = 0x9EF;
static constexpr uint32_t XK_horizlinescan3 = 0x9F0;
static constexpr uint32_t XK_horizlinescan5 = 0x9F1;
static constexpr uint32_t XK_horizlinescan7 = 0x9F2;
static constexpr uint32_t XK_horizlinescan9 = 0x9F3;
static constexpr uint32_t XK_leftt = 0x9F4;
static constexpr uint32_t XK_rightt = 0x9F5;
static constexpr uint32_t XK_bott = 0x9F6;
static constexpr uint32_t XK_topt = 0x9F7;
static constexpr uint32_t XK_vertbar = 0x9F8;
static constexpr uint32_t XK_emspace = 0xAA1;
static constexpr uint32_t XK_enspace = 0xAA2;
static constexpr uint32_t XK_em3space = 0xAA3;
static constexpr uint32_t XK_em4space = 0xAA4;
static constexpr uint32_t XK_digitspace = 0xAA5;
static constexpr uint32_t XK_punctspace = 0xAA6;
static constexpr uint32_t XK_thinspace = 0xAA7;
static constexpr uint32_t XK_hairspace = 0xAA8;
static constexpr uint32_t XK_emdash = 0xAA9;
static constexpr uint32_t XK_endash = 0xAAA;
static constexpr uint32_t XK_signifblank = 0xAAC;
static constexpr uint32_t XK_ellipsis = 0xAAE;
static constexpr uint32_t XK_doubbaselinedot = 0xAAF;
static constexpr uint32_t XK_onethird = 0xAB0;
static constexpr uint32_t XK_twothirds = 0xAB1;
static constexpr uint32_t XK_onefifth = 0xAB2;
static constexpr uint32_t XK_twofifths = 0xAB3;
static constexpr uint32_t XK_threefifths = 0xAB4;
static constexpr uint32_t XK_fourfifths = 0xAB5;
static constexpr uint32_t XK_onesixth = 0xAB6;
static constexpr uint32_t XK_fivesixths = 0xAB7;
static constexpr uint32_t XK_careof = 0xAB8;
static constexpr uint32_t XK_figdash = 0xABB;
static constexpr uint32_t XK_leftanglebracket = 0xABC;
static constexpr uint32_t XK_decimalpoint = 0xABD;
static constexpr uint32_t XK_rightanglebracket = 0xABE;
static constexpr uint32_t XK_oneeighth = 0xAC3;
static constexpr uint32_t XK_threeeighths = 0xAC4;
static constexpr uint32_t XK_fiveeighths = 0xAC5;
static constexpr uint32_t XK_seveneighths = 0xAC6;
static constexpr uint32_t XK_trademark = 0xAC9;
static constexpr uint32_t XK_signaturemark = 0xACA;
static constexpr uint32_t XK_leftopentriangle = 0xACC;
static constexpr uint32_t XK_rightopentriangle = 0xACD;
static constexpr uint32_t XK_emopencircle = 0xACE;
static constexpr uint32_t XK_emopenrectangle = 0xACF;
static constexpr uint32_t XK_leftsinglequotemark = 0xAD0;
static constexpr uint32_t XK_rightsinglequotemark = 0xAD1;
static constexpr uint32_t XK_leftdoublequotemark = 0xAD2;
static constexpr uint32_t XK_rightdoublequotemark = 0xAD3;
static constexpr uint32_t XK_prescription = 0xAD4;
static constexpr uint32_t XK_minutes = 0xAD6;
static constexpr uint32_t XK_seconds = 0xAD7;
static constexpr uint32_t XK_latincross = 0xAD9;
static constexpr uint32_t XK_filledrectbullet = 0xADB;
static constexpr uint32_t XK_filledlefttribullet = 0xADC;
static constexpr uint32_t XK_filledrighttribullet = 0xADD;
static constexpr uint32_t XK_emfilledcircle = 0xADE;
static constexpr uint32_t XK_emfilledrect = 0xADF;
static constexpr uint32_t XK_enopencircbullet = 0xAE0;
static constexpr uint32_t XK_enopensquarebullet = 0xAE1;
static constexpr uint32_t XK_openrectbullet = 0xAE2;
static constexpr uint32_t XK_opentribulletup = 0xAE3;
static constexpr uint32_t XK_opentribulletdown = 0xAE4;
static constexpr uint32_t XK_openstar = 0xAE5;
static constexpr uint32_t XK_enfilledcircbullet = 0xAE6;
static constexpr uint32_t XK_enfilledsqbullet = 0xAE7;
static constexpr uint32_t XK_filledtribulletup = 0xAE8;
static constexpr uint32_t XK_filledtribulletdown = 0xAE9;
static constexpr uint32_t XK_leftpointer = 0xAEA;
static constexpr uint32_t XK_rightpointer = 0xAEB;
static constexpr uint32_t XK_club = 0xAEC;
static constexpr uint32_t XK_diamond = 0xAED;
static constexpr uint32_t XK_heart = 0xAEE;
static constexpr uint32_t XK_maltesecross = 0xAF0;
static constexpr uint32_t XK_dagger = 0xAF1;
static constexpr uint32_t XK_doubledagger = 0xAF2;
static constexpr uint32_t XK_checkmark = 0xAF3;
static constexpr uint32_t XK_ballotcross = 0xAF4;
static constexpr uint32_t XK_musicalsharp = 0xAF5;
static constexpr uint32_t XK_musicalflat = 0xAF6;
static constexpr uint32_t XK_malesymbol = 0xAF7;
static constexpr uint32_t XK_femalesymbol = 0xAF8;
static constexpr uint32_t XK_telephone = 0xAF9;
static constexpr uint32_t XK_telephonerecorder = 0xAFA;
static constexpr uint32_t XK_phonographcopyright = 0xAFB;
static constexpr uint32_t XK_caret = 0xAFC;
static constexpr uint32_t XK_singlelowquotemark = 0xAFD;
static constexpr uint32_t XK_doublelowquotemark = 0xAFE;
static constexpr uint32_t XK_leftcaret = 0xBA3;
static constexpr uint32_t XK_rightcaret = 0xBA6;
static constexpr uint32_t XK_downcaret = 0xBA8;
static constexpr uint32_t XK_upcaret = 0xBA9;
static constexpr uint32_t XK_overbar = 0xBC0;
static constexpr uint32_t XK_downtack = 0xBC2;
static constexpr uint32_t XK_upshoe = 0xBC3;
static constexpr uint32_t XK_downstile = 0xBC4;
static constexpr uint32_t XK_underbar = 0xBC6;
static constexpr uint32_t XK_jot = 0xBCA;
static constexpr uint32_t XK_quad = 0xBCC;
static constexpr uint32_t XK_uptack = 0xBCE;
static constexpr uint32_t XK_circle = 0xBCF;
static constexpr uint32_t XK_upstile = 0xBD3;
static constexpr uint32_t XK_downshoe = 0xBD6;
static constexpr uint32_t XK_rightshoe = 0xBD8;
static constexpr uint32_t XK_leftshoe = 0xBDA;
static constexpr uint32_t XK_lefttack = 0xBDC;
static constexpr uint32_t XK_righttack = 0xBFC;
static constexpr uint32_t XK_hebrew_doublelowline = 0xCDF;
static constexpr uint32_t XK_hebrew_aleph = 0xCE0;
static constexpr uint32_t XK_hebrew_bet = 0xCE1;
static constexpr uint32_t XK_hebrew_gimel = 0xCE2;
static constexpr uint32_t XK_hebrew_dalet = 0xCE3;
static constexpr uint32_t XK_hebrew_he = 0xCE4;
static constexpr uint32_t XK_hebrew_waw = 0xCE5;
static constexpr uint32_t XK_hebrew_zain = 0xCE6;
static constexpr uint32_t XK_hebrew_chet = 0xCE7;
static constexpr uint32_t XK_hebrew_tet = 0xCE8;
static constexpr uint32_t XK_hebrew_yod = 0xCE9;
static constexpr uint32_t XK_hebrew_finalkaph = 0xCEA;
static constexpr uint32_t XK_hebrew_kaph = 0xCEB;
static constexpr uint32_t XK_hebrew_lamed = 0xCEC;
static constexpr uint32_t XK_hebrew_finalmem = 0xCED;
static constexpr uint32_t XK_hebrew_mem = 0xCEE;
static constexpr uint32_t XK_hebrew_finalnun = 0xCEF;
static constexpr uint32_t XK_hebrew_nun = 0xCF0;
static constexpr uint32_t XK_hebrew_samech = 0xCF1;
static constexpr uint32_t XK_hebrew_ayin = 0xCF2;
static constexpr uint32_t XK_hebrew_finalpe = 0xCF3;
static constexpr uint32_t XK_hebrew_pe = 0xCF4;
static constexpr uint32_t XK_hebrew_finalzade = 0xCF5;
static constexpr uint32_t XK_hebrew_zade = 0xCF6;
static constexpr uint32_t XK_hebrew_qoph = 0xCF7;
static constexpr uint32_t XK_hebrew_resh = 0xCF8;
static constexpr uint32_t XK_hebrew_shin = 0xCF9;
static constexpr uint32_t XK_hebrew_taw = 0xCFA;
static constexpr uint32_t XK_Thai_kokai = 0xDA1;
static constexpr uint32_t XK_Thai_khokhai = 0xDA2;
static constexpr uint32_t XK_Thai_khokhuat = 0xDA3;
static constexpr uint32_t XK_Thai_khokhwai = 0xDA4;
static constexpr uint32_t XK_Thai_khokhon = 0xDA5;
static constexpr uint32_t XK_Thai_khorakhang = 0xDA6;
static constexpr uint32_t XK_Thai_ngongu = 0xDA7;
static constexpr uint32_t XK_Thai_chochan = 0xDA8;
static constexpr uint32_t XK_Thai_choching = 0xDA9;
static constexpr uint32_t XK_Thai_chochang = 0xDAA;
static constexpr uint32_t XK_Thai_soso = 0xDAB;
static constexpr uint32_t XK_Thai_chochoe = 0xDAC;
static constexpr uint32_t XK_Thai_yoying = 0xDAD;
static constexpr uint32_t XK_Thai_dochada = 0xDAE;
static constexpr uint32_t XK_Thai_topatak = 0xDAF;
static constexpr uint32_t XK_Thai_thothan = 0xDB0;
static constexpr uint32_t XK_Thai_thonangmontho = 0xDB1;
static constexpr uint32_t XK_Thai_thophuthao = 0xDB2;
static constexpr uint32_t XK_Thai_nonen = 0xDB3;
static constexpr uint32_t XK_Thai_dodek = 0xDB4;
static constexpr uint32_t XK_Thai_totao = 0xDB5;
static constexpr uint32_t XK_Thai_thothung = 0xDB6;
static constexpr uint32_t XK_Thai_thothahan = 0xDB7;
static constexpr uint32_t XK_Thai_thothong = 0xDB8;
static constexpr uint32_t XK_Thai_nonu = 0xDB9;
static constexpr uint32_t XK_Thai_bobaimai = 0xDBA;
static constexpr uint32_t XK_Thai_popla = 0xDBB;
static constexpr uint32_t XK_Thai_phophung = 0xDBC;
static constexpr uint32_t XK_Thai_fofa = 0xDBD;
static constexpr uint32_t XK_Thai_phophan = 0xDBE;
static constexpr uint32_t XK_Thai_fofan = 0xDBF;
static constexpr uint32_t XK_Thai_phosamphao = 0xDC0;
static constexpr uint32_t XK_Thai_moma = 0xDC1;
static constexpr uint32_t XK_Thai_yoyak = 0xDC2;
static constexpr uint32_t XK_Thai_rorua = 0xDC3;
static constexpr uint32_t XK_Thai_ru = 0xDC4;
static constexpr uint32_t XK_Thai_loling = 0xDC5;
static constexpr uint32_t XK_Thai_lu = 0xDC6;
static constexpr uint32_t XK_Thai_wowaen = 0xDC7;
static constexpr uint32_t XK_Thai_sosala = 0xDC8;
static constexpr uint32_t XK_Thai_sorusi = 0xDC9;
static constexpr uint32_t XK_Thai_sosua = 0xDCA;
static constexpr uint32_t XK_Thai_hohip = 0xDCB;
static constexpr uint32_t XK_Thai_lochula = 0xDCC;
static constexpr uint32_t XK_Thai_oang = 0xDCD;
static constexpr uint32_t XK_Thai_honokhuk = 0xDCE;
static constexpr uint32_t XK_Thai_paiyannoi = 0xDCF;
static constexpr uint32_t XK_Thai_saraa = 0xDD0;
static constexpr uint32_t XK_Thai_maihanakat = 0xDD1;
static constexpr uint32_t XK_Thai_saraaa = 0xDD2;
static constexpr uint32_t XK_Thai_saraam = 0xDD3;
static constexpr uint32_t XK_Thai_sarai = 0xDD4;
static constexpr uint32_t XK_Thai_saraii = 0xDD5;
static constexpr uint32_t XK_Thai_saraue = 0xDD6;
static constexpr uint32_t XK_Thai_sarauee = 0xDD7;
static constexpr uint32_t XK_Thai_sarau = 0xDD8;
static constexpr uint32_t XK_Thai_sarauu = 0xDD9;
static constexpr uint32_t XK_Thai_phinthu = 0xDDA;
static constexpr uint32_t XK_Thai_baht = 0xDDF;
static constexpr uint32_t XK_Thai_sarae = 0xDE0;
static constexpr uint32_t XK_Thai_saraae = 0xDE1;
static constexpr uint32_t XK_Thai_sarao = 0xDE2;
static constexpr uint32_t XK_Thai_saraaimaimuan = 0xDE3;
static constexpr uint32_t XK_Thai_saraaimaimalai = 0xDE4;
static constexpr uint32_t XK_Thai_lakkhangyao = 0xDE5;
static constexpr uint32_t XK_Thai_maiyamok = 0xDE6;
static constexpr uint32_t XK_Thai_maitaikhu = 0xDE7;
static constexpr uint32_t XK_Thai_maiek = 0xDE8;
static constexpr uint32_t XK_Thai_maitho = 0xDE9;
static constexpr uint32_t XK_Thai_maitri = 0xDEA;
static constexpr uint32_t XK_Thai_maichattawa = 0xDEB;
static constexpr uint32_t XK_Thai_thanthakhat = 0xDEC;
static constexpr uint32_t XK_Thai_nikhahit = 0xDED;
static constexpr uint32_t XK_Thai_leksun = 0xDF0;
static constexpr uint32_t XK_Thai_leknung = 0xDF1;
static constexpr uint32_t XK_Thai_leksong = 0xDF2;
static constexpr uint32_t XK_Thai_leksam = 0xDF3;
static constexpr uint32_t XK_Thai_leksi = 0xDF4;
static constexpr uint32_t XK_Thai_lekha = 0xDF5;
static constexpr uint32_t XK_Thai_lekhok = 0xDF6;
static constexpr uint32_t XK_Thai_lekchet = 0xDF7;
static constexpr uint32_t XK_Thai_lekpaet = 0xDF8;
static constexpr uint32_t XK_Thai_lekkao = 0xDF9;
static constexpr uint32_t XK_Hangul_Kiyeog = 0xEA1;
static constexpr uint32_t XK_Hangul_SsangKiyeog = 0xEA2;
static constexpr uint32_t XK_Hangul_KiyeogSios = 0xEA3;
static constexpr uint32_t XK_Hangul_Nieun = 0xEA4;
static constexpr uint32_t XK_Hangul_NieunJieuj = 0xEA5;
static constexpr uint32_t XK_Hangul_NieunHieuh = 0xEA6;
static constexpr uint32_t XK_Hangul_Dikeud = 0xEA7;
static constexpr uint32_t XK_Hangul_SsangDikeud = 0xEA8;
static constexpr uint32_t XK_Hangul_Rieul = 0xEA9;
static constexpr uint32_t XK_Hangul_RieulKiyeog = 0xEAA;
static constexpr uint32_t XK_Hangul_RieulMieum = 0xEAB;
static constexpr uint32_t XK_Hangul_RieulPieub = 0xEAC;
static constexpr uint32_t XK_Hangul_RieulSios = 0xEAD;
static constexpr uint32_t XK_Hangul_RieulTieut = 0xEAE;
static constexpr uint32_t XK_Hangul_RieulPhieuf = 0xEAF;
static constexpr uint32_t XK_Hangul_RieulHieuh = 0xEB0;
static constexpr uint32_t XK_Hangul_Mieum = 0xEB1;
static constexpr uint32_t XK_Hangul_Pieub = 0xEB2;
static constexpr uint32_t XK_Hangul_SsangPieub = 0xEB3;
static constexpr uint32_t XK_Hangul_PieubSios = 0xEB4;
static constexpr uint32_t XK_Hangul_Sios = 0xEB5;
static constexpr uint32_t XK_Hangul_SsangSios = 0xEB6;
static constexpr uint32_t XK_Hangul_Ieung = 0xEB7;
static constexpr uint32_t XK_Hangul_Jieuj = 0xEB8;
static constexpr uint32_t XK_Hangul_SsangJieuj = 0xEB9;
static constexpr uint32_t XK_Hangul_Cieuc = 0xEBA;
static constexpr uint32_t XK_Hangul_Khieuq = 0xEBB;
static constexpr uint32_t XK_Hangul_Tieut = 0xEBC;
static constexpr uint32_t XK_Hangul_Phieuf = 0xEBD;
static constexpr uint32_t XK_Hangul_Hieuh = 0xEBE;
static constexpr uint32_t XK_Hangul_A = 0xEBF;
static constexpr uint32_t XK_Hangul_AE = 0xEC0;
static constexpr uint32_t XK_Hangul_YA = 0xEC1;
static constexpr uint32_t XK_Hangul_YAE = 0xEC2;
static constexpr uint32_t XK_Hangul_EO = 0xEC3;
static constexpr uint32_t XK_Hangul_E = 0xEC4;
static constexpr uint32_t XK_Hangul_YEO = 0xEC5;
static constexpr uint32_t XK_Hangul_YE = 0xEC6;
static constexpr uint32_t XK_Hangul_O = 0xEC7;
static constexpr uint32_t XK_Hangul_WA = 0xEC8;
static constexpr uint32_t XK_Hangul_WAE = 0xEC9;
static constexpr uint32_t XK_Hangul_OE = 0xECA;
static constexpr uint32_t XK_Hangul_YO = 0xECB;
static constexpr uint32_t XK_Hangul_U = 0xECC;
static constexpr uint32_t XK_Hangul_WEO = 0xECD;
static constexpr uint32_t XK_Hangul_WE = 0xECE;
static constexpr uint32_t XK_Hangul_WI = 0xECF;
static constexpr uint32_t XK_Hangul_YU = 0xED0;
static constexpr uint32_t XK_Hangul_EU = 0xED1;
static constexpr uint32_t XK_Hangul_YI = 0xED2;
static constexpr uint32_t XK_Hangul_I = 0xED3;
static constexpr uint32_t XK_Hangul_J_Kiyeog = 0xED4;
static constexpr uint32_t XK_Hangul_J_SsangKiyeog = 0xED5;
static constexpr uint32_t XK_Hangul_J_KiyeogSios = 0xED6;
static constexpr uint32_t XK_Hangul_J_Nieun = 0xED7;
static constexpr uint32_t XK_Hangul_J_NieunJieuj = 0xED8;
static constexpr uint32_t XK_Hangul_J_NieunHieuh = 0xED9;
static constexpr uint32_t XK_Hangul_J_Dikeud = 0xEDA;
static constexpr uint32_t XK_Hangul_J_Rieul = 0xEDB;
static constexpr uint32_t XK_Hangul_J_RieulKiyeog = 0xEDC;
static constexpr uint32_t XK_Hangul_J_RieulMieum = 0xEDD;
static constexpr uint32_t XK_Hangul_J_RieulPieub = 0xEDE;
static constexpr uint32_t XK_Hangul_J_RieulSios = 0xEDF;
static constexpr uint32_t XK_Hangul_J_RieulTieut = 0xEE0;
static constexpr uint32_t XK_Hangul_J_RieulPhieuf = 0xEE1;
static constexpr uint32_t XK_Hangul_J_RieulHieuh = 0xEE2;
static constexpr uint32_t XK_Hangul_J_Mieum = 0xEE3;
static constexpr uint32_t XK_Hangul_J_Pieub = 0xEE4;
static constexpr uint32_t XK_Hangul_J_PieubSios = 0xEE5;
static constexpr uint32_t XK_Hangul_J_Sios = 0xEE6;
static constexpr uint32_t XK_Hangul_J_SsangSios = 0xEE7;
static constexpr uint32_t XK_Hangul_J_Ieung = 0xEE8;
static constexpr uint32_t XK_Hangul_J_Jieuj = 0xEE9;
static constexpr uint32_t XK_Hangul_J_Cieuc = 0xEEA;
static constexpr uint32_t XK_Hangul_J_Khieuq = 0xEEB;
static constexpr uint32_t XK_Hangul_J_Tieut = 0xEEC;
static constexpr uint32_t XK_Hangul_J_Phieuf = 0xEED;
static constexpr uint32_t XK_Hangul_J_Hieuh = 0xEEE;
static constexpr uint32_t XK_Hangul_RieulYeorinHieuh = 0xEEF;
static constexpr uint32_t XK_Hangul_SunkyeongeumMieum = 0xEF0;
static constexpr uint32_t XK_Hangul_SunkyeongeumPieub = 0xEF1;
static constexpr uint32_t XK_Hangul_PanSios = 0xEF2;
static constexpr uint32_t XK_Hangul_KkogjiDalrinIeung = 0xEF3;
static constexpr uint32_t XK_Hangul_SunkyeongeumPhieuf = 0xEF4;
static constexpr uint32_t XK_Hangul_YeorinHieuh = 0xEF5;
static constexpr uint32_t XK_Hangul_AraeA = 0xEF6;
static constexpr uint32_t XK_Hangul_AraeAE = 0xEF7;
static constexpr uint32_t XK_Hangul_J_PanSios = 0xEF8;
static constexpr uint32_t XK_Hangul_J_KkogjiDalrinIeung = 0xEF9;
static constexpr uint32_t XK_Hangul_J_YeorinHieuh = 0xEFA;
static constexpr uint32_t XK_Korean_Won = 0xEFF;
static constexpr uint32_t XK_OE = 0x13BC;
static constexpr uint32_t XK_oe = 0x13BD;
static constexpr uint32_t XK_Ydiaeresis = 0x13BE;
static constexpr uint32_t XK_EuroSign = 0x20AC;
static constexpr uint32_t XK_3270_Duplicate = 0xFD01;
static constexpr uint32_t XK_3270_FieldMark = 0xFD02;
static constexpr uint32_t XK_3270_Right2 = 0xFD03;
static constexpr uint32_t XK_3270_Left2 = 0xFD04;
static constexpr uint32_t XK_3270_BackTab = 0xFD05;
static constexpr uint32_t XK_3270_EraseEOF = 0xFD06;
static constexpr uint32_t XK_3270_EraseInput = 0xFD07;
static constexpr uint32_t XK_3270_Reset = 0xFD08;
static constexpr uint32_t XK_3270_Quit = 0xFD09;
static constexpr uint32_t XK_3270_PA1 = 0xFD0A;
static constexpr uint32_t XK_3270_PA2 = 0xFD0B;
static constexpr uint32_t XK_3270_PA3 = 0xFD0C;
static constexpr uint32_t XK_3270_Test = 0xFD0D;
static constexpr uint32_t XK_3270_Attn = 0xFD0E;
static constexpr uint32_t XK_3270_CursorBlink = 0xFD0F;
static constexpr uint32_t XK_3270_AltCursor = 0xFD10;
static constexpr uint32_t XK_3270_KeyClick = 0xFD11;
static constexpr uint32_t XK_3270_Jump = 0xFD12;
static constexpr uint32_t XK_3270_Ident = 0xFD13;
static constexpr uint32_t XK_3270_Rule = 0xFD14;
static constexpr uint32_t XK_3270_Copy = 0xFD15;
static constexpr uint32_t XK_3270_Play = 0xFD16;
static constexpr uint32_t XK_3270_Setup = 0xFD17;
static constexpr uint32_t XK_3270_Record = 0xFD18;
static constexpr uint32_t XK_3270_ChangeScreen = 0xFD19;
static constexpr uint32_t XK_3270_DeleteWord = 0xFD1A;
static constexpr uint32_t XK_3270_ExSelect = 0xFD1B;
static constexpr uint32_t XK_3270_CursorSelect = 0xFD1C;
static constexpr uint32_t XK_3270_PrintScreen = 0xFD1D;
static constexpr uint32_t XK_3270_Enter = 0xFD1E;
static constexpr uint32_t XK_ISO_Lock = 0xFE01;
static constexpr uint32_t XK_ISO_Level3_Shift = 0xFE03;
static constexpr uint32_t XK_ISO_Level3_Latch = 0xFE04;
static constexpr uint32_t XK_ISO_Next_Group = 0xFE08;
static constexpr uint32_t XK_ISO_Next_Group_Lock = 0xFE09;
static constexpr uint32_t XK_ISO_Prev_Group = 0xFE0A;
static constexpr uint32_t XK_ISO_Prev_Group_Lock = 0xFE0B;
static constexpr uint32_t XK_ISO_First_Group = 0xFE0C;
static constexpr uint32_t XK_ISO_First_Group_Lock = 0xFE0D;
static constexpr uint32_t XK_ISO_Last_Group = 0xFE0E;
static constexpr uint32_t XK_ISO_Last_Group_Lock = 0xFE0F;
static constexpr uint32_t XK_ISO_Level5_Shift = 0xFE11;
static constexpr uint32_t XK_ISO_Level5_Lock = 0xFE13;
static constexpr uint32_t XK_ISO_Left_Tab = 0xFE20;
static constexpr uint32_t XK_ISO_Enter = 0xFE34;
static constexpr uint32_t XK_dead_grave = 0xFE50;
static constexpr uint32_t XK_dead_acute = 0xFE51;
static constexpr uint32_t XK_dead_circumflex = 0xFE52;
static constexpr uint32_t XK_dead_tilde = 0xFE53;
static constexpr uint32_t XK_dead_macron = 0xFE54;
static constexpr uint32_t XK_dead_breve = 0xFE55;
static constexpr uint32_t XK_dead_abovedot = 0xFE56;
static constexpr uint32_t XK_dead_diaeresis = 0xFE57;
static constexpr uint32_t XK_dead_abovering = 0xFE58;
static constexpr uint32_t XK_dead_doubleacute = 0xFE59;
static constexpr uint32_t XK_dead_caron = 0xFE5A;
static constexpr uint32_t XK_dead_cedilla = 0xFE5B;
static constexpr uint32_t XK_dead_ogonek = 0xFE5C;
static constexpr uint32_t XK_dead_iota = 0xFE5D;
static constexpr uint32_t XK_dead_voiced_sound = 0xFE5E;
static constexpr uint32_t XK_dead_semivoiced_sound = 0xFE5F;
static constexpr uint32_t XK_dead_belowdot = 0xFE60;
static constexpr uint32_t XK_dead_hook = 0xFE61;
static constexpr uint32_t XK_dead_horn = 0xFE62;
static constexpr uint32_t XK_dead_stroke = 0xFE63;
static constexpr uint32_t XK_dead_abovecomma = 0xFE64;
static constexpr uint32_t XK_dead_abovereversedcomma = 0xFE65;
static constexpr uint32_t XK_dead_doublegrave = 0xFE66;
static constexpr uint32_t XK_dead_belowring = 0xFE67;
static constexpr uint32_t XK_dead_belowmacron = 0xFE68;
static constexpr uint32_t XK_dead_belowcircumflex = 0xFE69;
static constexpr uint32_t XK_dead_belowtilde = 0xFE6A;
static constexpr uint32_t XK_dead_belowbreve = 0xFE6B;
static constexpr uint32_t XK_dead_belowdiaeresis = 0xFE6C;
static constexpr uint32_t XK_dead_invertedbreve = 0xFE6D;
static constexpr uint32_t XK_dead_belowcomma = 0xFE6E;
static constexpr uint32_t XK_dead_currency = 0xFE6F;
static constexpr uint32_t XK_dead_greek = 0xFE8C;
static constexpr uint32_t XK_Next_Virtual_Screen = 0xFED2;
static constexpr uint32_t XK_BackSpace = 0xFF08;
static constexpr uint32_t XK_Tab = 0xFF09;
static constexpr uint32_t XK_Linefeed = 0xFF0A;
static constexpr uint32_t XK_Clear = 0xFF0B;
static constexpr uint32_t XK_Return = 0xFF0D;
static constexpr uint32_t XK_Pause = 0xFF13;
static constexpr uint32_t XK_Scroll_Lock = 0xFF14;
static constexpr uint32_t XK_Sys_Req = 0xFF15;
static constexpr uint32_t XK_Escape = 0xFF1B;
static constexpr uint32_t XK_Multi_key = 0xFF20;
static constexpr uint32_t XK_Kanji = 0xFF21;
static constexpr uint32_t XK_Muhenkan = 0xFF22;
static constexpr uint32_t XK_Henkan = 0xFF23;
static constexpr uint32_t XK_Henkan_Mode = 0xFF23;
static constexpr uint32_t XK_Romaji = 0xFF24;
static constexpr uint32_t XK_Hiragana = 0xFF25;
static constexpr uint32_t XK_Katakana = 0xFF26;
static constexpr uint32_t XK_Hiragana_Katakana = 0xFF27;
static constexpr uint32_t XK_Zenkaku = 0xFF28;
static constexpr uint32_t XK_Hankaku = 0xFF29;
static constexpr uint32_t XK_Zenkaku_Hankaku = 0xFF2A;
static constexpr uint32_t XK_Kana_Lock = 0xFF2D;
static constexpr uint32_t XK_Kana_Shift = 0xFF2E;
static constexpr uint32_t XK_Eisu_Shift = 0xFF2F;
static constexpr uint32_t XK_Eisu_toggle = 0xFF30;
static constexpr uint32_t XK_Hangul = 0xFF31;
static constexpr uint32_t XK_Hangul_Start = 0xFF32;
static constexpr uint32_t XK_Hangul_End = 0xFF33;
static constexpr uint32_t XK_Hangul_Hanja = 0xFF34;
static constexpr uint32_t XK_Hangul_Jamo = 0xFF35;
static constexpr uint32_t XK_Hangul_Romaja = 0xFF36;
static constexpr uint32_t XK_Codeinput = 0xFF37;
static constexpr uint32_t XK_Hangul_Jeonja = 0xFF38;
static constexpr uint32_t XK_Hangul_Banja = 0xFF39;
static constexpr uint32_t XK_Hangul_PreHanja = 0xFF3A;
static constexpr uint32_t XK_Hangul_PostHanja = 0xFF3B;
static constexpr uint32_t XK_SingleCandidate = 0xFF3C;
static constexpr uint32_t XK_MultipleCandidate = 0xFF3D;
static constexpr uint32_t XK_PreviousCandidate = 0xFF3E;
static constexpr uint32_t XK_Hangul_Special = 0xFF3F;
static constexpr uint32_t XK_Home = 0xFF50;
static constexpr uint32_t XK_Left = 0xFF51;
static constexpr uint32_t XK_Up = 0xFF52;
static constexpr uint32_t XK_Right = 0xFF53;
static constexpr uint32_t XK_Down = 0xFF54;
static constexpr uint32_t XK_Page_Up = 0xFF55;
static constexpr uint32_t XK_Prior = 0xFF55;
static constexpr uint32_t XK_Next = 0xFF56;
static constexpr uint32_t XK_Page_Down = 0xFF56;
static constexpr uint32_t XK_End = 0xFF57;
static constexpr uint32_t XK_Select = 0xFF60;
static constexpr uint32_t XK_Print = 0xFF61;
static constexpr uint32_t XK_Execute = 0xFF62;
static constexpr uint32_t XK_Insert = 0xFF63;
static constexpr uint32_t XK_Undo = 0xFF65;
static constexpr uint32_t XK_Redo = 0xFF66;
static constexpr uint32_t XK_Menu = 0xFF67;
static constexpr uint32_t XK_Find = 0xFF68;
static constexpr uint32_t XK_Cancel = 0xFF69;
static constexpr uint32_t XK_Help = 0xFF6A;
static constexpr uint32_t XK_Break = 0xFF6B;
static constexpr uint32_t XK_Mode_switch = 0xFF7E;
static constexpr uint32_t XK_Num_Lock = 0xFF7F;
static constexpr uint32_t XK_KP_Space = 0xFF80;
static constexpr uint32_t XK_KP_Tab = 0xFF89;
static constexpr uint32_t XK_KP_Enter = 0xFF8D;
static constexpr uint32_t XK_KP_F1 = 0xFF91;
static constexpr uint32_t XK_KP_F2 = 0xFF92;
static constexpr uint32_t XK_KP_F3 = 0xFF93;
static constexpr uint32_t XK_KP_F4 = 0xFF94;
static constexpr uint32_t XK_KP_Home = 0xFF95;
static constexpr uint32_t XK_KP_Left = 0xFF96;
static constexpr uint32_t XK_KP_Up = 0xFF97;
static constexpr uint32_t XK_KP_Right = 0xFF98;
static constexpr uint32_t XK_KP_Down = 0xFF99;
static constexpr uint32_t XK_KP_Page_Up = 0xFF9A;
static constexpr uint32_t XK_KP_Prior = 0xFF9A;
static constexpr uint32_t XK_KP_Next = 0xFF9B;
static constexpr uint32_t XK_KP_Page_Down = 0xFF9B;
static constexpr uint32_t XK_KP_End = 0xFF9C;
static constexpr uint32_t XK_KP_Begin = 0xFF9D;
static constexpr uint32_t XK_KP_Insert = 0xFF9E;
static constexpr uint32_t XK_KP_Delete = 0xFF9F;
static constexpr uint32_t XK_KP_Multiply = 0xFFAA;
static constexpr uint32_t XK_KP_Add = 0xFFAB;
static constexpr uint32_t XK_KP_Separator = 0xFFAC;
static constexpr uint32_t XK_KP_Subtract = 0xFFAD;
static constexpr uint32_t XK_KP_Decimal = 0xFFAE;
static constexpr uint32_t XK_KP_Divide = 0xFFAF;
static constexpr uint32_t XK_KP_0 = 0xFFB0;
static constexpr uint32_t XK_KP_1 = 0xFFB1;
static constexpr uint32_t XK_KP_2 = 0xFFB2;
static constexpr uint32_t XK_KP_3 = 0xFFB3;
static constexpr uint32_t XK_KP_4 = 0xFFB4;
static constexpr uint32_t XK_KP_5 = 0xFFB5;
static constexpr uint32_t XK_KP_6 = 0xFFB6;
static constexpr uint32_t XK_KP_7 = 0xFFB7;
static constexpr uint32_t XK_KP_8 = 0xFFB8;
static constexpr uint32_t XK_KP_9 = 0xFFB9;
static constexpr uint32_t XK_KP_Equal = 0xFFBD;
static constexpr uint32_t XK_F1 = 0xFFBE;
static constexpr uint32_t XK_F2 = 0xFFBF;
static constexpr uint32_t XK_F3 = 0xFFC0;
static constexpr uint32_t XK_F4 = 0xFFC1;
static constexpr uint32_t XK_F5 = 0xFFC2;
static constexpr uint32_t XK_F6 = 0xFFC3;
static constexpr uint32_t XK_F7 = 0xFFC4;
static constexpr uint32_t XK_F8 = 0xFFC5;
static constexpr uint32_t XK_F9 = 0xFFC6;
static constexpr uint32_t XK_F10 = 0xFFC7;
static constexpr uint32_t XK_F11 = 0xFFC8;
static constexpr uint32_t XK_F12 = 0xFFC9;
static constexpr uint32_t XK_F13 = 0xFFCA;
static constexpr uint32_t XK_F14 = 0xFFCB;
static constexpr uint32_t XK_F15 = 0xFFCC;
static constexpr uint32_t XK_F16 = 0xFFCD;
static constexpr uint32_t XK_F17 = 0xFFCE;
static constexpr uint32_t XK_F18 = 0xFFCF;
static constexpr uint32_t XK_F19 = 0xFFD0;
static constexpr uint32_t XK_F20 = 0xFFD1;
static constexpr uint32_t XK_F21 = 0xFFD2;
static constexpr uint32_t XK_F22 = 0xFFD3;
static constexpr uint32_t XK_F23 = 0xFFD4;
static constexpr uint32_t XK_F24 = 0xFFD5;
static constexpr uint32_t XK_F25 = 0xFFD6;
static constexpr uint32_t XK_F26 = 0xFFD7;
static constexpr uint32_t XK_F27 = 0xFFD8;
static constexpr uint32_t XK_F28 = 0xFFD9;
static constexpr uint32_t XK_F29 = 0xFFDA;
static constexpr uint32_t XK_F30 = 0xFFDB;
static constexpr uint32_t XK_F31 = 0xFFDC;
static constexpr uint32_t XK_F32 = 0xFFDD;
static constexpr uint32_t XK_F33 = 0xFFDE;
static constexpr uint32_t XK_F34 = 0xFFDF;
static constexpr uint32_t XK_F35 = 0xFFE0;
static constexpr uint32_t XK_Shift_L = 0xFFE1;
static constexpr uint32_t XK_Shift_R = 0xFFE2;
static constexpr uint32_t XK_Control_L = 0xFFE3;
static constexpr uint32_t XK_Control_R = 0xFFE4;
static constexpr uint32_t XK_Caps_Lock = 0xFFE5;
static constexpr uint32_t XK_Shift_Lock = 0xFFE6;
static constexpr uint32_t XK_Meta_L = 0xFFE7;
static constexpr uint32_t XK_Meta_R = 0xFFE8;
static constexpr uint32_t XK_Alt_L = 0xFFE9;
static constexpr uint32_t XK_Alt_R = 0xFFEA;
static constexpr uint32_t XK_Super_L = 0xFFEB;
static constexpr uint32_t XK_Super_R = 0xFFEC;
static constexpr uint32_t XK_Hyper_L = 0xFFED;
static constexpr uint32_t XK_Hyper_R = 0xFFEE;
static constexpr uint32_t XK_Delete = 0xFFFF;
static constexpr uint32_t XK_VoidSymbol = 0xFFFFFF;
static constexpr uint32_t SunXK_Props = 0x1005FF70;
static constexpr uint32_t SunXK_Copy = 0x1005FF72;
static constexpr uint32_t SunXK_Open = 0x1005FF73;
static constexpr uint32_t SunXK_Paste = 0x1005FF74;
static constexpr uint32_t SunXK_Cut = 0x1005FF75;
static constexpr uint32_t XF86XK_ClearGrab = 0x1008FE21;
static constexpr uint32_t XF86XK_Next_VMode = 0x1008FE22;
static constexpr uint32_t XF86XK_MonBrightnessUp = 0x1008FF02;
static constexpr uint32_t XF86XK_MonBrightnessDown = 0x1008FF03;
static constexpr uint32_t XF86XK_KbdBrightnessUp = 0x1008FF05;
static constexpr uint32_t XF86XK_KbdBrightnessDown = 0x1008FF06;
static constexpr uint32_t XF86XK_Standby = 0x1008FF10;
static constexpr uint32_t XF86XK_AudioLowerVolume = 0x1008FF11;
static constexpr uint32_t XF86XK_AudioMute = 0x1008FF12;
static constexpr uint32_t XF86XK_AudioRaiseVolume = 0x1008FF13;
static constexpr uint32_t XF86XK_AudioPlay = 0x1008FF14;
static constexpr uint32_t XF86XK_AudioStop = 0x1008FF15;
static constexpr uint32_t XF86XK_AudioPrev = 0x1008FF16;
static constexpr uint32_t XF86XK_AudioNext = 0x1008FF17;
static constexpr uint32_t XF86XK_HomePage = 0x1008FF18;
static constexpr uint32_t XF86XK_Mail = 0x1008FF19;
static constexpr uint32_t XF86XK_Search = 0x1008FF1B;
static constexpr uint32_t XF86XK_AudioRecord = 0x1008FF1C;
static constexpr uint32_t XF86XK_Calculator = 0x1008FF1D;
static constexpr uint32_t XF86XK_Calendar = 0x1008FF20;
static constexpr uint32_t XF86XK_Back = 0x1008FF26;
static constexpr uint32_t XF86XK_Forward = 0x1008FF27;
static constexpr uint32_t XF86XK_Stop = 0x1008FF28;
static constexpr uint32_t XF86XK_Refresh = 0x1008FF29;
static constexpr uint32_t XF86XK_PowerOff = 0x1008FF2A;
static constexpr uint32_t XF86XK_WakeUp = 0x1008FF2B;
static constexpr uint32_t XF86XK_Eject = 0x1008FF2C;
static constexpr uint32_t XF86XK_ScreenSaver = 0x1008FF2D;
static constexpr uint32_t XF86XK_WWW = 0x1008FF2E;
static constexpr uint32_t XF86XK_Sleep = 0x1008FF2F;
static constexpr uint32_t XF86XK_Favorites = 0x1008FF30;
static constexpr uint32_t XF86XK_AudioPause = 0x1008FF31;
static constexpr uint32_t XF86XK_AudioMedia = 0x1008FF32;
static constexpr uint32_t XF86XK_MyComputer = 0x1008FF33;
static constexpr uint32_t XF86XK_OpenURL = 0x1008FF38;
static constexpr uint32_t XF86XK_AudioRewind = 0x1008FF3E;
static constexpr uint32_t XF86XK_BackForward = 0x1008FF3F;
static constexpr uint32_t XF86XK_Launch5 = 0x1008FF45;
static constexpr uint32_t XF86XK_Launch6 = 0x1008FF46;
static constexpr uint32_t XF86XK_Launch7 = 0x1008FF47;
static constexpr uint32_t XF86XK_Launch8 = 0x1008FF48;
static constexpr uint32_t XF86XK_Launch9 = 0x1008FF49;
static constexpr uint32_t XF86XK_LaunchA = 0x1008FF4A;
static constexpr uint32_t XF86XK_LaunchB = 0x1008FF4B;
static constexpr uint32_t XF86XK_CD = 0x1008FF53;
static constexpr uint32_t XF86XK_Clear = 0x1008FF55;
static constexpr uint32_t XF86XK_Close = 0x1008FF56;
static constexpr uint32_t XF86XK_Copy = 0x1008FF57;
static constexpr uint32_t XF86XK_Cut = 0x1008FF58;
static constexpr uint32_t XF86XK_Display = 0x1008FF59;
static constexpr uint32_t XF86XK_Excel = 0x1008FF5C;
static constexpr uint32_t XF86XK_Explorer = 0x1008FF5D;
static constexpr uint32_t XF86XK_LogOff = 0x1008FF61;
static constexpr uint32_t XF86XK_MenuKB = 0x1008FF65;
static constexpr uint32_t XF86XK_MenuPB = 0x1008FF66;
static constexpr uint32_t XF86XK_New = 0x1008FF68;
static constexpr uint32_t XF86XK_News = 0x1008FF69;
static constexpr uint32_t XF86XK_OfficeHome = 0x1008FF6A;
static constexpr uint32_t XF86XK_Open = 0x1008FF6B;
static constexpr uint32_t XF86XK_Paste = 0x1008FF6D;
static constexpr uint32_t XF86XK_Reply = 0x1008FF72;
static constexpr uint32_t XF86XK_Reload = 0x1008FF73;
static constexpr uint32_t XF86XK_Save = 0x1008FF77;
static constexpr uint32_t XF86XK_ScrollUp = 0x1008FF78;
static constexpr uint32_t XF86XK_ScrollDown = 0x1008FF79;
static constexpr uint32_t XF86XK_Send = 0x1008FF7B;
static constexpr uint32_t XF86XK_Spell = 0x1008FF7C;
static constexpr uint32_t XF86XK_SplitScreen = 0x1008FF7D;
static constexpr uint32_t XF86XK_Tools = 0x1008FF81;
static constexpr uint32_t XF86XK_Video = 0x1008FF87;
static constexpr uint32_t XF86XK_Word = 0x1008FF89;
static constexpr uint32_t XF86XK_ZoomIn = 0x1008FF8B;
static constexpr uint32_t XF86XK_ZoomOut = 0x1008FF8C;
static constexpr uint32_t XF86XK_WebCam = 0x1008FF8F;
static constexpr uint32_t XF86XK_MailForward = 0x1008FF90;
static constexpr uint32_t XF86XK_Music = 0x1008FF92;
static constexpr uint32_t XF86XK_WLAN = 0x1008FF95;
static constexpr uint32_t XF86XK_AudioForward = 0x1008FF97;
static constexpr uint32_t XF86XK_AudioRandomPlay = 0x1008FF99;
static constexpr uint32_t XF86XK_Subtitle = 0x1008FF9A;
static constexpr uint32_t XF86XK_Select = 0x1008FFA0;
static constexpr uint32_t XF86XK_Suspend = 0x1008FFA7;
static constexpr uint32_t XF86XK_Hibernate = 0x1008FFA8;

#endif  // UI_GFX_X_KEYSYMS_KEYSYMS_H_
