      SUBROUTINE TEST_SWAP(STATUS)
*+
*  Name:
*     TEST_SWAP

*  Purpose:
*     Test CHR_SWAP.

*  Language:
*     Starlink Fortran 77

*  Invocation:
*     CALL TEST_SWAP(STATUS)

*  Description:
*     Test CHR_SWAP.
*     If any failure occurs, return STATUS = SAI__ERROR.
*     Otherwise, STATUS is unchanged.

*  Arguments:
*     STATUS = INTEGER (Returned)
*        The status of the tests. 

*  Authors:
*     RLVAD::AJC: A J Chipperfield (STARLINK)
*     RLVAD::ACC: A C Charles (STARLINK)
*     {enter_new_authors_here}

*  History:
*     17-AUG-1989 (RLVAD::AJC):
*        Original version.
*     14-SEP-1993 (ACC)
*        Modularised version: broken into one routine for each of 5 main 
*        categories of tests.
*     02-MAR-1994 (ACC)
*        Second modularised version: broken further into one routine for 
*        each of subroutine tested.  This subroutine created.
*     {enter_further_changes_here}

*  Bugs:
*     {note_any_bugs_here}

*  Subprograms called:   
*     CHR_SWAP

*-

*  Type Definitions:
      IMPLICIT NONE              ! No implicit typing

*  Arguments Given:
*     None

*  Arguments Returned:
      INTEGER STATUS

*  Global Constants:
      INCLUDE 'SAE_PAR'          ! Standard SAE constants
      INCLUDE 'CHR_ERR'

*  Local Variables:
      CHARACTER*1 C1             ! CHARACTER values
      CHARACTER*1 C2

*.

*    Test CHR_SWAP

      C1 = 'A'
      C2 = 'B'
      CALL CHR_SWAP (C1, C2)
      IF ((C1 .EQ. 'B') .AND. (C2 .EQ. 'A')) THEN
         PRINT *, 'CHR_SWAP OK'
      ELSE
         PRINT *, 'CHR_SWAP FAILS'
         STATUS = SAI__ERROR
      ENDIF

      END
