# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -march=aarch64 -mcpu=exynos-m3 < %s | FileCheck %s

# Check that llvm-mca doesn't crash when analyzing this block of code.

# This test is related to PR38575.
# The crash was indirectly cause by an incorrectly truncation of a processor
# resource mask value (an uint64_t) to int value.
# The problem can only be observed on targets that declare more than 32
# resources (like exynos-m3).

ror x1, x2, x3

# CHECK:      Iterations:        100
# CHECK-NEXT: Instructions:      100
# CHECK-NEXT: Total Cycles:      28
# CHECK-NEXT: Total uOps:        100

# CHECK:      Dispatch Width:    6
# CHECK-NEXT: uOps Per Cycle:    3.57
# CHECK-NEXT: IPC:               3.57
# CHECK-NEXT: Block RThroughput: 0.3

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      1     0.25                        ror	x1, x2, x3

# CHECK:      Resources:
# CHECK-NEXT: [0]   - M3PipeF0
# CHECK-NEXT: [1]   - M3PipeF1
# CHECK-NEXT: [2]   - M3PipeF2
# CHECK-NEXT: [3.0] - M3UnitA
# CHECK-NEXT: [3.1] - M3UnitA
# CHECK-NEXT: [4.0] - M3UnitB
# CHECK-NEXT: [4.1] - M3UnitB
# CHECK-NEXT: [5.0] - M3UnitC
# CHECK-NEXT: [5.1] - M3UnitC
# CHECK-NEXT: [6]   - M3UnitD
# CHECK-NEXT: [7]   - M3UnitFADD0
# CHECK-NEXT: [8]   - M3UnitFADD1
# CHECK-NEXT: [9]   - M3UnitFADD2
# CHECK-NEXT: [10]  - M3UnitFCVT0
# CHECK-NEXT: [11]  - M3UnitFCVT1
# CHECK-NEXT: [12.0] - M3UnitFDIV0
# CHECK-NEXT: [12.1] - M3UnitFDIV0
# CHECK-NEXT: [13.0] - M3UnitFDIV1
# CHECK-NEXT: [13.1] - M3UnitFDIV1
# CHECK-NEXT: [14]  - M3UnitFMAC0
# CHECK-NEXT: [15]  - M3UnitFMAC1
# CHECK-NEXT: [16]  - M3UnitFMAC2
# CHECK-NEXT: [17.0] - M3UnitFSQR
# CHECK-NEXT: [17.1] - M3UnitFSQR
# CHECK-NEXT: [18]  - M3UnitFST0
# CHECK-NEXT: [19]  - M3UnitFST1
# CHECK-NEXT: [20.0] - M3UnitL
# CHECK-NEXT: [20.1] - M3UnitL
# CHECK-NEXT: [21]  - M3UnitNALU0
# CHECK-NEXT: [22]  - M3UnitNALU1
# CHECK-NEXT: [23]  - M3UnitNALU2
# CHECK-NEXT: [24]  - M3UnitNCRY0
# CHECK-NEXT: [25]  - M3UnitNCRY1
# CHECK-NEXT: [26]  - M3UnitNMSC
# CHECK-NEXT: [27]  - M3UnitNMUL
# CHECK-NEXT: [28]  - M3UnitNSHF0
# CHECK-NEXT: [29]  - M3UnitNSHF1
# CHECK-NEXT: [30]  - M3UnitNSHF2
# CHECK-NEXT: [31]  - M3UnitNSHT0
# CHECK-NEXT: [32]  - M3UnitNSHT1
# CHECK-NEXT: [33]  - M3UnitNSHT2
# CHECK-NEXT: [34]  - M3UnitS

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3.0]  [3.1]  [4.0]  [4.1]  [5.0]  [5.1]  [6]    [7]    [8]    [9]    [10]   [11]   [12.0] [12.1] [13.0] [13.1] [14]   [15]   [16]   [17.0] [17.1] [18]   [19]   [20.0] [20.1] [21]   [22]   [23]   [24]   [25]   [26]   [27]   [28]   [29]   [30]   [31]   [32]   [33]   [34]
# CHECK-NEXT:  -      -      -     0.25   0.25    -      -     0.25   0.25    -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3.0]  [3.1]  [4.0]  [4.1]  [5.0]  [5.1]  [6]    [7]    [8]    [9]    [10]   [11]   [12.0] [12.1] [13.0] [13.1] [14]   [15]   [16]   [17.0] [17.1] [18]   [19]   [20.0] [20.1] [21]   [22]   [23]   [24]   [25]   [26]   [27]   [28]   [29]   [30]   [31]   [32]   [33]   [34]   Instructions:
# CHECK-NEXT:  -      -      -     0.25   0.25    -      -     0.25   0.25    -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     ror	x1, x2, x3
