/*
 * Copyright (c) 2003, 2007-14 Matteo Frigo
 * Copyright (c) 2003, 2007-14 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Tue Sep 14 10:46:17 EDT 2021 */

#include "rdft/codelet-rdft.h"

#if defined(ARCH_PREFERS_FMA) || defined(ISA_EXTENSION_PREFERS_FMA)

/* Generated by: ../../../genfft/gen_hc2hc.native -fma -compact -variables 4 -pipeline-latency 4 -n 25 -dit -name hf_25 -include rdft/scalar/hf.h */

/*
 * This function contains 400 FP additions, 364 FP multiplications,
 * (or, 84 additions, 48 multiplications, 316 fused multiply/add),
 * 138 stack variables, 47 constants, and 100 memory accesses
 */
#include "rdft/scalar/hf.h"

static void hf_25(R *cr, R *ci, const R *W, stride rs, INT mb, INT me, INT ms)
{
     DK(KP614372930, +0.614372930789563808870829930444362096004872855);
     DK(KP621716863, +0.621716863012209892444754556304102309693593202);
     DK(KP860541664, +0.860541664367944677098261680920518816412804187);
     DK(KP949179823, +0.949179823508441261575555465843363271711583843);
     DK(KP557913902, +0.557913902031834264187699648465567037992437152);
     DK(KP249506682, +0.249506682107067890488084201715862638334226305);
     DK(KP681693190, +0.681693190061530575150324149145440022633095390);
     DK(KP560319534, +0.560319534973832390111614715371676131169633784);
     DK(KP998026728, +0.998026728428271561952336806863450553336905220);
     DK(KP906616052, +0.906616052148196230441134447086066874408359177);
     DK(KP845997307, +0.845997307939530944175097360758058292389769300);
     DK(KP968479752, +0.968479752739016373193524836781420152702090879);
     DK(KP994076283, +0.994076283785401014123185814696322018529298887);
     DK(KP772036680, +0.772036680810363904029489473607579825330539880);
     DK(KP734762448, +0.734762448793050413546343770063151342619912334);
     DK(KP062914667, +0.062914667253649757225485955897349402364686947);
     DK(KP921177326, +0.921177326965143320250447435415066029359282231);
     DK(KP833417178, +0.833417178328688677408962550243238843138996060);
     DK(KP541454447, +0.541454447536312777046285590082819509052033189);
     DK(KP242145790, +0.242145790282157779872542093866183953459003101);
     DK(KP559154169, +0.559154169276087864842202529084232643714075927);
     DK(KP683113946, +0.683113946453479238701949862233725244439656928);
     DK(KP943557151, +0.943557151597354104399655195398983005179443399);
     DK(KP803003575, +0.803003575438660414833440593570376004635464850);
     DK(KP554608978, +0.554608978404018097464974850792216217022558774);
     DK(KP248028675, +0.248028675328619457762448260696444630363259177);
     DK(KP525970792, +0.525970792408939708442463226536226366643874659);
     DK(KP726211448, +0.726211448929902658173535992263577167607493062);
     DK(KP968583161, +0.968583161128631119490168375464735813836012403);
     DK(KP992114701, +0.992114701314477831049793042785778521453036709);
     DK(KP904730450, +0.904730450839922351881287709692877908104763647);
     DK(KP831864738, +0.831864738706457140726048799369896829771167132);
     DK(KP871714437, +0.871714437527667770979999223229522602943903653);
     DK(KP549754652, +0.549754652192770074288023275540779861653779767);
     DK(KP939062505, +0.939062505817492352556001843133229685779824606);
     DK(KP256756360, +0.256756360367726783319498520922669048172391148);
     DK(KP851038619, +0.851038619207379630836264138867114231259902550);
     DK(KP912018591, +0.912018591466481957908415381764119056233607330);
     DK(KP912575812, +0.912575812670962425556968549836277086778922727);
     DK(KP634619297, +0.634619297544148100711287640319130485732531031);
     DK(KP470564281, +0.470564281212251493087595091036643380879947982);
     DK(KP827271945, +0.827271945972475634034355757144307982555673741);
     DK(KP126329378, +0.126329378446108174786050455341811215027378105);
     DK(KP951056516, +0.951056516295153572116439333379382143405698634);
     DK(KP559016994, +0.559016994374947424102293417182819058860154590);
     DK(KP250000000, +0.250000000000000000000000000000000000000000000);
     DK(KP618033988, +0.618033988749894848204586834365638117720309180);
     {
	  INT m;
	  for (m = mb, W = W + ((mb - 1) * 48); m < me; m = m + 1, cr = cr + ms, ci = ci - ms, W = W + 48, MAKE_VOLATILE_STRIDE(50, rs)) {
	       E T1, T6R, T3Y, T5G, T70, T7q, Ts, T3L, T3M, T6U, T6V, T6W, T45, T5T, T4c;
	       E T5Q, T2G, T5S, T42, T3G, T5P, T49, T4A, T68, T4H, T65, T11, T64, T4E, T2Z;
	       E T67, T4x, T4P, T61, T4W, T5Y, T1z, T5X, T4T, T3d, T60, T4M, T4k, T5J, T4r;
	       E T5M, T28, T5L, T4o, T3s, T5I, T4h;
	       {
		    E T7, T3P, Tq, T3W, Tk, T3U, Td, T3R;
		    T1 = cr[0];
		    T6R = ci[0];
		    {
			 E T3, T6, T4, T3O, T2, T5;
			 T3 = cr[WS(rs, 5)];
			 T6 = ci[WS(rs, 5)];
			 T2 = W[8];
			 T4 = T2 * T3;
			 T3O = T2 * T6;
			 T5 = W[9];
			 T7 = FMA(T5, T6, T4);
			 T3P = FNMS(T5, T3, T3O);
		    }
		    {
			 E Tm, Tp, Tn, T3V, Tl, To;
			 Tm = cr[WS(rs, 15)];
			 Tp = ci[WS(rs, 15)];
			 Tl = W[28];
			 Tn = Tl * Tm;
			 T3V = Tl * Tp;
			 To = W[29];
			 Tq = FMA(To, Tp, Tn);
			 T3W = FNMS(To, Tm, T3V);
		    }
		    {
			 E Tg, Tj, Th, T3T, Tf, Ti;
			 Tg = cr[WS(rs, 10)];
			 Tj = ci[WS(rs, 10)];
			 Tf = W[18];
			 Th = Tf * Tg;
			 T3T = Tf * Tj;
			 Ti = W[19];
			 Tk = FMA(Ti, Tj, Th);
			 T3U = FNMS(Ti, Tg, T3T);
		    }
		    {
			 E T9, Tc, Ta, T3Q, T8, Tb;
			 T9 = cr[WS(rs, 20)];
			 Tc = ci[WS(rs, 20)];
			 T8 = W[38];
			 Ta = T8 * T9;
			 T3Q = T8 * Tc;
			 Tb = W[39];
			 Td = FMA(Tb, Tc, Ta);
			 T3R = FNMS(Tb, T9, T3Q);
		    }
		    {
			 E T3S, T3X, T6Y, T6Z;
			 T3S = T3P - T3R;
			 T3X = T3U - T3W;
			 T3Y = FMA(KP618033988, T3X, T3S);
			 T5G = FNMS(KP618033988, T3S, T3X);
			 T6Y = Tk - Tq;
			 T6Z = T7 - Td;
			 T70 = FNMS(KP618033988, T6Z, T6Y);
			 T7q = FMA(KP618033988, T6Y, T6Z);
		    }
		    {
			 E Te, Tr, T6S, T6T;
			 Te = T7 + Td;
			 Tr = Tk + Tq;
			 Ts = Te + Tr;
			 T3L = FNMS(KP250000000, Ts, T1);
			 T3M = Te - Tr;
			 T6S = T3P + T3R;
			 T6T = T3U + T3W;
			 T6U = T6S + T6T;
			 T6V = FNMS(KP250000000, T6U, T6R);
			 T6W = T6S - T6T;
		    }
	       }
	       {
		    E T2e, T3u, T2x, T3B, T2D, T3D, T2E, T3E, T2k, T3w, T2q, T3y, T2r, T3z;
		    {
			 E T2a, T2d, T2b, T3t, T29, T2c;
			 T2a = cr[WS(rs, 3)];
			 T2d = ci[WS(rs, 3)];
			 T29 = W[4];
			 T2b = T29 * T2a;
			 T3t = T29 * T2d;
			 T2c = W[5];
			 T2e = FMA(T2c, T2d, T2b);
			 T3u = FNMS(T2c, T2a, T3t);
		    }
		    {
			 E T2t, T2w, T2u, T3A, T2z, T2C, T2A, T3C, T2s, T2y, T2v, T2B;
			 T2t = cr[WS(rs, 13)];
			 T2w = ci[WS(rs, 13)];
			 T2s = W[24];
			 T2u = T2s * T2t;
			 T3A = T2s * T2w;
			 T2z = cr[WS(rs, 18)];
			 T2C = ci[WS(rs, 18)];
			 T2y = W[34];
			 T2A = T2y * T2z;
			 T3C = T2y * T2C;
			 T2v = W[25];
			 T2x = FMA(T2v, T2w, T2u);
			 T3B = FNMS(T2v, T2t, T3A);
			 T2B = W[35];
			 T2D = FMA(T2B, T2C, T2A);
			 T3D = FNMS(T2B, T2z, T3C);
			 T2E = T2x + T2D;
			 T3E = T3B + T3D;
		    }
		    {
			 E T2g, T2j, T2h, T3v, T2m, T2p, T2n, T3x, T2f, T2l, T2i, T2o;
			 T2g = cr[WS(rs, 8)];
			 T2j = ci[WS(rs, 8)];
			 T2f = W[14];
			 T2h = T2f * T2g;
			 T3v = T2f * T2j;
			 T2m = cr[WS(rs, 23)];
			 T2p = ci[WS(rs, 23)];
			 T2l = W[44];
			 T2n = T2l * T2m;
			 T3x = T2l * T2p;
			 T2i = W[15];
			 T2k = FMA(T2i, T2j, T2h);
			 T3w = FNMS(T2i, T2g, T3v);
			 T2o = W[45];
			 T2q = FMA(T2o, T2p, T2n);
			 T3y = FNMS(T2o, T2m, T3x);
			 T2r = T2k + T2q;
			 T3z = T3w + T3y;
		    }
		    {
			 E T43, T44, T4a, T4b;
			 T43 = T3y - T3w;
			 T44 = T3D - T3B;
			 T45 = FMA(KP618033988, T44, T43);
			 T5T = FNMS(KP618033988, T43, T44);
			 T4a = T2k - T2q;
			 T4b = T2x - T2D;
			 T4c = FMA(KP618033988, T4b, T4a);
			 T5Q = FNMS(KP618033988, T4a, T4b);
		    }
		    {
			 E T41, T2F, T40, T48, T3F, T47;
			 T41 = T2E - T2r;
			 T2F = T2r + T2E;
			 T40 = FNMS(KP250000000, T2F, T2e);
			 T2G = T2e + T2F;
			 T5S = FMA(KP559016994, T41, T40);
			 T42 = FNMS(KP559016994, T41, T40);
			 T48 = T3E - T3z;
			 T3F = T3z + T3E;
			 T47 = FNMS(KP250000000, T3F, T3u);
			 T3G = T3u + T3F;
			 T5P = FMA(KP559016994, T48, T47);
			 T49 = FNMS(KP559016994, T48, T47);
		    }
	       }
	       {
		    E Tz, T2N, TS, T2U, TY, T2W, TZ, T2X, TF, T2P, TL, T2R, TM, T2S;
		    {
			 E Tv, Ty, Tw, T2M, Tu, Tx;
			 Tv = cr[WS(rs, 1)];
			 Ty = ci[WS(rs, 1)];
			 Tu = W[0];
			 Tw = Tu * Tv;
			 T2M = Tu * Ty;
			 Tx = W[1];
			 Tz = FMA(Tx, Ty, Tw);
			 T2N = FNMS(Tx, Tv, T2M);
		    }
		    {
			 E TO, TR, TP, T2T, TU, TX, TV, T2V, TN, TT, TQ, TW;
			 TO = cr[WS(rs, 11)];
			 TR = ci[WS(rs, 11)];
			 TN = W[20];
			 TP = TN * TO;
			 T2T = TN * TR;
			 TU = cr[WS(rs, 16)];
			 TX = ci[WS(rs, 16)];
			 TT = W[30];
			 TV = TT * TU;
			 T2V = TT * TX;
			 TQ = W[21];
			 TS = FMA(TQ, TR, TP);
			 T2U = FNMS(TQ, TO, T2T);
			 TW = W[31];
			 TY = FMA(TW, TX, TV);
			 T2W = FNMS(TW, TU, T2V);
			 TZ = TS + TY;
			 T2X = T2U + T2W;
		    }
		    {
			 E TB, TE, TC, T2O, TH, TK, TI, T2Q, TA, TG, TD, TJ;
			 TB = cr[WS(rs, 6)];
			 TE = ci[WS(rs, 6)];
			 TA = W[10];
			 TC = TA * TB;
			 T2O = TA * TE;
			 TH = cr[WS(rs, 21)];
			 TK = ci[WS(rs, 21)];
			 TG = W[40];
			 TI = TG * TH;
			 T2Q = TG * TK;
			 TD = W[11];
			 TF = FMA(TD, TE, TC);
			 T2P = FNMS(TD, TB, T2O);
			 TJ = W[41];
			 TL = FMA(TJ, TK, TI);
			 T2R = FNMS(TJ, TH, T2Q);
			 TM = TF + TL;
			 T2S = T2P + T2R;
		    }
		    {
			 E T4y, T4z, T4F, T4G;
			 T4y = TL - TF;
			 T4z = TY - TS;
			 T4A = FMA(KP618033988, T4z, T4y);
			 T68 = FNMS(KP618033988, T4y, T4z);
			 T4F = T2P - T2R;
			 T4G = T2W - T2U;
			 T4H = FNMS(KP618033988, T4G, T4F);
			 T65 = FMA(KP618033988, T4F, T4G);
		    }
		    {
			 E T4D, T10, T4C, T4w, T2Y, T4v;
			 T4D = TM - TZ;
			 T10 = TM + TZ;
			 T4C = FNMS(KP250000000, T10, Tz);
			 T11 = Tz + T10;
			 T64 = FNMS(KP559016994, T4D, T4C);
			 T4E = FMA(KP559016994, T4D, T4C);
			 T4w = T2S - T2X;
			 T2Y = T2S + T2X;
			 T4v = FNMS(KP250000000, T2Y, T2N);
			 T2Z = T2N + T2Y;
			 T67 = FNMS(KP559016994, T4w, T4v);
			 T4x = FMA(KP559016994, T4w, T4v);
		    }
	       }
	       {
		    E T17, T31, T1q, T38, T1w, T3a, T1x, T3b, T1d, T33, T1j, T35, T1k, T36;
		    {
			 E T13, T16, T14, T30, T12, T15;
			 T13 = cr[WS(rs, 4)];
			 T16 = ci[WS(rs, 4)];
			 T12 = W[6];
			 T14 = T12 * T13;
			 T30 = T12 * T16;
			 T15 = W[7];
			 T17 = FMA(T15, T16, T14);
			 T31 = FNMS(T15, T13, T30);
		    }
		    {
			 E T1m, T1p, T1n, T37, T1s, T1v, T1t, T39, T1l, T1r, T1o, T1u;
			 T1m = cr[WS(rs, 14)];
			 T1p = ci[WS(rs, 14)];
			 T1l = W[26];
			 T1n = T1l * T1m;
			 T37 = T1l * T1p;
			 T1s = cr[WS(rs, 19)];
			 T1v = ci[WS(rs, 19)];
			 T1r = W[36];
			 T1t = T1r * T1s;
			 T39 = T1r * T1v;
			 T1o = W[27];
			 T1q = FMA(T1o, T1p, T1n);
			 T38 = FNMS(T1o, T1m, T37);
			 T1u = W[37];
			 T1w = FMA(T1u, T1v, T1t);
			 T3a = FNMS(T1u, T1s, T39);
			 T1x = T1q + T1w;
			 T3b = T38 + T3a;
		    }
		    {
			 E T19, T1c, T1a, T32, T1f, T1i, T1g, T34, T18, T1e, T1b, T1h;
			 T19 = cr[WS(rs, 9)];
			 T1c = ci[WS(rs, 9)];
			 T18 = W[16];
			 T1a = T18 * T19;
			 T32 = T18 * T1c;
			 T1f = cr[WS(rs, 24)];
			 T1i = ci[WS(rs, 24)];
			 T1e = W[46];
			 T1g = T1e * T1f;
			 T34 = T1e * T1i;
			 T1b = W[17];
			 T1d = FMA(T1b, T1c, T1a);
			 T33 = FNMS(T1b, T19, T32);
			 T1h = W[47];
			 T1j = FMA(T1h, T1i, T1g);
			 T35 = FNMS(T1h, T1f, T34);
			 T1k = T1d + T1j;
			 T36 = T33 + T35;
		    }
		    {
			 E T4N, T4O, T4U, T4V;
			 T4N = T1j - T1d;
			 T4O = T1w - T1q;
			 T4P = FMA(KP618033988, T4O, T4N);
			 T61 = FNMS(KP618033988, T4N, T4O);
			 T4U = T35 - T33;
			 T4V = T3a - T38;
			 T4W = FMA(KP618033988, T4V, T4U);
			 T5Y = FNMS(KP618033988, T4U, T4V);
		    }
		    {
			 E T4S, T1y, T4R, T4L, T3c, T4K;
			 T4S = T1k - T1x;
			 T1y = T1k + T1x;
			 T4R = FNMS(KP250000000, T1y, T17);
			 T1z = T17 + T1y;
			 T5X = FNMS(KP559016994, T4S, T4R);
			 T4T = FMA(KP559016994, T4S, T4R);
			 T4L = T3b - T36;
			 T3c = T36 + T3b;
			 T4K = FNMS(KP250000000, T3c, T31);
			 T3d = T31 + T3c;
			 T60 = FMA(KP559016994, T4L, T4K);
			 T4M = FNMS(KP559016994, T4L, T4K);
		    }
	       }
	       {
		    E T1G, T3g, T1Z, T3n, T25, T3p, T26, T3q, T1M, T3i, T1S, T3k, T1T, T3l;
		    {
			 E T1C, T1F, T1D, T3f, T1B, T1E;
			 T1C = cr[WS(rs, 2)];
			 T1F = ci[WS(rs, 2)];
			 T1B = W[2];
			 T1D = T1B * T1C;
			 T3f = T1B * T1F;
			 T1E = W[3];
			 T1G = FMA(T1E, T1F, T1D);
			 T3g = FNMS(T1E, T1C, T3f);
		    }
		    {
			 E T1V, T1Y, T1W, T3m, T21, T24, T22, T3o, T1U, T20, T1X, T23;
			 T1V = cr[WS(rs, 12)];
			 T1Y = ci[WS(rs, 12)];
			 T1U = W[22];
			 T1W = T1U * T1V;
			 T3m = T1U * T1Y;
			 T21 = cr[WS(rs, 17)];
			 T24 = ci[WS(rs, 17)];
			 T20 = W[32];
			 T22 = T20 * T21;
			 T3o = T20 * T24;
			 T1X = W[23];
			 T1Z = FMA(T1X, T1Y, T1W);
			 T3n = FNMS(T1X, T1V, T3m);
			 T23 = W[33];
			 T25 = FMA(T23, T24, T22);
			 T3p = FNMS(T23, T21, T3o);
			 T26 = T1Z + T25;
			 T3q = T3n + T3p;
		    }
		    {
			 E T1I, T1L, T1J, T3h, T1O, T1R, T1P, T3j, T1H, T1N, T1K, T1Q;
			 T1I = cr[WS(rs, 7)];
			 T1L = ci[WS(rs, 7)];
			 T1H = W[12];
			 T1J = T1H * T1I;
			 T3h = T1H * T1L;
			 T1O = cr[WS(rs, 22)];
			 T1R = ci[WS(rs, 22)];
			 T1N = W[42];
			 T1P = T1N * T1O;
			 T3j = T1N * T1R;
			 T1K = W[13];
			 T1M = FMA(T1K, T1L, T1J);
			 T3i = FNMS(T1K, T1I, T3h);
			 T1Q = W[43];
			 T1S = FMA(T1Q, T1R, T1P);
			 T3k = FNMS(T1Q, T1O, T3j);
			 T1T = T1M + T1S;
			 T3l = T3i + T3k;
		    }
		    {
			 E T4i, T4j, T4p, T4q;
			 T4i = T1S - T1M;
			 T4j = T25 - T1Z;
			 T4k = FMA(KP618033988, T4j, T4i);
			 T5J = FNMS(KP618033988, T4i, T4j);
			 T4p = T3k - T3i;
			 T4q = T3n - T3p;
			 T4r = FNMS(KP618033988, T4q, T4p);
			 T5M = FMA(KP618033988, T4p, T4q);
		    }
		    {
			 E T4n, T27, T4m, T4g, T3r, T4f;
			 T4n = T26 - T1T;
			 T27 = T1T + T26;
			 T4m = FNMS(KP250000000, T27, T1G);
			 T28 = T1G + T27;
			 T5L = FMA(KP559016994, T4n, T4m);
			 T4o = FNMS(KP559016994, T4n, T4m);
			 T4g = T3q - T3l;
			 T3r = T3l + T3q;
			 T4f = FNMS(KP250000000, T3r, T3g);
			 T3s = T3g + T3r;
			 T5I = FMA(KP559016994, T4g, T4f);
			 T4h = FNMS(KP559016994, T4g, T4f);
		    }
	       }
	       {
		    E T3I, T3K, Tt, T2I, T2J, T2K, T3J, T2L;
		    {
			 E T3e, T3H, T1A, T2H;
			 T3e = T2Z - T3d;
			 T3H = T3s - T3G;
			 T3I = FMA(KP618033988, T3H, T3e);
			 T3K = FNMS(KP618033988, T3e, T3H);
			 Tt = T1 + Ts;
			 T1A = T11 + T1z;
			 T2H = T28 + T2G;
			 T2I = T1A + T2H;
			 T2J = FNMS(KP250000000, T2I, Tt);
			 T2K = T1A - T2H;
		    }
		    cr[0] = Tt + T2I;
		    T3J = FNMS(KP559016994, T2K, T2J);
		    cr[WS(rs, 10)] = FNMS(KP951056516, T3K, T3J);
		    ci[WS(rs, 9)] = FMA(KP951056516, T3K, T3J);
		    T2L = FMA(KP559016994, T2K, T2J);
		    ci[WS(rs, 4)] = FNMS(KP951056516, T3I, T2L);
		    cr[WS(rs, 5)] = FMA(KP951056516, T3I, T2L);
	       }
	       {
		    E T3Z, T5d, T7r, T7D, T56, T59, T7L, T7K, T7E, T7F, T7G, T4u, T4Z, T50, T5y;
		    E T5B, T7z, T7y, T7s, T7t, T7u, T5k, T5r, T5s, T3N, T7p;
		    T3N = FMA(KP559016994, T3M, T3L);
		    T3Z = FNMS(KP951056516, T3Y, T3N);
		    T5d = FMA(KP951056516, T3Y, T3N);
		    T7p = FMA(KP559016994, T6W, T6V);
		    T7r = FNMS(KP951056516, T7q, T7p);
		    T7D = FMA(KP951056516, T7q, T7p);
		    {
			 E T4e, T57, T4Y, T55, T4t, T58, T4J, T54;
			 {
			      E T46, T4d, T4Q, T4X;
			      T46 = FMA(KP951056516, T45, T42);
			      T4d = FMA(KP951056516, T4c, T49);
			      T4e = FNMS(KP126329378, T4d, T46);
			      T57 = FMA(KP126329378, T46, T4d);
			      T4Q = FNMS(KP951056516, T4P, T4M);
			      T4X = FMA(KP951056516, T4W, T4T);
			      T4Y = FMA(KP827271945, T4X, T4Q);
			      T55 = FNMS(KP827271945, T4Q, T4X);
			 }
			 {
			      E T4l, T4s, T4B, T4I;
			      T4l = FNMS(KP951056516, T4k, T4h);
			      T4s = FMA(KP951056516, T4r, T4o);
			      T4t = FNMS(KP470564281, T4s, T4l);
			      T58 = FMA(KP470564281, T4l, T4s);
			      T4B = FNMS(KP951056516, T4A, T4x);
			      T4I = FNMS(KP951056516, T4H, T4E);
			      T4J = FMA(KP634619297, T4I, T4B);
			      T54 = FNMS(KP634619297, T4B, T4I);
			 }
			 T56 = FMA(KP912575812, T55, T54);
			 T59 = FNMS(KP912018591, T58, T57);
			 T7L = FMA(KP912575812, T4Y, T4J);
			 T7K = FMA(KP912018591, T4t, T4e);
			 T7E = FMA(KP912018591, T58, T57);
			 T7F = FNMS(KP912575812, T55, T54);
			 T7G = FMA(KP851038619, T7F, T7E);
			 T4u = FNMS(KP912018591, T4t, T4e);
			 T4Z = FNMS(KP912575812, T4Y, T4J);
			 T50 = FNMS(KP851038619, T4Z, T4u);
		    }
		    {
			 E T5g, T5w, T5q, T5A, T5j, T5x, T5n, T5z;
			 {
			      E T5e, T5f, T5o, T5p;
			      T5e = FMA(KP951056516, T4H, T4E);
			      T5f = FMA(KP951056516, T4A, T4x);
			      T5g = FMA(KP256756360, T5f, T5e);
			      T5w = FNMS(KP256756360, T5e, T5f);
			      T5o = FNMS(KP951056516, T45, T42);
			      T5p = FNMS(KP951056516, T4c, T49);
			      T5q = FMA(KP939062505, T5p, T5o);
			      T5A = FNMS(KP939062505, T5o, T5p);
			 }
			 {
			      E T5h, T5i, T5l, T5m;
			      T5h = FMA(KP951056516, T4P, T4M);
			      T5i = FNMS(KP951056516, T4W, T4T);
			      T5j = FMA(KP634619297, T5i, T5h);
			      T5x = FNMS(KP634619297, T5h, T5i);
			      T5l = FNMS(KP951056516, T4r, T4o);
			      T5m = FMA(KP951056516, T4k, T4h);
			      T5n = FMA(KP549754652, T5m, T5l);
			      T5z = FNMS(KP549754652, T5l, T5m);
			 }
			 T5y = FMA(KP871714437, T5x, T5w);
			 T5B = FNMS(KP831864738, T5A, T5z);
			 T7z = FNMS(KP871714437, T5j, T5g);
			 T7y = FNMS(KP831864738, T5q, T5n);
			 T7s = FNMS(KP871714437, T5x, T5w);
			 T7t = FMA(KP831864738, T5A, T5z);
			 T7u = FMA(KP904730450, T7t, T7s);
			 T5k = FMA(KP871714437, T5j, T5g);
			 T5r = FMA(KP831864738, T5q, T5n);
			 T5s = FMA(KP904730450, T5r, T5k);
		    }
		    cr[WS(rs, 4)] = FNMS(KP992114701, T50, T3Z);
		    ci[WS(rs, 23)] = FMA(KP968583161, T7u, T7r);
		    ci[WS(rs, 20)] = FNMS(KP992114701, T7G, T7D);
		    cr[WS(rs, 1)] = FMA(KP968583161, T5s, T5d);
		    {
			 E T5a, T5c, T53, T5b, T51, T52;
			 T5a = FNMS(KP726211448, T59, T56);
			 T5c = FMA(KP525970792, T56, T59);
			 T51 = FMA(KP248028675, T50, T3Z);
			 T52 = FMA(KP851038619, T4Z, T4u);
			 T53 = FMA(KP554608978, T52, T51);
			 T5b = FNMS(KP554608978, T52, T51);
			 cr[WS(rs, 9)] = FNMS(KP803003575, T5a, T53);
			 ci[WS(rs, 5)] = FMA(KP943557151, T5c, T5b);
			 ci[0] = FMA(KP803003575, T5a, T53);
			 ci[WS(rs, 10)] = FNMS(KP943557151, T5c, T5b);
		    }
		    {
			 E T7A, T7C, T7x, T7B, T7v, T7w;
			 T7A = FNMS(KP683113946, T7z, T7y);
			 T7C = FMA(KP559154169, T7y, T7z);
			 T7v = FNMS(KP242145790, T7u, T7r);
			 T7w = FNMS(KP904730450, T7t, T7s);
			 T7x = FNMS(KP541454447, T7w, T7v);
			 T7B = FMA(KP541454447, T7w, T7v);
			 cr[WS(rs, 16)] = FMS(KP833417178, T7A, T7x);
			 ci[WS(rs, 18)] = FNMS(KP921177326, T7C, T7B);
			 ci[WS(rs, 13)] = FMA(KP833417178, T7A, T7x);
			 cr[WS(rs, 21)] = -(FMA(KP921177326, T7C, T7B));
		    }
		    {
			 E T7M, T7O, T7J, T7N, T7H, T7I;
			 T7M = FNMS(KP525970792, T7L, T7K);
			 T7O = FMA(KP726211448, T7K, T7L);
			 T7H = FMA(KP248028675, T7G, T7D);
			 T7I = FNMS(KP851038619, T7F, T7E);
			 T7J = FNMS(KP554608978, T7I, T7H);
			 T7N = FMA(KP554608978, T7I, T7H);
			 cr[WS(rs, 14)] = -(FMA(KP943557151, T7M, T7J));
			 ci[WS(rs, 15)] = FNMS(KP803003575, T7O, T7N);
			 cr[WS(rs, 19)] = FMS(KP943557151, T7M, T7J);
			 cr[WS(rs, 24)] = -(FMA(KP803003575, T7O, T7N));
		    }
		    {
			 E T5C, T5E, T5v, T5D, T5t, T5u;
			 T5C = FMA(KP559154169, T5B, T5y);
			 T5E = FNMS(KP683113946, T5y, T5B);
			 T5t = FNMS(KP242145790, T5s, T5d);
			 T5u = FNMS(KP904730450, T5r, T5k);
			 T5v = FMA(KP541454447, T5u, T5t);
			 T5D = FNMS(KP541454447, T5u, T5t);
			 ci[WS(rs, 3)] = FNMS(KP921177326, T5C, T5v);
			 ci[WS(rs, 8)] = FMA(KP833417178, T5E, T5D);
			 cr[WS(rs, 6)] = FMA(KP921177326, T5C, T5v);
			 cr[WS(rs, 11)] = FNMS(KP833417178, T5E, T5D);
		    }
	       }
	       {
		    E T7Y, T80, T7P, T7S, T7T, T7U, T7Z, T7V;
		    {
			 E T7W, T7X, T7Q, T7R;
			 T7W = T28 - T2G;
			 T7X = T1z - T11;
			 T7Y = FMA(KP618033988, T7X, T7W);
			 T80 = FNMS(KP618033988, T7W, T7X);
			 T7P = T6U + T6R;
			 T7Q = T2Z + T3d;
			 T7R = T3s + T3G;
			 T7S = T7Q + T7R;
			 T7T = FNMS(KP250000000, T7S, T7P);
			 T7U = T7Q - T7R;
		    }
		    ci[WS(rs, 24)] = T7S + T7P;
		    T7Z = FMA(KP559016994, T7U, T7T);
		    cr[WS(rs, 20)] = FMS(KP951056516, T80, T7Z);
		    ci[WS(rs, 19)] = FMA(KP951056516, T80, T7Z);
		    T7V = FNMS(KP559016994, T7U, T7T);
		    cr[WS(rs, 15)] = FMS(KP951056516, T7Y, T7V);
		    ci[WS(rs, 14)] = FMA(KP951056516, T7Y, T7V);
	       }
	       {
		    E T5H, T6p, T71, T7d, T6i, T6l, T7l, T7k, T7e, T7f, T7g, T5W, T6b, T6c, T6K;
		    E T6N, T79, T78, T72, T73, T74, T6w, T6D, T6E, T5F, T6X;
		    T5F = FNMS(KP559016994, T3M, T3L);
		    T5H = FMA(KP951056516, T5G, T5F);
		    T6p = FNMS(KP951056516, T5G, T5F);
		    T6X = FNMS(KP559016994, T6W, T6V);
		    T71 = FMA(KP951056516, T70, T6X);
		    T7d = FNMS(KP951056516, T70, T6X);
		    {
			 E T5O, T6j, T6a, T6h, T5V, T6k, T63, T6g;
			 {
			      E T5K, T5N, T66, T69;
			      T5K = FMA(KP951056516, T5J, T5I);
			      T5N = FMA(KP951056516, T5M, T5L);
			      T5O = FMA(KP062914667, T5N, T5K);
			      T6j = FNMS(KP062914667, T5K, T5N);
			      T66 = FNMS(KP951056516, T65, T64);
			      T69 = FMA(KP951056516, T68, T67);
			      T6a = FMA(KP939062505, T69, T66);
			      T6h = FNMS(KP939062505, T66, T69);
			 }
			 {
			      E T5R, T5U, T5Z, T62;
			      T5R = FNMS(KP951056516, T5Q, T5P);
			      T5U = FNMS(KP951056516, T5T, T5S);
			      T5V = FNMS(KP827271945, T5U, T5R);
			      T6k = FMA(KP827271945, T5R, T5U);
			      T5Z = FNMS(KP951056516, T5Y, T5X);
			      T62 = FMA(KP951056516, T61, T60);
			      T63 = FNMS(KP126329378, T62, T5Z);
			      T6g = FMA(KP126329378, T5Z, T62);
			 }
			 T6i = FMA(KP734762448, T6h, T6g);
			 T6l = FNMS(KP772036680, T6k, T6j);
			 T7l = FMA(KP734762448, T6a, T63);
			 T7k = FNMS(KP772036680, T5V, T5O);
			 T7e = FMA(KP772036680, T6k, T6j);
			 T7f = FNMS(KP734762448, T6h, T6g);
			 T7g = FMA(KP994076283, T7f, T7e);
			 T5W = FMA(KP772036680, T5V, T5O);
			 T6b = FNMS(KP734762448, T6a, T63);
			 T6c = FNMS(KP994076283, T6b, T5W);
		    }
		    {
			 E T6s, T6L, T6C, T6J, T6v, T6M, T6z, T6I;
			 {
			      E T6q, T6r, T6A, T6B;
			      T6q = FMA(KP951056516, T5Q, T5P);
			      T6r = FMA(KP951056516, T5T, T5S);
			      T6s = FMA(KP062914667, T6r, T6q);
			      T6L = FNMS(KP062914667, T6q, T6r);
			      T6A = FMA(KP951056516, T65, T64);
			      T6B = FNMS(KP951056516, T68, T67);
			      T6C = FMA(KP549754652, T6B, T6A);
			      T6J = FNMS(KP549754652, T6A, T6B);
			 }
			 {
			      E T6t, T6u, T6x, T6y;
			      T6t = FNMS(KP951056516, T5J, T5I);
			      T6u = FNMS(KP951056516, T5M, T5L);
			      T6v = FMA(KP634619297, T6u, T6t);
			      T6M = FNMS(KP634619297, T6t, T6u);
			      T6x = FNMS(KP951056516, T61, T60);
			      T6y = FMA(KP951056516, T5Y, T5X);
			      T6z = FNMS(KP470564281, T6y, T6x);
			      T6I = FMA(KP470564281, T6x, T6y);
			 }
			 T6K = FMA(KP968479752, T6J, T6I);
			 T6N = FNMS(KP845997307, T6M, T6L);
			 T79 = FNMS(KP968479752, T6C, T6z);
			 T78 = FNMS(KP845997307, T6v, T6s);
			 T72 = FMA(KP845997307, T6M, T6L);
			 T73 = FNMS(KP968479752, T6J, T6I);
			 T74 = FMA(KP906616052, T73, T72);
			 T6w = FMA(KP845997307, T6v, T6s);
			 T6D = FMA(KP968479752, T6C, T6z);
			 T6E = FMA(KP906616052, T6D, T6w);
		    }
		    cr[WS(rs, 3)] = FMA(KP998026728, T6c, T5H);
		    ci[WS(rs, 22)] = FNMS(KP998026728, T74, T71);
		    ci[WS(rs, 21)] = FNMS(KP998026728, T7g, T7d);
		    cr[WS(rs, 2)] = FMA(KP998026728, T6E, T6p);
		    {
			 E T7a, T7c, T77, T7b, T75, T76;
			 T7a = FNMS(KP560319534, T79, T78);
			 T7c = FMA(KP681693190, T78, T79);
			 T75 = FMA(KP249506682, T74, T71);
			 T76 = FNMS(KP906616052, T73, T72);
			 T77 = FNMS(KP557913902, T76, T75);
			 T7b = FMA(KP557913902, T76, T75);
			 cr[WS(rs, 17)] = -(FMA(KP949179823, T7a, T77));
			 ci[WS(rs, 17)] = FMA(KP860541664, T7c, T7b);
			 ci[WS(rs, 12)] = FNMS(KP949179823, T7a, T77);
			 cr[WS(rs, 22)] = FMS(KP860541664, T7c, T7b);
		    }
		    {
			 E T6O, T6Q, T6H, T6P, T6F, T6G;
			 T6O = FMA(KP681693190, T6N, T6K);
			 T6Q = FNMS(KP560319534, T6K, T6N);
			 T6F = FNMS(KP249506682, T6E, T6p);
			 T6G = FNMS(KP906616052, T6D, T6w);
			 T6H = FNMS(KP557913902, T6G, T6F);
			 T6P = FMA(KP557913902, T6G, T6F);
			 ci[WS(rs, 2)] = FNMS(KP860541664, T6O, T6H);
			 cr[WS(rs, 12)] = FNMS(KP949179823, T6Q, T6P);
			 cr[WS(rs, 7)] = FMA(KP860541664, T6O, T6H);
			 ci[WS(rs, 7)] = FMA(KP949179823, T6Q, T6P);
		    }
		    {
			 E T6m, T6o, T6f, T6n, T6d, T6e;
			 T6m = FNMS(KP621716863, T6l, T6i);
			 T6o = FMA(KP614372930, T6i, T6l);
			 T6d = FNMS(KP249506682, T6c, T5H);
			 T6e = FMA(KP994076283, T6b, T5W);
			 T6f = FNMS(KP557913902, T6e, T6d);
			 T6n = FMA(KP557913902, T6e, T6d);
			 ci[WS(rs, 1)] = FNMS(KP943557151, T6m, T6f);
			 ci[WS(rs, 11)] = FMA(KP949179823, T6o, T6n);
			 cr[WS(rs, 8)] = FMA(KP943557151, T6m, T6f);
			 ci[WS(rs, 6)] = FNMS(KP949179823, T6o, T6n);
		    }
		    {
			 E T7m, T7o, T7j, T7n, T7h, T7i;
			 T7m = FNMS(KP614372930, T7l, T7k);
			 T7o = FMA(KP621716863, T7k, T7l);
			 T7h = FMA(KP249506682, T7g, T7d);
			 T7i = FNMS(KP994076283, T7f, T7e);
			 T7j = FNMS(KP557913902, T7i, T7h);
			 T7n = FMA(KP557913902, T7i, T7h);
			 cr[WS(rs, 13)] = -(FMA(KP949179823, T7m, T7j));
			 ci[WS(rs, 16)] = FNMS(KP943557151, T7o, T7n);
			 cr[WS(rs, 18)] = FMS(KP949179823, T7m, T7j);
			 cr[WS(rs, 23)] = -(FMA(KP943557151, T7o, T7n));
		    }
	       }
	  }
     }
}

static const tw_instr twinstr[] = {
     { TW_FULL, 1, 25 },
     { TW_NEXT, 1, 0 }
};

static const hc2hc_desc desc = { 25, "hf_25", twinstr, &GENUS, { 84, 48, 316, 0 } };

void X(codelet_hf_25) (planner *p) {
     X(khc2hc_register) (p, hf_25, &desc);
}
#else

/* Generated by: ../../../genfft/gen_hc2hc.native -compact -variables 4 -pipeline-latency 4 -n 25 -dit -name hf_25 -include rdft/scalar/hf.h */

/*
 * This function contains 400 FP additions, 280 FP multiplications,
 * (or, 260 additions, 140 multiplications, 140 fused multiply/add),
 * 101 stack variables, 20 constants, and 100 memory accesses
 */
#include "rdft/scalar/hf.h"

static void hf_25(R *cr, R *ci, const R *W, stride rs, INT mb, INT me, INT ms)
{
     DK(KP998026728, +0.998026728428271561952336806863450553336905220);
     DK(KP062790519, +0.062790519529313376076178224565631133122484832);
     DK(KP684547105, +0.684547105928688673732283357621209269889519233);
     DK(KP728968627, +0.728968627421411523146730319055259111372571664);
     DK(KP481753674, +0.481753674101715274987191502872129653528542010);
     DK(KP876306680, +0.876306680043863587308115903922062583399064238);
     DK(KP248689887, +0.248689887164854788242283746006447968417567406);
     DK(KP968583161, +0.968583161128631119490168375464735813836012403);
     DK(KP992114701, +0.992114701314477831049793042785778521453036709);
     DK(KP125333233, +0.125333233564304245373118759816508793942918247);
     DK(KP425779291, +0.425779291565072648862502445744251703979973042);
     DK(KP904827052, +0.904827052466019527713668647932697593970413911);
     DK(KP637423989, +0.637423989748689710176712811676016195434917298);
     DK(KP770513242, +0.770513242775789230803009636396177847271667672);
     DK(KP844327925, +0.844327925502015078548558063966681505381659241);
     DK(KP535826794, +0.535826794978996618271308767867639978063575346);
     DK(KP587785252, +0.587785252292473129168705954639072768597652438);
     DK(KP951056516, +0.951056516295153572116439333379382143405698634);
     DK(KP250000000, +0.250000000000000000000000000000000000000000000);
     DK(KP559016994, +0.559016994374947424102293417182819058860154590);
     {
	  INT m;
	  for (m = mb, W = W + ((mb - 1) * 48); m < me; m = m + 1, cr = cr + ms, ci = ci - ms, W = W + 48, MAKE_VOLATILE_STRIDE(50, rs)) {
	       E T1, T6b, T2l, T6g, To, T2m, T6e, T6f, T6a, T6H, T2u, T4I, T2i, T60, T3S;
	       E T5D, T4r, T58, T3Z, T5C, T4q, T5b, TS, T5W, T2G, T5s, T4g, T4M, T2R, T5t;
	       E T4h, T4P, T1l, T5X, T37, T5v, T4k, T4T, T3e, T5w, T4j, T4W, T1P, T5Z, T3v;
	       E T5A, T4o, T54, T3C, T5z, T4n, T51;
	       {
		    E T6, T2o, Tb, T2p, Tc, T6c, Th, T2r, Tm, T2s, Tn, T6d;
		    T1 = cr[0];
		    T6b = ci[0];
		    {
			 E T3, T5, T2, T4;
			 T3 = cr[WS(rs, 5)];
			 T5 = ci[WS(rs, 5)];
			 T2 = W[8];
			 T4 = W[9];
			 T6 = FMA(T2, T3, T4 * T5);
			 T2o = FNMS(T4, T3, T2 * T5);
		    }
		    {
			 E T8, Ta, T7, T9;
			 T8 = cr[WS(rs, 20)];
			 Ta = ci[WS(rs, 20)];
			 T7 = W[38];
			 T9 = W[39];
			 Tb = FMA(T7, T8, T9 * Ta);
			 T2p = FNMS(T9, T8, T7 * Ta);
		    }
		    Tc = T6 + Tb;
		    T6c = T2o + T2p;
		    {
			 E Te, Tg, Td, Tf;
			 Te = cr[WS(rs, 10)];
			 Tg = ci[WS(rs, 10)];
			 Td = W[18];
			 Tf = W[19];
			 Th = FMA(Td, Te, Tf * Tg);
			 T2r = FNMS(Tf, Te, Td * Tg);
		    }
		    {
			 E Tj, Tl, Ti, Tk;
			 Tj = cr[WS(rs, 15)];
			 Tl = ci[WS(rs, 15)];
			 Ti = W[28];
			 Tk = W[29];
			 Tm = FMA(Ti, Tj, Tk * Tl);
			 T2s = FNMS(Tk, Tj, Ti * Tl);
		    }
		    Tn = Th + Tm;
		    T6d = T2r + T2s;
		    T2l = KP559016994 * (Tc - Tn);
		    T6g = KP559016994 * (T6c - T6d);
		    To = Tc + Tn;
		    T2m = FNMS(KP250000000, To, T1);
		    T6e = T6c + T6d;
		    T6f = FNMS(KP250000000, T6e, T6b);
		    {
			 E T68, T69, T2q, T2t;
			 T68 = Th - Tm;
			 T69 = T6 - Tb;
			 T6a = FNMS(KP587785252, T69, KP951056516 * T68);
			 T6H = FMA(KP951056516, T69, KP587785252 * T68);
			 T2q = T2o - T2p;
			 T2t = T2r - T2s;
			 T2u = FMA(KP951056516, T2q, KP587785252 * T2t);
			 T4I = FNMS(KP587785252, T2q, KP951056516 * T2t);
		    }
	       }
	       {
		    E T1U, T3O, T3E, T3F, T3X, T3W, T3J, T3M, T3P, T25, T2g, T2h;
		    {
			 E T1R, T1T, T1Q, T1S;
			 T1R = cr[WS(rs, 3)];
			 T1T = ci[WS(rs, 3)];
			 T1Q = W[4];
			 T1S = W[5];
			 T1U = FMA(T1Q, T1R, T1S * T1T);
			 T3O = FNMS(T1S, T1R, T1Q * T1T);
		    }
		    {
			 E T1Z, T3H, T2f, T3L, T24, T3I, T2a, T3K;
			 {
			      E T1W, T1Y, T1V, T1X;
			      T1W = cr[WS(rs, 8)];
			      T1Y = ci[WS(rs, 8)];
			      T1V = W[14];
			      T1X = W[15];
			      T1Z = FMA(T1V, T1W, T1X * T1Y);
			      T3H = FNMS(T1X, T1W, T1V * T1Y);
			 }
			 {
			      E T2c, T2e, T2b, T2d;
			      T2c = cr[WS(rs, 18)];
			      T2e = ci[WS(rs, 18)];
			      T2b = W[34];
			      T2d = W[35];
			      T2f = FMA(T2b, T2c, T2d * T2e);
			      T3L = FNMS(T2d, T2c, T2b * T2e);
			 }
			 {
			      E T21, T23, T20, T22;
			      T21 = cr[WS(rs, 23)];
			      T23 = ci[WS(rs, 23)];
			      T20 = W[44];
			      T22 = W[45];
			      T24 = FMA(T20, T21, T22 * T23);
			      T3I = FNMS(T22, T21, T20 * T23);
			 }
			 {
			      E T27, T29, T26, T28;
			      T27 = cr[WS(rs, 13)];
			      T29 = ci[WS(rs, 13)];
			      T26 = W[24];
			      T28 = W[25];
			      T2a = FMA(T26, T27, T28 * T29);
			      T3K = FNMS(T28, T27, T26 * T29);
			 }
			 T3E = T1Z - T24;
			 T3F = T2a - T2f;
			 T3X = T3K - T3L;
			 T3W = T3H - T3I;
			 T3J = T3H + T3I;
			 T3M = T3K + T3L;
			 T3P = T3J + T3M;
			 T25 = T1Z + T24;
			 T2g = T2a + T2f;
			 T2h = T25 + T2g;
		    }
		    T2i = T1U + T2h;
		    T60 = T3O + T3P;
		    {
			 E T3G, T57, T3R, T56, T3N, T3Q;
			 T3G = FMA(KP951056516, T3E, KP587785252 * T3F);
			 T57 = FNMS(KP587785252, T3E, KP951056516 * T3F);
			 T3N = KP559016994 * (T3J - T3M);
			 T3Q = FNMS(KP250000000, T3P, T3O);
			 T3R = T3N + T3Q;
			 T56 = T3Q - T3N;
			 T3S = T3G + T3R;
			 T5D = T57 + T56;
			 T4r = T3R - T3G;
			 T58 = T56 - T57;
		    }
		    {
			 E T3Y, T5a, T3V, T59, T3T, T3U;
			 T3Y = FMA(KP951056516, T3W, KP587785252 * T3X);
			 T5a = FNMS(KP587785252, T3W, KP951056516 * T3X);
			 T3T = KP559016994 * (T25 - T2g);
			 T3U = FNMS(KP250000000, T2h, T1U);
			 T3V = T3T + T3U;
			 T59 = T3U - T3T;
			 T3Z = T3V - T3Y;
			 T5C = T59 - T5a;
			 T4q = T3V + T3Y;
			 T5b = T59 + T5a;
		    }
	       }
	       {
		    E Tu, T2N, T2B, T2E, T2I, T2H, T2K, T2L, T2O, TF, TQ, TR;
		    {
			 E Tr, Tt, Tq, Ts;
			 Tr = cr[WS(rs, 1)];
			 Tt = ci[WS(rs, 1)];
			 Tq = W[0];
			 Ts = W[1];
			 Tu = FMA(Tq, Tr, Ts * Tt);
			 T2N = FNMS(Ts, Tr, Tq * Tt);
		    }
		    {
			 E Tz, T2z, TP, T2D, TE, T2A, TK, T2C;
			 {
			      E Tw, Ty, Tv, Tx;
			      Tw = cr[WS(rs, 6)];
			      Ty = ci[WS(rs, 6)];
			      Tv = W[10];
			      Tx = W[11];
			      Tz = FMA(Tv, Tw, Tx * Ty);
			      T2z = FNMS(Tx, Tw, Tv * Ty);
			 }
			 {
			      E TM, TO, TL, TN;
			      TM = cr[WS(rs, 16)];
			      TO = ci[WS(rs, 16)];
			      TL = W[30];
			      TN = W[31];
			      TP = FMA(TL, TM, TN * TO);
			      T2D = FNMS(TN, TM, TL * TO);
			 }
			 {
			      E TB, TD, TA, TC;
			      TB = cr[WS(rs, 21)];
			      TD = ci[WS(rs, 21)];
			      TA = W[40];
			      TC = W[41];
			      TE = FMA(TA, TB, TC * TD);
			      T2A = FNMS(TC, TB, TA * TD);
			 }
			 {
			      E TH, TJ, TG, TI;
			      TH = cr[WS(rs, 11)];
			      TJ = ci[WS(rs, 11)];
			      TG = W[20];
			      TI = W[21];
			      TK = FMA(TG, TH, TI * TJ);
			      T2C = FNMS(TI, TH, TG * TJ);
			 }
			 T2B = T2z - T2A;
			 T2E = T2C - T2D;
			 T2I = TK - TP;
			 T2H = Tz - TE;
			 T2K = T2z + T2A;
			 T2L = T2C + T2D;
			 T2O = T2K + T2L;
			 TF = Tz + TE;
			 TQ = TK + TP;
			 TR = TF + TQ;
		    }
		    TS = Tu + TR;
		    T5W = T2N + T2O;
		    {
			 E T2F, T4L, T2y, T4K, T2w, T2x;
			 T2F = FMA(KP951056516, T2B, KP587785252 * T2E);
			 T4L = FNMS(KP587785252, T2B, KP951056516 * T2E);
			 T2w = KP559016994 * (TF - TQ);
			 T2x = FNMS(KP250000000, TR, Tu);
			 T2y = T2w + T2x;
			 T4K = T2x - T2w;
			 T2G = T2y - T2F;
			 T5s = T4K - T4L;
			 T4g = T2y + T2F;
			 T4M = T4K + T4L;
		    }
		    {
			 E T2J, T4O, T2Q, T4N, T2M, T2P;
			 T2J = FMA(KP951056516, T2H, KP587785252 * T2I);
			 T4O = FNMS(KP587785252, T2H, KP951056516 * T2I);
			 T2M = KP559016994 * (T2K - T2L);
			 T2P = FNMS(KP250000000, T2O, T2N);
			 T2Q = T2M + T2P;
			 T4N = T2P - T2M;
			 T2R = T2J + T2Q;
			 T5t = T4O + T4N;
			 T4h = T2Q - T2J;
			 T4P = T4N - T4O;
		    }
	       }
	       {
		    E TX, T33, T2T, T2U, T3c, T3b, T2Y, T31, T34, T18, T1j, T1k;
		    {
			 E TU, TW, TT, TV;
			 TU = cr[WS(rs, 4)];
			 TW = ci[WS(rs, 4)];
			 TT = W[6];
			 TV = W[7];
			 TX = FMA(TT, TU, TV * TW);
			 T33 = FNMS(TV, TU, TT * TW);
		    }
		    {
			 E T12, T2W, T1i, T30, T17, T2X, T1d, T2Z;
			 {
			      E TZ, T11, TY, T10;
			      TZ = cr[WS(rs, 9)];
			      T11 = ci[WS(rs, 9)];
			      TY = W[16];
			      T10 = W[17];
			      T12 = FMA(TY, TZ, T10 * T11);
			      T2W = FNMS(T10, TZ, TY * T11);
			 }
			 {
			      E T1f, T1h, T1e, T1g;
			      T1f = cr[WS(rs, 19)];
			      T1h = ci[WS(rs, 19)];
			      T1e = W[36];
			      T1g = W[37];
			      T1i = FMA(T1e, T1f, T1g * T1h);
			      T30 = FNMS(T1g, T1f, T1e * T1h);
			 }
			 {
			      E T14, T16, T13, T15;
			      T14 = cr[WS(rs, 24)];
			      T16 = ci[WS(rs, 24)];
			      T13 = W[46];
			      T15 = W[47];
			      T17 = FMA(T13, T14, T15 * T16);
			      T2X = FNMS(T15, T14, T13 * T16);
			 }
			 {
			      E T1a, T1c, T19, T1b;
			      T1a = cr[WS(rs, 14)];
			      T1c = ci[WS(rs, 14)];
			      T19 = W[26];
			      T1b = W[27];
			      T1d = FMA(T19, T1a, T1b * T1c);
			      T2Z = FNMS(T1b, T1a, T19 * T1c);
			 }
			 T2T = T17 - T12;
			 T2U = T1d - T1i;
			 T3c = T2Z - T30;
			 T3b = T2W - T2X;
			 T2Y = T2W + T2X;
			 T31 = T2Z + T30;
			 T34 = T2Y + T31;
			 T18 = T12 + T17;
			 T1j = T1d + T1i;
			 T1k = T18 + T1j;
		    }
		    T1l = TX + T1k;
		    T5X = T33 + T34;
		    {
			 E T2V, T4S, T36, T4R, T32, T35;
			 T2V = FNMS(KP587785252, T2U, KP951056516 * T2T);
			 T4S = FMA(KP587785252, T2T, KP951056516 * T2U);
			 T32 = KP559016994 * (T2Y - T31);
			 T35 = FNMS(KP250000000, T34, T33);
			 T36 = T32 + T35;
			 T4R = T35 - T32;
			 T37 = T2V - T36;
			 T5v = T4S + T4R;
			 T4k = T2V + T36;
			 T4T = T4R - T4S;
		    }
		    {
			 E T3d, T4V, T3a, T4U, T38, T39;
			 T3d = FMA(KP951056516, T3b, KP587785252 * T3c);
			 T4V = FNMS(KP587785252, T3b, KP951056516 * T3c);
			 T38 = KP559016994 * (T18 - T1j);
			 T39 = FNMS(KP250000000, T1k, TX);
			 T3a = T38 + T39;
			 T4U = T39 - T38;
			 T3e = T3a - T3d;
			 T5w = T4U - T4V;
			 T4j = T3a + T3d;
			 T4W = T4U + T4V;
		    }
	       }
	       {
		    E T1r, T3r, T3h, T3i, T3A, T3z, T3m, T3p, T3s, T1C, T1N, T1O;
		    {
			 E T1o, T1q, T1n, T1p;
			 T1o = cr[WS(rs, 2)];
			 T1q = ci[WS(rs, 2)];
			 T1n = W[2];
			 T1p = W[3];
			 T1r = FMA(T1n, T1o, T1p * T1q);
			 T3r = FNMS(T1p, T1o, T1n * T1q);
		    }
		    {
			 E T1w, T3k, T1M, T3o, T1B, T3l, T1H, T3n;
			 {
			      E T1t, T1v, T1s, T1u;
			      T1t = cr[WS(rs, 7)];
			      T1v = ci[WS(rs, 7)];
			      T1s = W[12];
			      T1u = W[13];
			      T1w = FMA(T1s, T1t, T1u * T1v);
			      T3k = FNMS(T1u, T1t, T1s * T1v);
			 }
			 {
			      E T1J, T1L, T1I, T1K;
			      T1J = cr[WS(rs, 17)];
			      T1L = ci[WS(rs, 17)];
			      T1I = W[32];
			      T1K = W[33];
			      T1M = FMA(T1I, T1J, T1K * T1L);
			      T3o = FNMS(T1K, T1J, T1I * T1L);
			 }
			 {
			      E T1y, T1A, T1x, T1z;
			      T1y = cr[WS(rs, 22)];
			      T1A = ci[WS(rs, 22)];
			      T1x = W[42];
			      T1z = W[43];
			      T1B = FMA(T1x, T1y, T1z * T1A);
			      T3l = FNMS(T1z, T1y, T1x * T1A);
			 }
			 {
			      E T1E, T1G, T1D, T1F;
			      T1E = cr[WS(rs, 12)];
			      T1G = ci[WS(rs, 12)];
			      T1D = W[22];
			      T1F = W[23];
			      T1H = FMA(T1D, T1E, T1F * T1G);
			      T3n = FNMS(T1F, T1E, T1D * T1G);
			 }
			 T3h = T1w - T1B;
			 T3i = T1H - T1M;
			 T3A = T3n - T3o;
			 T3z = T3k - T3l;
			 T3m = T3k + T3l;
			 T3p = T3n + T3o;
			 T3s = T3m + T3p;
			 T1C = T1w + T1B;
			 T1N = T1H + T1M;
			 T1O = T1C + T1N;
		    }
		    T1P = T1r + T1O;
		    T5Z = T3r + T3s;
		    {
			 E T3j, T53, T3u, T52, T3q, T3t;
			 T3j = FMA(KP951056516, T3h, KP587785252 * T3i);
			 T53 = FNMS(KP587785252, T3h, KP951056516 * T3i);
			 T3q = KP559016994 * (T3m - T3p);
			 T3t = FNMS(KP250000000, T3s, T3r);
			 T3u = T3q + T3t;
			 T52 = T3t - T3q;
			 T3v = T3j + T3u;
			 T5A = T53 + T52;
			 T4o = T3u - T3j;
			 T54 = T52 - T53;
		    }
		    {
			 E T3B, T50, T3y, T4Z, T3w, T3x;
			 T3B = FMA(KP951056516, T3z, KP587785252 * T3A);
			 T50 = FNMS(KP587785252, T3z, KP951056516 * T3A);
			 T3w = KP559016994 * (T1C - T1N);
			 T3x = FNMS(KP250000000, T1O, T1r);
			 T3y = T3w + T3x;
			 T4Z = T3x - T3w;
			 T3C = T3y - T3B;
			 T5z = T4Z - T50;
			 T4n = T3y + T3B;
			 T51 = T4Z + T50;
		    }
	       }
	       {
		    E T62, T64, Tp, T2k, T5T, T5U, T63, T5V;
		    {
			 E T5Y, T61, T1m, T2j;
			 T5Y = T5W - T5X;
			 T61 = T5Z - T60;
			 T62 = FMA(KP951056516, T5Y, KP587785252 * T61);
			 T64 = FNMS(KP587785252, T5Y, KP951056516 * T61);
			 Tp = T1 + To;
			 T1m = TS + T1l;
			 T2j = T1P + T2i;
			 T2k = T1m + T2j;
			 T5T = KP559016994 * (T1m - T2j);
			 T5U = FNMS(KP250000000, T2k, Tp);
		    }
		    cr[0] = Tp + T2k;
		    T63 = T5U - T5T;
		    cr[WS(rs, 10)] = T63 - T64;
		    ci[WS(rs, 9)] = T63 + T64;
		    T5V = T5T + T5U;
		    ci[WS(rs, 4)] = T5V - T62;
		    cr[WS(rs, 5)] = T5V + T62;
	       }
	       {
		    E T2v, T4f, T6I, T6U, T42, T6Z, T43, T6Y, T4A, T6N, T4D, T6L, T4u, T6E, T4v;
		    E T6D, T48, T6V, T4b, T6T, T2n, T6G;
		    T2n = T2l + T2m;
		    T2v = T2n - T2u;
		    T4f = T2n + T2u;
		    T6G = T6g + T6f;
		    T6I = T6G - T6H;
		    T6U = T6H + T6G;
		    {
			 E T2S, T3f, T3g, T3D, T40, T41;
			 T2S = FMA(KP535826794, T2G, KP844327925 * T2R);
			 T3f = FNMS(KP637423989, T3e, KP770513242 * T37);
			 T3g = T2S + T3f;
			 T3D = FNMS(KP425779291, T3C, KP904827052 * T3v);
			 T40 = FNMS(KP992114701, T3Z, KP125333233 * T3S);
			 T41 = T3D + T40;
			 T42 = T3g + T41;
			 T6Z = T3D - T40;
			 T43 = KP559016994 * (T3g - T41);
			 T6Y = T3f - T2S;
		    }
		    {
			 E T4y, T4z, T6J, T4B, T4C, T6K;
			 T4y = FNMS(KP248689887, T4g, KP968583161 * T4h);
			 T4z = FNMS(KP844327925, T4j, KP535826794 * T4k);
			 T6J = T4y + T4z;
			 T4B = FNMS(KP481753674, T4n, KP876306680 * T4o);
			 T4C = FNMS(KP684547105, T4q, KP728968627 * T4r);
			 T6K = T4B + T4C;
			 T4A = T4y - T4z;
			 T6N = KP559016994 * (T6J - T6K);
			 T4D = T4B - T4C;
			 T6L = T6J + T6K;
		    }
		    {
			 E T4i, T4l, T4m, T4p, T4s, T4t;
			 T4i = FMA(KP968583161, T4g, KP248689887 * T4h);
			 T4l = FMA(KP535826794, T4j, KP844327925 * T4k);
			 T4m = T4i + T4l;
			 T4p = FMA(KP876306680, T4n, KP481753674 * T4o);
			 T4s = FMA(KP728968627, T4q, KP684547105 * T4r);
			 T4t = T4p + T4s;
			 T4u = T4m + T4t;
			 T6E = T4p - T4s;
			 T4v = KP559016994 * (T4m - T4t);
			 T6D = T4l - T4i;
		    }
		    {
			 E T46, T47, T6R, T49, T4a, T6S;
			 T46 = FNMS(KP844327925, T2G, KP535826794 * T2R);
			 T47 = FMA(KP770513242, T3e, KP637423989 * T37);
			 T6R = T46 + T47;
			 T49 = FMA(KP125333233, T3Z, KP992114701 * T3S);
			 T4a = FMA(KP904827052, T3C, KP425779291 * T3v);
			 T6S = T4a + T49;
			 T48 = T46 - T47;
			 T6V = T6R - T6S;
			 T4b = T49 - T4a;
			 T6T = KP559016994 * (T6R + T6S);
		    }
		    cr[WS(rs, 4)] = T2v + T42;
		    ci[WS(rs, 23)] = T6L + T6I;
		    ci[WS(rs, 20)] = T6V + T6U;
		    cr[WS(rs, 1)] = T4f + T4u;
		    {
			 E T4c, T4e, T45, T4d, T44;
			 T4c = FMA(KP951056516, T48, KP587785252 * T4b);
			 T4e = FNMS(KP587785252, T48, KP951056516 * T4b);
			 T44 = FNMS(KP250000000, T42, T2v);
			 T45 = T43 + T44;
			 T4d = T44 - T43;
			 ci[0] = T45 - T4c;
			 ci[WS(rs, 5)] = T4d + T4e;
			 cr[WS(rs, 9)] = T45 + T4c;
			 ci[WS(rs, 10)] = T4d - T4e;
		    }
		    {
			 E T6F, T6P, T6O, T6Q, T6M;
			 T6F = FMA(KP587785252, T6D, KP951056516 * T6E);
			 T6P = FNMS(KP587785252, T6E, KP951056516 * T6D);
			 T6M = FNMS(KP250000000, T6L, T6I);
			 T6O = T6M - T6N;
			 T6Q = T6N + T6M;
			 cr[WS(rs, 16)] = T6F - T6O;
			 ci[WS(rs, 18)] = T6P + T6Q;
			 ci[WS(rs, 13)] = T6F + T6O;
			 cr[WS(rs, 21)] = T6P - T6Q;
		    }
		    {
			 E T70, T71, T6X, T72, T6W;
			 T70 = FMA(KP587785252, T6Y, KP951056516 * T6Z);
			 T71 = FNMS(KP587785252, T6Z, KP951056516 * T6Y);
			 T6W = FNMS(KP250000000, T6V, T6U);
			 T6X = T6T - T6W;
			 T72 = T6T + T6W;
			 cr[WS(rs, 14)] = T6X - T70;
			 ci[WS(rs, 15)] = T71 + T72;
			 cr[WS(rs, 19)] = T70 + T6X;
			 cr[WS(rs, 24)] = T71 - T72;
		    }
		    {
			 E T4E, T4G, T4x, T4F, T4w;
			 T4E = FMA(KP951056516, T4A, KP587785252 * T4D);
			 T4G = FNMS(KP587785252, T4A, KP951056516 * T4D);
			 T4w = FNMS(KP250000000, T4u, T4f);
			 T4x = T4v + T4w;
			 T4F = T4w - T4v;
			 ci[WS(rs, 3)] = T4x - T4E;
			 ci[WS(rs, 8)] = T4F + T4G;
			 cr[WS(rs, 6)] = T4x + T4E;
			 cr[WS(rs, 11)] = T4F - T4G;
		    }
	       }
	       {
		    E T75, T7d, T76, T79, T7a, T7b, T7e, T7c;
		    {
			 E T73, T74, T77, T78;
			 T73 = T1l - TS;
			 T74 = T1P - T2i;
			 T75 = FMA(KP587785252, T73, KP951056516 * T74);
			 T7d = FNMS(KP587785252, T74, KP951056516 * T73);
			 T76 = T6e + T6b;
			 T77 = T5W + T5X;
			 T78 = T5Z + T60;
			 T79 = T77 + T78;
			 T7a = FNMS(KP250000000, T79, T76);
			 T7b = KP559016994 * (T77 - T78);
		    }
		    ci[WS(rs, 24)] = T79 + T76;
		    T7e = T7b + T7a;
		    cr[WS(rs, 20)] = T7d - T7e;
		    ci[WS(rs, 19)] = T7d + T7e;
		    T7c = T7a - T7b;
		    cr[WS(rs, 15)] = T75 - T7c;
		    ci[WS(rs, 14)] = T75 + T7c;
	       }
	       {
		    E T4J, T5r, T6i, T6u, T5e, T6z, T5f, T6y, T5M, T6n, T5P, T6l, T5G, T66, T5H;
		    E T65, T5k, T6v, T5n, T6t, T4H, T6h;
		    T4H = T2m - T2l;
		    T4J = T4H + T4I;
		    T5r = T4H - T4I;
		    T6h = T6f - T6g;
		    T6i = T6a + T6h;
		    T6u = T6h - T6a;
		    {
			 E T4Q, T4X, T4Y, T55, T5c, T5d;
			 T4Q = FMA(KP728968627, T4M, KP684547105 * T4P);
			 T4X = FNMS(KP992114701, T4W, KP125333233 * T4T);
			 T4Y = T4Q + T4X;
			 T55 = FMA(KP062790519, T51, KP998026728 * T54);
			 T5c = FNMS(KP637423989, T5b, KP770513242 * T58);
			 T5d = T55 + T5c;
			 T5e = T4Y + T5d;
			 T6z = T55 - T5c;
			 T5f = KP559016994 * (T4Y - T5d);
			 T6y = T4X - T4Q;
		    }
		    {
			 E T5K, T5L, T6j, T5N, T5O, T6k;
			 T5K = FNMS(KP481753674, T5s, KP876306680 * T5t);
			 T5L = FMA(KP904827052, T5w, KP425779291 * T5v);
			 T6j = T5K - T5L;
			 T5N = FNMS(KP844327925, T5z, KP535826794 * T5A);
			 T5O = FNMS(KP998026728, T5C, KP062790519 * T5D);
			 T6k = T5N + T5O;
			 T5M = T5K + T5L;
			 T6n = KP559016994 * (T6j - T6k);
			 T5P = T5N - T5O;
			 T6l = T6j + T6k;
		    }
		    {
			 E T5u, T5x, T5y, T5B, T5E, T5F;
			 T5u = FMA(KP876306680, T5s, KP481753674 * T5t);
			 T5x = FNMS(KP425779291, T5w, KP904827052 * T5v);
			 T5y = T5u + T5x;
			 T5B = FMA(KP535826794, T5z, KP844327925 * T5A);
			 T5E = FMA(KP062790519, T5C, KP998026728 * T5D);
			 T5F = T5B + T5E;
			 T5G = T5y + T5F;
			 T66 = T5B - T5E;
			 T5H = KP559016994 * (T5y - T5F);
			 T65 = T5x - T5u;
		    }
		    {
			 E T5i, T5j, T6r, T5l, T5m, T6s;
			 T5i = FNMS(KP684547105, T4M, KP728968627 * T4P);
			 T5j = FMA(KP125333233, T4W, KP992114701 * T4T);
			 T6r = T5i - T5j;
			 T5l = FNMS(KP998026728, T51, KP062790519 * T54);
			 T5m = FMA(KP770513242, T5b, KP637423989 * T58);
			 T6s = T5l - T5m;
			 T5k = T5i + T5j;
			 T6v = T6r + T6s;
			 T5n = T5l + T5m;
			 T6t = KP559016994 * (T6r - T6s);
		    }
		    cr[WS(rs, 3)] = T4J + T5e;
		    ci[WS(rs, 22)] = T6l + T6i;
		    ci[WS(rs, 21)] = T6v + T6u;
		    cr[WS(rs, 2)] = T5r + T5G;
		    {
			 E T67, T6p, T6o, T6q, T6m;
			 T67 = FMA(KP587785252, T65, KP951056516 * T66);
			 T6p = FNMS(KP587785252, T66, KP951056516 * T65);
			 T6m = FNMS(KP250000000, T6l, T6i);
			 T6o = T6m - T6n;
			 T6q = T6n + T6m;
			 cr[WS(rs, 17)] = T67 - T6o;
			 ci[WS(rs, 17)] = T6p + T6q;
			 ci[WS(rs, 12)] = T67 + T6o;
			 cr[WS(rs, 22)] = T6p - T6q;
		    }
		    {
			 E T5Q, T5S, T5J, T5R, T5I;
			 T5Q = FMA(KP951056516, T5M, KP587785252 * T5P);
			 T5S = FNMS(KP587785252, T5M, KP951056516 * T5P);
			 T5I = FNMS(KP250000000, T5G, T5r);
			 T5J = T5H + T5I;
			 T5R = T5I - T5H;
			 ci[WS(rs, 2)] = T5J - T5Q;
			 ci[WS(rs, 7)] = T5R + T5S;
			 cr[WS(rs, 7)] = T5J + T5Q;
			 cr[WS(rs, 12)] = T5R - T5S;
		    }
		    {
			 E T5o, T5q, T5h, T5p, T5g;
			 T5o = FMA(KP951056516, T5k, KP587785252 * T5n);
			 T5q = FNMS(KP587785252, T5k, KP951056516 * T5n);
			 T5g = FNMS(KP250000000, T5e, T4J);
			 T5h = T5f + T5g;
			 T5p = T5g - T5f;
			 ci[WS(rs, 1)] = T5h - T5o;
			 ci[WS(rs, 6)] = T5p + T5q;
			 cr[WS(rs, 8)] = T5h + T5o;
			 ci[WS(rs, 11)] = T5p - T5q;
		    }
		    {
			 E T6A, T6B, T6x, T6C, T6w;
			 T6A = FMA(KP587785252, T6y, KP951056516 * T6z);
			 T6B = FNMS(KP587785252, T6z, KP951056516 * T6y);
			 T6w = FNMS(KP250000000, T6v, T6u);
			 T6x = T6t - T6w;
			 T6C = T6t + T6w;
			 cr[WS(rs, 13)] = T6x - T6A;
			 ci[WS(rs, 16)] = T6B + T6C;
			 cr[WS(rs, 18)] = T6A + T6x;
			 cr[WS(rs, 23)] = T6B - T6C;
		    }
	       }
	  }
     }
}

static const tw_instr twinstr[] = {
     { TW_FULL, 1, 25 },
     { TW_NEXT, 1, 0 }
};

static const hc2hc_desc desc = { 25, "hf_25", twinstr, &GENUS, { 260, 140, 140, 0 } };

void X(codelet_hf_25) (planner *p) {
     X(khc2hc_register) (p, hf_25, &desc);
}
#endif
