/* valareport.c generated by valac, the Vala compiler
 * generated from valareport.vala, do not modify */

/* valareport.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <stdio.h>
#include <stdarg.h>
#include <gmodule.h>
#include <gobject/gvaluecollector.h>

#define VALA_REPORT_ANSI_COLOR_END "\x1b[0m"

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _g_module_close0(var) ((var == NULL) ? NULL : (var = (g_module_close (var), NULL)))
typedef gint (*ValaReportAttyFunc) (gint fd);
typedef struct _ValaParamSpecReport ValaParamSpecReport;

struct _ValaReportPrivate {
	gchar* locus_color_start;
	const gchar* locus_color_end;
	gchar* warning_color_start;
	const gchar* warning_color_end;
	gchar* error_color_start;
	const gchar* error_color_end;
	gchar* note_color_start;
	const gchar* note_color_end;
	gchar* caret_color_start;
	const gchar* caret_color_end;
	gchar* quote_color_start;
	const gchar* quote_color_end;
	gboolean verbose_errors;
	gboolean _enable_warnings;
};

struct _ValaParamSpecReport {
	GParamSpec parent_instance;
};

static gint ValaReport_private_offset;
static gpointer vala_report_parent_class = NULL;
static GRegex* vala_report_val_regex;
static GRegex* vala_report_val_regex = NULL;

static gboolean vala_report_is_atty (ValaReport* self,
                              gint fd);
static void vala_report_report_source (ValaReport* self,
                                ValaSourceReference* source);
static void vala_report_print_highlighted_message (ValaReport* self,
                                            const gchar* message);
static void vala_report_print_message (ValaReport* self,
                                ValaSourceReference* source,
                                const gchar* type,
                                const gchar* type_color_start,
                                const gchar* type_color_end,
                                const gchar* message,
                                gboolean do_report_source);
static void vala_report_real_note (ValaReport* self,
                            ValaSourceReference* source,
                            const gchar* message);
static void vala_report_real_depr (ValaReport* self,
                            ValaSourceReference* source,
                            const gchar* message);
static void vala_report_real_warn (ValaReport* self,
                            ValaSourceReference* source,
                            const gchar* message);
static void vala_report_real_err (ValaReport* self,
                           ValaSourceReference* source,
                           const gchar* message);
static void vala_report_finalize (ValaReport * obj);
static GType vala_report_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
vala_report_get_instance_private (ValaReport* self)
{
	return G_STRUCT_MEMBER_P (self, ValaReport_private_offset);
}

static GType
vala_report_colored_get_type_once (void)
{
	static const GEnumValue values[] = {{VALA_REPORT_COLORED_AUTO, "VALA_REPORT_COLORED_AUTO", "auto"}, {VALA_REPORT_COLORED_NEVER, "VALA_REPORT_COLORED_NEVER", "never"}, {VALA_REPORT_COLORED_ALWAYS, "VALA_REPORT_COLORED_ALWAYS", "always"}, {0, NULL, NULL}};
	GType vala_report_colored_type_id;
	vala_report_colored_type_id = g_enum_register_static ("ValaReportColored", values);
	return vala_report_colored_type_id;
}

GType
vala_report_colored_get_type (void)
{
	static volatile gsize vala_report_colored_type_id__volatile = 0;
	if (g_once_init_enter (&vala_report_colored_type_id__volatile)) {
		GType vala_report_colored_type_id;
		vala_report_colored_type_id = vala_report_colored_get_type_once ();
		g_once_init_leave (&vala_report_colored_type_id__volatile, vala_report_colored_type_id);
	}
	return vala_report_colored_type_id__volatile;
}

gboolean
vala_report_get_enable_warnings (ValaReport* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_enable_warnings;
	return result;
}

void
vala_report_set_enable_warnings (ValaReport* self,
                                 gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_enable_warnings = value;
}

/**
 * Set all colors by string
 *
 * {{{
 *   "error=01;31:warning=01;35:note=01;36:caret=01;32:locus=01:quote=01"
 * }}}
 */
gboolean
vala_report_set_colors (ValaReport* self,
                        const gchar* str,
                        ValaReportColored colored_output)
{
	gchar* error_color = NULL;
	gchar* warning_color = NULL;
	gchar* note_color = NULL;
	gchar* caret_color = NULL;
	gchar* locus_color = NULL;
	gchar* quote_color = NULL;
	gchar** fragments = NULL;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint fragments_length1;
	gint _fragments_size_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gboolean _tmp37_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (str != NULL, FALSE);
	{
		GRegex* _tmp0_;
		_tmp0_ = vala_report_val_regex;
		if (_tmp0_ == NULL) {
			GRegex* _tmp1_ = NULL;
			GRegex* _tmp2_;
			GRegex* _tmp4_;
			_tmp2_ = g_regex_new ("^\\s*[0-9]+(;[0-9]*)*\\s*$", 0, 0, &_inner_error0_);
			_tmp1_ = _tmp2_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp3_ = FALSE;
				if (_inner_error0_->domain == G_REGEX_ERROR) {
					goto __catch0_g_regex_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp3_;
			}
			_tmp4_ = _tmp1_;
			_tmp1_ = NULL;
			_g_regex_unref0 (vala_report_val_regex);
			vala_report_val_regex = _tmp4_;
			_g_regex_unref0 (_tmp1_);
		}
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp5_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp5_;
	}
	error_color = NULL;
	warning_color = NULL;
	note_color = NULL;
	caret_color = NULL;
	locus_color = NULL;
	quote_color = NULL;
	_tmp7_ = _tmp6_ = g_strsplit (str, ":", 0);
	fragments = _tmp7_;
	fragments_length1 = _vala_array_length (_tmp6_);
	_fragments_size_ = fragments_length1;
	_tmp8_ = fragments;
	_tmp8__length1 = fragments_length1;
	{
		gchar** fragment_collection = NULL;
		gint fragment_collection_length1 = 0;
		gint _fragment_collection_size_ = 0;
		gint fragment_it = 0;
		fragment_collection = _tmp8_;
		fragment_collection_length1 = _tmp8__length1;
		for (fragment_it = 0; fragment_it < fragment_collection_length1; fragment_it = fragment_it + 1) {
			const gchar* fragment = NULL;
			fragment = fragment_collection[fragment_it];
			{
				gchar** eq = NULL;
				const gchar* _tmp9_;
				gchar** _tmp10_;
				gchar** _tmp11_;
				gint eq_length1;
				gint _eq_size_;
				gchar** _tmp12_;
				gint _tmp12__length1;
				GRegex* _tmp13_;
				gchar** _tmp14_;
				gint _tmp14__length1;
				const gchar* _tmp15_;
				const gchar* checked_value = NULL;
				gchar** _tmp16_;
				gint _tmp16__length1;
				const gchar* _tmp17_;
				const gchar* _tmp18_;
				gchar** _tmp19_;
				gint _tmp19__length1;
				const gchar* _tmp20_;
				const gchar* _tmp21_;
				const gchar* _tmp22_;
				GQuark _tmp24_ = 0U;
				static GQuark _tmp23_label0 = 0;
				static GQuark _tmp23_label1 = 0;
				static GQuark _tmp23_label2 = 0;
				static GQuark _tmp23_label3 = 0;
				static GQuark _tmp23_label4 = 0;
				static GQuark _tmp23_label5 = 0;
				_tmp9_ = fragment;
				_tmp11_ = _tmp10_ = g_strsplit (_tmp9_, "=", 2);
				eq = _tmp11_;
				eq_length1 = _vala_array_length (_tmp10_);
				_eq_size_ = eq_length1;
				_tmp12_ = eq;
				_tmp12__length1 = eq_length1;
				if (_tmp12__length1 != 2) {
					result = FALSE;
					eq = (_vala_array_free (eq, eq_length1, (GDestroyNotify) g_free), NULL);
					fragments = (_vala_array_free (fragments, fragments_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (quote_color);
					_g_free0 (locus_color);
					_g_free0 (caret_color);
					_g_free0 (note_color);
					_g_free0 (warning_color);
					_g_free0 (error_color);
					return result;
				}
				_tmp13_ = vala_report_val_regex;
				_tmp14_ = eq;
				_tmp14__length1 = eq_length1;
				_tmp15_ = _tmp14_[1];
				if (!g_regex_match (_tmp13_, _tmp15_, 0, NULL)) {
					result = FALSE;
					eq = (_vala_array_free (eq, eq_length1, (GDestroyNotify) g_free), NULL);
					fragments = (_vala_array_free (fragments, fragments_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (quote_color);
					_g_free0 (locus_color);
					_g_free0 (caret_color);
					_g_free0 (note_color);
					_g_free0 (warning_color);
					_g_free0 (error_color);
					return result;
				}
				_tmp16_ = eq;
				_tmp16__length1 = eq_length1;
				_tmp17_ = _tmp16_[1];
				_tmp18_ = g_strstrip (_tmp17_);
				checked_value = _tmp18_;
				_tmp19_ = eq;
				_tmp19__length1 = eq_length1;
				_tmp20_ = _tmp19_[0];
				_tmp21_ = g_strstrip (_tmp20_);
				_tmp22_ = _tmp21_;
				_tmp24_ = (NULL == _tmp22_) ? 0 : g_quark_from_string (_tmp22_);
				if (_tmp24_ == ((0 != _tmp23_label0) ? _tmp23_label0 : (_tmp23_label0 = g_quark_from_static_string ("error")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp25_;
							gchar* _tmp26_;
							_tmp25_ = checked_value;
							_tmp26_ = g_strdup (_tmp25_);
							_g_free0 (error_color);
							error_color = _tmp26_;
							break;
						}
					}
				} else if (_tmp24_ == ((0 != _tmp23_label1) ? _tmp23_label1 : (_tmp23_label1 = g_quark_from_static_string ("warning")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp27_;
							gchar* _tmp28_;
							_tmp27_ = checked_value;
							_tmp28_ = g_strdup (_tmp27_);
							_g_free0 (warning_color);
							warning_color = _tmp28_;
							break;
						}
					}
				} else if (_tmp24_ == ((0 != _tmp23_label2) ? _tmp23_label2 : (_tmp23_label2 = g_quark_from_static_string ("note")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp29_;
							gchar* _tmp30_;
							_tmp29_ = checked_value;
							_tmp30_ = g_strdup (_tmp29_);
							_g_free0 (note_color);
							note_color = _tmp30_;
							break;
						}
					}
				} else if (_tmp24_ == ((0 != _tmp23_label3) ? _tmp23_label3 : (_tmp23_label3 = g_quark_from_static_string ("caret")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp31_;
							gchar* _tmp32_;
							_tmp31_ = checked_value;
							_tmp32_ = g_strdup (_tmp31_);
							_g_free0 (caret_color);
							caret_color = _tmp32_;
							break;
						}
					}
				} else if (_tmp24_ == ((0 != _tmp23_label4) ? _tmp23_label4 : (_tmp23_label4 = g_quark_from_static_string ("locus")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp33_;
							gchar* _tmp34_;
							_tmp33_ = checked_value;
							_tmp34_ = g_strdup (_tmp33_);
							_g_free0 (locus_color);
							locus_color = _tmp34_;
							break;
						}
					}
				} else if (_tmp24_ == ((0 != _tmp23_label5) ? _tmp23_label5 : (_tmp23_label5 = g_quark_from_static_string ("quote")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp35_;
							gchar* _tmp36_;
							_tmp35_ = checked_value;
							_tmp36_ = g_strdup (_tmp35_);
							_g_free0 (quote_color);
							quote_color = _tmp36_;
							break;
						}
					}
				} else {
					switch (0) {
						default:
						{
							result = FALSE;
							eq = (_vala_array_free (eq, eq_length1, (GDestroyNotify) g_free), NULL);
							fragments = (_vala_array_free (fragments, fragments_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (quote_color);
							_g_free0 (locus_color);
							_g_free0 (caret_color);
							_g_free0 (note_color);
							_g_free0 (warning_color);
							_g_free0 (error_color);
							return result;
						}
					}
				}
				eq = (_vala_array_free (eq, eq_length1, (GDestroyNotify) g_free), NULL);
			}
		}
	}
	if (colored_output == VALA_REPORT_COLORED_ALWAYS) {
		_tmp37_ = TRUE;
	} else {
		gboolean _tmp38_ = FALSE;
		if (colored_output == VALA_REPORT_COLORED_AUTO) {
			FILE* _tmp39_;
			_tmp39_ = stderr;
			_tmp38_ = vala_report_is_atty (self, fileno (_tmp39_));
		} else {
			_tmp38_ = FALSE;
		}
		_tmp37_ = _tmp38_;
	}
	if (_tmp37_) {
		const gchar* _tmp40_;
		const gchar* _tmp45_;
		const gchar* _tmp50_;
		const gchar* _tmp55_;
		const gchar* _tmp60_;
		const gchar* _tmp65_;
		_tmp40_ = error_color;
		if (_tmp40_ != NULL) {
			const gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			_tmp41_ = error_color;
			_tmp42_ = g_strconcat ("\x1b[0", _tmp41_, NULL);
			_tmp43_ = _tmp42_;
			_tmp44_ = g_strconcat (_tmp43_, "m", NULL);
			_g_free0 (self->priv->error_color_start);
			self->priv->error_color_start = _tmp44_;
			_g_free0 (_tmp43_);
			self->priv->error_color_end = VALA_REPORT_ANSI_COLOR_END;
		}
		_tmp45_ = warning_color;
		if (_tmp45_ != NULL) {
			const gchar* _tmp46_;
			gchar* _tmp47_;
			gchar* _tmp48_;
			gchar* _tmp49_;
			_tmp46_ = warning_color;
			_tmp47_ = g_strconcat ("\x1b[0", _tmp46_, NULL);
			_tmp48_ = _tmp47_;
			_tmp49_ = g_strconcat (_tmp48_, "m", NULL);
			_g_free0 (self->priv->warning_color_start);
			self->priv->warning_color_start = _tmp49_;
			_g_free0 (_tmp48_);
			self->priv->warning_color_end = VALA_REPORT_ANSI_COLOR_END;
		}
		_tmp50_ = note_color;
		if (_tmp50_ != NULL) {
			const gchar* _tmp51_;
			gchar* _tmp52_;
			gchar* _tmp53_;
			gchar* _tmp54_;
			_tmp51_ = note_color;
			_tmp52_ = g_strconcat ("\x1b[0", _tmp51_, NULL);
			_tmp53_ = _tmp52_;
			_tmp54_ = g_strconcat (_tmp53_, "m", NULL);
			_g_free0 (self->priv->note_color_start);
			self->priv->note_color_start = _tmp54_;
			_g_free0 (_tmp53_);
			self->priv->note_color_end = VALA_REPORT_ANSI_COLOR_END;
		}
		_tmp55_ = caret_color;
		if (_tmp55_ != NULL) {
			const gchar* _tmp56_;
			gchar* _tmp57_;
			gchar* _tmp58_;
			gchar* _tmp59_;
			_tmp56_ = caret_color;
			_tmp57_ = g_strconcat ("\x1b[0", _tmp56_, NULL);
			_tmp58_ = _tmp57_;
			_tmp59_ = g_strconcat (_tmp58_, "m", NULL);
			_g_free0 (self->priv->caret_color_start);
			self->priv->caret_color_start = _tmp59_;
			_g_free0 (_tmp58_);
			self->priv->caret_color_end = VALA_REPORT_ANSI_COLOR_END;
		}
		_tmp60_ = locus_color;
		if (_tmp60_ != NULL) {
			const gchar* _tmp61_;
			gchar* _tmp62_;
			gchar* _tmp63_;
			gchar* _tmp64_;
			_tmp61_ = locus_color;
			_tmp62_ = g_strconcat ("\x1b[0", _tmp61_, NULL);
			_tmp63_ = _tmp62_;
			_tmp64_ = g_strconcat (_tmp63_, "m", NULL);
			_g_free0 (self->priv->locus_color_start);
			self->priv->locus_color_start = _tmp64_;
			_g_free0 (_tmp63_);
			self->priv->locus_color_end = VALA_REPORT_ANSI_COLOR_END;
		}
		_tmp65_ = quote_color;
		if (_tmp65_ != NULL) {
			const gchar* _tmp66_;
			gchar* _tmp67_;
			gchar* _tmp68_;
			gchar* _tmp69_;
			_tmp66_ = quote_color;
			_tmp67_ = g_strconcat ("\x1b[0", _tmp66_, NULL);
			_tmp68_ = _tmp67_;
			_tmp69_ = g_strconcat (_tmp68_, "m", NULL);
			_g_free0 (self->priv->quote_color_start);
			self->priv->quote_color_start = _tmp69_;
			_g_free0 (_tmp68_);
			self->priv->quote_color_end = VALA_REPORT_ANSI_COLOR_END;
		}
	}
	result = TRUE;
	fragments = (_vala_array_free (fragments, fragments_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (quote_color);
	_g_free0 (locus_color);
	_g_free0 (caret_color);
	_g_free0 (note_color);
	_g_free0 (warning_color);
	_g_free0 (error_color);
	return result;
}

/**
 * Set the error verbosity.
 */
void
vala_report_set_verbose_errors (ValaReport* self,
                                gboolean verbose)
{
	g_return_if_fail (self != NULL);
	self->priv->verbose_errors = verbose;
}

/**
 * Returns the total number of warnings reported.
 */
gint
vala_report_get_warnings (ValaReport* self)
{
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	result = self->warnings;
	return result;
}

/**
 * Returns the total number of errors reported.
 */
gint
vala_report_get_errors (ValaReport* self)
{
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	result = self->errors;
	return result;
}

/**
 * Pretty-print the actual line of offending code if possible.
 */
static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static void
vala_report_report_source (ValaReport* self,
                           ValaSourceReference* source)
{
	ValaSourceLocation _tmp0_ = {0};
	ValaSourceLocation _tmp1_;
	ValaSourceLocation _tmp2_ = {0};
	ValaSourceLocation _tmp3_;
	gchar* offending_line = NULL;
	ValaSourceFile* _tmp4_;
	ValaSourceFile* _tmp5_;
	ValaSourceLocation _tmp6_ = {0};
	ValaSourceLocation _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	vala_source_reference_get_begin (source, &_tmp0_);
	_tmp1_ = _tmp0_;
	vala_source_reference_get_end (source, &_tmp2_);
	_tmp3_ = _tmp2_;
	if (_tmp1_.line != _tmp3_.line) {
		return;
	}
	_tmp4_ = vala_source_reference_get_file (source);
	_tmp5_ = _tmp4_;
	vala_source_reference_get_begin (source, &_tmp6_);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_source_file_get_source_line (_tmp5_, _tmp7_.line);
	offending_line = _tmp8_;
	_tmp9_ = offending_line;
	if (_tmp9_ != NULL) {
		FILE* _tmp10_;
		const gchar* _tmp11_;
		gint idx = 0;
		FILE* _tmp19_;
		const gchar* _tmp20_;
		FILE* _tmp30_;
		const gchar* _tmp31_;
		FILE* _tmp32_;
		_tmp10_ = stderr;
		_tmp11_ = offending_line;
		fprintf (_tmp10_, "%s\n", _tmp11_);
		{
			gboolean _tmp12_ = FALSE;
			idx = 1;
			_tmp12_ = TRUE;
			while (TRUE) {
				ValaSourceLocation _tmp14_ = {0};
				ValaSourceLocation _tmp15_;
				const gchar* _tmp16_;
				if (!_tmp12_) {
					gint _tmp13_;
					idx = idx + 1;
					_tmp13_ = idx;
				}
				_tmp12_ = FALSE;
				vala_source_reference_get_begin (source, &_tmp14_);
				_tmp15_ = _tmp14_;
				if (!(idx < _tmp15_.column)) {
					break;
				}
				_tmp16_ = offending_line;
				if (string_get (_tmp16_, (glong) (idx - 1)) == '\t') {
					FILE* _tmp17_;
					_tmp17_ = stderr;
					fprintf (_tmp17_, "\t");
				} else {
					FILE* _tmp18_;
					_tmp18_ = stderr;
					fprintf (_tmp18_, " ");
				}
			}
		}
		_tmp19_ = stderr;
		_tmp20_ = self->priv->caret_color_start;
		fputs (_tmp20_, _tmp19_);
		{
			ValaSourceLocation _tmp21_ = {0};
			ValaSourceLocation _tmp22_;
			gboolean _tmp23_ = FALSE;
			vala_source_reference_get_begin (source, &_tmp21_);
			_tmp22_ = _tmp21_;
			idx = _tmp22_.column;
			_tmp23_ = TRUE;
			while (TRUE) {
				ValaSourceLocation _tmp25_ = {0};
				ValaSourceLocation _tmp26_;
				const gchar* _tmp27_;
				if (!_tmp23_) {
					gint _tmp24_;
					idx = idx + 1;
					_tmp24_ = idx;
				}
				_tmp23_ = FALSE;
				vala_source_reference_get_end (source, &_tmp25_);
				_tmp26_ = _tmp25_;
				if (!(idx <= _tmp26_.column)) {
					break;
				}
				_tmp27_ = offending_line;
				if (string_get (_tmp27_, (glong) (idx - 1)) == '\t') {
					FILE* _tmp28_;
					_tmp28_ = stderr;
					fprintf (_tmp28_, "\t");
				} else {
					FILE* _tmp29_;
					_tmp29_ = stderr;
					fprintf (_tmp29_, "^");
				}
			}
		}
		_tmp30_ = stderr;
		_tmp31_ = self->priv->caret_color_end;
		fputs (_tmp31_, _tmp30_);
		_tmp32_ = stderr;
		fprintf (_tmp32_, "\n");
	}
	_g_free0 (offending_line);
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gint
string_index_of_char (const gchar* self,
                      gunichar c,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static const gchar*
string_offset (const gchar* self,
               glong offset)
{
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = (const gchar*) (((gchar*) self) + offset);
	return result;
}

static void
vala_report_print_highlighted_message (ValaReport* self,
                                       const gchar* message)
{
	gint start = 0;
	gint cur = 0;
	FILE* _tmp19_;
	const gchar* _tmp20_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	start = 0;
	cur = 0;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		if (!(string_get (message, (glong) cur) != '\0')) {
			break;
		}
		if (string_get (message, (glong) cur) == '\'') {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = string_get (message, (glong) cur) == '`';
		}
		if (_tmp0_) {
			const gchar* _tmp1_ = NULL;
			const gchar* end_chars = NULL;
			FILE* _tmp2_;
			gchar* _tmp3_;
			gchar* _tmp4_;
			gint _tmp5_;
			if (string_get (message, (glong) cur) == '`') {
				_tmp1_ = "`'";
			} else {
				_tmp1_ = "'";
			}
			end_chars = _tmp1_;
			_tmp2_ = stderr;
			_tmp3_ = string_substring (message, (glong) start, (glong) (cur - start));
			_tmp4_ = _tmp3_;
			fputs (_tmp4_, _tmp2_);
			_g_free0 (_tmp4_);
			start = cur;
			_tmp5_ = cur;
			cur = _tmp5_ + 1;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gint _tmp8_;
				if (string_get (message, (glong) cur) != '\0') {
					const gchar* _tmp7_;
					_tmp7_ = end_chars;
					_tmp6_ = string_index_of_char (_tmp7_, (gunichar) string_get (message, (glong) cur), 0) < 0;
				} else {
					_tmp6_ = FALSE;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp8_ = cur;
				cur = _tmp8_ + 1;
			}
			if (string_get (message, (glong) cur) == '\0') {
				FILE* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				_tmp9_ = stderr;
				_tmp10_ = string_substring (message, (glong) start, (glong) (cur - start));
				_tmp11_ = _tmp10_;
				fputs (_tmp11_, _tmp9_);
				_g_free0 (_tmp11_);
				start = cur;
			} else {
				gint _tmp12_;
				FILE* _tmp13_;
				const gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				const gchar* _tmp17_;
				_tmp12_ = cur;
				cur = _tmp12_ + 1;
				_tmp13_ = stderr;
				_tmp14_ = self->priv->quote_color_start;
				_tmp15_ = string_substring (message, (glong) start, (glong) (cur - start));
				_tmp16_ = _tmp15_;
				_tmp17_ = self->priv->quote_color_end;
				fprintf (_tmp13_, "%s%s%s", _tmp14_, _tmp16_, _tmp17_);
				_g_free0 (_tmp16_);
				start = cur;
			}
		} else {
			gint _tmp18_;
			_tmp18_ = cur;
			cur = _tmp18_ + 1;
		}
	}
	_tmp19_ = stderr;
	_tmp20_ = string_offset (message, (glong) start);
	fputs (_tmp20_, _tmp19_);
}

static void
vala_report_print_message (ValaReport* self,
                           ValaSourceReference* source,
                           const gchar* type,
                           const gchar* type_color_start,
                           const gchar* type_color_end,
                           const gchar* message,
                           gboolean do_report_source)
{
	FILE* _tmp5_;
	FILE* _tmp6_;
	gboolean _tmp7_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	g_return_if_fail (type_color_start != NULL);
	g_return_if_fail (type_color_end != NULL);
	g_return_if_fail (message != NULL);
	if (source != NULL) {
		FILE* _tmp0_;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp0_ = stderr;
		_tmp1_ = self->priv->locus_color_start;
		_tmp2_ = vala_source_reference_to_string (source);
		_tmp3_ = _tmp2_;
		_tmp4_ = self->priv->locus_color_end;
		fprintf (_tmp0_, "%s%s:%s ", _tmp1_, _tmp3_, _tmp4_);
		_g_free0 (_tmp3_);
	}
	_tmp5_ = stderr;
	fprintf (_tmp5_, "%s%s:%s ", type_color_start, type, type_color_end);
	vala_report_print_highlighted_message (self, message);
	_tmp6_ = stderr;
	fputc ('\n', _tmp6_);
	if (do_report_source) {
		_tmp7_ = source != NULL;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		vala_report_report_source (self, source);
	}
}

/**
 * Reports the specified message as note.
 *
 * @param source  reference to source code
 * @param message note message
 */
static void
vala_report_real_note (ValaReport* self,
                       ValaSourceReference* source,
                       const gchar* message)
{
	gboolean _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (message != NULL);
	_tmp0_ = self->priv->_enable_warnings;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->note_color_start;
	_tmp2_ = self->priv->note_color_end;
	vala_report_print_message (self, source, "note", _tmp1_, _tmp2_, message, self->priv->verbose_errors);
}

void
vala_report_note (ValaReport* self,
                  ValaSourceReference* source,
                  const gchar* message)
{
	ValaReportClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = VALA_REPORT_GET_CLASS (self);
	if (_klass_->note) {
		_klass_->note (self, source, message);
	}
}

/**
 * Reports the specified message as deprecation warning.
 *
 * @param source  reference to source code
 * @param message warning message
 */
static void
vala_report_real_depr (ValaReport* self,
                       ValaSourceReference* source,
                       const gchar* message)
{
	gboolean _tmp0_;
	gint _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (message != NULL);
	_tmp0_ = self->priv->_enable_warnings;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = self->warnings;
	self->warnings = _tmp1_ + 1;
	_tmp2_ = self->priv->warning_color_start;
	_tmp3_ = self->priv->warning_color_end;
	vala_report_print_message (self, source, "warning", _tmp2_, _tmp3_, message, self->priv->verbose_errors);
}

void
vala_report_depr (ValaReport* self,
                  ValaSourceReference* source,
                  const gchar* message)
{
	ValaReportClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = VALA_REPORT_GET_CLASS (self);
	if (_klass_->depr) {
		_klass_->depr (self, source, message);
	}
}

/**
 * Reports the specified message as warning.
 *
 * @param source  reference to source code
 * @param message warning message
 */
static void
vala_report_real_warn (ValaReport* self,
                       ValaSourceReference* source,
                       const gchar* message)
{
	gboolean _tmp0_;
	gint _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (message != NULL);
	_tmp0_ = self->priv->_enable_warnings;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = self->warnings;
	self->warnings = _tmp1_ + 1;
	_tmp2_ = self->priv->warning_color_start;
	_tmp3_ = self->priv->warning_color_end;
	vala_report_print_message (self, source, "warning", _tmp2_, _tmp3_, message, self->priv->verbose_errors);
}

void
vala_report_warn (ValaReport* self,
                  ValaSourceReference* source,
                  const gchar* message)
{
	ValaReportClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = VALA_REPORT_GET_CLASS (self);
	if (_klass_->warn) {
		_klass_->warn (self, source, message);
	}
}

/**
 * Reports the specified message as error.
 *
 * @param source  reference to source code
 * @param message error message
 */
static void
vala_report_real_err (ValaReport* self,
                      ValaSourceReference* source,
                      const gchar* message)
{
	gint _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (message != NULL);
	_tmp0_ = self->errors;
	self->errors = _tmp0_ + 1;
	_tmp1_ = self->priv->error_color_start;
	_tmp2_ = self->priv->error_color_end;
	vala_report_print_message (self, source, "error", _tmp1_, _tmp2_, message, self->priv->verbose_errors);
}

void
vala_report_err (ValaReport* self,
                 ValaSourceReference* source,
                 const gchar* message)
{
	ValaReportClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = VALA_REPORT_GET_CLASS (self);
	if (_klass_->err) {
		_klass_->err (self, source, message);
	}
}

void
vala_report_notice (ValaSourceReference* source,
                    const gchar* msg_format,
                    ...)
{
	ValaCodeContext* _tmp0_;
	ValaCodeContext* _tmp1_;
	ValaReport* _tmp2_;
	ValaReport* _tmp3_;
	va_list _tmp4_ = {0};
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (msg_format != NULL);
	_tmp0_ = vala_code_context_get ();
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_code_context_get_report (_tmp1_);
	_tmp3_ = _tmp2_;
	va_start (_tmp4_, msg_format);
	_tmp5_ = g_strdup_vprintf (msg_format, _tmp4_);
	_tmp6_ = _tmp5_;
	vala_report_note (_tmp3_, source, _tmp6_);
	_g_free0 (_tmp6_);
	va_end (_tmp4_);
	_vala_code_context_unref0 (_tmp1_);
}

void
vala_report_deprecated (ValaSourceReference* source,
                        const gchar* msg_format,
                        ...)
{
	ValaCodeContext* _tmp0_;
	ValaCodeContext* _tmp1_;
	ValaReport* _tmp2_;
	ValaReport* _tmp3_;
	va_list _tmp4_ = {0};
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (msg_format != NULL);
	_tmp0_ = vala_code_context_get ();
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_code_context_get_report (_tmp1_);
	_tmp3_ = _tmp2_;
	va_start (_tmp4_, msg_format);
	_tmp5_ = g_strdup_vprintf (msg_format, _tmp4_);
	_tmp6_ = _tmp5_;
	vala_report_depr (_tmp3_, source, _tmp6_);
	_g_free0 (_tmp6_);
	va_end (_tmp4_);
	_vala_code_context_unref0 (_tmp1_);
}

void
vala_report_experimental (ValaSourceReference* source,
                          const gchar* msg_format,
                          ...)
{
	ValaCodeContext* _tmp0_;
	ValaCodeContext* _tmp1_;
	ValaReport* _tmp2_;
	ValaReport* _tmp3_;
	va_list _tmp4_ = {0};
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (msg_format != NULL);
	_tmp0_ = vala_code_context_get ();
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_code_context_get_report (_tmp1_);
	_tmp3_ = _tmp2_;
	va_start (_tmp4_, msg_format);
	_tmp5_ = g_strdup_vprintf (msg_format, _tmp4_);
	_tmp6_ = _tmp5_;
	vala_report_depr (_tmp3_, source, _tmp6_);
	_g_free0 (_tmp6_);
	va_end (_tmp4_);
	_vala_code_context_unref0 (_tmp1_);
}

void
vala_report_warning (ValaSourceReference* source,
                     const gchar* msg_format,
                     ...)
{
	ValaCodeContext* _tmp0_;
	ValaCodeContext* _tmp1_;
	ValaReport* _tmp2_;
	ValaReport* _tmp3_;
	va_list _tmp4_ = {0};
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (msg_format != NULL);
	_tmp0_ = vala_code_context_get ();
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_code_context_get_report (_tmp1_);
	_tmp3_ = _tmp2_;
	va_start (_tmp4_, msg_format);
	_tmp5_ = g_strdup_vprintf (msg_format, _tmp4_);
	_tmp6_ = _tmp5_;
	vala_report_warn (_tmp3_, source, _tmp6_);
	_g_free0 (_tmp6_);
	va_end (_tmp4_);
	_vala_code_context_unref0 (_tmp1_);
}

void
vala_report_error (ValaSourceReference* source,
                   const gchar* msg_format,
                   ...)
{
	ValaCodeContext* _tmp0_;
	ValaCodeContext* _tmp1_;
	ValaReport* _tmp2_;
	ValaReport* _tmp3_;
	va_list _tmp4_ = {0};
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (msg_format != NULL);
	_tmp0_ = vala_code_context_get ();
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_code_context_get_report (_tmp1_);
	_tmp3_ = _tmp2_;
	va_start (_tmp4_, msg_format);
	_tmp5_ = g_strdup_vprintf (msg_format, _tmp4_);
	_tmp6_ = _tmp5_;
	vala_report_err (_tmp3_, source, _tmp6_);
	_g_free0 (_tmp6_);
	va_end (_tmp4_);
	_vala_code_context_unref0 (_tmp1_);
}

static gboolean
vala_report_is_atty (ValaReport* self,
                     gint fd)
{
	GModule* module = NULL;
	GModule* _tmp0_;
	GModule* _tmp1_;
	void* _func = NULL;
	GModule* _tmp2_;
	void* _tmp3_ = NULL;
	void* _tmp4_;
	ValaReportAttyFunc func = NULL;
	void* _tmp5_;
	ValaReportAttyFunc _tmp6_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_module_open (NULL, G_MODULE_BIND_LAZY);
	module = _tmp0_;
	_tmp1_ = module;
	if (_tmp1_ == NULL) {
		result = FALSE;
		_g_module_close0 (module);
		return result;
	}
	_tmp2_ = module;
	g_module_symbol (_tmp2_, "isatty", &_tmp3_);
	_func = _tmp3_;
	_tmp4_ = _func;
	if (_tmp4_ == NULL) {
		result = FALSE;
		_g_module_close0 (module);
		return result;
	}
	_tmp5_ = _func;
	func = (ValaReportAttyFunc) _tmp5_;
	_tmp6_ = func;
	result = _tmp6_ (fd) == 1;
	_g_module_close0 (module);
	return result;
}

ValaReport*
vala_report_construct (GType object_type)
{
	ValaReport* self = NULL;
	self = (ValaReport*) g_type_create_instance (object_type);
	return self;
}

ValaReport*
vala_report_new (void)
{
	return vala_report_construct (VALA_TYPE_REPORT);
}

static void
vala_value_report_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
vala_value_report_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_report_unref (value->data[0].v_pointer);
	}
}

static void
vala_value_report_copy_value (const GValue* src_value,
                              GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_report_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
vala_value_report_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
vala_value_report_collect_value (GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaReport * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_report_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
vala_value_report_lcopy_value (const GValue* value,
                               guint n_collect_values,
                               GTypeCValue* collect_values,
                               guint collect_flags)
{
	ValaReport ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_report_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
vala_param_spec_report (const gchar* name,
                        const gchar* nick,
                        const gchar* blurb,
                        GType object_type,
                        GParamFlags flags)
{
	ValaParamSpecReport* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_REPORT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
vala_value_get_report (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_REPORT), NULL);
	return value->data[0].v_pointer;
}

void
vala_value_set_report (GValue* value,
                       gpointer v_object)
{
	ValaReport * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_REPORT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_REPORT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_report_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_report_unref (old);
	}
}

void
vala_value_take_report (GValue* value,
                        gpointer v_object)
{
	ValaReport * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_REPORT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_REPORT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_report_unref (old);
	}
}

static void
vala_report_class_init (ValaReportClass * klass,
                        gpointer klass_data)
{
	vala_report_parent_class = g_type_class_peek_parent (klass);
	((ValaReportClass *) klass)->finalize = vala_report_finalize;
	g_type_class_adjust_private_offset (klass, &ValaReport_private_offset);
	((ValaReportClass *) klass)->note = (void (*) (ValaReport*, ValaSourceReference*, const gchar*)) vala_report_real_note;
	((ValaReportClass *) klass)->depr = (void (*) (ValaReport*, ValaSourceReference*, const gchar*)) vala_report_real_depr;
	((ValaReportClass *) klass)->warn = (void (*) (ValaReport*, ValaSourceReference*, const gchar*)) vala_report_real_warn;
	((ValaReportClass *) klass)->err = (void (*) (ValaReport*, ValaSourceReference*, const gchar*)) vala_report_real_err;
}

static void
vala_report_instance_init (ValaReport * self,
                           gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	self->priv = vala_report_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->locus_color_start = _tmp0_;
	self->priv->locus_color_end = "";
	_tmp1_ = g_strdup ("");
	self->priv->warning_color_start = _tmp1_;
	self->priv->warning_color_end = "";
	_tmp2_ = g_strdup ("");
	self->priv->error_color_start = _tmp2_;
	self->priv->error_color_end = "";
	_tmp3_ = g_strdup ("");
	self->priv->note_color_start = _tmp3_;
	self->priv->note_color_end = "";
	_tmp4_ = g_strdup ("");
	self->priv->caret_color_start = _tmp4_;
	self->priv->caret_color_end = "";
	_tmp5_ = g_strdup ("");
	self->priv->quote_color_start = _tmp5_;
	self->priv->quote_color_end = "";
	self->priv->_enable_warnings = TRUE;
	self->ref_count = 1;
}

static void
vala_report_finalize (ValaReport * obj)
{
	ValaReport * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_REPORT, ValaReport);
	g_signal_handlers_destroy (self);
	_g_free0 (self->priv->locus_color_start);
	_g_free0 (self->priv->warning_color_start);
	_g_free0 (self->priv->error_color_start);
	_g_free0 (self->priv->note_color_start);
	_g_free0 (self->priv->caret_color_start);
	_g_free0 (self->priv->quote_color_start);
}

/**
 * Namespace to centralize reporting warnings and errors.
 */
static GType
vala_report_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { vala_value_report_init, vala_value_report_free_value, vala_value_report_copy_value, vala_value_report_peek_pointer, "p", vala_value_report_collect_value, "p", vala_value_report_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ValaReportClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_report_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaReport), 0, (GInstanceInitFunc) vala_report_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType vala_report_type_id;
	vala_report_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaReport", &g_define_type_info, &g_define_type_fundamental_info, 0);
	ValaReport_private_offset = g_type_add_instance_private (vala_report_type_id, sizeof (ValaReportPrivate));
	return vala_report_type_id;
}

GType
vala_report_get_type (void)
{
	static volatile gsize vala_report_type_id__volatile = 0;
	if (g_once_init_enter (&vala_report_type_id__volatile)) {
		GType vala_report_type_id;
		vala_report_type_id = vala_report_get_type_once ();
		g_once_init_leave (&vala_report_type_id__volatile, vala_report_type_id);
	}
	return vala_report_type_id__volatile;
}

gpointer
vala_report_ref (gpointer instance)
{
	ValaReport * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
vala_report_unref (gpointer instance)
{
	ValaReport * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_REPORT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

