/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.stream.Collectors;
import org.openjdk.asmtools.asmutils.HexUtils;
import org.openjdk.asmtools.asmutils.StringUtils;
import org.openjdk.asmtools.jdis.BootstrapMethodData;
import org.openjdk.asmtools.jdis.ClassData;
import org.openjdk.asmtools.jdis.Options;
import org.openjdk.asmtools.jdis.TraceUtils;
import org.openjdk.asmtools.jdis.Utils;

public class ConstantPool {
    private static final Hashtable<Byte, TAG> taghash = new Hashtable();
    private static final Hashtable<Byte, SUBTAG> subtaghash = new Hashtable();
    private boolean printTAG = false;
    private final Indent indent = new Indent(2, 1);
    public ArrayList<Constant> pool;
    private ClassData cd;

    public void setPrintTAG(boolean value) {
        this.printTAG = value;
    }

    public String getPrintedTAG(TAG tag) {
        return this.printTAG ? tag.tagname + " " : "";
    }

    public ConstantPool(ClassData cd) {
        this.pool = null;
        this.cd = cd;
    }

    public ConstantPool(ClassData cd, int size) {
        this.pool = new ArrayList(size);
        this.cd = cd;
    }

    void read(DataInputStream in) throws IOException {
        int length = in.readUnsignedShort();
        this.pool = new ArrayList(length);
        this.pool.add(0, null);
        TraceUtils.traceln("CP len=" + length);
        block10: for (int i = 1; i < length; ++i) {
            byte tag = in.readByte();
            TAG tagobj = taghash.get(tag);
            TraceUtils.traceln("CP entry #" + i + " + tagindex=" + tag + " tag=" + (Object)((Object)tagobj));
            switch (tagobj) {
                case CONSTANT_UTF8: {
                    this.pool.add(i, new CP_Str(tagobj, in.readUTF()));
                    continue block10;
                }
                case CONSTANT_INTEGER: {
                    this.pool.add(i, new CP_Int(tagobj, in.readInt()));
                    continue block10;
                }
                case CONSTANT_LONG: {
                    this.pool.add(i, new CP_Long(tagobj, in.readLong()));
                    ++i;
                    this.pool.add(null);
                    continue block10;
                }
                case CONSTANT_FLOAT: {
                    this.pool.add(i, new CP_Float(tagobj, in.readFloat()));
                    continue block10;
                }
                case CONSTANT_DOUBLE: {
                    this.pool.add(i, new CP_Double(tagobj, in.readDouble()));
                    ++i;
                    this.pool.add(null);
                    continue block10;
                }
                case CONSTANT_CLASS: 
                case CONSTANT_PACKAGE: 
                case CONSTANT_MODULE: 
                case CONSTANT_METHODTYPE: 
                case CONSTANT_STRING: {
                    this.pool.add(i, new CPX(tagobj, in.readUnsignedShort()));
                    continue block10;
                }
                case CONSTANT_FIELD: 
                case CONSTANT_METHOD: 
                case CONSTANT_INTERFACEMETHOD: 
                case CONSTANT_NAMEANDTYPE: 
                case CONSTANT_DYNAMIC: 
                case CONSTANT_INVOKEDYNAMIC: {
                    this.pool.add(i, new CPX2(tagobj, in.readUnsignedShort(), in.readUnsignedShort()));
                    continue block10;
                }
                case CONSTANT_METHODHANDLE: {
                    this.pool.add(i, new CPX2(tagobj, in.readUnsignedByte(), in.readUnsignedShort()));
                    continue block10;
                }
                default: {
                    throw new ClassFormatError("invalid constant type: " + tag);
                }
            }
        }
    }

    private boolean inbounds(int cpx) {
        return cpx != 0 && cpx < this.pool.size();
    }

    public Constant getConst(int cpx) {
        if (this.inbounds(cpx)) {
            return this.pool.get(cpx);
        }
        return null;
    }

    public String StringTag(int cpx) {
        Constant cns;
        String str = "Incorrect CP index:" + cpx;
        if (this.inbounds(cpx) && (cns = this.pool.get(cpx)) != null) {
            str = cns.tag.tagname;
        }
        return str;
    }

    public String getString(int cpx) {
        Constant cns;
        String str = null;
        if (this.inbounds(cpx) && (cns = this.pool.get(cpx)) != null && cns.tag == TAG.CONSTANT_UTF8) {
            CP_Str cns1 = (CP_Str)cns;
            str = cns1.value;
        }
        return str;
    }

    public String getModule(int cpx) {
        Constant cns;
        String str = null;
        if (this.inbounds(cpx) && (cns = this.pool.get(cpx)) != null && cns.tag == TAG.CONSTANT_MODULE) {
            str = cns.stringVal();
        }
        return str;
    }

    public String getPackage(int cpx) {
        Constant cns;
        String str = null;
        if (this.inbounds(cpx) && (cns = this.pool.get(cpx)) != null && cns.tag == TAG.CONSTANT_PACKAGE) {
            str = cns.stringVal();
        }
        return str;
    }

    public String getName(int cpx) {
        String str = this.getString(cpx);
        if (str == null) {
            return "<invalid constant pool index:" + cpx + ">";
        }
        return Utils.javaName(str);
    }

    public String getClassName(int cpx) {
        String res = "#" + cpx;
        if (cpx == 0) {
            return res;
        }
        if (!this.inbounds(cpx)) {
            return res;
        }
        Constant cns = this.pool.get(cpx);
        if (cns == null || cns.tag != TAG.CONSTANT_CLASS) {
            return res;
        }
        return this.getClassName((CPX)cns);
    }

    public String getClassName(CPX2 classConst) {
        return this._getClassName(classConst.value1);
    }

    public String getClassName(CPX classConst) {
        return this._getClassName(classConst.value);
    }

    private String _getClassName(int nameIndex) {
        String res = "#" + nameIndex;
        if (!this.inbounds(nameIndex)) {
            return res;
        }
        Constant nameconst = this.pool.get(nameIndex);
        if (nameconst == null || nameconst.tag != TAG.CONSTANT_UTF8) {
            return res;
        }
        CP_Str name = (CP_Str)nameconst;
        String classname = name.value;
        if (Utils.isClassArrayDescriptor(classname)) {
            classname = "\"" + classname + "\"";
        }
        return classname;
    }

    public String getShortClassName(String className, String pkgPrefix) {
        if (className.startsWith(pkgPrefix)) {
            return className.substring(pkgPrefix.length());
        }
        return className;
    }

    public String getShortClassName(int cpx, String pkgPrefix) {
        String name = Utils.javaName(this.getClassName(cpx));
        return this.getShortClassName(name, pkgPrefix);
    }

    public String decodeClassDescriptor(int cpx) {
        String rawEnumName = this.getName(cpx);
        int len = rawEnumName.length();
        int begin = rawEnumName.startsWith("\"L") ? 2 : 0;
        int end = begin > 0 ? len - 2 : len;
        return rawEnumName.substring(begin, end);
    }

    private String subtagToString(int subtag) {
        SUBTAG st = subtaghash.get((byte)subtag);
        if (st == null) {
            return "BOGUS_SUBTAG:" + subtag;
        }
        return st.tagname;
    }

    public String StringValue(int cpx) {
        if (cpx == 0) {
            return "#0";
        }
        if (!this.inbounds(cpx)) {
            return "<Incorrect CP index:" + cpx + ">";
        }
        Constant cnst = this.pool.get(cpx);
        if (cnst == null) {
            return "<NULL>";
        }
        return cnst.stringVal();
    }

    public String ConstantStrValue(int cpx) {
        if (cpx == 0) {
            return "#0";
        }
        if (!this.inbounds(cpx)) {
            return "#" + cpx;
        }
        Constant cns = this.pool.get(cpx);
        if (cns == null) {
            return "#" + cpx;
        }
        if (cns instanceof CPX2) {
            CPX2 cns2 = (CPX2)cns;
            if (cns2.value1 == this.cd.this_cpx && cns2.refersClassMember()) {
                cpx = cns2.value2;
            }
        }
        return cns.tag.tagname + " " + this.StringValue(cpx);
    }

    public void print(PrintWriter out) throws IOException {
        int cpx = 0;
        for (Constant cns : this.pool) {
            if (cpx == 0) {
                ++cpx;
                continue;
            }
            out.print("\tconst #" + cpx + " = ");
            if (cns == null) {
                out.println("null");
                ++cpx;
                continue;
            }
            cns.print(out);
            cpx += cns.size();
        }
    }

    void PrintConstant(PrintWriter out, int cpx) {
        out.print(this.ConstantStrValue(cpx));
    }

    public void printlnClassId(PrintWriter out, int cpx) throws IOException {
        this.printlnClassId(out, cpx, false);
    }

    public void printlnClassId(PrintWriter out, int cpx, boolean addComma) throws IOException {
        if (!this.cd.options.contains(Options.PR.CPX)) {
            out.print(this.getShortClassName(cpx, this.cd.pkgPrefix) + (addComma ? "," : ""));
        } else {
            out.print("\t#" + cpx + (addComma ? "," : "") + " //");
            this.PrintConstant(out, cpx);
        }
    }

    static {
        taghash.put(TAG.CONSTANT_UTF8.value(), TAG.CONSTANT_UTF8);
        taghash.put(TAG.CONSTANT_UNICODE.value(), TAG.CONSTANT_UNICODE);
        taghash.put(TAG.CONSTANT_INTEGER.value(), TAG.CONSTANT_INTEGER);
        taghash.put(TAG.CONSTANT_FLOAT.value(), TAG.CONSTANT_FLOAT);
        taghash.put(TAG.CONSTANT_LONG.value(), TAG.CONSTANT_LONG);
        taghash.put(TAG.CONSTANT_DOUBLE.value(), TAG.CONSTANT_DOUBLE);
        taghash.put(TAG.CONSTANT_CLASS.value(), TAG.CONSTANT_CLASS);
        taghash.put(TAG.CONSTANT_STRING.value(), TAG.CONSTANT_STRING);
        taghash.put(TAG.CONSTANT_FIELD.value(), TAG.CONSTANT_FIELD);
        taghash.put(TAG.CONSTANT_METHOD.value(), TAG.CONSTANT_METHOD);
        taghash.put(TAG.CONSTANT_INTERFACEMETHOD.value(), TAG.CONSTANT_INTERFACEMETHOD);
        taghash.put(TAG.CONSTANT_NAMEANDTYPE.value(), TAG.CONSTANT_NAMEANDTYPE);
        taghash.put(TAG.CONSTANT_METHODHANDLE.value(), TAG.CONSTANT_METHODHANDLE);
        taghash.put(TAG.CONSTANT_METHODTYPE.value(), TAG.CONSTANT_METHODTYPE);
        taghash.put(TAG.CONSTANT_DYNAMIC.value(), TAG.CONSTANT_DYNAMIC);
        taghash.put(TAG.CONSTANT_INVOKEDYNAMIC.value(), TAG.CONSTANT_INVOKEDYNAMIC);
        taghash.put(TAG.CONSTANT_MODULE.value(), TAG.CONSTANT_MODULE);
        taghash.put(TAG.CONSTANT_PACKAGE.value(), TAG.CONSTANT_PACKAGE);
        subtaghash.put(SUBTAG.REF_GETFIELD.value(), SUBTAG.REF_GETFIELD);
        subtaghash.put(SUBTAG.REF_GETSTATIC.value(), SUBTAG.REF_GETSTATIC);
        subtaghash.put(SUBTAG.REF_PUTFIELD.value(), SUBTAG.REF_PUTFIELD);
        subtaghash.put(SUBTAG.REF_PUTSTATIC.value(), SUBTAG.REF_PUTSTATIC);
        subtaghash.put(SUBTAG.REF_INVOKEVIRTUAL.value(), SUBTAG.REF_INVOKEVIRTUAL);
        subtaghash.put(SUBTAG.REF_INVOKESTATIC.value(), SUBTAG.REF_INVOKESTATIC);
        subtaghash.put(SUBTAG.REF_INVOKESPECIAL.value(), SUBTAG.REF_INVOKESPECIAL);
        subtaghash.put(SUBTAG.REF_NEWINVOKESPECIAL.value(), SUBTAG.REF_NEWINVOKESPECIAL);
        subtaghash.put(SUBTAG.REF_INVOKEINTERFACE.value(), SUBTAG.REF_INVOKEINTERFACE);
    }

    class Indent {
        private int length = 0;
        private int offset;
        private int step;

        void inc() {
            this.length += this.step;
        }

        void dec() {
            this.length -= this.step;
        }

        Indent(int offset, int step) {
            this.step = step;
            this.offset = offset;
        }

        int size() {
            return this.offset + this.length;
        }

        private String get() {
            return Collections.nCopies(this.size(), "\t").stream().collect(Collectors.joining());
        }
    }

    public static enum TAG {
        CONSTANT_UTF8(1, "Asciz", "CONSTANT_UTF8"),
        CONSTANT_UNICODE(2, "unicorn", "CONSTANT_UNICODE"),
        CONSTANT_INTEGER(3, "int", "CONSTANT_INTEGER"),
        CONSTANT_FLOAT(4, "float", "CONSTANT_FLOAT"),
        CONSTANT_LONG(5, "long", "CONSTANT_LONG"),
        CONSTANT_DOUBLE(6, "double", "CONSTANT_DOUBLE"),
        CONSTANT_CLASS(7, "class", "CONSTANT_CLASS"),
        CONSTANT_STRING(8, "String", "CONSTANT_STRING"),
        CONSTANT_FIELD(9, "Field", "CONSTANT_FIELD"),
        CONSTANT_METHOD(10, "Method", "CONSTANT_METHOD"),
        CONSTANT_INTERFACEMETHOD(11, "InterfaceMethod", "CONSTANT_INTERFACEMETHOD"),
        CONSTANT_NAMEANDTYPE(12, "NameAndType", "CONSTANT_NAMEANDTYPE"),
        CONSTANT_METHODHANDLE(15, "MethodHandle", "CONSTANT_METHODHANDLE"),
        CONSTANT_METHODTYPE(16, "MethodType", "CONSTANT_METHODTYPE"),
        CONSTANT_DYNAMIC(17, "Dynamic", "CONSTANT_DYNAMIC"),
        CONSTANT_INVOKEDYNAMIC(18, "InvokeDynamic", "CONSTANT_INVOKEDYNAMIC"),
        CONSTANT_MODULE(19, "Module", "CONSTANT_MODULE"),
        CONSTANT_PACKAGE(20, "Package", "CONSTANT_PACKAGE");

        private final Byte value;
        private final String tagname;
        private final String printval;

        private TAG(byte val, String tgname, String print) {
            this.value = val;
            this.tagname = tgname;
            this.printval = print;
        }

        public byte value() {
            return this.value;
        }

        public String tagname() {
            return this.tagname;
        }

        public String description() {
            return this.printval;
        }

        public String toString() {
            return "<" + this.tagname + "> ";
        }
    }

    class CP_Str
    extends Constant {
        String value;

        CP_Str(TAG tagval, String str) {
            super(tagval);
            this.value = str;
        }

        @Override
        public String stringVal() {
            return StringUtils.Utf8ToString(this.value);
        }

        @Override
        public void print(PrintWriter out) {
            super.print(out);
            out.println(this.stringVal() + ";");
        }
    }

    class CP_Int
    extends Constant {
        Integer value;

        CP_Int(TAG tagval, int intval) {
            super(tagval);
            this.value = intval;
        }

        @Override
        public String stringVal() {
            if (((ConstantPool)ConstantPool.this).cd.options.contains(Options.PR.HEX)) {
                return HexUtils.toHex(this.value);
            }
            return this.value.toString();
        }

        @Override
        public void print(PrintWriter out) {
            super.print(out);
            out.println(this.stringVal() + ";");
        }
    }

    class CP_Long
    extends Constant {
        Long value;

        CP_Long(TAG tagval, long intval) {
            super(tagval);
            this.value = intval;
        }

        @Override
        public String stringVal() {
            if (((ConstantPool)ConstantPool.this).cd.options.contains(Options.PR.HEX)) {
                return HexUtils.toHex(this.value) + 'l';
            }
            return this.value.toString() + 'l';
        }

        @Override
        public void print(PrintWriter out) {
            super.print(out);
            out.println(this.stringVal() + ";");
        }

        @Override
        public int size() {
            return 2;
        }
    }

    class CP_Float
    extends Constant {
        Float value;

        CP_Float(TAG tagval, float fltvl) {
            super(tagval);
            this.value = Float.valueOf(fltvl);
        }

        @Override
        public String stringVal() {
            if (((ConstantPool)ConstantPool.this).cd.options.contains(Options.PR.HEX)) {
                return "bits " + HexUtils.toHex(Float.floatToIntBits(this.value.floatValue()));
            }
            String sf = this.value.toString();
            if (this.value.isNaN() || this.value.isInfinite()) {
                return sf;
            }
            return sf + "f";
        }

        @Override
        public void print(PrintWriter out) {
            super.print(out);
            out.println(this.stringVal() + ";");
        }
    }

    class CP_Double
    extends Constant {
        Double value;

        CP_Double(TAG tagval, double fltvl) {
            super(tagval);
            this.value = fltvl;
        }

        @Override
        public String stringVal() {
            if (((ConstantPool)ConstantPool.this).cd.options.contains(Options.PR.HEX)) {
                return "bits " + HexUtils.toHex(Double.doubleToLongBits(this.value)) + 'l';
            }
            String sd = this.value.toString();
            if (this.value.isNaN() || this.value.isInfinite()) {
                return sd;
            }
            return sd + "d";
        }

        @Override
        public void print(PrintWriter out) {
            super.print(out);
            out.println(this.stringVal() + ";");
        }

        @Override
        public int size() {
            return 2;
        }
    }

    class CPX
    extends Constant {
        int value;

        CPX(TAG tagval, int cpx) {
            super(tagval);
            this.value = cpx;
        }

        @Override
        public String stringVal() {
            String str = "UnknownTag";
            switch (this.tag) {
                case CONSTANT_CLASS: {
                    str = ConstantPool.this.getShortClassName(ConstantPool.this.getClassName(this), ((ConstantPool)ConstantPool.this).cd.pkgPrefix);
                    break;
                }
                case CONSTANT_PACKAGE: 
                case CONSTANT_MODULE: {
                    str = ConstantPool.this.getString(this.value);
                    break;
                }
                case CONSTANT_METHODTYPE: 
                case CONSTANT_STRING: {
                    str = ConstantPool.this.StringValue(this.value);
                    break;
                }
            }
            return str;
        }

        @Override
        public void print(PrintWriter out) {
            super.print(out);
            switch (this.tag) {
                case CONSTANT_CLASS: 
                case CONSTANT_PACKAGE: 
                case CONSTANT_MODULE: 
                case CONSTANT_METHODTYPE: 
                case CONSTANT_STRING: {
                    out.println("#" + this.value + ";\t//  " + this.stringVal());
                }
            }
        }
    }

    class CPX2
    extends Constant {
        int value1;
        int value2;

        CPX2(TAG tagval, int cpx1, int cpx2) {
            super(tagval);
            this.value1 = cpx1;
            this.value2 = cpx2;
        }

        @Override
        public String stringVal() {
            String str = "UnknownTag";
            switch (this.tag) {
                case CONSTANT_FIELD: {
                    str = ConstantPool.this.getShortClassName(ConstantPool.this.getClassName(this.value1), ((ConstantPool)ConstantPool.this).cd.pkgPrefix) + "." + ConstantPool.this.StringValue(this.value2);
                    break;
                }
                case CONSTANT_METHOD: 
                case CONSTANT_INTERFACEMETHOD: {
                    str = ConstantPool.this.getPrintedTAG(this.tag) + ConstantPool.this.getShortClassName(ConstantPool.this.getClassName(this.value1), ((ConstantPool)ConstantPool.this).cd.pkgPrefix) + "." + ConstantPool.this.StringValue(this.value2);
                    break;
                }
                case CONSTANT_NAMEANDTYPE: {
                    str = ConstantPool.this.getName(this.value1) + ":" + ConstantPool.this.StringValue(this.value2);
                    break;
                }
                case CONSTANT_METHODHANDLE: {
                    str = ConstantPool.this.subtagToString(this.value1) + ":" + ConstantPool.this.StringValue(this.value2);
                    break;
                }
                case CONSTANT_DYNAMIC: 
                case CONSTANT_INVOKEDYNAMIC: {
                    BootstrapMethodData bsmData;
                    int bsm_attr_idx = this.value1;
                    int nape_idx = this.value2;
                    try {
                        bsmData = ((ConstantPool)ConstantPool.this).cd.bootstrapMethods.get(bsm_attr_idx);
                    }
                    catch (NullPointerException npe) {
                        return "<Missing BootstrapMethods attribute>";
                    }
                    catch (IndexOutOfBoundsException ioob) {
                        return "<Invalid bootstrap method index:" + bsm_attr_idx + ">";
                    }
                    StringBuilder bsm_args_str = new StringBuilder();
                    int bsm_ref = bsmData.bsm_index;
                    int bsm_args_len = bsmData.bsm_args_indexes.size();
                    if (bsm_args_len > 0) {
                        bsm_args_str.append(" {\n");
                        String offsetBrace = ConstantPool.this.indent.get();
                        ConstantPool.this.indent.inc();
                        String offsetParm = ConstantPool.this.indent.get();
                        for (int i = 0; i < bsm_args_len; ++i) {
                            int bsm_arg_idx = bsmData.bsm_args_indexes.get(i);
                            Constant cnt = ConstantPool.this.pool.get(bsm_arg_idx);
                            if (cnt.equals(this)) {
                                String s = "circular reference to " + cnt.tag.tagname() + " #" + bsm_arg_idx;
                                bsm_args_str.append(offsetParm).append("  <").append(s).append(">");
                                cnt.setIssue(new IOException(s));
                            } else {
                                bsm_args_str.append(offsetParm).append(ConstantPool.this.ConstantStrValue(bsm_arg_idx));
                                if (i + 1 < bsm_args_len) {
                                    bsm_args_str.append(",");
                                }
                            }
                            bsm_args_str.append('\n');
                        }
                        ConstantPool.this.indent.dec();
                        bsm_args_str.append(offsetBrace).append("}");
                    }
                    str = ConstantPool.this.StringValue(bsm_ref) + ":" + ConstantPool.this.StringValue(nape_idx) + bsm_args_str.toString();
                }
            }
            return str;
        }

        @Override
        public void print(PrintWriter out) {
            super.print(out);
            switch (this.tag) {
                case CONSTANT_FIELD: 
                case CONSTANT_METHOD: 
                case CONSTANT_INTERFACEMETHOD: {
                    out.println("#" + this.value1 + ".#" + this.value2 + ";\t//  " + this.stringVal());
                    break;
                }
                case CONSTANT_METHODHANDLE: {
                    out.println(this.value1 + ":#" + this.value2 + ";\t//  " + this.stringVal());
                    break;
                }
                case CONSTANT_NAMEANDTYPE: {
                    out.println("#" + this.value1 + ":#" + this.value2 + ";\t//  " + this.stringVal());
                    break;
                }
                case CONSTANT_DYNAMIC: 
                case CONSTANT_INVOKEDYNAMIC: {
                    out.println(this.value1 + ":#" + this.value2 + ";\t" + Utils.commentString(this.stringVal()));
                    break;
                }
            }
        }

        public boolean refersClassMember() {
            return this.tag == TAG.CONSTANT_FIELD || this.tag == TAG.CONSTANT_METHOD || this.tag == TAG.CONSTANT_INTERFACEMETHOD;
        }
    }

    public class Constant {
        public TAG tag;
        private IOException issue;

        public Constant(TAG tagval) {
            this.tag = tagval;
        }

        public String stringVal() {
            return "";
        }

        public void print(PrintWriter out) {
            out.print(this.tag.tagname + "\t");
        }

        public int size() {
            return 1;
        }

        public String toString() {
            return "<CONSTANT " + this.tag.toString() + " " + this.stringVal() + ">";
        }

        public IOException getIssue() {
            return this.issue;
        }

        public void setIssue(IOException value) {
            this.issue = value;
        }
    }

    public static enum SUBTAG {
        REF_GETFIELD(1, "REF_getField", "REF_GETFIELD"),
        REF_GETSTATIC(2, "REF_getStatic", "REF_GETSTATIC"),
        REF_PUTFIELD(3, "REF_putField", "REF_PUTFIELD"),
        REF_PUTSTATIC(4, "REF_putStatic", "REF_PUTSTATIC"),
        REF_INVOKEVIRTUAL(5, "REF_invokeVirtual", "REF_INVOKEVIRTUAL"),
        REF_INVOKESTATIC(6, "REF_invokeStatic", "REF_INVOKESTATIC"),
        REF_INVOKESPECIAL(7, "REF_invokeSpecial", "REF_INVOKESPECIAL"),
        REF_NEWINVOKESPECIAL(8, "REF_newInvokeSpecial", "REF_NEWINVOKESPECIAL"),
        REF_INVOKEINTERFACE(9, "REF_invokeInterface", "REF_INVOKEINTERFACE");

        private final Byte value;
        private final String tagname;
        private final String printval;

        private SUBTAG(byte val, String tgname, String print) {
            this.value = val;
            this.tagname = tgname;
            this.printval = print;
        }

        public byte value() {
            return this.value;
        }

        public String tagname() {
            return this.tagname;
        }

        public String description() {
            return this.printval;
        }

        public String toString() {
            return "<" + this.tagname + "> ";
        }
    }
}

