/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdec;

import java.io.DataInputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.openjdk.asmtools.common.Tool;
import org.openjdk.asmtools.jdec.ClassData;
import org.openjdk.asmtools.jdis.uEscWriter;
import org.openjdk.asmtools.util.I18NResourceBundle;
import org.openjdk.asmtools.util.ProductInfo;

public class Main
extends Tool {
    int printFlags = 0;
    public static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(Main.class);

    public Main(PrintWriter out, PrintWriter err, String programName) {
        super(out, err, programName);
        this.printCannotReadMsg = fname -> this.error(i18n.getString("jdec.error.cannot_read", fname));
    }

    public Main(PrintStream out, String program) {
        this(new PrintWriter(out), new PrintWriter(System.err), program);
    }

    @Override
    public void usage() {
        this.println(i18n.getString("jdec.usage"));
        this.println(i18n.getString("jdec.opt.g"));
        this.println(i18n.getString("jdec.opt.version"));
    }

    public synchronized boolean decode(String[] argv) {
        long tm = System.currentTimeMillis();
        ArrayList<String> vargs = new ArrayList<String>();
        ArrayList<String> vj = new ArrayList<String>();
        boolean nowrite = false;
        boolean addOptions = false;
        int i = 0;
        for (String arg : argv) {
            if (arg.equals("-g")) {
                this.printFlags |= 1;
                vargs.add(arg);
            } else if (arg.equals("-v")) {
                this.DebugFlag = () -> true;
                vargs.add(arg);
                this.out.println("arg[" + i + "]=" + argv[i] + "/verbose");
            } else if (arg.equals("-version")) {
                this.out.println(ProductInfo.FULL_VERSION);
            } else {
                if (arg.startsWith("-")) {
                    this.error(i18n.getString("jdec.error.invalid_flag", (Object)arg));
                    this.usage();
                    return false;
                }
                vargs.add(arg);
                vj.add(arg);
            }
            ++i;
        }
        if (vj.isEmpty()) {
            this.usage();
            return false;
        }
        String[] names = new String[]{};
        for (String inpname : names = vj.toArray(names)) {
            try {
                DataInputStream dataInputStream = this.getDataInputStream(inpname);
                if (dataInputStream == null) {
                    return false;
                }
                ClassData cc = new ClassData(dataInputStream, this.printFlags, this.out);
                cc.DebugFlag = this.DebugFlag.getAsBoolean();
                cc.decodeClass(inpname);
                continue;
            }
            catch (Error ee) {
                if (this.DebugFlag.getAsBoolean()) {
                    ee.printStackTrace();
                }
                this.error(i18n.getString("jdec.error.fatal_error"));
            }
            catch (Exception ee) {
                if (this.DebugFlag.getAsBoolean()) {
                    ee.printStackTrace();
                }
                this.error(i18n.getString("jdec.error.fatal_exception"));
            }
            return false;
        }
        return true;
    }

    public static void main(String[] argv) {
        Main decoder = new Main(new PrintWriter(new uEscWriter(System.out)), new PrintWriter(System.err), "jdec");
        System.exit(decoder.decode(argv) ? 0 : 1);
    }
}

