/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import java.util.function.Predicate;
import org.openjdk.asmtools.jasm.Environment;
import org.openjdk.asmtools.jasm.JasmTokens;
import org.openjdk.asmtools.jasm.ParseBase;
import org.openjdk.asmtools.jasm.Tables;

public class Scanner
extends ParseBase {
    protected Environment in;
    protected int ch;
    protected JasmTokens.Token token;
    protected int pos;
    protected char charValue;
    protected int intValue;
    protected long longValue;
    protected float floatValue;
    protected double doubleValue;
    protected String stringValue;
    protected String idValue;
    protected int radix;
    protected String docComment;
    private int count;
    private char[] buffer = new char[32];
    private Predicate<Integer> escapingAllowed;
    protected int prevPos;
    protected int sign;
    protected boolean inBits;
    private Predicate<Integer> noFunc = ch -> false;
    private Predicate<Integer> yesAndProcessFunc = ch -> {
        boolean res;
        boolean bl = res = ch == 92 || ch == 58 || ch == 64;
        if (res) {
            this.putCh(92);
        }
        return res;
    };

    protected Scanner(Environment env) throws IOException {
        super.init(this, null, env);
        this.escapingAllowed = this.noFunc;
        this.in = env;
        this.ch = env.read();
        this.xscan();
    }

    protected void scanModuleStatement() throws IOException {
        try {
            this.escapingAllowed = this.yesAndProcessFunc;
            this.scan();
        }
        finally {
            this.escapingAllowed = this.noFunc;
        }
    }

    protected void scan() throws IOException {
        int signloc = 1;
        int cnt = 0;
        this.prevPos = this.pos;
        block6: while (true) {
            this.xscan();
            switch (this.token) {
                case SIGN: {
                    signloc *= this.intValue;
                    break;
                }
                default: {
                    break block6;
                }
            }
            ++cnt;
        }
        switch (this.token) {
            case INTVAL: 
            case LONGVAL: 
            case FLOATVAL: 
            case DOUBLEVAL: 
            case INF: 
            case NAN: {
                this.sign = signloc;
                break;
            }
        }
    }

    protected final boolean checkTokenIdent() {
        return this.token.possibleJasmIdentifier();
    }

    static String readableConstant(int t) {
        return "<" + (Object)((Object)Tables.tag(t)) + "> [" + t + "]";
    }

    protected final void expect(JasmTokens.Token t) throws SyntaxError, IOException {
        this.check(t);
        this.scan();
    }

    protected final void check(JasmTokens.Token t) throws SyntaxError, IOException {
        if (!(this.token == t || t == JasmTokens.Token.IDENT && this.checkTokenIdent())) {
            this.env.traceln("expect:" + (Object)((Object)t) + " instead of " + (Object)((Object)this.token));
            switch (t) {
                case IDENT: {
                    this.env.error(this.pos, "identifier.expected");
                    break;
                }
                default: {
                    this.env.error(this.pos, "token.expected", (Object)("<" + t.printValue() + ">"));
                }
            }
            if (this.debugFlag) {
                this.debugStr("<<<<<PROBLEM>>>>>>>: ");
                throw new Error("<<<<<PROBLEM>>>>>>>");
            }
            throw new SyntaxError();
        }
    }

    private void putCh(int ch) {
        if (this.count == this.buffer.length) {
            char[] newBuffer = new char[this.buffer.length * 2];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
            this.buffer = newBuffer;
        }
        this.buffer[this.count++] = (char)ch;
    }

    private String bufferString() {
        char[] buf = new char[this.count];
        System.arraycopy(this.buffer, 0, buf, 0, this.count);
        return new String(buf);
    }

    public static boolean isUCDigit(int ch) {
        if (ch >= 48 && ch <= 57) {
            return true;
        }
        switch (ch >> 8) {
            case 6: {
                return ch >= 1632 && ch <= 1641 || ch >= 1776 && ch <= 1785;
            }
            default: {
                return false;
            }
            case 9: {
                return ch >= 2406 && ch <= 2415 || ch >= 2534 && ch <= 2543;
            }
            case 10: {
                return ch >= 2662 && ch <= 2671 || ch >= 2790 && ch <= 2799;
            }
            case 11: {
                return ch >= 2918 && ch <= 2927 || ch >= 3047 && ch <= 3055;
            }
            case 12: {
                return ch >= 3174 && ch <= 3183 || ch >= 3302 && ch <= 3311;
            }
            case 13: {
                return ch >= 3430 && ch <= 3439;
            }
            case 14: {
                return ch >= 3664 && ch <= 3673 || ch >= 3792 && ch <= 3801;
            }
            case 15: {
                return false;
            }
            case 16: 
        }
        return ch >= 4160 && ch <= 4169;
    }

    public static boolean isUCLetter(int ch) {
        if (ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122) {
            return true;
        }
        if (ch < 256) {
            if (ch < 192) {
                return ch == 95 || ch == 36;
            }
            return ch >= 192 && ch <= 214 || ch >= 216 && ch <= 246 || ch >= 248 && ch <= 255;
        }
        if (ch <= 8191) {
            return !Scanner.isUCDigit(ch);
        }
        return ch >= 12352 && ch <= 12687 || ch >= 13056 && ch <= 13183 || ch >= 13312 && ch <= 15661 || ch >= 19968 && ch <= 40959 || ch >= 63744 && ch <= 64255;
    }

    private void skipComment() throws IOException {
        block4: while (true) {
            switch (this.ch) {
                case -1: {
                    this.env.error(this.pos, "eof.in.comment");
                    return;
                }
                case 42: {
                    this.ch = this.in.read();
                    if (this.ch != 47) continue block4;
                    this.ch = this.in.read();
                    return;
                }
            }
            this.ch = this.in.read();
        }
    }

    private String scanDocComment() throws IOException {
        this.count = 0;
        if (this.ch == 42) {
            do {
                this.ch = this.in.read();
            } while (this.ch == 42);
            if (this.ch == 47) {
                this.ch = this.in.read();
                return "";
            }
        }
        switch (this.ch) {
            case 10: 
            case 32: {
                this.ch = this.in.read();
            }
        }
        boolean seenstar = false;
        int c = this.count;
        block14: while (true) {
            switch (this.ch) {
                case -1: {
                    this.env.error(this.pos, "eof.in.comment");
                    return this.bufferString();
                }
                case 10: {
                    this.putCh(10);
                    this.ch = this.in.read();
                    seenstar = false;
                    c = this.count;
                    continue block14;
                }
                case 9: 
                case 32: {
                    this.putCh(this.ch);
                    this.ch = this.in.read();
                    continue block14;
                }
                case 42: {
                    if (seenstar) {
                        this.ch = this.in.read();
                        if (this.ch == 47) {
                            this.ch = this.in.read();
                            this.count = c;
                            return this.bufferString();
                        }
                        this.putCh(42);
                        continue block14;
                    }
                    seenstar = true;
                    this.count = c;
                    while ((this.ch = this.in.read()) == 42) {
                    }
                    switch (this.ch) {
                        case 32: {
                            this.ch = this.in.read();
                            break;
                        }
                        case 47: {
                            this.ch = this.in.read();
                            this.count = c;
                            return this.bufferString();
                        }
                    }
                    continue block14;
                }
            }
            if (!seenstar) {
                seenstar = true;
            }
            this.putCh(this.ch);
            this.ch = this.in.read();
            c = this.count;
        }
    }

    private void scanCPRef() throws IOException {
        this.ch = this.in.read();
        switch (this.ch) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                boolean overflow = false;
                long value = this.ch - 48;
                this.count = 0;
                this.putCh(this.ch);
                block6: while (true) {
                    this.ch = this.in.read();
                    switch (this.ch) {
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            this.putCh(this.ch);
                            if (overflow) continue block6;
                            overflow = (value = value * 10L + (long)(this.ch - 48)) > 65535L;
                            continue block6;
                        }
                    }
                    break;
                }
                this.intValue = (int)value;
                this.stringValue = this.bufferString();
                this.token = JasmTokens.Token.CPINDEX;
                if (!overflow) break;
                this.env.error(this.pos, "overflow");
                break;
            }
            default: {
                this.stringValue = Character.toString((char)this.ch);
                this.env.error(this.in.pos, "invalid.number", (Object)this.stringValue);
                this.intValue = 0;
                this.token = JasmTokens.Token.CPINDEX;
                this.ch = this.in.read();
            }
        }
    }

    private void scanNumber() throws IOException {
        boolean seenNonOctal = false;
        boolean overflow = false;
        this.radix = this.ch == 48 ? 8 : 10;
        long value = this.ch - 48;
        this.count = 0;
        this.putCh(this.ch);
        block9: while (true) {
            this.ch = this.in.read();
            switch (this.ch) {
                case 46: {
                    if (this.radix == 16) break block9;
                    this.scanReal();
                    return;
                }
                case 56: 
                case 57: {
                    seenNonOctal = true;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: {
                    this.putCh(this.ch);
                    if (this.radix == 10) {
                        overflow = overflow || value * 10L / 10L != value;
                        value = value * 10L + (long)(this.ch - 48);
                        overflow = overflow || value - 1L < -1L;
                        continue block9;
                    }
                    if (this.radix == 8) {
                        overflow = overflow || value >>> 61 != 0L;
                        value = (value << 3) + (long)(this.ch - 48);
                        continue block9;
                    }
                    overflow = overflow || value >>> 60 != 0L;
                    value = (value << 4) + (long)(this.ch - 48);
                    continue block9;
                }
                case 68: 
                case 69: 
                case 70: 
                case 100: 
                case 101: 
                case 102: {
                    if (this.radix != 16) {
                        this.scanReal();
                        return;
                    }
                }
                case 65: 
                case 66: 
                case 67: 
                case 97: 
                case 98: 
                case 99: {
                    this.putCh(this.ch);
                    if (this.radix != 16) break block9;
                    overflow = overflow || value >>> 60 != 0L;
                    value = (value << 4) + 10L + (long)Character.toLowerCase((char)this.ch) - 97L;
                    continue block9;
                }
                case 76: 
                case 108: {
                    this.ch = this.in.read();
                    this.longValue = value;
                    this.token = JasmTokens.Token.LONGVAL;
                    break block9;
                }
                case 88: 
                case 120: {
                    if (this.count != 1 || this.radix != 8) break block9;
                    this.radix = 16;
                    continue block9;
                }
                default: {
                    this.intValue = (int)value;
                    this.token = JasmTokens.Token.INTVAL;
                    break block9;
                }
            }
            break;
        }
        if (Scanner.isUCDigit(this.ch) || Scanner.isUCLetter(this.ch) || this.ch == 46) {
            this.env.error(this.in.pos, "invalid.number", (Object)Character.toString((char)this.ch));
            do {
                this.ch = this.in.read();
            } while (Scanner.isUCDigit(this.ch) || Scanner.isUCLetter(this.ch) || this.ch == 46);
            this.intValue = 0;
            this.token = JasmTokens.Token.INTVAL;
        } else if (this.radix == 8 && seenNonOctal) {
            this.intValue = 0;
            this.token = JasmTokens.Token.INTVAL;
            this.env.error(this.in.pos, "invalid.octal.number");
        } else if (overflow || this.token == JasmTokens.Token.INTVAL && (this.radix == 10 ? this.intValue - 1 < -1 : (value & 0xFFFFFFFF00000000L) != 0L)) {
            this.intValue = 0;
            this.longValue = 0L;
            this.env.error(this.pos, "overflow");
        }
    }

    private void scanReal() throws IOException {
        char lastChar;
        boolean seenExponent = false;
        boolean isSingleFloat = false;
        if (this.ch == 46) {
            this.putCh(this.ch);
            this.ch = this.in.read();
        }
        block9: while (true) {
            switch (this.ch) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.putCh(this.ch);
                    break;
                }
                case 69: 
                case 101: {
                    if (seenExponent) break block9;
                    this.putCh(this.ch);
                    seenExponent = true;
                    break;
                }
                case 43: 
                case 45: {
                    lastChar = this.buffer[this.count - 1];
                    if (lastChar != 'e' && lastChar != 'E') break block9;
                    this.putCh(this.ch);
                    break;
                }
                case 70: 
                case 102: {
                    this.ch = this.in.read();
                    isSingleFloat = true;
                    break block9;
                }
                case 68: 
                case 100: {
                    this.ch = this.in.read();
                }
                default: {
                    break block9;
                }
            }
            this.ch = this.in.read();
        }
        if (Scanner.isUCDigit(this.ch) || Scanner.isUCLetter(this.ch) || this.ch == 46) {
            this.env.error(this.in.pos, "invalid.number", (Object)Character.toString((char)this.ch));
            do {
                this.ch = this.in.read();
            } while (Scanner.isUCDigit(this.ch) || Scanner.isUCLetter(this.ch) || this.ch == 46);
            this.doubleValue = 0.0;
            this.token = JasmTokens.Token.DOUBLEVAL;
        } else {
            this.token = isSingleFloat ? JasmTokens.Token.FLOATVAL : JasmTokens.Token.DOUBLEVAL;
            try {
                lastChar = this.buffer[this.count - 1];
                if (lastChar == 'e' || lastChar == 'E' || lastChar == '+' || lastChar == '-') {
                    this.env.error(this.in.pos - 1, "float.format");
                } else if (isSingleFloat) {
                    this.floatValue = Float.valueOf(this.bufferString()).floatValue();
                    if (Float.isInfinite(this.floatValue)) {
                        this.env.error(this.pos, "overflow");
                    }
                } else {
                    this.doubleValue = Double.valueOf(this.bufferString());
                    if (Double.isInfinite(this.doubleValue)) {
                        this.env.error(this.pos, "overflow");
                        this.env.error(this.pos, "overflow");
                    }
                }
            }
            catch (NumberFormatException ee) {
                this.env.error(this.pos, "float.format");
                this.doubleValue = 0.0;
                this.floatValue = 0.0f;
            }
        }
    }

    private int scanEscapeChar() throws IOException {
        int p = this.in.pos;
        this.ch = this.in.read();
        switch (this.ch) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                int n = this.ch - 48;
                block15: for (int i = 2; i > 0; --i) {
                    this.ch = this.in.read();
                    switch (this.ch) {
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: {
                            n = (n << 3) + this.ch - 48;
                            continue block15;
                        }
                        default: {
                            if (n > 255) {
                                this.env.error(p, "invalid.escape.char");
                            }
                            return n;
                        }
                    }
                }
                this.ch = this.in.read();
                if (n > 255) {
                    this.env.error(p, "invalid.escape.char");
                }
                return n;
            }
            case 114: {
                this.ch = this.in.read();
                return 13;
            }
            case 110: {
                this.ch = this.in.read();
                return 10;
            }
            case 102: {
                this.ch = this.in.read();
                return 12;
            }
            case 98: {
                this.ch = this.in.read();
                return 8;
            }
            case 116: {
                this.ch = this.in.read();
                return 9;
            }
            case 92: {
                this.ch = this.in.read();
                return 92;
            }
            case 34: {
                this.ch = this.in.read();
                return 34;
            }
            case 39: {
                this.ch = this.in.read();
                return 39;
            }
            case 117: {
                int unich = this.in.convertUnicode();
                this.ch = this.in.read();
                return unich;
            }
        }
        return 92;
    }

    private void scanString() throws IOException {
        this.token = JasmTokens.Token.STRINGVAL;
        this.count = 0;
        this.ch = this.in.read();
        block6: while (true) {
            switch (this.ch) {
                case -1: {
                    this.env.error(this.pos, "eof.in.string");
                    this.stringValue = this.bufferString();
                    return;
                }
                case 10: {
                    this.ch = this.in.read();
                    this.env.error(this.pos, "newline.in.string");
                    this.stringValue = this.bufferString();
                    return;
                }
                case 34: {
                    this.ch = this.in.read();
                    this.stringValue = this.bufferString();
                    return;
                }
                case 92: {
                    int c = this.scanEscapeChar();
                    if (c < 0) continue block6;
                    this.putCh((char)c);
                    continue block6;
                }
            }
            this.putCh(this.ch);
            this.ch = this.in.read();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void scanIdentifier(char[] prefix) throws IOException {
        block16: {
            this.count = 0;
            if (prefix != null) {
                while (true) lbl-1000:
                // 4 sources

                {
                    for (i = 0; i < prefix.length; ++i) {
                        this.putCh(prefix[i]);
                    }
                    this.ch = this.in.read();
                    if (this.ch != 92) break block16;
                    this.ch = this.in.read();
                    if (this.ch == 117) {
                        this.ch = this.in.convertUnicode();
                        if (Scanner.isUCLetter(this.ch) || Scanner.isUCDigit(this.ch)) break;
                        prefix = new char[]{(char)this.ch};
                        ** continue;
                    }
                    if (!this.escapingAllowed.test(this.ch)) break;
                    prefix = new char[]{(char)this.ch};
                }
                p = this.in.pos;
                this.env.error(p, "invalid.escape.char");
            }
        }
        firstChar = this.ch;
        firstIteration = true;
        block7: while (true) {
            this.putCh(this.ch);
            this.ch = this.in.read();
            if (firstIteration && firstChar == 64) {
                if (this.ch == 84) {
                    this.putCh(this.ch);
                    this.ch = this.in.read();
                }
                if (this.ch == 43 || this.ch == 45) {
                    this.putCh(this.ch);
                    this.ch = this.in.read();
                }
                this.stringValue = this.idValue = this.bufferString();
                this.token = JasmTokens.Token.ANNOTATION;
                return;
            }
            firstIteration = false;
            switch (this.ch) {
                case 36: 
                case 40: 
                case 41: 
                case 45: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 60: 
                case 62: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 93: 
                case 95: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: {
                    continue block7;
                }
                case 47: {
                    c = this.in.lookForward();
                    if (c != 42 && c != 47) continue block7;
                    break block7;
                }
                case 92: {
                    this.ch = this.in.read();
                    if (this.ch == 117) {
                        this.ch = this.in.convertUnicode();
                        if (Scanner.isUCLetter(this.ch) || Scanner.isUCDigit(this.ch)) {
                            continue block7;
                        }
                    } else {
                        if (!this.escapingAllowed.test(this.ch)) ** break;
                        continue block7;
                    }
                    p = this.in.pos;
                    this.env.error(p, "invalid.escape.char");
                }
            }
            break;
        }
        this.stringValue = this.idValue = this.bufferString();
        this.token = JasmTokens.keyword_token_ident(this.idValue);
        this.debugStr(String.format("##### SCANNER (scanIdent) ######## token = %s value = \"%s\"\n", new Object[]{this.token, this.idValue}));
    }

    /*
     * Enabled aggressive block sorting
     */
    protected final void xscan() throws IOException {
        this.docComment = null;
        block27: while (true) {
            this.pos = this.in.pos;
            switch (this.ch) {
                case -1: {
                    this.token = JasmTokens.Token.EOF;
                    return;
                }
                case 9: 
                case 10: 
                case 12: 
                case 32: {
                    this.ch = this.in.read();
                    continue block27;
                }
                case 47: {
                    this.ch = this.in.read();
                    switch (this.ch) {
                        case 47: {
                            while (true) {
                                if ((this.ch = this.in.read()) == -1 || this.ch == 10) continue block27;
                            }
                        }
                        case 42: {
                            this.ch = this.in.read();
                            if (this.ch == 42) {
                                this.docComment = this.scanDocComment();
                                continue block27;
                            }
                            this.skipComment();
                            continue block27;
                        }
                    }
                    this.token = JasmTokens.Token.DIV;
                    return;
                }
                case 34: {
                    this.scanString();
                    return;
                }
                case 45: {
                    this.intValue = -1;
                    this.token = JasmTokens.Token.SIGN;
                    this.ch = this.in.read();
                    return;
                }
                case 43: {
                    this.intValue = 1;
                    this.ch = this.in.read();
                    this.token = JasmTokens.Token.SIGN;
                    return;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.scanNumber();
                    return;
                }
                case 46: {
                    this.ch = this.in.read();
                    switch (this.ch) {
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            this.count = 0;
                            this.putCh(46);
                            this.scanReal();
                            return;
                        }
                    }
                    this.token = JasmTokens.Token.FIELD;
                    return;
                }
                case 123: {
                    this.ch = this.in.read();
                    this.token = JasmTokens.Token.LBRACE;
                    return;
                }
                case 125: {
                    this.ch = this.in.read();
                    this.token = JasmTokens.Token.RBRACE;
                    return;
                }
                case 44: {
                    this.ch = this.in.read();
                    this.token = JasmTokens.Token.COMMA;
                    return;
                }
                case 59: {
                    this.ch = this.in.read();
                    this.token = JasmTokens.Token.SEMICOLON;
                    return;
                }
                case 58: {
                    this.ch = this.in.read();
                    this.token = JasmTokens.Token.COLON;
                    return;
                }
                case 61: {
                    this.ch = this.in.read();
                    if (this.ch == 61) {
                        this.ch = this.in.read();
                        this.token = JasmTokens.Token.EQ;
                        return;
                    }
                    this.token = JasmTokens.Token.ASSIGN;
                    return;
                }
                case 36: 
                case 40: 
                case 41: 
                case 60: 
                case 62: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 93: 
                case 95: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: {
                    this.scanIdentifier(null);
                    return;
                }
                case 26: {
                    this.ch = this.in.read();
                    if (this.ch == -1) {
                        this.token = JasmTokens.Token.EOF;
                        return;
                    }
                    this.env.error(this.pos, "funny.char");
                    this.ch = this.in.read();
                    continue block27;
                }
                case 35: {
                    int c = this.in.lookForward();
                    if (c == 123) {
                        this.ch = this.in.read();
                        this.token = JasmTokens.Token.PARAM_NAME;
                        return;
                    }
                    this.scanCPRef();
                    return;
                }
                case 92: {
                    this.ch = this.in.read();
                    if (this.ch == 117) {
                        this.ch = this.in.convertUnicode();
                        if (!Scanner.isUCLetter(this.ch)) break;
                        this.scanIdentifier(null);
                        return;
                    }
                    if (!this.escapingAllowed.test(this.ch)) break;
                    this.scanIdentifier(new char[]{'\\', (char)this.ch});
                    return;
                }
            }
            this.env.out.println("funny.char:" + this.env.lineNumber(this.pos) + "/" + (this.pos & 0x7FFFF));
            this.env.error(this.pos, "funny.char");
            this.ch = this.in.read();
        }
    }

    @Override
    protected void debugScan(String dbstr) {
        if (this.token == null) {
            this.env.traceln(dbstr + "<<<NULL TOKEN>>>");
            return;
        }
        this.env.trace(dbstr + (Object)((Object)this.token));
        switch (this.token) {
            case IDENT: {
                this.env.traceln(" = '" + this.stringValue + "' {idValue = '" + this.idValue + "'}");
                break;
            }
            case STRINGVAL: {
                this.env.traceln(" = {stringValue}: \"" + this.stringValue + "\"");
                break;
            }
            case INTVAL: {
                this.env.traceln(" = {intValue}: " + this.intValue + "}");
                break;
            }
            case FLOATVAL: {
                this.env.traceln(" = {floatValue}: " + this.floatValue);
                break;
            }
            case DOUBLEVAL: {
                this.env.traceln(" = {doubleValue}: " + this.doubleValue);
                break;
            }
            default: {
                this.env.traceln("");
            }
        }
    }

    protected static class SyntaxError
    extends Error {
        boolean fatalError = false;

        protected SyntaxError() {
        }

        SyntaxError Fatal() {
            this.fatalError = true;
            return this;
        }

        boolean isFatal() {
            return this.fatalError;
        }
    }
}

