/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openjdk.asmtools.jasm.CheckedDataOutputStream;
import org.openjdk.asmtools.jasm.Data;

public class DataVector<T extends Data>
implements Iterable<T> {
    ArrayList<T> elements;

    public DataVector(int initSize) {
        this.elements = new ArrayList(initSize);
    }

    public DataVector() {
        this(12);
    }

    @Override
    public Iterator<T> iterator() {
        return this.elements.iterator();
    }

    public void add(T element) {
        this.elements.add(element);
    }

    public void addAll(List<T> collection) {
        this.elements.addAll(collection);
    }

    public int getLength() {
        int length = 0;
        for (Data element : this.elements) {
            length += element.getLength();
        }
        return 2 + length;
    }

    public void write(CheckedDataOutputStream out) throws IOException {
        out.writeShort(this.elements.size());
        this.writeElements(out);
    }

    public void writeElements(CheckedDataOutputStream out) throws IOException {
        for (Data element : this.elements) {
            element.write(out);
        }
    }

    public void addElement(T element) {
        this.elements.add(element);
    }

    public int size() {
        return this.elements.size();
    }

    public Data elementAt(int k) {
        return (Data)this.elements.get(k);
    }
}

