/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

public class CFVersion
implements Cloneable {
    public static final short DEFAULT_MAJOR_VERSION = 45;
    public static final short DEFAULT_MINOR_VERSION = 3;
    public static final short DEFAULT_MODULE_MAJOR_VERSION = 53;
    public static final short DEFAULT_MODULE_MINOR_VERSION = 0;
    public static final short UNDEFINED_VERSION = -1;
    private short major_version;
    private short minor_version;
    private boolean frozen;
    private boolean isSet;

    public CFVersion() {
        this.frozen = false;
        this.isSet = false;
        this.major_version = (short)-1;
        this.minor_version = (short)-1;
    }

    public CFVersion(boolean frozenCFV, short major_version, short minor_version) {
        this.isSet = true;
        this.frozen = frozenCFV;
        this.major_version = major_version;
        this.minor_version = minor_version;
    }

    public void setMajorVersion(short major_version) {
        if (!this.frozen) {
            this.isSet = true;
            this.major_version = major_version;
        }
    }

    public void setMinorVersion(short minor_version) {
        if (!this.frozen) {
            this.isSet = true;
            this.minor_version = minor_version;
        }
    }

    public String asString() {
        return this.isSet ? this.major_version + ":" + this.minor_version : "(undef):(undef)";
    }

    public void initModuleDefaults() {
        if (!this.isSet) {
            this.major_version = (short)53;
            this.minor_version = 0;
        }
    }

    public void initClassDefaults() {
        if (!this.isSet) {
            this.major_version = (short)45;
            this.minor_version = (short)3;
        }
    }

    public short minor_version() {
        return this.minor_version;
    }

    public short major_version() {
        return this.major_version;
    }

    public CFVersion clone() {
        try {
            return (CFVersion)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

