/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.util;

import com.sun.javatest.util.DynamicArray;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.WrapWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;

public class HelpTree {
    private static final int ALL = 1;
    private static final int ANY = 2;
    private Node[] nodes;
    private int nodeIndent = 4;
    private int descriptionIndent = 16;
    private Comparator<Node> nodeComparator = new Comparator<Node>(){

        @Override
        public int compare(Node n1, Node n2) {
            int v = this.compareStrings(n1.name, n2.name);
            return v != 0 ? v : this.compareStrings(n1.description, n2.description);
        }

        private int compareStrings(String s1, String s2) {
            if (s1 == null && s2 == null) {
                return 0;
            }
            if (s1 == null || s2 == null) {
                return s1 == null ? -1 : 1;
            }
            return s1.toLowerCase().compareTo(s2.toLowerCase());
        }
    };

    public HelpTree() {
        this.nodes = new Node[0];
    }

    public HelpTree(Node ... nodes) {
        this.nodes = nodes;
    }

    public void addNode(Node node) {
        this.nodes = DynamicArray.append(this.nodes, node);
    }

    public int getNodeIndent() {
        return this.nodeIndent;
    }

    public void setNodeIndent(int n) {
        this.nodeIndent = n;
    }

    public int getDescriptionIndent() {
        return this.descriptionIndent;
    }

    public void setDescriptionIndent(int n) {
        this.descriptionIndent = n;
    }

    public Selection find(String ... words) {
        Selection s = this.find(words, 1);
        if (s == null && words.length > 1) {
            s = this.find(words, 2);
        }
        return s;
    }

    public Selection findAll(String ... words) {
        return this.find(words, 1);
    }

    public Selection findAny(String ... words) {
        return this.find(words, 2);
    }

    private Selection find(String[] words, int mode) {
        TreeMap<Node, Selection> map = null;
        for (Node node : this.nodes) {
            Selection s = this.find(node, words, mode);
            if (s == null) continue;
            if (map == null) {
                map = new TreeMap<Node, Selection>(this.nodeComparator);
            }
            map.put(node, s);
        }
        return map == null ? null : new Selection(map);
    }

    private Selection find(Node node, String[] words, int mode) {
        if (mode == 1) {
            if (this.containsAllOf(node.name, words) || this.containsAllOf(node.description, words)) {
                return new Selection(node);
            }
        } else if (mode == 2) {
            if (this.containsAnyOf(node.name, words) || this.containsAnyOf(node.description, words)) {
                return new Selection(node);
            }
        } else {
            throw new IllegalArgumentException();
        }
        if (node.children == null) {
            return null;
        }
        TreeMap<Node, Selection> map = null;
        for (int i = 0; i < node.children.length; ++i) {
            Node child = node.children[i];
            Selection s = this.find(child, words, mode);
            if (s == null) continue;
            if (map == null) {
                map = new TreeMap<Node, Selection>(this.nodeComparator);
            }
            map.put(child, s);
        }
        return map == null ? null : new Selection(node, map);
    }

    public void write(Writer out) throws IOException {
        WrapWriter ww = this.getWrapWriter(out);
        for (Node node : this.nodes) {
            this.write(ww, node);
            ww.write('\n');
        }
        if (ww != out) {
            ww.flush();
        }
    }

    public void write(Writer out, Selection s) throws IOException {
        WrapWriter ww = this.getWrapWriter(out);
        this.write(ww, s.map);
        if (ww != out) {
            ww.flush();
        }
    }

    public void writeSummary(Writer out) throws IOException {
        WrapWriter ww = this.getWrapWriter(out);
        for (Node node : this.nodes) {
            this.writeHead(ww, node);
        }
        if (ww != out) {
            ww.flush();
        }
    }

    public Comparator<Node> getNodeComparator() {
        return this.nodeComparator;
    }

    public void setNodeComparator(Comparator<Node> comparator) {
        this.nodeComparator = comparator;
    }

    private void write(WrapWriter out, Map<Node, Selection> m) throws IOException {
        int margin = out.getLeftMargin();
        for (Map.Entry<Node, Selection> e : m.entrySet()) {
            Node node = e.getKey();
            Selection s = e.getValue();
            if (s.map == null) {
                this.write(out, node);
            } else {
                this.writeHead(out, node);
                out.setLeftMargin(margin + this.nodeIndent);
                this.write(out, s.map);
                out.setLeftMargin(margin);
            }
            if (margin != 0) continue;
            out.write('\n');
        }
    }

    private void write(WrapWriter out, Node node) throws IOException {
        int baseMargin = out.getLeftMargin();
        this.writeHead(out, node);
        Node[] children = node.children;
        if (children != null && children.length > 0) {
            out.setLeftMargin(baseMargin + this.nodeIndent);
            for (Node aChildren : children) {
                this.write(out, aChildren);
            }
        }
        out.setLeftMargin(baseMargin);
    }

    private void writeHead(WrapWriter out, Node node) throws IOException {
        int baseMargin = out.getLeftMargin();
        String name = node.name;
        String desc = node.description;
        if (name != null) {
            out.write(name);
            out.write(' ');
            if (desc != null) {
                out.setLeftMargin(baseMargin + this.descriptionIndent);
                if (out.getCharsOnLineSoFar() + 2 > out.getLeftMargin()) {
                    out.write('\n');
                }
                out.write(desc);
            }
            out.write('\n');
        }
        out.setLeftMargin(baseMargin);
    }

    private boolean containsAllOf(String text, String ... words) {
        for (String word : words) {
            if (this.contains(text, word)) continue;
            return false;
        }
        return true;
    }

    private boolean containsAnyOf(String text, String ... words) {
        for (String word : words) {
            if (!this.contains(text, word)) continue;
            return true;
        }
        return false;
    }

    private boolean contains(String text, String word) {
        int startIndex = text.toLowerCase().indexOf(word.toLowerCase());
        if (startIndex == -1) {
            return false;
        }
        int endIndex = startIndex + word.length();
        return !(startIndex != 0 && Character.isLetter(text.charAt(startIndex - 1)) || endIndex != text.length() && Character.isLetter(text.charAt(endIndex)));
    }

    private WrapWriter getWrapWriter(Writer out) {
        return out instanceof WrapWriter ? (WrapWriter)out : new WrapWriter(out);
    }

    public static class Node {
        private String name;
        private String description;
        private Node[] children;

        public Node(String name, String description) {
            this.name = name;
            this.description = description;
        }

        public Node(String name, String description, Node ... children) {
            this.name = name;
            this.description = description;
            this.children = children;
        }

        public Node(I18NResourceBundle i18n, String prefix) {
            this.name = i18n.getString(prefix + ".name");
            this.description = i18n.getString(prefix + ".desc");
        }

        public Node(I18NResourceBundle i18n, String prefix, Node ... children) {
            this(i18n, prefix);
            this.children = children;
        }

        public Node(I18NResourceBundle i18n, String prefix, String ... entries) {
            this(i18n, prefix);
            this.children = new Node[entries.length];
            for (int i = 0; i < this.children.length; ++i) {
                this.children[i] = new Node(i18n, prefix + '.' + entries[i]);
            }
        }

        public final String getName() {
            return this.name;
        }

        public final String getDescription() {
            return this.description;
        }

        public int getChildCount() {
            return this.children == null ? 0 : this.children.length;
        }

        public Node getChild(int i) {
            if (i >= this.getChildCount()) {
                throw new IllegalArgumentException();
            }
            return this.children[i];
        }
    }

    public static class Selection {
        private Node node;
        private Map<Node, Selection> map;

        private Selection(Node node) {
            this(node, (Map<Node, Selection>)null);
        }

        private Selection(Map<Node, Selection> map) {
            this(null, map);
        }

        private Selection(Node node, Map<Node, Selection> map) {
            this.node = node;
            this.map = map;
        }
    }
}

