/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.ExcludeList;
import com.sun.javatest.TestDescription;
import com.sun.javatest.util.DynamicArray;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

public class KnownFailuresList {
    public static final String KFLFILE_EXTN = ".kfl";
    public static final String KFL_FILE_VERSION = "1.0";
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(KnownFailuresList.class);
    private Map<Key, Object> table = new HashMap<Key, Object>();
    private String title;
    private boolean strict;

    public KnownFailuresList() {
    }

    public KnownFailuresList(File f) throws FileNotFoundException, IOException, Fault {
        this(f, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KnownFailuresList(File f, boolean strict) throws FileNotFoundException, IOException, Fault {
        this.setStrictModeEnabled(strict);
        if (f != null) {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), StandardCharsets.UTF_8));
            Parser p = new Parser(in);
            try {
                Entry e;
                while ((e = p.readEntry()) != null) {
                    this.addEntry(e);
                }
            }
            finally {
                in.close();
            }
            this.title = p.getTitle();
        }
    }

    public KnownFailuresList(File ... files) throws FileNotFoundException, IOException, Fault {
        this(files, false);
    }

    public KnownFailuresList(File[] files, boolean strict) throws FileNotFoundException, IOException, Fault {
        this.setStrictModeEnabled(strict);
        for (File file : files) {
            KnownFailuresList kfl = new KnownFailuresList(file, strict);
            this.merge(kfl);
        }
    }

    public static boolean isKflFile(File f) {
        return f.getPath().endsWith(KFLFILE_EXTN);
    }

    private static boolean equals(String s1, String s2) {
        return s1 == null && s2 == null || s1 != null && s2 != null && s1.equals(s2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntry(Entry e) throws Fault {
        Map<Key, Object> map = this.table;
        synchronized (map) {
            Key key = new Key(e.relativeURL);
            Object o = this.table.get(key);
            if (o == null) {
                this.table.put(key, e);
            } else if (o instanceof Entry) {
                Entry curr = (Entry)o;
                if (curr.testCase == null) {
                    if (e.testCase == null) {
                        this.table.put(key, e);
                    } else if (this.strict) {
                        throw new Fault(i18n, "kfl.cantListCase", e.relativeURL);
                    }
                } else if (e.testCase == null) {
                    if (this.strict) {
                        throw new Fault(i18n, "kfl.cantListTest", e.relativeURL);
                    }
                    this.table.put(key, e);
                } else if (curr.testCase.equals(e.testCase)) {
                    this.table.put(key, e);
                } else {
                    this.table.put(key, new Entry[]{curr, e});
                }
            } else if (e.testCase == null) {
                if (this.strict) {
                    throw new Fault(i18n, "kfl.cantListTest", e.relativeURL);
                }
                this.table.put(key, e);
            } else {
                Entry[] curr = (Entry[])o;
                for (int i = 0; i < curr.length; ++i) {
                    if (!curr[i].testCase.equals(e.testCase)) continue;
                    curr[i] = e;
                    return;
                }
                this.table.put(key, DynamicArray.append(curr, e));
            }
        }
    }

    public boolean isStrictModeEnabled() {
        return this.strict;
    }

    public void setStrictModeEnabled(boolean on) {
        this.strict = on;
    }

    public Iterator<Entry> getIterator(boolean group) {
        if (group) {
            ArrayList<Entry> result = new ArrayList<Entry>();
            for (Object value : this.table.values()) {
                result.add((Entry)value);
            }
            return result.iterator();
        }
        ArrayList<Entry> v = new ArrayList<Entry>(this.table.size());
        for (Object value : this.table.values()) {
            if (value instanceof Entry) {
                v.add((Entry)value);
                continue;
            }
            Collections.addAll(v, (Entry[])value);
        }
        return v.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(KnownFailuresList other) {
        Map<Key, Object> map = this.table;
        synchronized (map) {
            Iterator<Entry> iter = other.getIterator(false);
            while (iter.hasNext()) {
                Entry otherEntry = iter.next();
                Key key = new Key(otherEntry.relativeURL);
                Object o = this.table.get(key);
                if (o == null) {
                    this.table.put(key, otherEntry);
                    continue;
                }
                if (o instanceof Entry) {
                    Entry curr = (Entry)o;
                    if (curr.testCase == null || otherEntry.testCase == null) {
                        this.table.put(key, new Entry(curr.relativeURL, null, ExcludeList.mergeBugIds(curr.bugIdStrings, otherEntry.bugIdStrings), ExcludeList.mergeSynopsis(curr.notes, otherEntry.notes)));
                        continue;
                    }
                    this.table.put(key, new Entry[]{curr, otherEntry});
                    continue;
                }
                if (otherEntry.testCase == null) {
                    Entry[] curr;
                    String[] bugIdStrings = otherEntry.bugIdStrings;
                    String notes = otherEntry.notes;
                    for (Entry aCurr : curr = (Entry[])o) {
                        bugIdStrings = ExcludeList.mergeBugIds(bugIdStrings, aCurr.bugIdStrings);
                        notes = ExcludeList.mergeSynopsis(notes, aCurr.notes);
                    }
                    this.table.put(key, new Entry(otherEntry.relativeURL, null, bugIdStrings, notes));
                    continue;
                }
                this.table.put(key, DynamicArray.append((Entry[])o, otherEntry));
            }
        }
    }

    public Entry[] find(String url) {
        Object o = this.table.get(new Key(url));
        if (o == null) {
            return null;
        }
        if (o instanceof Entry[]) {
            return (Entry[])o;
        }
        return new Entry[]{(Entry)o};
    }

    public Entry find(String url, String tc) {
        Entry[] entries = this.find(url);
        if (entries == null || entries.length == 0) {
            return null;
        }
        for (Entry e : entries) {
            if (!e.containsTestCase(tc)) continue;
            return e;
        }
        return null;
    }

    public boolean listsAllOf(TestDescription td) {
        return this.listsAllOf(td.getRootRelativeURL());
    }

    public boolean listsAllOf(String url) {
        Object o = this.table.get(new Key(url));
        return o != null && o instanceof Entry && ((Entry)o).testCase == null;
    }

    public boolean listsAnyOf(TestDescription td) {
        return this.listsAnyOf(td.getRootRelativeURL());
    }

    public boolean listsAnyOf(String url) {
        Object o = this.table.get(new Key(url));
        return o != null;
    }

    public boolean isEmpty() {
        return this.table.isEmpty();
    }

    public int size() {
        return 0;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void write(File f) throws IOException {
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), StandardCharsets.UTF_8));
        out.write("### KFL/");
        out.write(KFL_FILE_VERSION);
        out.newLine();
        out.write("### Known Failures List");
        out.newLine();
        if (this.title != null) {
            out.write("### title " + this.title);
            out.newLine();
        }
        out.close();
    }

    private void write(Writer out, String s, int width) throws IOException {
        out.write(s);
        for (int i = s.length(); i < width; ++i) {
            out.write(32);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KnownFailuresList other = (KnownFailuresList)obj;
        return this.table == other.table || this.table != null && this.table.equals(other.table);
    }

    public int hashCode() {
        int hash = 3;
        hash = 71 * hash + (this.table != null ? this.table.hashCode() : 0);
        return hash;
    }

    private static final class Parser {
        private Reader in;
        private int ch;
        private String title;

        Parser(Reader in) throws IOException {
            this.in = in;
            this.ch = in.read();
        }

        String getTitle() {
            return this.title;
        }

        Entry readEntry() throws IOException, Fault {
            int i;
            String url = this.readURL();
            if (url == null) {
                return null;
            }
            String testCase = null;
            if (url.endsWith("]") && (i = url.lastIndexOf(91)) != -1) {
                testCase = url.substring(i + 1, url.length() - 1);
                url = url.substring(0, i);
            }
            String[] bugIdStrings = this.readBugIds();
            String note = this.readRest();
            return new Entry(url, testCase, bugIdStrings, note);
        }

        private boolean isEndOfLine(int ch) {
            return ch == -1 || ch == 10 || ch == 13;
        }

        private boolean isWhitespace(int ch) {
            return ch == 32 || ch == 9;
        }

        private String readURL() throws IOException {
            block5: while (true) {
                this.skipWhite();
                switch (this.ch) {
                    case -1: {
                        return null;
                    }
                    case 35: {
                        this.skipComment();
                        continue block5;
                    }
                    case 10: 
                    case 13: {
                        this.ch = this.in.read();
                        continue block5;
                    }
                }
                break;
            }
            return this.readWord();
        }

        private String[] readBugIds() throws IOException {
            this.skipWhite();
            TreeSet<String> s = new TreeSet<String>();
            StringBuilder sb = new StringBuilder();
            while (!this.isEndOfLine(this.ch) && !this.isWhitespace(this.ch)) {
                if (this.ch == 44) {
                    if (sb.length() > 0) {
                        s.add(sb.toString());
                        sb.setLength(0);
                    }
                } else {
                    sb.append((char)this.ch);
                }
                this.ch = this.in.read();
            }
            if (sb.length() > 0) {
                s.add(sb.toString());
            }
            if (s.isEmpty()) {
                s.add("0");
            }
            return s.toArray(new String[s.size()]);
        }

        private String readRest() throws IOException {
            this.skipWhite();
            StringBuilder word = new StringBuilder(80);
            while (!this.isEndOfLine(this.ch)) {
                word.append((char)this.ch);
                this.ch = this.in.read();
            }
            this.ch = this.in.read();
            return word.toString();
        }

        private String readWord() throws IOException {
            StringBuilder word = new StringBuilder(32);
            while (!this.isEndOfLine(this.ch) && !this.isWhitespace(this.ch)) {
                word.append((char)this.ch);
                this.ch = this.in.read();
            }
            return word.toString();
        }

        private void skipComment() throws IOException {
            this.ch = this.in.read();
            if (this.ch == 35) {
                this.ch = this.in.read();
                if (this.ch == 35) {
                    this.ch = this.in.read();
                    this.skipWhite();
                    String s = this.readWord();
                    if (s.equals("title")) {
                        this.skipWhite();
                        this.title = this.readRest();
                        return;
                    }
                }
            }
            while (!this.isEndOfLine(this.ch)) {
                this.ch = this.in.read();
            }
        }

        private void skipWhite() throws IOException {
            while (this.ch != -1 && this.isWhitespace(this.ch)) {
                this.ch = this.in.read();
            }
        }
    }

    public static final class Entry
    implements Comparable<Entry> {
        private String relativeURL;
        private String testCase;
        private String[] bugIdStrings;
        private int[] bugIds;
        private String notes;

        public Entry(String u, String tc, String[] b, String s) {
            if (b == null) {
                throw new NullPointerException();
            }
            if (b.length == 0) {
                throw new IllegalArgumentException();
            }
            this.relativeURL = u;
            this.testCase = tc;
            this.bugIdStrings = b;
            this.notes = s;
        }

        public static Entry read(String text) throws Fault {
            try {
                return new Parser(new StringReader(text)).readEntry();
            }
            catch (IOException e) {
                throw new Fault(i18n, "kfl.badEntry", e);
            }
        }

        private static boolean equals(int[] i1, int ... i2) {
            if (i1 == null || i2 == null) {
                return i1 == null && i2 == null;
            }
            if (i1.length != i2.length) {
                return false;
            }
            for (int x = 0; x < i1.length; ++x) {
                if (i1[x] == i2[x]) continue;
                return false;
            }
            return true;
        }

        private static boolean equals(String[] s1, String ... s2) {
            if (s1 == null || s2 == null) {
                return s1 == null && s2 == null;
            }
            if (s1.length != s2.length) {
                return false;
            }
            for (int x = 0; x < s1.length; ++x) {
                if (Entry.equals(s1[x], s2[x])) continue;
                return false;
            }
            return true;
        }

        private static boolean equals(String s1, String s2) {
            return s1 == null && s2 == null || s1 != null && s2 != null && s1.equals(s2);
        }

        @Override
        public int compareTo(Entry e) {
            int n = this.relativeURL.compareTo(e.relativeURL);
            if (n == 0) {
                if (this.testCase == null && e.testCase == null) {
                    return 0;
                }
                if (this.testCase == null) {
                    return -1;
                }
                if (e.testCase == null) {
                    return 1;
                }
                return this.testCase.compareTo(e.testCase);
            }
            return n;
        }

        public boolean containsTestCase(String s) {
            String[] tcs = this.getTestCaseList();
            if (tcs == null || tcs.length == 0) {
                return false;
            }
            for (String tc : tcs) {
                if (!tc.equals(s)) continue;
                return true;
            }
            return false;
        }

        public String getRelativeURL() {
            return this.relativeURL;
        }

        public String getTestCases() {
            return this.testCase;
        }

        public String[] getTestCaseList() {
            if (this.testCase == null) {
                return null;
            }
            ArrayList<String> v = new ArrayList<String>();
            int start = -1;
            for (int i = 0; i < this.testCase.length(); ++i) {
                if (this.testCase.charAt(i) == ',') {
                    if (start != -1) {
                        v.add(this.testCase.substring(start, i));
                    }
                    start = -1;
                    continue;
                }
                if (start != -1) continue;
                start = i;
            }
            if (start != -1) {
                v.add(this.testCase.substring(start));
            }
            if (v.isEmpty()) {
                return null;
            }
            String[] a = new String[v.size()];
            v.toArray(a);
            return a;
        }

        public String[] getBugIdStrings() {
            return this.bugIdStrings;
        }

        public String getNotes() {
            return this.notes;
        }

        public boolean equals(Object o) {
            if (o instanceof Entry) {
                Entry e = (Entry)o;
                return Entry.equals(this.relativeURL, e.relativeURL) && Entry.equals(this.testCase, e.testCase) && Entry.equals(this.bugIdStrings, e.bugIdStrings) && Entry.equals(this.notes, e.notes);
            }
            return false;
        }

        public int hashCode() {
            return this.relativeURL.hashCode();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(64);
            sb.append(this.relativeURL);
            if (this.testCase != null) {
                sb.append('[');
                sb.append(this.testCase);
                sb.append(']');
            }
            if (this.bugIdStrings != null) {
                for (int i = 0; i < this.bugIdStrings.length; ++i) {
                    sb.append(i == 0 ? (char)' ' : ',');
                    sb.append(this.bugIdStrings[i]);
                }
            }
            if (this.notes != null) {
                sb.append(' ');
                sb.append(this.notes);
            }
            return new String(sb);
        }
    }

    private static class Key {
        private static final char sep = File.separatorChar;
        private String relativeURL;
        private int hash;

        Key(String url) {
            this.relativeURL = url;
        }

        public int hashCode() {
            int h = this.hash;
            if (h == 0) {
                int len = this.relativeURL.length();
                for (int i = 0; i < len; ++i) {
                    char c = Character.toLowerCase(this.relativeURL.charAt(i));
                    if (c == sep) {
                        c = '/';
                    }
                    h = 31 * h + c;
                }
                this.hash = h;
            }
            return h;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof Key)) {
                return false;
            }
            String u1 = this.relativeURL;
            String u2 = ((Key)o).relativeURL;
            int len = u1.length();
            if (len != u2.length()) {
                return false;
            }
            for (int i = 0; i < len; ++i) {
                char c2;
                char c1 = Character.toLowerCase(u1.charAt(i));
                if (c1 == sep) {
                    c1 = '/';
                }
                if ((c2 = Character.toLowerCase(u2.charAt(i))) == sep) {
                    c2 = '/';
                }
                if (c1 == c2) continue;
                return false;
            }
            return true;
        }
    }

    public static class Fault
    extends Exception {
        Fault(I18NResourceBundle i18n, String s, Object o) {
            super(i18n.getString(s, o));
        }
    }
}

