/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.AllTestsFilter;
import com.sun.javatest.CompositeFilter;
import com.sun.javatest.ExcludeList;
import com.sun.javatest.HarnessHttpHandler;
import com.sun.javatest.JavaTestError;
import com.sun.javatest.LastRunInfo;
import com.sun.javatest.Parameters;
import com.sun.javatest.TRT_Iterator;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.TestRunner;
import com.sun.javatest.TestSuite;
import com.sun.javatest.Trace;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.httpd.HttpdServer;
import com.sun.javatest.httpd.RootRegistry;
import com.sun.javatest.util.BackupPolicy;
import com.sun.javatest.util.DynamicArray;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.ReadAheadIterator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Harness {
    private static final boolean ZERO_TESTS_OK = true;
    private static final boolean ZERO_TESTS_ERROR = false;
    private static final int DEFAULT_READ_AHEAD = 100;
    private static File classDir;
    private static I18NResourceBundle i18n;
    private BackupPolicy backupPolicy;
    private int autostopThreshold;
    private HarnessHttpHandler httpHandler;
    private Trace trace;
    private Thread worker;
    private Parameters params;
    private TestSuite testSuite;
    private WorkDirectory workDir;
    private ExcludeList excludeList;
    private TestResultTable.TreeIterator testIter;
    private int readAheadMode = 2;
    private ReadAheadIterator<TestResult> raTestIter;
    private int numTestsDone;
    private TestEnvironment env;
    private TestResultTable resultTable;
    private Notifier notifier = new Notifier();
    private long startTime = -1L;
    private long finishTime = -1L;
    private long cleanupFinishTime = -1L;
    private long testsStartTime = -1L;
    private boolean isBatchRun;
    private boolean stopping;
    public static final String DEBUG_OBSERVER_CLASSNAME_SYS_PROP = "com.sun.javatest.Harness.DEBUG_OBSERVER";

    @Deprecated
    public Harness(File classDir) {
        this();
        Harness.setClassDir(classDir);
    }

    public Harness() {
        String debugObserverClassName;
        Integer i = Integer.getInteger("javatest.autostop.threshold");
        this.autostopThreshold = i == null ? 0 : i;
        this.backupPolicy = BackupPolicy.noBackups();
        this.params = null;
        if (!Boolean.getBoolean("javatest.noTraceRequired")) {
            this.trace = new Trace(this.backupPolicy);
            this.addObserver(this.trace);
        }
        if ((debugObserverClassName = System.getProperty(DEBUG_OBSERVER_CLASSNAME_SYS_PROP)) != null) {
            try {
                Observer debugObserverInstance = Class.forName(debugObserverClassName).asSubclass(Observer.class).getConstructor(new Class[0]).newInstance(new Object[0]);
                this.addObserver(debugObserverInstance);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to instantiate debug observer: " + debugObserverClassName);
            }
        }
        if (HttpdServer.isActive()) {
            this.httpHandler = new HarnessHttpHandler(this);
            RootRegistry.getInstance().addHandler("/harness", "JT Harness", this.httpHandler);
        }
    }

    public static File getClassDir() {
        return classDir;
    }

    public static void setClassDir(File classDir) {
        if (Harness.classDir != null && Harness.classDir != classDir) {
            throw new IllegalStateException(i18n.getString("harness.classDirAlreadySet"));
        }
        Harness.classDir = classDir;
    }

    private static ArrayList<String> listFilterNames(TestFilter ... filters) {
        ArrayList<String> result = new ArrayList<String>();
        if (filters == null || filters.length == 0) {
            return result;
        }
        for (TestFilter f : filters) {
            if (f instanceof CompositeFilter) {
                result.addAll(Harness.listFilterNames(((CompositeFilter)f).getFilters()));
                continue;
            }
            if (f instanceof AllTestsFilter) continue;
            result.add(f.getName());
        }
        return result;
    }

    private static String formatFilterList(List<String> names) {
        if (names == null || names.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String s : names) {
            sb.append("- ");
            sb.append(s);
            sb.append("\n");
        }
        return sb.toString();
    }

    private static String formatFilterStats(String[] tests, TestResultTable.TreeIterator iter) {
        TRT_Iterator treeit = null;
        if (iter == null || !(iter instanceof TRT_Iterator)) {
            return "";
        }
        treeit = (TRT_Iterator)iter;
        TestFilter[] filters = treeit.getFilters();
        HashMap<TestFilter, ArrayList<TestDescription>> map = treeit.getFilterStats();
        Set<TestFilter> keyset = map.keySet();
        StringBuilder sb = new StringBuilder();
        if (tests != null && tests.length > 0) {
            sb.append("- ");
            sb.append("Tests to Run (" + tests.length + " path(s) specified)");
            sb.append("\n");
        }
        for (TestFilter f : keyset) {
            ArrayList<TestDescription> tds = map.get(f);
            sb.append("- ");
            sb.append(tds.size());
            sb.append(" due to ");
            sb.append(f.getName());
            sb.append("\n");
            sb.append("    ");
            sb.append(f.getReason());
            sb.append("\n");
        }
        return sb.toString();
    }

    public BackupPolicy getBackupPolicy() {
        return this.backupPolicy;
    }

    public void setBackupPolicy(BackupPolicy bp) {
        this.backupPolicy = bp;
    }

    public boolean isTracingRequired() {
        return this.trace != null;
    }

    public void setTracingRequired(boolean b) {
        if (b && this.trace == null) {
            this.trace = new Trace(this.backupPolicy);
            this.addObserver(this.trace);
        } else if (!b && this.trace != null) {
            this.removeObserver(this.trace);
            this.trace = null;
        }
    }

    public Parameters getParameters() {
        return this.params;
    }

    public TestEnvironment getEnv() {
        return this.env;
    }

    public TestResultTable getResultTable() {
        WorkDirectory wd = this.params == null ? null : this.params.getWorkDirectory();
        return wd == null ? null : wd.getTestResultTable();
    }

    public void addObserver(Observer o) {
        this.notifier.addObserver(o);
    }

    public void removeObserver(Observer o) {
        this.notifier.removeObserver(o);
    }

    public void start(Parameters p) throws Fault {
        this.startWorker(p);
    }

    public synchronized void waitUntilDone() throws InterruptedException {
        while (this.worker != null) {
            this.wait();
        }
    }

    public synchronized void stop() {
        if (this.worker != null) {
            if (!this.stopping) {
                this.notifier.stoppingTestRun();
                this.stopping = true;
            }
            this.worker.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean batch(Parameters params) throws Fault {
        this.isBatchRun = true;
        if (Boolean.getBoolean("javatest.noReadAhead")) {
            this.readAheadMode = 0;
        }
        Harness harness = this;
        synchronized (harness) {
            if (this.worker != null) {
                throw new Fault(i18n, "harness.alreadyRunning");
            }
            this.worker = Thread.currentThread();
        }
        if (!params.isValid()) {
            throw new Fault(i18n, "harness.incompleteParameters", (Object)params.getErrorMessage());
        }
        boolean ok = false;
        try {
            this.workDir = params.getWorkDirectory();
            this.resultTable = this.workDir.getTestResultTable();
            ok = this.runTests(params, true);
        }
        catch (TestSuite.Fault e) {
            throw new Fault(i18n, "harness.testsuiteError", (Object)e.getMessage());
        }
        finally {
            Harness harness2 = this;
            synchronized (harness2) {
                this.worker = null;
                this.notifyAll();
            }
            this.notifier.finishedTestRun(ok);
            this.isBatchRun = false;
        }
        return ok;
    }

    public boolean isRunning() {
        return this.worker != null;
    }

    public synchronized boolean isBatchRun() {
        if (!this.isRunning()) {
            throw new IllegalStateException();
        }
        return this.isBatchRun;
    }

    public boolean isAllTestsFound() {
        if (this.isRunning() && this.raTestIter != null) {
            return this.raTestIter.isSourceExhausted();
        }
        return false;
    }

    public long getElapsedTime() {
        long time = 0L;
        if (this.startTime == -1L) {
            time = 0L;
        } else if (this.cleanupFinishTime == -1L) {
            long now = System.currentTimeMillis();
            time = now - this.startTime;
        } else {
            time = this.cleanupFinishTime - this.startTime;
        }
        return time;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    public long getCleanupFinishTime() {
        return this.cleanupFinishTime;
    }

    public long getTotalCleanupTime() {
        if (this.cleanupFinishTime < this.finishTime || this.cleanupFinishTime == -1L) {
            return -1L;
        }
        return this.cleanupFinishTime - this.finishTime;
    }

    public long getTotalSetupTime() {
        if (this.testsStartTime < this.startTime || this.testsStartTime == -1L) {
            return -1L;
        }
        return this.testsStartTime - this.startTime;
    }

    public long getEstimatedTime() {
        if (!this.isRunning() || this.numTestsDone == 0) {
            return 0L;
        }
        return this.getElapsedTime() * (long)(this.getTestsFoundCount() - this.numTestsDone) / (long)this.numTestsDone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTestsFoundCount() {
        if (this.raTestIter == null) {
            return 0;
        }
        ReadAheadIterator<TestResult> readAheadIterator = this.raTestIter;
        synchronized (readAheadIterator) {
            return this.raTestIter.getUsedElementCount() + this.raTestIter.getOutputQueueSize();
        }
    }

    public TestResultTable.TreeIterator getTestIterator() {
        return this.testIter;
    }

    public void setAutostopThreshold(int n) {
        this.autostopThreshold = n;
    }

    public int getAutostopThreshold(int n) {
        return this.autostopThreshold;
    }

    private synchronized void startWorker(Parameters p) throws Fault {
        if (this.worker != null) {
            throw new Fault(i18n, "harness.alreadyRunning");
        }
        this.worker = new Thread(() -> {
            boolean ok = false;
            try {
                ok = this.runTests(p, false);
            }
            catch (Fault | TestSuite.Fault e) {
                this.notifyLocalizedError(e.getMessage());
            }
            finally {
                Harness harness = this;
                synchronized (harness) {
                    this.worker = null;
                    this.notifyAll();
                }
                this.notifier.finishedTestRun(ok);
            }
        });
        this.worker.setName("Harness:Worker");
        this.worker.setPriority(3);
        this.worker.start();
    }

    private boolean runTests(Parameters p, boolean zeroTestsOK) throws Fault, TestSuite.Fault {
        File atsr;
        boolean ok = true;
        this.stopping = false;
        this.startTime = System.currentTimeMillis();
        this.testsStartTime = -1L;
        this.cleanupFinishTime = -1L;
        this.finishTime = -1L;
        this.numTestsDone = 0;
        if (!p.isValid()) {
            throw new Fault(i18n, "harness.incompleteParameters", (Object)p.getErrorMessage());
        }
        this.params = p;
        this.testSuite = this.params.getTestSuite();
        this.workDir = this.params.getWorkDirectory();
        this.resultTable = this.workDir.getTestResultTable();
        this.excludeList = this.params.getExcludeList();
        this.workDir.log(i18n, "harness.starting");
        float tf = this.params.getTimeoutFactor();
        if (Float.isNaN(tf)) {
            tf = 1.0f;
        }
        String[] timeoutFactors = new String[]{String.valueOf((int)Math.ceil(tf)), String.valueOf(tf)};
        this.env = this.params.getEnv();
        this.env.put("javatestTimeoutFactor", timeoutFactors);
        this.env.putUrlAndFile("javatestClassDir", classDir);
        this.env.putUrlAndFile("harnessClassDir", classDir);
        this.env.putUrlAndFile("javatestWorkDir", this.workDir.getRoot());
        String altTSRoot = this.testSuite.getTestSuiteInfo("env.tsRoot");
        File file = atsr = altTSRoot == null ? null : new File(altTSRoot);
        if (atsr != null && atsr.exists()) {
            this.env.putUrlAndFile("testSuiteRoot", atsr);
            this.env.putUrlAndFile("testSuiteRootDir", atsr.isDirectory() ? atsr : atsr.getParentFile());
        } else {
            this.env.putUrlAndFile("testSuiteRoot", this.testSuite.getRoot());
            this.env.putUrlAndFile("testSuiteRootDir", this.testSuite.getRootDir());
        }
        this.testSuite.starting(this);
        this.notifier.startingTestRun(this.params);
        this.testIter = this.createTreeIterator();
        this.raTestIter = this.getTestsIterator(this.testIter);
        if (this.autostopThreshold > 0) {
            this.addObserver(new Autostop(this.autostopThreshold));
        }
        TestRunner r = this.testSuite.createTestRunner();
        r.setWorkDirectory(this.workDir);
        r.setBackupPolicy(this.backupPolicy);
        r.setEnvironment(this.env);
        r.setExcludeList(this.excludeList);
        int concurrency = this.params.getConcurrency();
        concurrency = Math.max(1, Math.min(concurrency, 256));
        r.setConcurrency(concurrency);
        r.setNotifier(this.notifier);
        TestURLCollector testURLCollector = new TestURLCollector();
        this.notifier.addObserver(testURLCollector);
        this.testsStartTime = System.currentTimeMillis();
        try {
            ok = r.runTests(new Iterator<TestDescription>(){

                @Override
                public boolean hasNext() {
                    return Harness.this.stopping ? false : Harness.this.raTestIter.hasNext();
                }

                @Override
                public TestDescription next() {
                    TestResult tr = (TestResult)Harness.this.raTestIter.next();
                    try {
                        return tr.getDescription();
                    }
                    catch (TestResult.Fault e) {
                        Harness.this.stopping = true;
                        throw new JavaTestError(i18n, "harness.trProb", (Object)tr.getWorkRelativePath(), (Throwable)e);
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            });
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.notifier.removeObserver(testURLCollector);
        this.finishTime = System.currentTimeMillis();
        this.notifier.finishedTesting(this.testIter);
        int[] stats = this.testIter.getResultStats();
        int iteratorCount = 0;
        for (int stat : stats) {
            iteratorCount += stat;
        }
        if (iteratorCount == 0 && !zeroTestsOK) {
            TestFilter[] filters = this.params.getFilters();
            this.notifyError(i18n, "harness.noTests", Harness.formatFilterList(Harness.listFilterNames(filters)), this.testIter.getRejectCount(), Harness.formatFilterStats(this.params.getTests(), this.testIter));
            ok = false;
        }
        if (ok && (this.notifier.getErrorCount() > 0 || this.notifier.getFailedCount() > 0)) {
            ok = false;
        }
        try {
            LastRunInfo.writeInfo(this.workDir, this.startTime, this.finishTime, this.env.getName(), testURLCollector.testURLs);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.resultTable.waitUntilReady();
        this.workDir.log(i18n, "harness.done", (Object)(ok ? 0 : 1));
        this.cleanupFinishTime = System.currentTimeMillis();
        return ok;
    }

    public ReadAheadIterator<TestResult> getTestsIterator(TestResultTable.TreeIterator iter) throws Fault {
        if (iter == null) {
            iter = this.createTreeIterator();
        }
        return new ReadAheadIterator<TestResult>(iter, this.readAheadMode, 100);
    }

    private TestResultTable.TreeIterator createTreeIterator() throws Fault {
        TestResultTable.TreeIterator iter;
        String[] tests = this.params.getTests();
        TestFilter[] filters = this.params.getFilters();
        this.resultTable.waitUntilReady();
        if (tests == null || tests.length == 0) {
            iter = this.resultTable.getIterator(filters);
        } else {
            try {
                File[] files = new File[tests.length];
                for (int i = 0; i < tests.length; ++i) {
                    files[i] = new File(tests[i]);
                }
                iter = this.resultTable.getIterator(files, filters);
            }
            catch (TestResultTable.Fault err) {
                throw new Fault(i18n, "harness.badInitFiles", (Object)err.getMessage());
            }
        }
        return iter;
    }

    private void notifyError(I18NResourceBundle i18n, String key) {
        this.notifyLocalizedError(i18n.getString(key));
    }

    private void notifyError(I18NResourceBundle i18n, String key, Object arg) {
        this.notifyLocalizedError(i18n.getString(key, arg));
    }

    private void notifyError(I18NResourceBundle i18n, String key, Object ... args) {
        this.notifyLocalizedError(i18n.getString(key, args));
    }

    private void notifyLocalizedError(String msg) {
        this.notifier.error(msg);
    }

    public void notifyOfTheFinalStats(Map<TestFilter, List<TestDescription>> filterStats, int ... stats) {
        this.notifier.notifyOfTheFinalStats(filterStats, stats);
    }

    static {
        i18n = I18NResourceBundle.getBundleForClass(Harness.class);
    }

    private class Notifier
    implements Observer {
        private Observer[] observers = new Observer[0];
        private volatile int errCount;
        private volatile int failCount;

        private Notifier() {
        }

        void addObserver(Observer o) {
            if (o == null) {
                throw new NullPointerException();
            }
            this.observers = DynamicArray.append(this.observers, o);
        }

        void removeObserver(Observer o) {
            this.observers = DynamicArray.remove(this.observers, o);
        }

        @Override
        public void startingTestRun(Parameters params) {
            Harness.this.resultTable.starting();
            Observer[] stableObservers = this.observers;
            for (int i = stableObservers.length - 1; i >= 0; --i) {
                stableObservers[i].startingTestRun(params);
            }
        }

        @Override
        public void startingTest(TestResult tr) {
            Observer[] stableObservers = this.observers;
            for (int i = stableObservers.length - 1; i >= 0; --i) {
                stableObservers[i].startingTest(tr);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void finishedTest(TestResult tr) {
            Harness.this.numTestsDone++;
            Harness.this.resultTable.update(tr);
            Observer[] stableObservers = this.observers;
            for (int i = stableObservers.length - 1; i >= 0; --i) {
                stableObservers[i].finishedTest(tr);
            }
            switch (tr.getStatus().getType()) {
                case 1: {
                    Notifier notifier = this;
                    synchronized (notifier) {
                        ++this.failCount;
                        break;
                    }
                }
                case 2: {
                    Notifier notifier = this;
                    synchronized (notifier) {
                        ++this.errCount;
                        break;
                    }
                }
            }
        }

        @Override
        public void stoppingTestRun() {
            Observer[] stableObservers = this.observers;
            for (int i = stableObservers.length - 1; i >= 0; --i) {
                stableObservers[i].stoppingTestRun();
            }
        }

        @Override
        public void finishedTesting(TestResultTable.TreeIterator treeIterator) {
            Harness.this.resultTable.finished();
            Observer[] stableObservers = this.observers;
            for (int i = stableObservers.length - 1; i >= 0; --i) {
                stableObservers[i].finishedTesting();
                stableObservers[i].finishedTesting(treeIterator);
            }
        }

        @Override
        public void finishedTestRun(boolean allOK) {
            Observer[] stableObservers = this.observers;
            for (int i = stableObservers.length - 1; i >= 0; --i) {
                stableObservers[i].finishedTestRun(allOK);
            }
        }

        @Override
        public void error(String msg) {
            Observer[] stableObservers = this.observers;
            for (int i = stableObservers.length - 1; i >= 0; --i) {
                stableObservers[i].error(msg);
            }
        }

        @Override
        public void notifyOfTheFinalStats(Map<TestFilter, List<TestDescription>> filterStats, int ... stats) {
            Observer[] stableObservers = this.observers;
            for (int i = stableObservers.length - 1; i >= 0; --i) {
                stableObservers[i].notifyOfTheFinalStats(filterStats, stats);
            }
        }

        synchronized int getErrorCount() {
            return this.errCount;
        }

        synchronized int getFailedCount() {
            return this.failCount;
        }
    }

    public static interface Observer {
        default public void startingTestRun(Parameters params) {
        }

        default public void startingTest(TestResult tr) {
        }

        default public void finishedTest(TestResult tr) {
        }

        default public void stoppingTestRun() {
        }

        default public void finishedTesting() {
        }

        default public void finishedTesting(TestResultTable.TreeIterator treeIterator) {
        }

        default public void finishedTestRun(boolean allOK) {
        }

        default public void error(String msg) {
        }

        default public void notifyOfTheFinalStats(Map<TestFilter, List<TestDescription>> filterStats, int ... stats) {
        }
    }

    public static class Fault
    extends Exception {
        Fault(I18NResourceBundle i18n, String s) {
            super(i18n.getString(s));
        }

        Fault(I18NResourceBundle i18n, String s, Throwable cause) {
            super(i18n.getString(s), cause);
        }

        Fault(I18NResourceBundle i18n, String s, Object o) {
            super(i18n.getString(s, o));
        }

        Fault(I18NResourceBundle i18n, String s, Object ... o) {
            super(i18n.getString(s, o));
        }
    }

    class Autostop
    implements Observer {
        private int level;
        private int threshold;

        Autostop(int threshold) {
            this.threshold = threshold;
        }

        @Override
        public void finishedTest(TestResult tr) {
            switch (tr.getStatus().getType()) {
                case 1: {
                    ++this.level;
                    break;
                }
                case 2: {
                    this.level += 5;
                    break;
                }
                default: {
                    this.level = Math.max(this.level - 2, 0);
                }
            }
            if (this.level >= this.threshold) {
                Harness.this.notifyError(i18n, "harness.tooManyErrors");
                Harness.this.stop();
            }
        }
    }

    static class TestURLCollector
    implements Observer {
        final List<String> testURLs = new ArrayList<String>();

        TestURLCollector() {
        }

        @Override
        public synchronized void startingTest(TestResult tr) {
            this.testURLs.add(tr.getTestName());
        }
    }
}

