/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.tool;

import com.sun.javatest.regtest.agent.SearchPath;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class JarFinder {
    private List<String> jars = new ArrayList<String>();
    private List<String> classes;
    private File libDir;

    JarFinder(String string, String ... stringArray) {
        this.jars.add(string);
        this.jars.addAll(Arrays.asList(stringArray));
    }

    JarFinder classes(String ... stringArray) {
        this.classes = Arrays.asList(stringArray);
        return this;
    }

    JarFinder classes(Class<?> ... classArray) {
        this.classes = new ArrayList<String>();
        for (Class<?> clazz : classArray) {
            this.classes.add(clazz.getName());
        }
        return this;
    }

    JarFinder libDir(File file) {
        this.libDir = file;
        return this;
    }

    SearchPath getPath() {
        Iterator<String> iterator;
        String object4;
        SearchPath searchPath = new SearchPath();
        Object object2 = this.jars.iterator();
        while (object2.hasNext() && (object4 = System.getProperty((String)((Object)(iterator = object2.next())))) != null) {
            searchPath.append(object4);
        }
        if (!searchPath.isEmpty()) {
            return searchPath;
        }
        object2 = System.getProperty("jtreg.home");
        if (object2 != null) {
            iterator = new File((String)object2, "lib");
            for (String string : this.jars) {
                searchPath.append(new File((File)((Object)iterator), string));
            }
            if (!searchPath.isEmpty()) {
                return searchPath;
            }
        }
        if (this.classes != null) {
            for (String string : this.classes) {
                String string2 = string.replace(".", "/") + ".class";
                try {
                    URL uRL = SearchPath.class.getClassLoader().getResource(string2);
                    if (uRL == null) continue;
                    URI uRI = uRL.toURI();
                    if (uRI.getScheme().equals("jar")) {
                        var8_17 = uRI.getRawSchemeSpecificPart();
                        var9_18 = var8_17.lastIndexOf("!");
                        uRI = new URI(var8_17.substring(0, var9_18));
                    } else if (uRI.getScheme().equals("file")) {
                        var8_17 = uRI.getRawSchemeSpecificPart();
                        var9_18 = var8_17.indexOf(string2);
                        uRI = new URI("file://" + var8_17.substring(0, var9_18));
                    }
                    if (!uRI.getScheme().equals("file")) continue;
                    searchPath.append(new File(uRI.getPath()));
                }
                catch (URISyntaxException uRISyntaxException) {
                    uRISyntaxException.printStackTrace(System.err);
                }
            }
            if (!searchPath.isEmpty()) {
                return searchPath;
            }
        }
        if (this.libDir != null) {
            for (String string : this.jars) {
                searchPath.append(new File(this.libDir, string));
            }
        }
        return searchPath;
    }

    File getFile() {
        List<File> list;
        SearchPath searchPath = this.getPath();
        if (searchPath != null && (list = searchPath.asList()).size() == 1) {
            return list.get(0);
        }
        return null;
    }
}

