/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.tool;

import com.sun.javatest.regtest.agent.SearchPath;
import com.sun.javatest.regtest.tool.Option;
import com.sun.javatest.regtest.tool.Tool;
import com.sun.javatest.regtest.tool.Version;
import com.sun.javatest.util.HelpTree;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.WrapWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.JarFile;

public class Help {
    private final List<Option> options;
    private final List<VersionHelper> versionHelpers = new ArrayList<VersionHelper>();
    private boolean releaseNotesFlag;
    private boolean tagSpecFlag;
    private boolean versionFlag;
    private List<String> commandLineHelpQuery;
    private static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(Help.class);

    public Help(List<Option> list) {
        this.options = list;
    }

    boolean isEnabled() {
        return this.versionFlag || this.releaseNotesFlag || this.tagSpecFlag || this.commandLineHelpQuery != null;
    }

    void addVersionHelper(VersionHelper versionHelper) {
        this.versionHelpers.add(versionHelper);
    }

    void addJarVersionHelper(final String string, final File file, final String string2) {
        this.addVersionHelper(new VersionHelper(){

            @Override
            public void showVersion(PrintWriter printWriter) {
                try (JarFile jarFile = new JarFile(file);){
                    String string3 = (String)jarFile.getManifest().getMainAttributes().get(Attributes.Name.IMPLEMENTATION_VERSION);
                    if (string3 == null && string2 != null) {
                        Properties properties = new Properties();
                        try (InputStream inputStream = jarFile.getInputStream(jarFile.getEntry(string2));){
                            properties.load(inputStream);
                            string3 = properties.getProperty("version");
                        }
                    }
                    printWriter.println(string + ": version " + (string3 == null ? "unknown" : string3));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    void addPathVersionHelper(final String string, final SearchPath searchPath) {
        this.addVersionHelper(new VersionHelper(){

            @Override
            public void showVersion(PrintWriter printWriter) {
                try {
                    for (File file : searchPath.asList()) {
                        try (JarFile jarFile = new JarFile(file);){
                            Attributes attributes = jarFile.getManifest().getMainAttributes();
                            String string3 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                            if (string3 == null) {
                                string3 = attributes.getValue("Bundle-Version");
                            }
                            String string2 = searchPath.asList().size() == 1 ? "" : " (" + file.getName() + ")";
                            printWriter.println(string + string2 + ": version " + (string3 == null ? "unknown" : string3));
                        }
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    void setVersionFlag(boolean bl) {
        this.versionFlag = bl;
    }

    void setReleaseNotes(boolean bl) {
        this.releaseNotesFlag = bl;
    }

    void setTagSpec(boolean bl) {
        this.tagSpecFlag = bl;
    }

    void setCommandLineHelpQuery(String string) {
        if (this.commandLineHelpQuery == null) {
            this.commandLineHelpQuery = new ArrayList<String>();
        }
        if (string != null && string.trim().length() > 0) {
            this.commandLineHelpQuery.addAll(Arrays.asList(string.trim().split("\\s+")));
        }
    }

    void show(PrintStream printStream) {
        PrintWriter printWriter = new PrintWriter(printStream);
        this.show(printWriter);
        printWriter.flush();
    }

    boolean show(PrintWriter printWriter) {
        boolean bl = false;
        if (this.releaseNotesFlag) {
            this.showReleaseNotes(printWriter);
        }
        if (this.tagSpecFlag) {
            this.showTagSpec(printWriter);
        }
        if (this.versionFlag) {
            this.showVersion(printWriter);
        }
        if (this.commandLineHelpQuery != null) {
            this.showCommandLineHelp(printWriter);
        }
        return bl;
    }

    void showReleaseNotes(PrintWriter printWriter) {
        File file = this.getHomeDir();
        File file2 = new File(file, "README");
        if (file2.exists()) {
            printWriter.println(i18n.getString("help.releaseNotes", (Object)file2.getAbsolutePath()));
        } else {
            printWriter.println(i18n.getString("help.cantFindReleaseNotes"));
        }
    }

    void showTagSpec(PrintWriter printWriter) {
        File file = this.getDocDir();
        File file2 = new File(file, "tag-spec.txt");
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file2));){
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                printWriter.println(string);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            printWriter.println(i18n.getString("help.cantFindSpec"));
        }
        catch (IOException iOException) {
            printWriter.println(i18n.getString("help.cantReadSpec", (Object)iOException));
        }
    }

    void showVersion(PrintWriter printWriter) {
        String string;
        String string2;
        String string3;
        Version version = Version.getCurrent();
        String string4 = i18n.getString("help.version.unknown");
        String string5 = "jtreg";
        String string6 = version.getProperty(string5 + "-Name", string4);
        String string7 = version.versionString;
        if (string7 == null) {
            string3 = version.getProperty(string5 + "-Version", string4);
            string2 = version.getProperty(string5 + "-Milestone", string4);
            string = version.getProperty(string5 + "-Build", string4);
            string7 = String.format("version %s %s %s", string3, string2, string);
        }
        string3 = version.getProperty(string5 + "-BuildJavaVersion", string4);
        string2 = version.getProperty(string5 + "-BuildDate", string4);
        string = System.getProperty("java.home");
        String string8 = System.getProperty("java.version");
        File file = this.getClassPathFileForClass(Tool.class);
        String string9 = file == null ? string4 : file.getPath();
        DateFormat dateFormat = DateFormat.getDateInstance(1);
        Object[] objectArray = new Object[]{string6, string7, string9, string8, string, string3, string2};
        printWriter.println(i18n.getString("help.version.txt", objectArray));
        printWriter.println(i18n.getString("help.copyright.txt"));
        for (VersionHelper versionHelper : this.versionHelpers) {
            versionHelper.showVersion(printWriter);
        }
    }

    private File getHomeDir() {
        File file = this.getClassPathFileForClass(Tool.class);
        if (file == null) {
            return null;
        }
        File file2 = file.getParentFile();
        File file3 = file2.getParentFile();
        return file3;
    }

    private File getDocDir() {
        File file = this.getHomeDir();
        File file2 = new File(new File(file, "doc"), "jtreg");
        if (file2.exists()) {
            return file2;
        }
        return null;
    }

    private URL getClassPathEntryForClass(Class<?> clazz) {
        try {
            URL uRL = clazz.getResource("/" + clazz.getName().replace('.', '/') + ".class");
            if (uRL.getProtocol().equals("jar")) {
                String string = uRL.getPath();
                int n = string.lastIndexOf("!");
                return new URL(string.substring(0, n));
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }

    private File getClassPathFileForClass(Class<?> clazz) {
        URL uRL = this.getClassPathEntryForClass(clazz);
        if (uRL != null && uRL.getProtocol().equals("file")) {
            return new File(uRL.getPath());
        }
        return null;
    }

    private Properties getManifestForClass(Class<?> clazz) {
        URL uRL = this.getClassPathEntryForClass(clazz);
        if (uRL == null) {
            return null;
        }
        try {
            Enumeration<URL> enumeration = this.getClass().getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (enumeration.hasMoreElements()) {
                int n;
                String string;
                URL uRL2;
                URL uRL3 = enumeration.nextElement();
                if (!uRL3.getProtocol().equals("jar") || !(uRL2 = new URL((string = uRL3.getPath()).substring(0, n = string.lastIndexOf("!")))).equals(uRL)) continue;
                Properties properties = new Properties();
                try (InputStream inputStream = uRL3.openStream();){
                    properties.load(inputStream);
                }
                return properties;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public void showCommandLineHelp(PrintWriter printWriter) {
        Object object;
        String[] stringArray;
        Object object2;
        Integer n;
        Object object5;
        HelpTree helpTree = new HelpTree();
        try {
            object5 = HelpTree.class.getDeclaredField("nodeComparator");
            ((Field)object5).setAccessible(true);
            ((Field)object5).set(helpTree, new NodeComparator());
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
            // empty catch block
        }
        object5 = Integer.getInteger("javatest.help.nodeIndent");
        if (object5 != null) {
            helpTree.setNodeIndent((Integer)object5);
        }
        if ((n = Integer.getInteger("javatest.help.descIndent")) != null) {
            helpTree.setDescriptionIndent(n);
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (Option object42 : this.options) {
            linkedHashSet.add(object42.group);
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (String string : linkedHashSet) {
            linkedHashMap.put(string, new TreeMap(new CaseInsensitiveStringComparator()));
        }
        for (Option option : this.options) {
            if (option.names.length <= 0) continue;
            ((SortedMap)linkedHashMap.get(option.group)).put(option.names[0], option);
        }
        for (String string : linkedHashSet) {
            object2 = (SortedMap)linkedHashMap.get(string);
            if (object2.isEmpty()) continue;
            stringArray = new ArrayList();
            for (Option option : object2.values()) {
                stringArray.add(this.createOptionHelpNode(option));
            }
            object = new HelpTree.Node(i18n, "help." + string.toLowerCase(), stringArray.toArray(new HelpTree.Node[stringArray.size()]));
            helpTree.addNode((HelpTree.Node)object);
        }
        HelpTree.Node node = new HelpTree.Node(i18n, "help.tests", "at", "groups");
        helpTree.addNode(node);
        String string = Help.getProgramName();
        try {
            object2 = new WrapWriter(printWriter);
            if (this.commandLineHelpQuery == null || this.commandLineHelpQuery.isEmpty()) {
                ((Writer)object2).write(i18n.getString("help.cmd.proto", (Object)string));
                ((Writer)object2).write("\n\n");
                ((Writer)object2).write(i18n.getString("help.cmd.introHead"));
                ((WrapWriter)object2).write('\n');
                helpTree.writeSummary((Writer)object2);
            } else if (this.commandLineHelpQuery.contains("all")) {
                ((Writer)object2).write(i18n.getString("help.cmd.proto", (Object)string));
                ((Writer)object2).write("\n\n");
                ((Writer)object2).write(i18n.getString("help.cmd.fullHead"));
                ((WrapWriter)object2).write('\n');
                helpTree.write((Writer)object2);
            } else {
                stringArray = this.commandLineHelpQuery.toArray(new String[this.commandLineHelpQuery.size()]);
                object = helpTree.find(stringArray);
                if (object != null) {
                    helpTree.write((Writer)object2, (HelpTree.Selection)object);
                } else {
                    ((Writer)object2).write(i18n.getString("help.cmd.noEntriesFound"));
                    ((Writer)object2).write("\n\n");
                    ((Writer)object2).write(i18n.getString("help.cmd.summaryHead"));
                    ((WrapWriter)object2).write('\n');
                    helpTree.writeSummary((Writer)object2);
                }
            }
            ((WrapWriter)object2).write('\n');
            ((Writer)object2).write(i18n.getString("help.copyright.txt"));
            ((Writer)object2).write("\n\n");
            ((WrapWriter)object2).flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private HelpTree.Node createOptionHelpNode(Option option) {
        String string = "help." + option.group.toLowerCase() + "." + option.names[0].replaceAll("^-+", "").replaceAll("[^A-Za-z0-9.]+", "_");
        String string2 = option.argType == Option.ArgType.NONE ? null : i18n.getString(string + ".arg");
        StringBuilder stringBuilder = new StringBuilder();
        block7: for (String string3 : option.names) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("  |  ");
            }
            stringBuilder.append(string3);
            switch (option.argType) {
                case NONE: {
                    continue block7;
                }
                case OLD: 
                case STD: 
                case FILE: {
                    stringBuilder.append(":").append(string2);
                    continue block7;
                }
                case GNU: 
                case SEP: 
                case REST: {
                    stringBuilder.append(" ").append(string2);
                    continue block7;
                }
                case WILDCARD: {
                    stringBuilder.append(string2);
                    continue block7;
                }
                case OPT: {
                    stringBuilder.append("  |  -").append(string3).append(":").append(string2);
                    continue block7;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        String string4 = stringBuilder.toString();
        String string5 = i18n.getString(string + ".desc");
        String[] stringArray = option.getChoices();
        if (stringArray == null || stringArray.length == 0) {
            return new HelpTree.Node(string4, string5);
        }
        HelpTree.Node[] nodeArray = new HelpTree.Node[stringArray.length];
        for (int i = 0; i < nodeArray.length; ++i) {
            nodeArray[i] = new HelpTree.Node(stringArray[i], i18n.getString(string + "." + stringArray[i] + ".desc"));
        }
        return new HelpTree.Node(string4, string5, nodeArray);
    }

    private static String getProgramName() {
        String string = System.getProperty("program");
        if (string != null) {
            return string;
        }
        List<File> list = new SearchPath(System.getProperty("java.class.path")).asList();
        if (list.size() == 1 && list.get(0).getName().equals("jtreg.jar")) {
            return "java -jar jtreg.jar ";
        }
        return "java " + Tool.class.getName();
    }

    static interface VersionHelper {
        public void showVersion(PrintWriter var1);
    }

    private static class NodeComparator
    implements Comparator<HelpTree.Node> {
        private NodeComparator() {
        }

        @Override
        public int compare(HelpTree.Node node, HelpTree.Node node2) {
            int n = node.getName().replaceAll("^-+", "").compareToIgnoreCase(node2.getName().replaceAll("^-+", ""));
            return n != 0 ? n : node.getDescription().compareToIgnoreCase(node2.getDescription());
        }
    }

    private static class CaseInsensitiveStringComparator
    implements Comparator<String> {
        private CaseInsensitiveStringComparator() {
        }

        @Override
        public int compare(String string, String string2) {
            if (string == null && string2 == null) {
                return 0;
            }
            if (string == null || string2 == null) {
                return string == null ? -1 : 1;
            }
            return string.replaceAll("^-*", "").compareToIgnoreCase(string2.replaceAll("^-*", ""));
        }
    }
}

