/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.exec;

import com.sun.javatest.Status;
import com.sun.javatest.regtest.agent.JDK_Version;
import com.sun.javatest.regtest.agent.TestNGRunner;
import com.sun.javatest.regtest.config.Locations;
import com.sun.javatest.regtest.config.ParseException;
import com.sun.javatest.regtest.exec.BuildAction;
import com.sun.javatest.regtest.exec.MainAction;
import com.sun.javatest.regtest.exec.RegressionScript;
import com.sun.javatest.regtest.exec.TestRunException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TestNGAction
extends MainAction {
    public static final String NAME = "testng";
    boolean userSpecified = false;
    private static final File TESTNG_RESULTS_XML = new File("testng-results.xml");

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void init(Map<String, String> map, List<String> list, String string, RegressionScript regressionScript) throws ParseException {
        this.userSpecified = string.startsWith("User specified action: run ");
        boolean bl = regressionScript.getTestDescription().getParameter("importsJUnit") != null;
        this.init(map, list, string, regressionScript, TestNGRunner.class, regressionScript.getTestResult().getTestName(), Boolean.toString(bl));
        if (bl) {
            this.othervmOverrideReasons.add("test uses TestNG/JUnit mixed mode");
        }
    }

    @Override
    protected Status build() throws TestRunException {
        Object object;
        if (this.userSpecified) {
            return super.build();
        }
        JDK_Version jDK_Version = this.script.getCompileJDKVersion();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (jDK_Version.compareTo(JDK_Version.V1_6) >= 0) {
            hashMap.put("implicit", "none");
        }
        Locations locations = this.script.locations;
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(this.script.getLibBuildArgs());
        if (linkedHashSet.isEmpty()) {
            linkedHashSet.addAll(this.listModules(locations.absLibSrcList(Locations.LibLocn.Kind.SYS_MODULE)));
            linkedHashSet.addAll(this.listModules(locations.absLibSrcList(Locations.LibLocn.Kind.USER_MODULE)));
            linkedHashSet.addAll(this.listClasses(locations.absLibSrcList(Locations.LibLocn.Kind.PACKAGE)));
        }
        try {
            object = locations.absTestSrcDir();
            switch (locations.getDirKind((File)object)) {
                case PACKAGE: {
                    linkedHashSet.addAll(this.listClasses(Collections.singletonList(object)));
                    break;
                }
                case SYS_MODULE: 
                case USER_MODULE: {
                    linkedHashSet.addAll(this.listModules(Collections.singletonList(object)));
                }
            }
        }
        catch (Locations.Fault fault) {
            return Status.error(fault.getMessage());
        }
        object = new BuildAction();
        return ((BuildAction)object).build(hashMap, new ArrayList<String>(linkedHashSet), "Named class compiled on demand", this.script);
    }

    private List<String> listClasses(List<File> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (File file : list) {
            this.listClasses(file, null, arrayList);
        }
        return arrayList;
    }

    private void listClasses(File file, String string, List<String> list) {
        for (File file2 : file.listFiles()) {
            String string2 = file2.getName();
            if (file2.isDirectory()) {
                this.listClasses(file2, (String)(string == null ? string2 : string + "." + string2), list);
                continue;
            }
            if (!string2.endsWith(".java")) continue;
            String string3 = string2.substring(0, string2.length() - 5);
            list.add((String)(string == null ? string3 : string + "." + string3));
        }
    }

    private Set<String> listModules(List<File> list) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (File file : list) {
            for (File file2 : file.listFiles()) {
                if (!file2.isDirectory()) continue;
                linkedHashSet.add(file2.getName() + "/*");
            }
        }
        return linkedHashSet;
    }

    @Override
    public void endAction(Status status) {
        super.endAction(status);
        if (this.script.isCheck()) {
            return;
        }
        this.script.getTestNGReporter().add(this.script.getTestResult(), this.section);
        String string = this.script.getTestResult().getWorkRelativePath();
        String string2 = string.replaceAll("\\.jtr$", ".testng-results.xml");
        this.script.saveScratchFile(TESTNG_RESULTS_XML, new File(string2));
    }
}

