/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.exec;

import com.sun.javatest.Status;
import com.sun.javatest.regtest.RStatus;
import com.sun.javatest.regtest.config.Locations;
import com.sun.javatest.regtest.config.ParseException;
import com.sun.javatest.regtest.exec.Action;
import com.sun.javatest.regtest.exec.RegressionScript;
import com.sun.javatest.regtest.exec.TestRunException;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CleanAction
extends Action {
    public static final String NAME = "clean";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void init(Map<String, String> map, List<String> list, String string, RegressionScript regressionScript) throws ParseException {
        super.init(map, list, string, regressionScript);
        if (!map.isEmpty()) {
            throw new ParseException("Unexpected option(s) for `clean'");
        }
        if (list.isEmpty()) {
            throw new ParseException("No classname(s) provided for `clean'");
        }
        for (String string2 : list) {
            if (string2.indexOf(File.separatorChar) == -1 && string2.indexOf(47) == -1) continue;
            throw new ParseException("Bad classname provided for `clean': " + string2);
        }
    }

    @Override
    public Status run() throws TestRunException {
        Status status = RStatus.passed("Clean successful");
        this.startAction(false);
        if (this.script.isCheck()) {
            status = RStatus.passed("Test description appears acceptable");
        } else {
            for (String string : this.args) {
                Object object;
                if (string.equals("*")) {
                    string = ".*";
                }
                if (string.endsWith(".*")) {
                    object = string.substring(0, string.length() - 2);
                    object = ((String)object).replace('.', File.separatorChar);
                    File file = this.script.absTestClsDir();
                    if (!((String)object).equals("")) {
                        file = new File(file, (String)object);
                    }
                    this.recorder.exec("for f in " + file + "/*; do\n  if [ -f $f ]; then rm $f ; fi\ndone");
                    try {
                        File[] fileArray;
                        if (!file.isDirectory() || (fileArray = file.listFiles()) == null) continue;
                        for (File file2 : fileArray) {
                            if (file2.delete() || file2.isDirectory()) continue;
                            throw new TestRunException("`clean' unable to delete file: " + file2);
                        }
                        continue;
                    }
                    catch (SecurityException securityException) {
                        throw new TestRunException("Problem deleting directory contents: " + file);
                    }
                }
                object = new File(this.script.absTestClsDir(), string.replace('.', File.separatorChar) + ".class");
                this.recorder.exec("rm -f " + (File)object);
                if (!((File)object).exists() || ((File)object).delete()) continue;
                return RStatus.error("`clean' unable to delete file: " + (File)object);
            }
        }
        this.endAction(status);
        return status;
    }

    @Override
    public Set<File> getSourceFiles() {
        LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>();
        for (String string : this.args) {
            try {
                for (Locations.ClassLocn classLocn : this.script.locations.locateClasses(string)) {
                    if (!classLocn.absSrcFile.exists()) continue;
                    linkedHashSet.add(classLocn.absSrcFile);
                }
            }
            catch (Locations.Fault fault) {
            }
        }
        return linkedHashSet;
    }
}

