/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.exec;

import com.sun.javatest.Status;
import com.sun.javatest.regtest.RStatus;
import com.sun.javatest.regtest.TimeoutHandler;
import com.sun.javatest.regtest.agent.AppletWrapper;
import com.sun.javatest.regtest.agent.SearchPath;
import com.sun.javatest.regtest.config.JDKOpts;
import com.sun.javatest.regtest.config.Modules;
import com.sun.javatest.regtest.config.ParseException;
import com.sun.javatest.regtest.exec.Action;
import com.sun.javatest.regtest.exec.BuildAction;
import com.sun.javatest.regtest.exec.ProcessCommand;
import com.sun.javatest.regtest.exec.RegressionScript;
import com.sun.javatest.regtest.exec.TestRunException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class AppletAction
extends Action {
    public static final String NAME = "applet";
    private String manual = "unset";
    private boolean reverseStatus = false;
    private boolean othervm = false;
    private int timeout = -1;
    private File policyFN = null;
    private String secureFN = null;
    private boolean overrideSysPolicy = false;
    private String htmlFN;
    private String clsName;
    private HTMLFileContents htmlFileContents;
    private static final Object appletLock = new Object();

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void init(Map<String, String> map, List<String> list, String string, RegressionScript regressionScript) throws ParseException {
        super.init(map, list, string, regressionScript);
        if (list.size() != 1) {
            throw new ParseException("`applet' requires exactly one file argument");
        }
        block18: for (Map.Entry<String, String> entry : map.entrySet()) {
            String string2 = entry.getKey();
            String string3 = entry.getValue();
            switch (string2) {
                case "fail": {
                    this.reverseStatus = this.parseFail(string3);
                    continue block18;
                }
                case "timeout": {
                    this.timeout = this.parseTimeout(string3);
                    continue block18;
                }
                case "manual": {
                    this.manual = this.parseAppletManual(string3);
                    continue block18;
                }
                case "othervm": {
                    this.othervm = true;
                    continue block18;
                }
                case "policy": {
                    this.overrideSysPolicy = true;
                    this.policyFN = this.parsePolicy(string3);
                    continue block18;
                }
                case "java.security.policy": {
                    String string4 = string3;
                    if (string3.startsWith("=")) {
                        this.overrideSysPolicy = true;
                        string4 = string3.substring(1, string3.length());
                    }
                    this.policyFN = this.parsePolicy(string4);
                    continue block18;
                }
                case "secure": {
                    this.secureFN = this.parseSecure(string3);
                    continue block18;
                }
            }
            throw new ParseException("Bad option for applet: " + string2);
        }
        if (this.manual.equals("unset")) {
            if (this.timeout < 0) {
                this.timeout = regressionScript.getActionTimeout(-1);
            }
        } else {
            if (this.timeout >= 0) {
                throw new ParseException("`/manual' disables use of `/timeout'");
            }
            this.timeout = 0;
        }
        if (!this.othervm) {
            if (this.policyFN != null) {
                throw new ParseException("`/policy' and `/java.security.policy` require use of `/othervm'");
            }
            if (this.secureFN != null) {
                throw new ParseException("`/secure' requires use of `/othervm'");
            }
        }
        this.htmlFN = list.get(0);
    }

    @Override
    public Set<File> getSourceFiles() {
        return Collections.singleton(new File(this.script.absTestSrcDir(), this.htmlFN));
    }

    @Override
    public Status run() throws TestRunException {
        List<String> list;
        Map<String, String> map;
        BuildAction buildAction;
        Status status;
        this.htmlFileContents = new HTMLFileContents(this.htmlFN);
        this.clsName = this.htmlFileContents.getAppletAttrs().get("code");
        if (this.clsName.endsWith(".class")) {
            this.clsName = this.clsName.substring(0, this.clsName.lastIndexOf(".class"));
        }
        if (!(status = (buildAction = new BuildAction()).build(map = Collections.emptyMap(), list = Arrays.asList(this.clsName), "Named class compiled on demand", this.script)).isPassed()) {
            return status;
        }
        this.startAction(false);
        status = this.script.isCheck() ? RStatus.passed("Test description appears acceptable") : this.runOtherJVM();
        this.endAction(status);
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Status runOtherJVM() throws TestRunException {
        Object object;
        Object object2;
        Object object4;
        Map<RegressionScript.PathKind, SearchPath> map = this.script.getExecutionPaths(false, null, false, true);
        Map<RegressionScript.PathKind, SearchPath> map2 = this.script.getExecutionPaths(false, null, false, false);
        File file = this.getArgFile();
        try {
            object4 = new BufferedWriter(new FileWriter(file));
            try {
                ((Writer)object4).write(this.clsName + "\u0000");
                ((Writer)object4).write(this.script.absTestSrcDir() + "\u0000");
                ((Writer)object4).write(this.script.absTestClsDir() + "\u0000");
                ((Writer)object4).write(map2.get((Object)RegressionScript.PathKind.CLASSPATH) + "\u0000");
                ((Writer)object4).write(this.manual + "\u0000");
                ((Writer)object4).write(this.htmlFileContents.getBody() + "\u0000");
                ((Writer)object4).write(AppletAction.toString(this.htmlFileContents.getAppletParams()) + "\u0000");
                ((Writer)object4).write(AppletAction.toString(this.htmlFileContents.getAppletAttrs()) + "\u0000");
            }
            finally {
                ((Writer)object4).close();
            }
        }
        catch (IOException iOException) {
            return RStatus.error("Can't write `applet' argument file");
        }
        object4 = new ArrayList(6);
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        object4.add(this.script.getJavaProg());
        object4.add("-classpath");
        object4.add(map.get((Object)RegressionScript.PathKind.CLASSPATH).toString());
        JDKOpts jDKOpts = new JDKOpts();
        jDKOpts.addAll(this.getExtraModuleConfigOptions(Modules.Phase.DYNAMIC));
        jDKOpts.addAll(this.script.getTestVMJavaOptions());
        jDKOpts.addAll(this.script.getTestDebugOptions());
        object4.addAll(jDKOpts.toList());
        for (Map.Entry<String, String> entry : this.script.getTestProperties().entrySet()) {
            object4.add("-D" + entry.getKey() + "=" + entry.getValue());
        }
        String string = System.getProperty("java.awt.headless");
        if (string != null) {
            object4.add("-Djava.awt.headless=" + (String)string);
        }
        boolean bl = false;
        for (String object32 : jDKOpts.toList()) {
            if (!object32.startsWith("-mx") && !object32.startsWith("-Xmx")) continue;
            bl = true;
        }
        if (!bl) {
            object4.add("-mx128m");
        }
        if (this.policyFN != null) {
            object2 = this.addGrantEntries(this.policyFN);
            String string2 = this.overrideSysPolicy ? "-Djava.security.policy==" + (File)object2 : "-Djava.security.policy=" + (File)object2;
            object4.add(string2);
        }
        if (this.secureFN != null) {
            object4.add("-Djava.security.manager=" + this.secureFN);
        } else if (this.policyFN != null) {
            object4.add("-Djava.security.manager=default");
        }
        object4.add(AppletWrapper.class.getName());
        object4.add(file.getPath());
        linkedHashMap.putAll(this.script.getEnvVars());
        PrintWriter printWriter = this.section.createOutput("System.out");
        PrintWriter printWriter2 = this.section.createOutput("System.err");
        try {
            if (showCmd) {
                this.showCmd(NAME, (List<String>)object4, this.section);
            }
            this.recorder.exec((List<String>)object4, linkedHashMap);
            object = new ProcessCommand();
            ((ProcessCommand)object).setExecDir(this.script.absTestScratchDir());
            ((ProcessCommand)object).setStatusForExit(Status.exitCodes[0], RStatus.passed("Execution successful"));
            ((ProcessCommand)object).setStatusForExit(Status.exitCodes[1], RStatus.failed("Execution failed"));
            ((ProcessCommand)object).setDefaultStatus(RStatus.failed("Unexpected exit from test"));
            TimeoutHandler timeoutHandler = this.script.getTimeoutHandlerProvider().createHandler(this.getClass(), this.script, this.section);
            ((ProcessCommand)object).setCommand((List<String>)object4).setEnvironment(linkedHashMap).setStreams(printWriter, printWriter2).setTimeout(this.timeout, TimeUnit.SECONDS).setTimeoutHandler(timeoutHandler);
            Object object3 = appletLock;
            synchronized (object3) {
                object2 = RStatus.normalize(((ProcessCommand)object).exec());
            }
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
            if (printWriter2 != null) {
                printWriter2.close();
            }
        }
        if (!((Status)object2).isError() && !((Status)object2).getReason().startsWith("Unexpected exit from test")) {
            if (((Status)object2).getReason().equals("")) {
                boolean bl2 = this.manual.equals("yesno");
                boolean bl3 = this.manual.equals("yesno") || this.manual.equals("done");
                String string3 = bl2 ? ", user evaluated" : "";
                object = bl3 ? "Manual test" + string3 + ": " : "";
            } else {
                object = "";
            }
            boolean bl4 = ((Status)object2).isPassed();
            int n = ((Status)object2).getType();
            if (bl4 && this.reverseStatus) {
                object = (String)object + "Execution passed unexpectedly";
                n = 1;
            } else if (bl4 && !this.reverseStatus) {
                object = (String)object + "Execution successful";
            } else if (!bl4 && this.reverseStatus) {
                object = (String)object + "Execution failed as expected";
                n = 0;
            } else {
                object = (String)object + "Execution failed";
            }
            if (n == 1 && !((Status)object2).getReason().equals("") && !((Status)object2).getReason().equals("Execution successful")) {
                object = (String)object + ": " + ((Status)object2).getReason();
            }
            object2 = RStatus.createStatus(n, (String)object);
        }
        return object2;
    }

    private String parseAppletManual(String string) throws ParseException {
        if (string == null) {
            return "novalue";
        }
        if (!string.equals("yesno") && !string.equals("done")) {
            throw new ParseException("Bad value for `manual' option: " + string);
        }
        return string;
    }

    private static String toString(Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            stringBuilder.append(entry.getKey());
            stringBuilder.append("\u001c");
            stringBuilder.append(entry.getValue());
            stringBuilder.append("\u001c");
        }
        return stringBuilder.toString();
    }

    private class HTMLFileContents {
        String body;
        Map<String, String> appletParams = new HashMap<String, String>(1);
        Map<String, String> appletAttrs;

        HTMLFileContents(String string) throws TestRunException {
            int[] nArray;
            int[] nArray2;
            String string2;
            Object object;
            StringBuilder stringBuilder = new StringBuilder();
            string = new File(AppletAction.this.script.absTestSrcDir(), string).getPath();
            try {
                object = new BufferedReader(new FileReader(string));
                try {
                    String string3;
                    while ((string3 = ((BufferedReader)object).readLine()) != null) {
                        stringBuilder.append(string3);
                        stringBuilder.append(Action.LINESEP);
                    }
                }
                finally {
                    ((BufferedReader)object).close();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new TestRunException("Can't find HTML file: " + string);
            }
            catch (IOException iOException) {
                throw new TestRunException("Problem reading HTML file: " + string);
            }
            object = stringBuilder.toString();
            String string4 = ((String)object).toLowerCase();
            int[] nArray22 = this.getTagPositions((String)object, string4, "body", 0);
            if (nArray22 == null) {
                this.body = object;
                string2 = string4;
            } else {
                nArray2 = this.getTagPositions((String)object, string4, "/body", nArray22[3] - 1);
                if (nArray2 == null) {
                    throw new ParseException("No </body> tag in " + string);
                }
                this.body = ((String)object).substring(nArray22[3], nArray2[0]);
                string2 = string4.substring(nArray22[3], nArray2[0]);
            }
            nArray2 = this.getTagPositions(this.body, string2, AppletAction.NAME, 0);
            if (nArray2 == null) {
                throw new ParseException("No <applet> tag in " + string);
            }
            int[] nArray3 = this.getTagPositions(this.body, string2, "/applet", nArray2[3] - 1);
            if (nArray3 == null) {
                throw new ParseException("No </applet> tag in " + string);
            }
            this.appletAttrs = this.parseAttrs(this.body.substring(nArray2[1], nArray2[2]));
            String[] stringArray = new String[]{"code", "width", "height"};
            for (String object2 : stringArray) {
                if (this.appletAttrs.get(object2) != null) continue;
                throw new ParseException(string + " missing required attribute " + object2);
            }
            if (this.appletAttrs.get("archive") != null) {
                throw new ParseException("`archive' not supported in file: " + string);
            }
            String string5 = this.body.substring(nArray2[3], nArray3[0]);
            String string6 = string5.toLowerCase();
            int object3 = 0;
            while ((nArray = this.getTagPositions(string5, string6, "param", object3)) != null) {
                Map<String, String> map = this.parseAttrs(string5.substring(nArray[1], nArray[2]));
                String string3 = map.get("name");
                String string7 = map.get("value");
                if (string3 == null || string7 == null) {
                    throw new ParseException("Missing required name or value for param in <param> tag");
                }
                this.appletParams.put(string3, string7);
                object3 = nArray[3];
            }
        }

        String getBody() {
            return this.body;
        }

        Map<String, String> getAppletParams() {
            return this.appletParams;
        }

        Map<String, String> getAppletAttrs() {
            return this.appletAttrs;
        }

        private int[] getAttrPositions(String string, int n) {
            try {
                int n2;
                int n3;
                int n4 = n;
                while (Character.isWhitespace(string.charAt(n4))) {
                    ++n4;
                }
                int n5 = n4;
                while (!Character.isWhitespace((char)(n3 = string.charAt(n5))) && n3 != 61) {
                    ++n5;
                }
                n3 = n5;
                while (Character.isWhitespace(string.charAt(n3))) {
                    ++n3;
                }
                if (string.charAt(n3) != '=') {
                    return null;
                }
                ++n3;
                while (Character.isWhitespace(string.charAt(n3))) {
                    ++n3;
                }
                int n6 = string.length();
                boolean bl = false;
                for (n2 = n3; n2 < n6; ++n2) {
                    char c = string.charAt(n2);
                    if (!bl && Character.isWhitespace(c)) break;
                    if (c == '\"') {
                        boolean bl2 = bl = !bl;
                    }
                    if (c != '\\' || n2 >= n6 - 1) continue;
                    ++n2;
                }
                if (n5 <= n4 || n2 <= n3) {
                    return null;
                }
                int[] nArray = new int[]{n4, n5, n3, n2};
                return nArray;
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                return null;
            }
        }

        private int[] getTagPositions(String string, String string2, String string3, int n) {
            int n2 = string2.indexOf("<" + string3, n);
            if (n2 == -1) {
                return null;
            }
            int n3 = string2.indexOf(">", n2);
            if (n3 == -1) {
                return null;
            }
            int[] nArray = new int[]{n2, n2 + string3.length() + 1, n3, n3 + 1};
            return nArray;
        }

        private Map<String, String> parseAttrs(String string) {
            int[] nArray;
            HashMap<String, String> hashMap = new HashMap<String, String>(3);
            int n = 0;
            while ((nArray = this.getAttrPositions(string, n)) != null) {
                String string2 = string.substring(nArray[2], nArray[3]);
                if (string2.indexOf("\"") == 0 && string2.lastIndexOf("\"") == string2.length() - 1) {
                    string2 = string2.substring(1, string2.length() - 1);
                }
                hashMap.put(string.substring(nArray[0], nArray[1]).toLowerCase(), string2);
                n = nArray[3];
            }
            return hashMap;
        }
    }
}

