/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.config;

import com.sun.javatest.TestDescription;
import com.sun.javatest.TestFinder;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestSuite;
import com.sun.javatest.finder.CommentStream;
import com.sun.javatest.finder.HTMLCommentStream;
import com.sun.javatest.finder.JavaCommentStream;
import com.sun.javatest.finder.ShScriptCommentStream;
import com.sun.javatest.finder.TagTestFinder;
import com.sun.javatest.regtest.config.Expr;
import com.sun.javatest.regtest.config.Modules;
import com.sun.javatest.regtest.config.RegressionContext;
import com.sun.javatest.regtest.config.TestProperties;
import com.sun.javatest.regtest.util.StringUtils;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegressionTestFinder
extends TagTestFinder {
    Map<String, TestDescription> paths = new HashMap<String, TestDescription>();
    private static final Pattern bugIdPattern = Pattern.compile("(([A-Z]+-)?[0-9]{7})|(14[0-9]{6})");
    public static final String TEST = "test";
    public static final String AUTHOR = "author";
    public static final String BUG = "bug";
    public static final String BUILD = "build";
    public static final String CLEAN = "clean";
    public static final String COMPILE = "compile";
    public static final String ENABLE_PREVIEW = "enablePreview";
    public static final String ERROR = "error";
    public static final String IGNORE = "ignore";
    public static final String KEY = "key";
    public static final String LIBRARY = "library";
    public static final String MODULES = "modules";
    public static final String REQUIRES = "requires";
    public static final String RUN = "run";
    public static final String SUMMARY = "summary";
    public static final String COMMENT = "comment";
    private static final String LINESEP = System.getProperty("line.separator");
    static final String[] excludeNames = new String[]{"SCCS", "Codemgr_wsdata", ".hg", "RCS", ".svn", "DeletedFiles", "DELETED-FILES", "deleted_files", "TemporarilyRemoved"};
    protected static final String PARSE_TAG_BAD = "Invalid tag: ";
    protected static final String PARSE_BUG_EMPTY = "No value provided for `@bug'";
    protected static final String PARSE_BUG_INVALID = "Invalid or unrecognized bugid: ";
    protected static final String PARSE_KEY_EMPTY = "No value provided for `@key'";
    protected static final String PARSE_KEY_BAD = "Invalid key: ";
    protected static final String PARSE_LIB_EMPTY = "No value provided for `@library'";
    protected static final String PARSE_LIB_AFTER_RUN = "`@library' must appear before first action tag";
    protected static final String PARSE_MODULES_EMPTY = "No values provided for @modules";
    protected static final String PARSE_BAD_MODULE = "Invalid item in @modules: ";
    protected static final String PARSE_BAD_RUN = "Explicit action tag not allowed";
    protected static final String PARSE_REQUIRES_EMPTY = "No expression for @requires";
    protected static final String PARSE_REQUIRES_SYNTAX = "Syntax error in @requires expression: ";
    protected static final String PARSE_RUN_ENDS_WITH_BUILD = "No action after @build";
    protected static final String PARSE_MULTIPLE_COMMENTS_NOT_ALLOWED = "Multiple test descriptions not allowed";
    protected static final String PARSE_INVALID_ENABLE_PREVIEW = "invalid value for @enablePreview: ";
    private static final Pattern BOOTCLASSPATH_OPTION = RegressionTestFinder.getOptionPattern("bootclasspath");
    private static final Pattern OTHERVM_OPTION = RegressionTestFinder.getOptionPattern("othervm");
    private static final Pattern MANUAL_OPTION = RegressionTestFinder.getOptionPattern("manual");
    private static final Pattern NATIVE_OPTION = RegressionTestFinder.getOptionPattern("native");
    private static final Pattern SHELL_ACTION = RegressionTestFinder.getActionPattern("shell");
    private static final Pattern JUNIT_ACTION = RegressionTestFinder.getActionPattern("junit");
    private static final Pattern TESTNG_ACTION = RegressionTestFinder.getActionPattern("testng");
    private static final Pattern DRIVER_ACTION = RegressionTestFinder.getActionPattern("driver");
    private static final Pattern IGNORE_ACTION = RegressionTestFinder.getActionPattern("ignore");
    private final Set<String> validTagNames;
    private final TestProperties properties;
    private final boolean checkBugID;
    private final RegressionContext baseContext;
    private static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(RegressionTestFinder.class);
    private static final boolean rejectTrailingBuild = !Boolean.getBoolean("javatest.regtest.allowTrailingBuild");

    public RegressionTestFinder(TestProperties testProperties, TestFinder.ErrorHandler errorHandler) {
        this.setErrorHandler(errorHandler);
        this.properties = testProperties;
        this.checkBugID = testProperties.checkBugID;
        Set<String> set = testProperties.validKeys;
        this.validTagNames = this.getValidTagNames(set != null);
        this.exclude(excludeNames);
        this.addExtension(".sh", ShScriptCommentStream.class);
        this.addExtension(".html", HTMLCommentStream.class);
        this.addExtension(".jasm", JavaCommentStream.class);
        this.addExtension(".jcod", JavaCommentStream.class);
        this.baseContext = RegressionContext.getDefault();
    }

    Set<String> getAllowedExtensions() {
        return ((HashMap)this.getField("extensionTable")).keySet();
    }

    Set<String> getIgnoredDirectories() {
        return ((HashMap)this.getField("excludeList")).keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getField(String string) {
        Field field = TagTestFinder.class.getDeclaredField(string);
        try {
            field.setAccessible(true);
            Object object = field.get(this);
            field.setAccessible(false);
            return object;
        }
        catch (Throwable throwable) {
            try {
                field.setAccessible(false);
                throw throwable;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                noSuchFieldException.printStackTrace(System.err);
                return null;
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace(System.err);
                return null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace(System.err);
                return null;
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace(System.err);
                return null;
            }
        }
    }

    @Override
    protected void setRoot(File file) throws TestFinder.Fault {
        super.setRoot(this.canon(file));
    }

    @Override
    protected void scanFile(File file) {
        if (file.getName().startsWith(",")) {
            return;
        }
        try {
            File file2 = this.properties.getTestNGRoot(file);
            if (file2 != null) {
                this.scanTestNGFile(file2, file);
            } else {
                this.modifiedScanFile(file);
            }
        }
        catch (TestSuite.Fault fault) {
            this.error(i18n, "finder.cant.read.test.properties", (Object)fault.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void modifiedScanFile(File file) {
        CommentStream commentStream;
        boolean bl;
        Object object;
        I18NResourceBundle i18NResourceBundle;
        try {
            Field field = TagTestFinder.class.getDeclaredField("i18n");
            field.setAccessible(true);
            i18NResourceBundle = (I18NResourceBundle)field.get(this);
            object = TagTestFinder.class.getDeclaredField("fastScan");
            ((Field)object).setAccessible(true);
            bl = (Boolean)((Field)object).get(this);
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            throw new Error(reflectiveOperationException);
        }
        int n = 0;
        object = file.getName();
        int n2 = ((String)object).indexOf(46);
        if (n2 == -1) {
            return;
        }
        String string = ((String)object).substring(n2);
        Class<? extends CommentStream> clazz = this.getClassForExtension(string);
        if (clazz == null) {
            this.error(i18NResourceBundle, "tag.noParser", file, string);
            return;
        }
        try {
            commentStream = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            this.error(i18NResourceBundle, "tag.cantCreateClass", clazz.getName(), string);
            return;
        }
        try {
            LineCounterBufferedReader lineCounterBufferedReader = new LineCounterBufferedReader(new FileReader(file));
            commentStream.init(lineCounterBufferedReader);
            if (bl) {
                commentStream.setFastScan(true);
            }
            String string2 = commentStream.readComment();
            int n3 = lineCounterBufferedReader.lineNumber;
            while (string2 != null) {
                Map<String, String> map = this.parseComment(string2, file);
                String string3 = commentStream.readComment();
                int n4 = lineCounterBufferedReader.lineNumber;
                if (!map.isEmpty()) {
                    if (map.get("id") == null) {
                        if (string3 != null && string3.trim().startsWith("@test") || n != 0) {
                            Matcher matcher;
                            String string4 = map.get(TEST);
                            String string5 = string4 != null && (matcher = Pattern.compile("id=(?<id>[A-Za-z0-9-_]+)\\b.*").matcher(string4)).matches() ? matcher.group("id") : "id" + n;
                            map.put("id", string5);
                        }
                        ++n;
                    }
                    map.remove(TEST);
                    this.foundTestDescription(map, file, n3);
                }
                string2 = string3;
                n3 = n4;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.error(i18NResourceBundle, "tag.cantFindFile", (Object)file);
        }
        catch (IOException iOException) {
            this.error(i18NResourceBundle, "tag.ioError", (Object)file);
        }
        finally {
            try {
                commentStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected void scanTestNGFile(File file, File file2) throws TestSuite.Fault {
        if (this.isTestNGTest(file2)) {
            PackageImportParser packageImportParser = new PackageImportParser(file, file2);
            packageImportParser.parse();
            String string = packageImportParser.inferClassName();
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file2));){
                Set<String> set;
                Map<String, String> map = this.readTestNGComments(file2, bufferedReader);
                if (map == null) {
                    map = new HashMap<String, String>();
                }
                map.put("packageRoot", this.getRootDir().toURI().relativize(file.toURI()).getPath());
                if (string == null) {
                    map.put(ERROR, "cannot determine class name");
                } else {
                    map.put("testngClass", string);
                }
                if (packageImportParser.importsJUnit) {
                    map.put("importsJUnit", "true");
                }
                if ((set = this.properties.getLibDirs(file2)) != null && !set.isEmpty()) {
                    map.put(LIBRARY, StringUtils.join(set, " "));
                }
                this.foundTestDescription(map, file2, 0);
            }
            catch (IOException iOException) {
                this.error(i18n, "finder.ioError", (Object)file2);
            }
        }
    }

    private Map<String, String> readTestNGComments(File file, BufferedReader bufferedReader) throws IOException {
        String string;
        JavaCommentStream javaCommentStream = new JavaCommentStream();
        javaCommentStream.init(bufferedReader);
        javaCommentStream.setFastScan(true);
        Map<String, String> map = null;
        int n = 1;
        while ((string = ((CommentStream)javaCommentStream).readComment()) != null) {
            Map<String, String> map2 = this.parseComment(string, file);
            if (map2.isEmpty()) continue;
            if (map == null) {
                map = map2;
            } else {
                map2.put(ERROR, PARSE_MULTIPLE_COMMENTS_NOT_ALLOWED);
                map2.put("id", String.valueOf(n++));
                this.foundTestDescription(map2, file, 0);
            }
            map.remove(TEST);
        }
        return map;
    }

    protected boolean isTestNGTest(File file) {
        String string = file.getName();
        return string.endsWith(".java") && !string.equals("module-info.java") && !string.equals("package-info.java");
    }

    private File canon(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            return new File(file.getAbsoluteFile().toURI().normalize());
        }
    }

    protected Map<String, String> normalize(Map map) {
        return this.normalize0(map);
    }

    private Map<String, String> normalize0(Map<String, String> map) {
        int n;
        Object object;
        Object object3;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = this.getCurrentFile().getName();
        String string2 = string.substring(0, string.lastIndexOf("."));
        boolean bl = map.containsKey("testngClass");
        hashMap.put("title", " ");
        hashMap.put("source", string);
        if (bl) {
            if (map.get(RUN) != null) {
                map.put(ERROR, PARSE_BAD_RUN);
            }
            object3 = map.get("testngClass");
            hashMap.put(RUN, "ASSUMED_ACTION testng " + (String)object3 + LINESEP);
        } else if (string.endsWith(".sh")) {
            hashMap.put(RUN, "ASSUMED_ACTION shell " + string + LINESEP);
        } else if (string.endsWith(".java")) {
            hashMap.put(RUN, "ASSUMED_ACTION main " + string2 + LINESEP);
        } else {
            hashMap.put(RUN, "ASSUMED_ACTION applet " + string + LINESEP);
        }
        for (Map.Entry object22 : map.entrySet()) {
            String n2 = (String)object22.getKey();
            object = (String)object22.getValue();
            block7 : switch (n2) {
                case "summary": {
                    n2 = "title";
                    int set = 0;
                    while ((set = ((String)object).indexOf(".", set)) != -1 && set + 1 != ((String)object).length()) {
                        switch (((String)object).charAt(set + 1)) {
                            case '\b': 
                            case '\t': 
                            case '\n': 
                            case '\f': 
                            case '\r': 
                            case ' ': {
                                object = ((String)object).substring(0, set + 1);
                                break block7;
                            }
                        }
                        ++set;
                    }
                    break;
                }
                case "bug": 
                case "key": {
                    n2 = "keywords";
                    String bl2 = (String)hashMap.get("keywords");
                    if (bl2 == null) break;
                    object = bl2 + " " + (String)object;
                    break;
                }
                case "test": {
                    n2 = "keywords";
                    String bl2 = (String)hashMap.get("keywords");
                    if (bl2 != null) {
                        object = bl2 + " regtest";
                        break;
                    }
                    object = "regtest";
                    break;
                }
            }
            hashMap.put(n2, (String)object);
        }
        object3 = (String)hashMap.get(RUN);
        Set<String> set = this.split((String)hashMap.get("keywords"), "\\s+");
        if (RegressionTestFinder.match((CharSequence)object3, OTHERVM_OPTION) || RegressionTestFinder.match((CharSequence)object3, BOOTCLASSPATH_OPTION)) {
            set.add("othervm");
        }
        if (RegressionTestFinder.match((CharSequence)object3, MANUAL_OPTION)) {
            set.add("manual");
        }
        if (RegressionTestFinder.match((CharSequence)object3, NATIVE_OPTION)) {
            set.add("native");
        }
        if (RegressionTestFinder.match((CharSequence)object3, SHELL_ACTION)) {
            set.add("shell");
        }
        if (RegressionTestFinder.match((CharSequence)object3, JUNIT_ACTION)) {
            set.add("junit");
        }
        if (RegressionTestFinder.match((CharSequence)object3, TESTNG_ACTION) || bl) {
            set.add("testng");
        }
        if (RegressionTestFinder.match((CharSequence)object3, DRIVER_ACTION)) {
            set.add("driver");
        }
        if (RegressionTestFinder.match((CharSequence)object3, IGNORE_ACTION)) {
            set.add(IGNORE);
        }
        hashMap.put("keywords", StringUtils.join(set, " "));
        if (rejectTrailingBuild && ((String)(object = ((String)object3).substring((n = ((String)object3).lastIndexOf(LINESEP, ((String)object3).length() - 1 - LINESEP.length())) == -1 ? 0 : n + LINESEP.length()))).startsWith("USER_SPECIFIED build")) {
            hashMap.put(ERROR, PARSE_RUN_ENDS_WITH_BUILD);
        }
        int n3 = -1;
        object = Pattern.compile("/timeout=([0-9]+)(?:/| )");
        Object object2 = ((Pattern)object).matcher((CharSequence)object3);
        while (((Matcher)object2).find()) {
            int string6 = Integer.parseInt(((Matcher)object2).group(1));
            if (string6 == 0) {
                n3 = 0;
                break;
            }
            if (string6 <= n3) continue;
            n3 = string6;
        }
        if (n3 > 0) {
            hashMap.put("maxTimeout", String.valueOf(n3));
        }
        try {
            boolean bl2;
            String string3;
            Set<String> set2;
            String fault = (String)hashMap.get(MODULES);
            if ((fault == null || fault.isEmpty()) && (set2 = this.properties.getModules(this.getCurrentFile())) != null && !set2.isEmpty()) {
                this.processModules(hashMap, set2);
            }
            if ((string3 = (String)hashMap.get(ENABLE_PREVIEW)) == null && (bl2 = this.properties.getEnablePreview(this.getCurrentFile()))) {
                hashMap.put(ENABLE_PREVIEW, "true");
            }
        }
        catch (TestSuite.Fault fault) {
            this.error(i18n, "finder.cant.read.test.properties", (Object)fault.getMessage());
        }
        return hashMap;
    }

    private static boolean match(CharSequence charSequence, Pattern pattern) {
        return pattern.matcher(charSequence).matches();
    }

    private Set<String> split(String string, String string2) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        if (string != null) {
            linkedHashSet.addAll(Arrays.asList(string.split(string2)));
        }
        return linkedHashSet;
    }

    protected void processEntry(Map map, String string, String object) {
        Map map2 = map;
        if (string.startsWith("(#)")) {
            return;
        }
        if (string.startsWith(COMPILE) || string.startsWith(CLEAN) || string.startsWith(BUILD) || string.startsWith(IGNORE)) {
            object = string + " " + (String)object;
            string = RUN;
        }
        try {
            switch (string) {
                case "run": {
                    this.processRun(map2, (String)object);
                    break;
                }
                case "bug": {
                    this.processBug(map2, (String)object);
                    break;
                }
                case "requires": {
                    this.processRequires(map2, (String)object);
                    break;
                }
                case "key": {
                    this.processKey(map2, (String)object);
                    break;
                }
                case "modules": {
                    this.processModules((Map<String, String>)map2, (String)object);
                    break;
                }
                case "library": {
                    this.processLibrary(map2, (String)object);
                    break;
                }
                case "comment": {
                    break;
                }
                case "enablePreview": {
                    this.processEnablePreview(map2, (String)object);
                    break;
                }
                default: {
                    if (!this.validTagNames.contains(string)) {
                        this.parseError(map2, PARSE_TAG_BAD + string);
                        break;
                    }
                    map2.put(string, object);
                    break;
                }
            }
        }
        catch (TestSuite.Fault fault) {
            this.reportError(map2, fault.getMessage());
        }
    }

    @Override
    protected void foundTestDescription(TestDescription testDescription) {
        String string = TestResult.getWorkRelativePath(testDescription);
        TestDescription testDescription2 = this.paths.get(string);
        if (testDescription2 != null && !testDescription.getRootRelativeURL().equals(testDescription2.getRootRelativeURL())) {
            this.error(i18n, "finder.jtrClash", testDescription.getFile(), testDescription2.getFile());
            return;
        }
        super.foundTestDescription(testDescription);
        this.paths.put(string, testDescription);
    }

    private void parseError(Map<String, String> map, String string) {
        this.reportError(map, "Parse Exception: " + string);
    }

    private void reportError(Map<String, String> map, String string) {
        if (map.get(ERROR) == null) {
            map.put(ERROR, string);
        }
    }

    private void processRun(Map<String, String> map, String string) {
        String string2 = map.get(RUN);
        StringBuilder stringBuilder = new StringBuilder();
        if (string2 != null) {
            stringBuilder.append(string2);
        }
        stringBuilder.append("USER_SPECIFIED").append(" ").append(string).append(LINESEP);
        map.put(RUN, stringBuilder.toString());
    }

    private void processBug(Map<String, String> map, String string) {
        if (string.trim().length() == 0) {
            this.parseError(map, PARSE_BUG_EMPTY);
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (map.get(BUG) != null) {
            stringBuilder.append(map.get(BUG));
        }
        for (String string2 : StringUtils.splitWS(string)) {
            if (this.checkBugID && !bugIdPattern.matcher(string2).matches()) {
                this.parseError(map, PARSE_BUG_INVALID + string2);
                continue;
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(BUG).append(string2);
        }
        if (stringBuilder.length() > 0) {
            map.put(BUG, stringBuilder.toString());
        }
    }

    private void processRequires(Map<String, String> map, String string) throws TestSuite.Fault {
        Object object;
        if (string.trim().length() == 0) {
            this.parseError(map, PARSE_REQUIRES_EMPTY);
            return;
        }
        try {
            object = this.properties.getValidRequiresProperties(this.getCurrentFile());
            RegressionContext regressionContext = new RegressionContext(this.baseContext, (Set<String>)object);
            Expr.parse(string, regressionContext);
        }
        catch (Expr.Fault fault) {
            this.parseError(map, PARSE_REQUIRES_SYNTAX + fault.getMessage());
            return;
        }
        object = map.get(REQUIRES);
        if (object == null) {
            map.put(REQUIRES, string);
        } else {
            map.put(REQUIRES, "(" + (String)object + ") & (" + string + ")");
        }
    }

    private void processKey(Map<String, String> map, String string) throws TestSuite.Fault {
        if (string.trim().length() == 0) {
            this.parseError(map, PARSE_KEY_EMPTY);
            return;
        }
        Set<String> set = this.properties.getValidKeys(this.getCurrentFile());
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : StringUtils.splitWS(string)) {
            String string3 = string2.replace("-", "_");
            if (!set.contains(string3)) {
                this.parseError(map, PARSE_KEY_BAD + string2);
                continue;
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(string3);
        }
        if (stringBuilder.length() > 0) {
            map.put(KEY, stringBuilder.toString());
        }
    }

    private void processModules(Map<String, String> map, String string) throws TestSuite.Fault {
        if (string.trim().length() == 0) {
            this.parseError(map, PARSE_MODULES_EMPTY);
            return;
        }
        this.processModules(map, Arrays.asList(string.trim().split("\\s+")));
    }

    private void processModules(Map<String, String> map, Collection<String> collection) {
        String string2;
        for (String string2 : collection) {
            try {
                Modules.Entry entry = Modules.parse(string2);
            }
            catch (Modules.Fault fault) {
                this.parseError(map, PARSE_BAD_MODULE + fault.getMessage());
                return;
            }
        }
        String string3 = map.get(MODULES);
        string2 = StringUtils.join(collection, " ");
        if (string3 == null) {
            map.put(MODULES, string2);
        } else {
            map.put(MODULES, (String)string3 + " " + string2);
        }
    }

    private void processLibrary(Map<String, String> map, String string) {
        if (map.get(RUN) == null) {
            if (string.trim().length() != 0) {
                String string2 = map.get(LIBRARY);
                Object object = string2 != null ? string.trim() + " " + string2 : string.trim();
                map.put(LIBRARY, (String)object);
            } else {
                this.parseError(map, PARSE_LIB_EMPTY);
            }
        } else {
            this.parseError(map, PARSE_LIB_AFTER_RUN);
        }
    }

    private void processEnablePreview(Map<String, String> map, String string) {
        if (string.isEmpty()) {
            map.put(ENABLE_PREVIEW, "true");
        } else {
            String string2;
            switch (string2 = string.trim()) {
                case "false": 
                case "true": {
                    map.put(ENABLE_PREVIEW, string2);
                    break;
                }
                default: {
                    this.parseError(map, PARSE_INVALID_ENABLE_PREVIEW + string2);
                }
            }
        }
    }

    private Set<String> getValidTagNames(boolean bl) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(TEST);
        hashSet.add(BUG);
        hashSet.add(SUMMARY);
        hashSet.add(AUTHOR);
        hashSet.add(LIBRARY);
        hashSet.add(MODULES);
        hashSet.add(CLEAN);
        hashSet.add(COMPILE);
        hashSet.add(IGNORE);
        hashSet.add(RUN);
        hashSet.add(BUILD);
        hashSet.add(REQUIRES);
        hashSet.add(COMMENT);
        hashSet.add(ENABLE_PREVIEW);
        if (bl) {
            hashSet.add(KEY);
        }
        return hashSet;
    }

    private static Pattern getActionPattern(String string) {
        return Pattern.compile("(?s).*(USER_SPECIFIED|ASSUMED_ACTION) \\Q" + string + "\\E\\b.*");
    }

    private static Pattern getOptionPattern(String string) {
        return Pattern.compile("(?s).*/" + string + "[/= \t].*");
    }

    private class LineCounterBufferedReader
    extends BufferedReader {
        int lineNumber;

        LineCounterBufferedReader(FileReader fileReader) {
            super(fileReader);
            this.lineNumber = 1;
        }

        @Override
        public int read() throws IOException {
            int n = super.read();
            this.checkNewline(n);
            return n;
        }

        @Override
        public String readLine() throws IOException {
            String string = super.readLine();
            ++this.lineNumber;
            return string;
        }

        @Override
        public int read(char[] cArray, int n, int n2) throws IOException {
            int n3 = super.read(cArray, n, n2);
            for (int i = n; i < n + n3; ++i) {
                this.checkNewline(cArray[i]);
            }
            return n3;
        }

        private void checkNewline(int n) {
            if (n == 10) {
                ++this.lineNumber;
            }
        }
    }

    private class PackageImportParser {
        private final File tngRoot;
        private final File file;
        String packageName;
        boolean importsJUnit;

        PackageImportParser(File file, File file2) {
            this.tngRoot = file;
            this.file = file2;
        }

        void parse() {
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(this.file));){
                int n;
                StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
                streamTokenizer.resetSyntax();
                streamTokenizer.slashSlashComments(true);
                streamTokenizer.slashStarComments(true);
                streamTokenizer.wordChars(97, 122);
                streamTokenizer.wordChars(65, 90);
                streamTokenizer.wordChars(36, 36);
                streamTokenizer.wordChars(95, 95);
                streamTokenizer.wordChars(48, 57);
                streamTokenizer.wordChars(46, 46);
                streamTokenizer.wordChars(42, 42);
                streamTokenizer.whitespaceChars(0, 32);
                streamTokenizer.eolIsSignificant(false);
                while ((n = streamTokenizer.nextToken()) != -1) {
                    if (n != -3) {
                        return;
                    }
                    switch (streamTokenizer.sval) {
                        case "package": {
                            if (streamTokenizer.nextToken() != -3) {
                                return;
                            }
                            this.packageName = streamTokenizer.sval;
                            if (streamTokenizer.nextToken() == 59) break;
                            return;
                        }
                        case "import": {
                            n = streamTokenizer.nextToken();
                            if (n == -3 && streamTokenizer.sval.equals("static")) {
                                n = streamTokenizer.nextToken();
                            }
                            if (n == -3 && streamTokenizer.sval.startsWith("org.junit")) {
                                this.importsJUnit = true;
                                return;
                            }
                            if (streamTokenizer.nextToken() == 59) break;
                            return;
                        }
                    }
                }
            }
            catch (IOException iOException) {
                RegressionTestFinder.this.error(i18n, "finder.ioError", this.file);
            }
        }

        String inferClassName() {
            String string;
            String string2 = this.tngRoot.toURI().relativize(this.file.toURI()).getPath();
            String string3 = this.file.getName();
            String string4 = string3.replace(".java", "");
            String string5 = string = this.packageName == null ? this.file.getName() : this.packageName.replace('.', '/') + "/" + string3;
            if (string2.equalsIgnoreCase(string)) {
                return this.packageName == null ? string4 : this.packageName + "." + string4;
            }
            if (string2.toLowerCase().endsWith("/" + string.toLowerCase())) {
                String string6 = string2.substring(0, string2.length() - string.length());
                return string6 + (String)(this.packageName == null ? string4 : this.packageName + "." + string4);
            }
            return null;
        }
    }
}

