/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.config;

import com.sun.javatest.TestDescription;
import com.sun.javatest.TestFilter;
import com.sun.javatest.util.DynamicArray;

public class ObservableTestFilter
extends TestFilter {
    private TestFilter delegate;
    private TestFilter.Observer[] observers = new TestFilter.Observer[0];

    ObservableTestFilter(TestFilter testFilter) {
        if (testFilter == null) {
            throw new NullPointerException();
        }
        this.delegate = testFilter;
    }

    void addObserver(TestFilter.Observer observer) {
        if (observer == null) {
            throw new NullPointerException();
        }
        this.observers = DynamicArray.append(this.observers, observer);
    }

    void removeObserver(TestFilter.Observer observer) {
        this.observers = DynamicArray.remove(this.observers, observer);
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public String getDescription() {
        return this.delegate.getDescription();
    }

    @Override
    public String getReason() {
        return this.delegate.getReason();
    }

    @Override
    public boolean accepts(TestDescription testDescription) throws TestFilter.Fault {
        if (this.delegate.accepts(testDescription)) {
            return true;
        }
        TestFilter.Observer[] observerArray = this.observers;
        for (int i = observerArray.length - 1; i >= 0; --i) {
            observerArray[i].rejected(testDescription, this);
        }
        return false;
    }
}

