/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.config;

import com.sun.javatest.TestDescription;
import com.sun.javatest.regtest.config.RegressionParameters;
import com.sun.javatest.regtest.util.StringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class Modules
implements Iterable<Entry> {
    public static final Modules noModules = new Modules();
    Set<Entry> entries;
    private static final WeakHashMap<RegressionParameters, Map<String, Entry>> caches = new WeakHashMap();

    public static Entry parse(String string) throws Fault {
        String string2;
        String string3 = null;
        boolean bl = false;
        boolean bl2 = false;
        int n = string.indexOf("/");
        if (n == -1) {
            string2 = string;
        } else {
            string2 = string.substring(0, n);
            int n2 = string.indexOf(":", n + 1);
            if (n2 == -1) {
                string3 = string.substring(n + 1);
                bl = true;
            } else {
                String[] stringArray;
                string3 = string.substring(n + 1, n2);
                String[] stringArray2 = stringArray = string.substring(n2 + 1).split(",");
                int n3 = stringArray2.length;
                block9: for (int i = 0; i < n3; ++i) {
                    String string4;
                    switch (string4 = stringArray2[i]) {
                        case "open": 
                        case "private": {
                            bl2 = true;
                            continue block9;
                        }
                        case "+open": {
                            bl = true;
                            bl2 = true;
                            continue block9;
                        }
                        default: {
                            throw new Fault("bad modifier: " + string4);
                        }
                    }
                }
            }
        }
        if (!Modules.isDottedName(string2)) {
            throw new Fault("invalid module name: " + string2);
        }
        if (string3 != null && !Modules.isDottedName(string3)) {
            throw new Fault("invalid package name: " + string3);
        }
        return new Entry(string2, string3, bl, bl2);
    }

    private static boolean isDottedName(String string) {
        for (String string2 : string.split("\\.")) {
            if (Modules.isValidIdentifier(string2)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidIdentifier(String string) {
        if (string.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private Modules() {
        this.entries = Collections.emptySet();
    }

    public Modules(RegressionParameters regressionParameters, TestDescription testDescription) throws Fault {
        String string = testDescription.getParameter("modules");
        if (string == null) {
            this.entries = Collections.emptySet();
        } else {
            this.entries = new LinkedHashSet<Entry>();
            for (String string2 : string.trim().split("\\s+")) {
                this.entries.add(this.getEntry(regressionParameters, string2));
            }
        }
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public Iterator<Entry> iterator() {
        return this.entries.iterator();
    }

    public String toString() {
        return StringUtils.join(this.entries, " ");
    }

    private Entry getEntry(RegressionParameters regressionParameters, String string) throws Fault {
        Entry entry;
        Map<String, Entry> map = caches.get(regressionParameters);
        if (map == null) {
            map = new HashMap<String, Entry>();
            caches.put(regressionParameters, map);
        }
        if ((entry = map.get(string)) == null) {
            entry = Modules.parse(string);
            map.put(string, entry);
        }
        return entry;
    }

    public static class Fault
    extends Exception {
        private static final long serialVersionUID = 1L;

        Fault(String string) {
            super(string);
        }
    }

    public static class Entry {
        public final String moduleName;
        public final String packageName;
        public final boolean addExports;
        public final boolean addOpens;

        Entry(String string, String string2, boolean bl, boolean bl2) {
            this.moduleName = string;
            this.packageName = string2;
            this.addExports = bl;
            this.addOpens = bl2;
        }

        public boolean needAddExports() {
            return this.packageName != null;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.moduleName);
            if (this.packageName != null) {
                stringBuilder.append("/").append(this.packageName);
                String string = ":";
                if (this.addOpens) {
                    if (this.addExports) {
                        stringBuilder.append(string).append("+open");
                    } else {
                        stringBuilder.append(string).append("open");
                    }
                }
            }
            return stringBuilder.toString();
        }
    }

    public static enum Phase {
        STATIC,
        DYNAMIC;

    }
}

