/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.config;

public abstract class Expr {
    protected static final int PREC_LIT = 6;
    protected static final int PREC_NOT = 6;
    protected static final int PREC_NUM = 6;
    protected static final int PREC_PRN = 6;
    protected static final int PREC_TRM = 6;
    protected static final int PREC_DIV = 5;
    protected static final int PREC_MUL = 5;
    protected static final int PREC_REM = 5;
    protected static final int PREC_ADD = 4;
    protected static final int PREC_SUB = 4;
    protected static final int PREC_GE = 3;
    protected static final int PREC_GT = 3;
    protected static final int PREC_LE = 3;
    protected static final int PREC_LT = 3;
    protected static final int PREC_EQ = 2;
    protected static final int PREC_NE = 2;
    protected static final int PREC_AND = 1;
    protected static final int PREC_OR = 0;

    public static Expr parse(String string, Context context) throws Fault {
        Parser parser = new Parser(string, context);
        return parser.parse();
    }

    public abstract String eval(Context var1) throws Fault;

    public boolean evalBoolean(Context context) throws Fault {
        String string = this.eval(context);
        if (string.equals("true")) {
            return true;
        }
        if (string.equals("false")) {
            return false;
        }
        throw new Fault("invalid boolean value: `" + string + "' for expression `" + this + "'");
    }

    public long evalNumber(Context context) throws Fault {
        String string = this.eval(context);
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new Fault("invalid numeric value: " + string);
        }
    }

    abstract int precedence();

    Expr order() {
        return this;
    }

    static class Parser {
        private final Context context;
        private final String text;
        private int index;
        private Token token;
        private String idValue;

        Parser(String string, Context context) throws Fault {
            this.context = context;
            this.text = string;
            this.nextToken();
        }

        Expr parse() throws Fault {
            Expr expr = this.parseExpr();
            this.expect(Token.END);
            return expr;
        }

        Expr parseExpr() throws Fault {
            block16: for (Expr expr = this.parseTerm(); expr != null; expr = expr.order()) {
                switch (this.token) {
                    case ADD: {
                        this.nextToken();
                        expr = new AddExpr(expr, this.parseTerm());
                        continue block16;
                    }
                    case AND: {
                        this.nextToken();
                        expr = new AndExpr(expr, this.parseTerm());
                        continue block16;
                    }
                    case DIV: {
                        this.nextToken();
                        expr = new DivideExpr(expr, this.parseTerm());
                        continue block16;
                    }
                    case EQ: {
                        this.nextToken();
                        expr = new EqualExpr(expr, this.parseTerm());
                        continue block16;
                    }
                    case GE: {
                        this.nextToken();
                        expr = new GreaterEqualExpr(expr, this.parseTerm());
                        continue block16;
                    }
                    case GT: {
                        this.nextToken();
                        expr = new GreaterExpr(expr, this.parseTerm());
                        continue block16;
                    }
                    case LE: {
                        this.nextToken();
                        expr = new LessEqualExpr(expr, this.parseTerm());
                        continue block16;
                    }
                    case LT: {
                        this.nextToken();
                        expr = new LessExpr(expr, this.parseTerm());
                        continue block16;
                    }
                    case MATCH: {
                        this.nextToken();
                        expr = new MatchExpr(expr, this.parseTerm());
                        continue block16;
                    }
                    case MUL: {
                        this.nextToken();
                        expr = new MultiplyExpr(expr, this.parseTerm());
                        continue block16;
                    }
                    case NE: {
                        this.nextToken();
                        expr = new NotEqualExpr(expr, this.parseTerm());
                        continue block16;
                    }
                    case OR: {
                        this.nextToken();
                        expr = new OrExpr(expr, this.parseTerm());
                        continue block16;
                    }
                    case REM: {
                        this.nextToken();
                        expr = new RemainderExpr(expr, this.parseTerm());
                        continue block16;
                    }
                    case SUB: {
                        this.nextToken();
                        expr = new SubtractExpr(expr, this.parseTerm());
                        continue block16;
                    }
                    default: {
                        return expr;
                    }
                }
            }
            return null;
        }

        Expr parseTerm() throws Fault {
            switch (this.token) {
                case NAME: {
                    String string = this.idValue;
                    this.nextToken();
                    if (this.context.isValidName(string)) {
                        return new NameExpr(string);
                    }
                    throw new Fault("invalid name: " + string);
                }
                case NOT: {
                    this.nextToken();
                    return new NotExpr(this.parseTerm());
                }
                case NUMBER: 
                case TRUE: 
                case FALSE: {
                    String string = this.idValue;
                    this.nextToken();
                    return new NumberExpr(string);
                }
                case LPAREN: {
                    this.nextToken();
                    Expr expr = this.parseExpr();
                    this.expect(Token.RPAREN);
                    return new ParenExpr(expr);
                }
                case STRING: {
                    String string = this.idValue;
                    this.nextToken();
                    return new StringExpr(string);
                }
            }
            throw new Fault(this.token.getText() + " not expected");
        }

        private void expect(Token token) throws Fault {
            if (token != this.token) {
                throw new Fault(token.getText() + "expected, but " + this.token.getText() + " found");
            }
            this.nextToken();
        }

        private void nextToken() throws Fault {
            block31: while (this.index < this.text.length()) {
                int n = this.text.charAt(this.index++);
                switch (n) {
                    case 9: 
                    case 32: {
                        continue block31;
                    }
                    case 38: {
                        this.token = Token.AND;
                        return;
                    }
                    case 124: {
                        this.token = Token.OR;
                        return;
                    }
                    case 43: {
                        this.token = Token.ADD;
                        return;
                    }
                    case 45: {
                        this.token = Token.SUB;
                        return;
                    }
                    case 42: {
                        this.token = Token.MUL;
                        return;
                    }
                    case 47: {
                        this.token = Token.DIV;
                        return;
                    }
                    case 37: {
                        this.token = Token.REM;
                        return;
                    }
                    case 40: {
                        this.token = Token.LPAREN;
                        return;
                    }
                    case 41: {
                        this.token = Token.RPAREN;
                        return;
                    }
                    case 60: {
                        if (this.index < this.text.length() && this.text.charAt(this.index) == '=') {
                            this.token = Token.LE;
                            ++this.index;
                        } else {
                            this.token = Token.LT;
                        }
                        return;
                    }
                    case 62: {
                        if (this.index < this.text.length() && this.text.charAt(this.index) == '=') {
                            this.token = Token.GE;
                            ++this.index;
                        } else {
                            this.token = Token.GT;
                        }
                        return;
                    }
                    case 126: {
                        if (this.index < this.text.length() && this.text.charAt(this.index) == '=') {
                            this.token = Token.MATCH;
                            ++this.index;
                        } else {
                            throw new Fault("unexpected character after `~'");
                        }
                        return;
                    }
                    case 61: {
                        if (this.index < this.text.length() && this.text.charAt(this.index) == '=') {
                            this.token = Token.EQ;
                            ++this.index;
                        } else {
                            throw new Fault("unexpected character after `='");
                        }
                        return;
                    }
                    case 33: {
                        if (this.index < this.text.length() && this.text.charAt(this.index) == '=') {
                            this.token = Token.NE;
                            ++this.index;
                        } else {
                            this.token = Token.NOT;
                        }
                        return;
                    }
                    case 34: {
                        StringBuffer stringBuffer = new StringBuffer();
                        if (this.index < this.text.length()) {
                            n = this.text.charAt(this.index);
                            ++this.index;
                        } else {
                            throw new Fault("invalid string constant");
                        }
                        while (n != 34) {
                            if (n == 92) {
                                if (this.index < this.text.length()) {
                                    n = this.text.charAt(this.index);
                                    ++this.index;
                                } else {
                                    throw new Fault("invalid string constant");
                                }
                                switch (n) {
                                    case 98: {
                                        n = 8;
                                        break;
                                    }
                                    case 102: {
                                        n = 12;
                                        break;
                                    }
                                    case 110: {
                                        n = 10;
                                        break;
                                    }
                                    case 114: {
                                        n = 13;
                                        break;
                                    }
                                    case 116: {
                                        n = 9;
                                        break;
                                    }
                                    case 92: {
                                        n = 92;
                                        break;
                                    }
                                    case 39: {
                                        n = 39;
                                        break;
                                    }
                                    case 34: {
                                        n = 34;
                                        break;
                                    }
                                    default: {
                                        throw new Fault("invalid string constant");
                                    }
                                }
                            }
                            stringBuffer.append((char)n);
                            if (this.index >= this.text.length()) break;
                            n = this.text.charAt(this.index);
                            ++this.index;
                        }
                        if (n != 34) {
                            throw new Fault("invalid string constant");
                        }
                        this.token = Token.STRING;
                        this.idValue = String.valueOf(stringBuffer);
                        return;
                    }
                }
                if (Character.isUnicodeIdentifierStart((char)n)) {
                    this.idValue = String.valueOf((char)n);
                    while (this.index < this.text.length() && (Character.isUnicodeIdentifierPart((char)(n = this.text.charAt(this.index))) || n == 46)) {
                        if (!Character.isIdentifierIgnorable((char)n)) {
                            this.idValue = this.idValue + (char)n;
                        }
                        ++this.index;
                    }
                    this.token = this.idValue.equalsIgnoreCase("true") ? Token.TRUE : (this.idValue.equalsIgnoreCase("false") ? Token.FALSE : Token.NAME);
                    return;
                }
                if (Character.isDigit((char)n)) {
                    int n2 = this.index - 1;
                    while (this.index < this.text.length()) {
                        n = this.text.charAt(this.index);
                        if (Character.isDigit((char)n)) {
                            ++this.index;
                            continue;
                        }
                        switch (n) {
                            case 71: 
                            case 75: 
                            case 77: 
                            case 103: 
                            case 107: 
                            case 109: {
                                ++this.index;
                            }
                        }
                    }
                    this.token = Token.NUMBER;
                    this.idValue = this.text.substring(n2, this.index);
                    return;
                }
                throw new Fault("unrecognized character: `" + (char)n + "'");
            }
            this.token = Token.END;
        }
    }

    public static interface Context {
        public boolean isValidName(String var1);

        public String get(String var1) throws Fault;
    }

    public static class Fault
    extends Exception {
        private static final long serialVersionUID = 1L;

        Fault(String string) {
            super(string);
        }
    }

    static class SubtractExpr
    extends BinaryExpr {
        SubtractExpr(Expr expr, Expr expr2) {
            super(expr, expr2);
        }

        @Override
        public String eval(Context context) throws Fault {
            return String.valueOf(this.left.evalNumber(context) - this.right.evalNumber(context));
        }

        @Override
        int precedence() {
            return 4;
        }

        public String toString() {
            return "`" + this.left + "-" + this.right + "'";
        }
    }

    static class StringExpr
    extends Expr {
        private final String value;

        StringExpr(String string) {
            this.value = string;
        }

        @Override
        public String eval(Context context) throws Fault {
            return this.value;
        }

        @Override
        int precedence() {
            return 6;
        }

        public String toString() {
            return "\"" + this.value + "\"";
        }
    }

    static class RemainderExpr
    extends BinaryExpr {
        RemainderExpr(Expr expr, Expr expr2) {
            super(expr, expr2);
        }

        @Override
        public String eval(Context context) throws Fault {
            return String.valueOf(this.left.evalNumber(context) % this.right.evalNumber(context));
        }

        @Override
        int precedence() {
            return 5;
        }

        public String toString() {
            return "`" + this.left + "%" + this.right + "'";
        }
    }

    static class ParenExpr
    extends Expr {
        private final Expr expr;

        ParenExpr(Expr expr) {
            this.expr = expr;
        }

        @Override
        public String eval(Context context) throws Fault {
            return this.expr.eval(context);
        }

        @Override
        int precedence() {
            return 6;
        }

        public String toString() {
            return "(" + this.expr + ")";
        }
    }

    static class OrExpr
    extends BinaryExpr {
        OrExpr(Expr expr, Expr expr2) {
            super(expr, expr2);
        }

        @Override
        public String eval(Context context) throws Fault {
            return String.valueOf(this.left.evalBoolean(context) ? true : this.right.evalBoolean(context));
        }

        @Override
        int precedence() {
            return 0;
        }

        public String toString() {
            return "`" + this.left + "|" + this.right + "'";
        }
    }

    static class NumberExpr
    extends Expr {
        private final String value;

        NumberExpr(String string) {
            this.value = string;
        }

        @Override
        public String eval(Context context) throws Fault {
            long l;
            char c = this.value.charAt(this.value.length() - 1);
            switch (c) {
                case 'K': 
                case 'k': {
                    l = 1024L;
                    break;
                }
                case 'M': 
                case 'm': {
                    l = 0x100000L;
                    break;
                }
                case 'G': 
                case 'g': {
                    l = 0x40000000L;
                    break;
                }
                default: {
                    return this.value;
                }
            }
            try {
                String string = this.value.substring(0, this.value.length() - 1);
                return String.valueOf(Long.parseLong(string) * l);
            }
            catch (NumberFormatException numberFormatException) {
                throw new Fault("invalid numeric value: " + this.value);
            }
        }

        @Override
        int precedence() {
            return 6;
        }

        public String toString() {
            return this.value;
        }
    }

    static class NotExpr
    extends Expr {
        private final Expr expr;

        NotExpr(Expr expr) {
            this.expr = expr;
        }

        @Override
        public String eval(Context context) throws Fault {
            return String.valueOf(!this.expr.evalBoolean(context));
        }

        @Override
        int precedence() {
            return 6;
        }

        public String toString() {
            return "!" + this.expr;
        }
    }

    static class NotEqualExpr
    extends BinaryExpr {
        NotEqualExpr(Expr expr, Expr expr2) {
            super(expr, expr2);
        }

        @Override
        public String eval(Context context) throws Fault {
            return String.valueOf(!this.left.eval(context).equalsIgnoreCase(this.right.eval(context)));
        }

        @Override
        int precedence() {
            return 2;
        }

        public String toString() {
            return "`" + this.left + "!=" + this.right + "'";
        }
    }

    static class NameExpr
    extends Expr {
        private final String name;

        NameExpr(String string) {
            this.name = string;
        }

        @Override
        public String eval(Context context) throws Fault {
            String string = context.get(this.name);
            if (string == null) {
                throw new Fault("name not defined: " + this.name);
            }
            return string;
        }

        @Override
        int precedence() {
            return 6;
        }

        public String toString() {
            return this.name;
        }
    }

    static class MultiplyExpr
    extends BinaryExpr {
        MultiplyExpr(Expr expr, Expr expr2) {
            super(expr, expr2);
        }

        @Override
        public String eval(Context context) throws Fault {
            return String.valueOf(this.left.evalNumber(context) * this.right.evalNumber(context));
        }

        @Override
        int precedence() {
            return 5;
        }

        public String toString() {
            return "`" + this.left + "*" + this.right + "'";
        }
    }

    static class MatchExpr
    extends BinaryExpr {
        MatchExpr(Expr expr, Expr expr2) {
            super(expr, expr2);
        }

        @Override
        public String eval(Context context) throws Fault {
            return String.valueOf(this.left.eval(context).matches(this.right.eval(context)));
        }

        @Override
        int precedence() {
            return 2;
        }

        public String toString() {
            return "`" + this.left + "~=" + this.right + "'";
        }
    }

    static class LessEqualExpr
    extends BinaryExpr {
        LessEqualExpr(Expr expr, Expr expr2) {
            super(expr, expr2);
        }

        @Override
        public String eval(Context context) throws Fault {
            return String.valueOf(this.left.evalNumber(context) <= this.right.evalNumber(context));
        }

        @Override
        int precedence() {
            return 3;
        }

        public String toString() {
            return "`" + this.left + "<=" + this.right + "'";
        }
    }

    static class LessExpr
    extends BinaryExpr {
        LessExpr(Expr expr, Expr expr2) {
            super(expr, expr2);
        }

        @Override
        public String eval(Context context) throws Fault {
            return String.valueOf(this.left.evalNumber(context) < this.right.evalNumber(context));
        }

        @Override
        int precedence() {
            return 3;
        }

        public String toString() {
            return "`" + this.left + "<" + this.right + "'";
        }
    }

    static class GreaterEqualExpr
    extends BinaryExpr {
        GreaterEqualExpr(Expr expr, Expr expr2) {
            super(expr, expr2);
        }

        @Override
        public String eval(Context context) throws Fault {
            return String.valueOf(this.left.evalNumber(context) >= this.right.evalNumber(context));
        }

        @Override
        int precedence() {
            return 3;
        }

        public String toString() {
            return "`" + this.left + ">=" + this.right + "'";
        }
    }

    static class GreaterExpr
    extends BinaryExpr {
        GreaterExpr(Expr expr, Expr expr2) {
            super(expr, expr2);
        }

        @Override
        public String eval(Context context) throws Fault {
            return String.valueOf(this.left.evalNumber(context) > this.right.evalNumber(context));
        }

        @Override
        int precedence() {
            return 3;
        }

        public String toString() {
            return "`" + this.left + ">" + this.right + "'";
        }
    }

    static class EqualExpr
    extends BinaryExpr {
        EqualExpr(Expr expr, Expr expr2) {
            super(expr, expr2);
        }

        @Override
        public String eval(Context context) throws Fault {
            return String.valueOf(this.left.eval(context).equalsIgnoreCase(this.right.eval(context)));
        }

        @Override
        int precedence() {
            return 2;
        }

        public String toString() {
            return "`" + this.left + "==" + this.right + "'";
        }
    }

    static class DivideExpr
    extends BinaryExpr {
        DivideExpr(Expr expr, Expr expr2) {
            super(expr, expr2);
        }

        @Override
        public String eval(Context context) throws Fault {
            return String.valueOf(this.left.evalNumber(context) / this.right.evalNumber(context));
        }

        @Override
        int precedence() {
            return 5;
        }

        public String toString() {
            return "`" + this.left + "/" + this.right + "'";
        }
    }

    static class AndExpr
    extends BinaryExpr {
        AndExpr(Expr expr, Expr expr2) {
            super(expr, expr2);
        }

        @Override
        public String eval(Context context) throws Fault {
            return String.valueOf(this.left.evalBoolean(context) ? this.right.evalBoolean(context) : false);
        }

        @Override
        int precedence() {
            return 1;
        }

        public String toString() {
            return "`" + this.left + "&" + this.right + "'";
        }
    }

    static class AddExpr
    extends BinaryExpr {
        AddExpr(Expr expr, Expr expr2) {
            super(expr, expr2);
        }

        @Override
        public String eval(Context context) throws Fault {
            return String.valueOf(this.left.evalNumber(context) + this.right.evalNumber(context));
        }

        @Override
        int precedence() {
            return 4;
        }

        public String toString() {
            return "`" + this.left + "+" + this.right + "'";
        }
    }

    static abstract class BinaryExpr
    extends Expr {
        protected Expr left;
        protected Expr right;

        BinaryExpr(Expr expr, Expr expr2) {
            this.left = expr;
            this.right = expr2;
        }

        @Override
        Expr order() {
            if (this.precedence() > this.left.precedence() && this.left instanceof BinaryExpr) {
                BinaryExpr binaryExpr = (BinaryExpr)this.left;
                this.left = binaryExpr.right;
                binaryExpr.right = this.order();
                return binaryExpr;
            }
            return this;
        }
    }

    static enum Token {
        ADD("+"),
        AND("&"),
        DIV("/"),
        END("<end-of-expression>"),
        ERROR("<error>"),
        EQ("="),
        FALSE("false"),
        GE(">="),
        GT(">"),
        LE("<="),
        LPAREN("("),
        LT("<"),
        MATCH("~="),
        MUL("*"),
        NAME("<name>"),
        NE("!="),
        NOT("!"),
        NUMBER("<number>"),
        OR("|"),
        REM("%"),
        RPAREN(")"),
        STRING("<string>"),
        SUB("-"),
        TRUE("true");

        final String text;

        private Token(String string2) {
            this.text = string2;
        }

        String getText() {
            return this.text.startsWith("<") ? this.text : "'" + this.text + "'";
        }
    }
}

