/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.config;

import com.sun.javatest.TestDescription;
import com.sun.javatest.TestFilter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class CachingTestFilter
extends TestFilter {
    private final String name;
    private final String description;
    private final String reason;
    private final Map<String, Entry> cache = new HashMap<String, Entry>();

    CachingTestFilter(String string, String string2, String string3) {
        this.name = string;
        this.description = string2;
        this.reason = string3;
    }

    protected abstract String getCacheKey(TestDescription var1);

    protected abstract boolean getCacheableValue(TestDescription var1) throws TestFilter.Fault;

    public Collection<Entry> getCacheEntries() {
        return Collections.unmodifiableCollection(this.cache.values());
    }

    public void clear() {
        this.cache.clear();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public final boolean accepts(TestDescription testDescription) throws TestFilter.Fault {
        String string = this.getCacheKey(testDescription);
        Entry entry = this.cache.get(string);
        if (entry == null) {
            entry = new Entry(testDescription, this.getCacheableValue(testDescription));
            this.cache.put(string, entry);
        }
        return entry.value;
    }

    public class Entry {
        public final TestDescription td;
        public final Boolean value;

        Entry(TestDescription testDescription, Boolean bl) {
            this.td = testDescription;
            this.value = bl;
        }
    }
}

