/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.agent;

import com.sun.javatest.regtest.agent.JavaTestSecurityManager;
import java.security.Permission;
import java.util.PropertyPermission;

public class RegressionSecurityManager
extends JavaTestSecurityManager {
    private boolean allowExec = true;
    private boolean propertiesModified;
    private boolean allowSetIO = false;
    private boolean allowSetSecurityManager = false;
    private static boolean verbose = Boolean.getBoolean("javatest.security.verbose");

    public static void install() {
        block5: {
            int n;
            String string = System.getProperty("java.specification.version");
            if (string != null && string.matches("[0-9]+") && (n = Integer.parseInt(string)) >= 18) {
                return;
            }
            try {
                if (Boolean.getBoolean("javatest.security.noSecurityManager")) {
                    System.err.println();
                    System.err.println("     ---- WARNING -----");
                    System.err.println();
                    System.err.println("JavaTest did not install its own Security Manager");
                    System.err.println("because the property javatest.security.noSecurityManager was set.");
                    System.err.println("This is not a fatal error, but it may affect the");
                    System.err.println("execution of sameJVM tests");
                    System.err.println();
                } else {
                    System.setSecurityManager(new RegressionSecurityManager());
                }
            }
            catch (SecurityException securityException) {
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager instanceof JavaTestSecurityManager) break block5;
                System.err.println();
                System.err.println("     ---- WARNING -----");
                System.err.println();
                System.err.println("JavaTest could not install its own Security Manager");
                System.err.println("because of the following exception:");
                System.err.println("     " + securityException);
                System.err.println("This is not a fatal error, but it may affect the");
                System.err.println("execution of sameJVM tests");
                System.err.println();
            }
        }
    }

    @Override
    public void checkExec(String string) {
        if (!this.allowExec) {
            if (verbose) {
                System.err.println(this.getClass().getName() + ": subprocess creation forbidden");
                new Throwable().printStackTrace();
            }
            throw new SecurityException("Subprocess creation forbidden by JavaTest");
        }
    }

    public boolean setAllowExec(boolean bl) {
        boolean bl2 = this.allowExec;
        this.allowExec = bl;
        return bl2;
    }

    @Override
    public void checkPermission(Permission permission) {
        if (permission instanceof RuntimePermission) {
            if (permission.getName().equals("setIO")) {
                if (!this.allowSetIO) {
                    super.checkPermission(new RuntimePermission("setIO"));
                }
            } else if (permission.getName().equals("exitVM")) {
                this.checkExit(0);
            } else if (!permission.getName().equals("createSecurityManager") && permission.getName().equals("setSecurityManager")) {
                if (!this.allowSetSecurityManager) {
                    this.forbid(permission);
                }
                this.propertiesModified = true;
            }
        } else if (permission instanceof PropertyPermission && permission.getActions().contains("write")) {
            this.propertiesModified = true;
        }
    }

    void forbid(Permission permission) throws SecurityException {
        if (verbose) {
            System.err.println(this.getClass().getName() + ": " + permission);
            Thread.dumpStack();
        }
        throw new SecurityException("Action forbidden by jtreg: " + permission.getName());
    }

    @Override
    public synchronized void checkPropertiesAccess() {
        super.checkPropertiesAccess();
        this.propertiesModified = true;
    }

    boolean isPropertiesModified() {
        return this.propertiesModified;
    }

    @Override
    public boolean setAllowPropertiesAccess(boolean bl) {
        return super.setAllowPropertiesAccess(bl);
    }

    void resetPropertiesModified() {
        this.propertiesModified = false;
    }

    public boolean setAllowSetIO(boolean bl) {
        boolean bl2 = this.allowSetIO;
        this.allowSetIO = bl;
        return bl2;
    }

    public boolean setAllowSetSecurityManager(boolean bl) {
        boolean bl2 = this.allowSetSecurityManager;
        this.allowSetSecurityManager = bl;
        return bl2;
    }
}

