/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.agent;

import com.sun.javatest.regtest.agent.AStatus;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class RegressionCompileCommand {
    public static boolean defaultVerbose = Boolean.getBoolean("javatest.JavaCompileCommand.verbose");
    private boolean verbose = defaultVerbose;
    private PrintWriter log;
    private static final AStatus passed = AStatus.passed("Compilation successful");
    private static final AStatus failed = AStatus.failed("Compilation failed");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        AStatus aStatus;
        PrintWriter printWriter = new PrintWriter(System.out);
        PrintWriter printWriter2 = new PrintWriter(System.err);
        try {
            RegressionCompileCommand regressionCompileCommand = new RegressionCompileCommand();
            aStatus = regressionCompileCommand.run(stringArray, printWriter, printWriter2);
        }
        finally {
            printWriter.flush();
            printWriter2.flush();
        }
        aStatus.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AStatus run(String[] stringArray, PrintWriter printWriter, PrintWriter printWriter2) {
        Class<?> clazz;
        int n;
        if (stringArray.length == 0) {
            return AStatus.error("No args supplied");
        }
        Class<?> clazz2 = null;
        Object object = null;
        String[] stringArray2 = null;
        for (n = 0; n < stringArray.length; ++n) {
            if (!stringArray[n].equals("-")) continue;
            stringArray2 = new String[n];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray2.length);
            stringArray = RegressionCompileCommand.shift(stringArray, n + 1);
            break;
        }
        if (stringArray2 != null) {
            for (n = 0; n < stringArray2.length; ++n) {
                if (stringArray2[n].equals("-compiler")) {
                    int n2;
                    if (n + 1 == stringArray2.length) {
                        return AStatus.error("No compiler specified after -compiler option");
                    }
                    if ((n2 = ((String)((Object)(clazz = stringArray2[++n]))).indexOf(":")) == -1) {
                        clazz2 = clazz;
                        object = "java " + (String)((Object)clazz);
                        continue;
                    }
                    clazz2 = ((String)((Object)clazz)).substring(n2 + 1);
                    object = ((String)((Object)clazz)).substring(0, n2);
                    continue;
                }
                if (stringArray2[n].equals("-verbose")) {
                    this.verbose = true;
                    continue;
                }
                return AStatus.error("Unrecognized option: " + stringArray2[n]);
            }
        }
        this.log = printWriter;
        try {
            Object object2;
            Object var7_8 = null;
            if (clazz2 != null) {
                clazz = this.getClass(var7_8, (String)((Object)clazz2));
                if (clazz == null) {
                    AStatus aStatus = AStatus.error("Cannot find compiler: " + clazz2);
                    return aStatus;
                }
            } else {
                object = "javac";
                clazz = this.getClass(var7_8, "com.sun.tools.javac.Main");
                if (clazz == null) {
                    AStatus aStatus = AStatus.error("Cannot find compiler");
                    return aStatus;
                }
            }
            var7_8 = null;
            Method method = this.getMethod(clazz, "compile", String[].class, PrintWriter.class);
            if (method == null) {
                AStatus aStatus = AStatus.error("Cannot find compile method for " + clazz.getName());
                return aStatus;
            }
            Object[] objectArray = new Object[]{stringArray, printWriter2};
            if (!Modifier.isStatic(method.getModifiers())) {
                AStatus aStatus = AStatus.error("compile method is not static");
                return aStatus;
            }
            try {
                object2 = method.invoke(null, objectArray);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(printWriter);
                AStatus aStatus = AStatus.error("Error invoking compiler");
                printWriter.flush();
                printWriter2.flush();
                return aStatus;
            }
            if (object2 instanceof Boolean) {
                AStatus aStatus = this.getStatus((Boolean)object2);
                return aStatus;
            }
            if (object2 instanceof Integer) {
                AStatus aStatus = this.getStatus((Integer)object2);
                return aStatus;
            }
            AStatus aStatus = AStatus.error("Unexpected return value from compiler: " + object2);
            return aStatus;
        }
        finally {
            printWriter.flush();
            printWriter2.flush();
        }
    }

    protected AStatus getStatus(boolean bl) {
        return bl ? passed : failed;
    }

    protected AStatus getStatus(int n) {
        return n == 0 ? passed : failed;
    }

    private Class<?> getClass(ClassLoader classLoader, String string) {
        try {
            return classLoader == null ? Class.forName(string) : classLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private Method getMethod(Class<?> clazz, String string, Class<?> ... classArray) {
        try {
            return clazz.getMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        catch (Throwable throwable) {
            if (this.verbose) {
                throwable.printStackTrace(this.log);
            }
            return null;
        }
    }

    private static String[] shift(String[] stringArray, int n) {
        String[] stringArray2 = new String[stringArray.length - n];
        System.arraycopy(stringArray, n, stringArray2, 0, stringArray2.length);
        return stringArray2;
    }
}

