/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.agent;

import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class ModuleHelper {
    private static Method findModuleMethod;
    private static Method configurationMethod;
    private static Method defineModulesWithOneLoaderMethod;
    private static Method findLoaderMethod;
    private static Object bootLayer;
    private static Method moduleFinderOfMethod;
    private static Method resolveMethod;
    private static Method getUnnamedModuleMethod;
    private static Method isPresentMethod;
    private static Method getMethod;
    private static Method toPathMethod;
    private static Object[] emptyArrayOfPaths;
    private static Method addExportsMethod;
    private static Method addOpensMethod;

    static void addExports(Set<String> set, ClassLoader classLoader) throws Fault {
        for (String string : set) {
            ModuleHelper.addExportsOrOpens(string, false, classLoader);
        }
    }

    static void addOpens(Set<String> set, ClassLoader classLoader) throws Fault {
        for (String string : set) {
            ModuleHelper.addExportsOrOpens(string, true, classLoader);
        }
    }

    static ClassLoader addModules(List<File> list, Set<String> set) throws Fault {
        ModuleHelper.init();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        try {
            for (File object2 : list) {
                for (File file : object2.listFiles()) {
                    arrayList.add(toPathMethod.invoke((Object)file, new Object[0]));
                }
            }
            Object object3 = moduleFinderOfMethod.invoke(null, new Object[]{arrayList.toArray(emptyArrayOfPaths)});
            Object object = moduleFinderOfMethod.invoke(null, new Object[]{emptyArrayOfPaths});
            Object object2 = configurationMethod.invoke(bootLayer, new Object[0]);
            Object object4 = resolveMethod.invoke(object2, object3, object, set);
            Object object5 = defineModulesWithOneLoaderMethod.invoke(bootLayer, object4, ClassLoader.getSystemClassLoader());
            return (ClassLoader)findLoaderMethod.invoke(object5, set.iterator().next());
        }
        catch (SecurityException securityException) {
            throw new Fault("unexpected exception: " + securityException, securityException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Fault("unexpected exception: " + illegalAccessException, illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new Fault("unexpected exception: " + illegalArgumentException, illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new Fault("unexpected exception: " + invocationTargetException, invocationTargetException);
        }
    }

    private static void addExportsOrOpens(String string, boolean bl, ClassLoader classLoader) throws Fault {
        int n = string.indexOf("/");
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        try {
            ModuleHelper.init();
            Object object = findModuleMethod.invoke(bootLayer, string2);
            if (!((Boolean)isPresentMethod.invoke(object, new Object[0])).booleanValue()) {
                throw new Fault("module not found: " + string2, null);
            }
            Object object2 = getMethod.invoke(object, new Object[0]);
            Object object3 = getUnnamedModuleMethod.invoke((Object)classLoader, new Object[0]);
            try {
                Method method = bl ? addOpensMethod : addExportsMethod;
                method.invoke(null, object2, string3, object3);
            }
            catch (InvocationTargetException invocationTargetException) {
                if (invocationTargetException.getCause() instanceof IllegalArgumentException) {
                    String string4 = invocationTargetException.getCause().getMessage();
                    throw new Fault("package not found: " + string3 + " (" + string4 + ")", null);
                }
                throw new Fault("unexpected exception: " + invocationTargetException, invocationTargetException);
            }
        }
        catch (SecurityException securityException) {
            throw new Fault("unexpected exception: " + securityException, securityException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Fault("unexpected exception: " + illegalAccessException, illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new Fault("unexpected exception: " + illegalArgumentException, illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new Fault("unexpected exception: " + invocationTargetException, invocationTargetException);
        }
    }

    private static synchronized void init() throws Fault {
        if (bootLayer != null) {
            return;
        }
        try {
            Class<?> clazz = Class.forName("java.nio.file.Path");
            toPathMethod = File.class.getDeclaredMethod("toPath", new Class[0]);
            emptyArrayOfPaths = (Object[])Array.newInstance(clazz, 0);
            Class<?> clazz2 = emptyArrayOfPaths.getClass();
            Class<?> clazz3 = Class.forName("java.util.Optional");
            isPresentMethod = clazz3.getDeclaredMethod("isPresent", new Class[0]);
            getMethod = clazz3.getDeclaredMethod("get", new Class[0]);
            Class<?> clazz4 = Class.forName("java.lang.module.ModuleFinder");
            moduleFinderOfMethod = clazz4.getDeclaredMethod("of", clazz2);
            Class<?> clazz5 = Class.forName("java.lang.module.Configuration");
            resolveMethod = clazz5.getDeclaredMethod("resolve", clazz4, clazz4, Collection.class);
            Class<?> clazz6 = Class.forName("java.lang.ModuleLayer");
            findModuleMethod = clazz6.getDeclaredMethod("findModule", String.class);
            configurationMethod = clazz6.getDeclaredMethod("configuration", new Class[0]);
            defineModulesWithOneLoaderMethod = clazz6.getDeclaredMethod("defineModulesWithOneLoader", clazz5, ClassLoader.class);
            findLoaderMethod = clazz6.getDeclaredMethod("findLoader", String.class);
            Method method = clazz6.getDeclaredMethod("boot", new Class[0]);
            bootLayer = method.invoke(null, new Object[0]);
            Class<?> clazz7 = Class.forName("java.lang.JTRegModuleHelper");
            addExportsMethod = clazz7.getDeclaredMethod("addExports", Object.class, String.class, Object.class);
            addOpensMethod = clazz7.getDeclaredMethod("addOpens", Object.class, String.class, Object.class);
            getUnnamedModuleMethod = ClassLoader.class.getDeclaredMethod("getUnnamedModule", new Class[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new Fault("unexpected exception: " + classNotFoundException, classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new Fault("unexpected exception: " + noSuchMethodException, noSuchMethodException);
        }
        catch (SecurityException securityException) {
            throw new Fault("unexpected exception: " + securityException, securityException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Fault("unexpected exception: " + illegalAccessException, illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new Fault("unexpected exception: " + illegalArgumentException, illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new Fault("unexpected exception: " + invocationTargetException, invocationTargetException);
        }
    }

    static class Fault
    extends Exception {
        private static final long serialVersionUID = 1L;

        Fault(String string, Throwable throwable) {
            super(string, throwable);
        }
    }
}

